/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.io;

import java.io.IOException;
import java.io.OutputStream;

public class TeeOutputStream
extends OutputStream {
    private final OutputStream os1;
    private final OutputStream os2;

    public TeeOutputStream(OutputStream os1, OutputStream os2) {
        this.os1 = os1;
        this.os2 = os2;
    }

    public void write(int b) throws IOException {
        Exception e1 = null;
        Exception e2 = null;
        try {
            this.os1.write(b);
        }
        catch (Exception e) {
            e1 = e;
        }
        try {
            this.os2.write(b);
        }
        catch (Exception e) {
            e2 = e;
        }
        this.rethrow(e1);
        this.rethrow(e2);
    }

    public void flush() throws IOException {
        Exception e1 = null;
        Exception e2 = null;
        try {
            this.os1.flush();
        }
        catch (Exception e) {
            e1 = e;
        }
        try {
            this.os2.flush();
        }
        catch (Exception e) {
            e2 = e;
        }
        this.rethrow(e1);
        this.rethrow(e2);
    }

    public void close() throws IOException {
        Exception e1 = null;
        Exception e2 = null;
        try {
            this.os1.close();
        }
        catch (Exception e) {
            e1 = e;
        }
        try {
            this.os2.close();
        }
        catch (Exception e) {
            e2 = e;
        }
        this.rethrow(e1);
        this.rethrow(e2);
    }

    private void rethrow(Exception e) throws IOException {
        if (e != null) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw (RuntimeException)e;
        }
    }
}

