/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleList;
import mondrian.calc.impl.DelegatingTupleList;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Access;
import mondrian.olap.Annotation;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.ResultStyleException;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.HierarchyCurrentMemberFunDef;
import mondrian.olap.fun.MemberOrderKeyFunDef;
import mondrian.olap.fun.MondrianEvaluationException;
import mondrian.olap.fun.ParenthesesFunDef;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.SetFunDef;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapUtil;
import mondrian.util.ConcatenableList;
import mondrian.util.IdentifierParser;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.log4j.Logger;
import org.olap4j.impl.IdentifierParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunUtil
extends Util {
    private static final Logger LOGGER = Logger.getLogger(FunUtil.class);
    private static final String SORT_TIMING_NAME = "Sort";
    private static final String SORT_EVAL_TIMING_NAME = "EvalForSort";
    static final String[] emptyStringArray = new String[0];
    private static final boolean debug = false;
    public static final NullMember NullMember = new NullMember();
    public static final double DoubleNull = 1.2345E-8;
    public static final double DoubleEmpty = -1.2345E-8;
    public static final int IntegerNull = -2147483647;
    public static final boolean BooleanNull = false;

    public static RuntimeException newEvalException(FunDef funDef, String message) {
        Util.discard((Object)funDef);
        return new MondrianEvaluationException(message);
    }

    public static RuntimeException newEvalException(Throwable throwable) {
        return new MondrianEvaluationException(throwable.getClass().getName() + ": " + throwable.getMessage());
    }

    public static RuntimeException newEvalException(String message, Throwable throwable) {
        return new MondrianEvaluationException(message + ": " + Util.getErrorMessage(throwable));
    }

    public static void checkIterListResultStyles(Calc calc) {
        switch (calc.getResultStyle()) {
            case ITERABLE: 
            case LIST: 
            case MUTABLE_LIST: {
                break;
            }
            default: {
                throw ResultStyleException.generateBadType(ResultStyle.ITERABLE_LIST_MUTABLELIST, calc.getResultStyle());
            }
        }
    }

    public static void checkListResultStyles(Calc calc) {
        switch (calc.getResultStyle()) {
            case LIST: 
            case MUTABLE_LIST: {
                break;
            }
            default: {
                throw ResultStyleException.generateBadType(ResultStyle.LIST_MUTABLELIST, calc.getResultStyle());
            }
        }
    }

    static String getLiteralArg(ResolvedFunCall call, int i, String defaultValue, String[] allowedValues) {
        if (i >= call.getArgCount()) {
            if (defaultValue == null) {
                throw FunUtil.newEvalException(call.getFunDef(), "Required argument is missing");
            }
            return defaultValue;
        }
        Exp arg = call.getArg(i);
        if (!(arg instanceof Literal) || arg.getCategory() != 11) {
            throw FunUtil.newEvalException(call.getFunDef(), "Expected a symbol, found '" + arg + "'");
        }
        String s = (String)((Literal)arg).getValue();
        StringBuilder sb = new StringBuilder(64);
        for (int j = 0; j < allowedValues.length; ++j) {
            String allowedValue = allowedValues[j];
            if (allowedValue.equalsIgnoreCase(s)) {
                return allowedValue;
            }
            if (j > 0) {
                sb.append(", ");
            }
            sb.append(allowedValue);
        }
        throw FunUtil.newEvalException(call.getFunDef(), "Allowed values are: {" + sb + "}");
    }

    static <E extends Enum<E>> E getLiteralArg(ResolvedFunCall call, int i, E defaultValue, Class<E> allowedValues) {
        if (i >= call.getArgCount()) {
            if (defaultValue == null) {
                throw FunUtil.newEvalException(call.getFunDef(), "Required argument is missing");
            }
            return defaultValue;
        }
        Exp arg = call.getArg(i);
        if (!(arg instanceof Literal) || arg.getCategory() != 11) {
            throw FunUtil.newEvalException(call.getFunDef(), "Expected a symbol, found '" + arg + "'");
        }
        String s = (String)((Literal)arg).getValue();
        for (Enum e : (Enum[])allowedValues.getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(s)) continue;
            return (E)e;
        }
        StringBuilder buf = new StringBuilder(64);
        int k = 0;
        for (Enum e : (Enum[])allowedValues.getEnumConstants()) {
            if (k++ > 0) {
                buf.append(", ");
            }
            buf.append(e.name());
        }
        throw FunUtil.newEvalException(call.getFunDef(), "Allowed values are: {" + buf + "}");
    }

    static void checkCompatible(Exp left, Exp right, FunDef funDef) {
        Type rightType;
        Type leftType = TypeUtil.stripSetType(left.getType());
        if (!TypeUtil.isUnionCompatible(leftType, rightType = TypeUtil.stripSetType(right.getType()))) {
            throw FunUtil.newEvalException(funDef, "Expressions must have the same hierarchy");
        }
    }

    static void addUnique(TupleList left, TupleList right, Set<List<Member>> set) {
        assert (left != null);
        assert (right != null);
        if (right.isEmpty()) {
            return;
        }
        int n = right.size();
        for (int i = 0; i < n; ++i) {
            List o = (List)right.get(i);
            if (!set.add(o)) continue;
            left.add(o);
        }
    }

    public static Hierarchy getDimensionDefaultHierarchy(Dimension dimension) {
        Hierarchy[] hierarchies = dimension.getHierarchies();
        if (hierarchies.length == 1) {
            return hierarchies[0];
        }
        if (MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return null;
        }
        for (Hierarchy hierarchy : hierarchies) {
            if (hierarchy.getName() != null && !hierarchy.getUniqueName().equals(dimension.getUniqueName())) continue;
            return hierarchy;
        }
        return null;
    }

    static List<Member> addMembers(SchemaReader schemaReader, List<Member> members, Hierarchy hierarchy) {
        for (Level level : schemaReader.getHierarchyLevels(hierarchy)) {
            FunUtil.addMembers(schemaReader, members, level);
        }
        return members;
    }

    static List<Member> addMembers(SchemaReader schemaReader, List<Member> members, Level level) {
        List<Member> levelMembers = schemaReader.getLevelMembers(level, true);
        members.addAll(levelMembers);
        return members;
    }

    static List<Member> removeCalculatedMembers(List<Member> memberList) {
        ArrayList<Member> clone = new ArrayList<Member>();
        for (Member member : memberList) {
            if (member.isCalculated() && !member.isParentChildPhysicalMember()) continue;
            clone.add(member);
        }
        return clone;
    }

    static TupleList removeCalculatedMembers(TupleList memberList) {
        if (memberList.getArity() == 1) {
            return new UnaryTupleList(FunUtil.removeCalculatedMembers(memberList.slice(0)));
        }
        TupleList clone = memberList.cloneList(memberList.size());
        block0: for (List members : memberList) {
            for (Member member : members) {
                if (!member.isCalculated() || member.isParentChildPhysicalMember()) continue;
                continue block0;
            }
            clone.add(members);
        }
        return clone;
    }

    static boolean isAncestorOf(Member m0, Member m1, boolean strict) {
        if (strict) {
            if (m1 == null) {
                return false;
            }
            m1 = m1.getParentMember();
        }
        while (m1 != null) {
            if (m1.equals(m0)) {
                return true;
            }
            m1 = m1.getParentMember();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<Member, Object> evaluateMembers(Evaluator evaluator, Calc exp, Iterable<Member> memberIter, List<Member> memberList, boolean parentsToo) {
        int savepoint = evaluator.savepoint();
        try {
            assert (exp.getType() instanceof ScalarType);
            HashMap<Member, Object> mapMemberToValue = new HashMap<Member, Object>();
            for (Member member : memberIter) {
                if (memberList != null) {
                    memberList.add(member);
                }
                do {
                    evaluator.setContext(member);
                    Object result = exp.evaluate(evaluator);
                    if (result == null) {
                        result = Util.nullValue;
                    }
                    mapMemberToValue.put(member, result);
                } while (parentsToo && (member = member.getParentMember()) != null && !mapMemberToValue.containsKey(member));
            }
            HashMap<Member, Object> hashMap = mapMemberToValue;
            return hashMap;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<List<Member>, Object> evaluateTuples(Evaluator evaluator, Calc exp, TupleList tuples) {
        int savepoint = evaluator.savepoint();
        try {
            assert (exp.getType() instanceof ScalarType);
            HashMap<List<Member>, Object> mapMemberToValue = new HashMap<List<Member>, Object>();
            int count = tuples.size();
            for (int i = 0; i < count; ++i) {
                List tuple = (List)tuples.get(i);
                evaluator.setContext(tuple);
                Object result = exp.evaluate(evaluator);
                if (result == null) {
                    result = Util.nullValue;
                }
                mapMemberToValue.put(tuple, result);
            }
            HashMap<List<Member>, Object> hashMap = mapMemberToValue;
            return hashMap;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<Member> sortMembers(Evaluator evaluator, Iterable<Member> memberIter, List<Member> memberList, Calc exp, boolean desc, boolean brk) {
        if (memberList != null && memberList.size() <= 1) {
            return memberList;
        }
        evaluator.getTiming().markStart(SORT_EVAL_TIMING_NAME);
        boolean timingEval = true;
        boolean timingSort = false;
        try {
            Map<Member, Object> mapMemberToValue;
            boolean parentsToo;
            boolean bl = parentsToo = !brk;
            if (memberList == null) {
                memberList = new ArrayList<Member>();
                mapMemberToValue = FunUtil.evaluateMembers(evaluator, exp, memberIter, memberList, parentsToo);
            } else {
                mapMemberToValue = FunUtil.evaluateMembers(evaluator, exp, memberIter, null, parentsToo);
            }
            MemberComparator comp = brk ? new BreakMemberComparator(evaluator, exp, desc) : new HierarchicalMemberComparator(evaluator, exp, desc);
            comp.preloadValues(mapMemberToValue);
            evaluator.getTiming().markEnd(SORT_EVAL_TIMING_NAME);
            timingEval = false;
            evaluator.getTiming().markStart(SORT_TIMING_NAME);
            timingSort = true;
            Collections.sort(memberList, comp.wrap());
            List<Member> list = memberList;
            return list;
        }
        finally {
            if (timingEval) {
                evaluator.getTiming().markEnd(SORT_EVAL_TIMING_NAME);
            } else if (timingSort) {
                evaluator.getTiming().markEnd(SORT_TIMING_NAME);
            }
        }
    }

    static List<Member> sortMembers(Evaluator evaluator, Iterable<Member> memberIter, List<Member> memberList, List<SortKeySpec> keySpecList) {
        if (memberList != null && memberList.size() <= 1) {
            return memberList;
        }
        if (memberList == null) {
            memberList = new ArrayList<Member>();
            for (Member member : memberIter) {
                memberList.add(member);
            }
            if (memberList.size() <= 1) {
                return memberList;
            }
        }
        ComparatorChain chain = new ComparatorChain();
        for (SortKeySpec key : keySpecList) {
            boolean brk = ((SortKeySpec)key).direction.brk;
            MemberComparator comp = brk ? new BreakMemberComparator(evaluator, key.key, ((SortKeySpec)key).direction.descending) : new HierarchicalMemberComparator(evaluator, key.key, ((SortKeySpec)key).direction.descending);
            comp.preloadValues(memberList);
            chain.addComparator(comp.wrap(), false);
        }
        Collections.sort(memberList, chain);
        return memberList;
    }

    public static TupleList sortTuples(Evaluator evaluator, TupleIterable tupleIterable, TupleList tupleList, Calc exp, boolean desc, boolean brk, int arity) {
        Comparator<List<Member>> comparator;
        List<List<Member>> tupleArrayList;
        if (tupleList == null) {
            tupleArrayList = new ArrayList();
            TupleCursor cursor = tupleIterable.tupleCursor();
            while (cursor.forward()) {
                tupleArrayList.add(cursor.current());
            }
            if (tupleArrayList.size() <= 1) {
                return new DelegatingTupleList(tupleIterable.getArity(), tupleArrayList);
            }
        } else {
            if (tupleList.size() <= 1) {
                return tupleList;
            }
            tupleArrayList = tupleList;
        }
        List[] tuples = tupleArrayList.toArray(new List[tupleArrayList.size()]);
        DelegatingTupleList result = new DelegatingTupleList(tupleIterable.getArity(), Arrays.asList(tuples));
        if (brk) {
            comparator = new BreakTupleComparator(evaluator, exp, arity);
            if (desc) {
                comparator = Collections.reverseOrder(comparator);
            }
        } else {
            comparator = new HierarchicalTupleComparator(evaluator, exp, arity, desc);
        }
        Arrays.sort(tuples, comparator);
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("FunUtil.sortTuples returned:");
            for (List tuple : tuples) {
                sb.append("\n");
                sb.append(tuple.toString());
            }
            LOGGER.debug((Object)sb.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Member> partiallySortMembers(Evaluator evaluator, List<Member> list, Calc exp, int limit, boolean desc) {
        assert (list.size() > 0);
        assert (limit <= list.size());
        evaluator.getTiming().markStart(SORT_EVAL_TIMING_NAME);
        boolean timingEval = true;
        boolean timingSort = false;
        try {
            BreakMemberComparator comp = new BreakMemberComparator(evaluator, exp, desc);
            Map<Member, Object> valueMap = FunUtil.evaluateMembers(evaluator, exp, list, null, false);
            evaluator.getTiming().markEnd(SORT_EVAL_TIMING_NAME);
            timingEval = false;
            evaluator.getTiming().markStart(SORT_TIMING_NAME);
            timingSort = true;
            comp.preloadValues(valueMap);
            List<Member> list2 = FunUtil.stablePartialSort(list, comp.wrap(), limit);
            return list2;
        }
        finally {
            if (timingEval) {
                evaluator.getTiming().markEnd(SORT_EVAL_TIMING_NAME);
            } else if (timingSort) {
                evaluator.getTiming().markEnd(SORT_TIMING_NAME);
            }
        }
    }

    static TupleList sortTuples(Evaluator evaluator, TupleIterable tupleIter, TupleList tupleList, List<SortKeySpec> keySpecList, int arity) {
        if (tupleList == null) {
            tupleList = TupleCollections.createList(arity);
            TupleCursor cursor = tupleIter.tupleCursor();
            while (cursor.forward()) {
                tupleList.addCurrent(cursor);
            }
        }
        if (tupleList.size() <= 1) {
            return tupleList;
        }
        ComparatorChain chain = new ComparatorChain();
        for (SortKeySpec key : keySpecList) {
            TupleExpComparator comp;
            boolean brk = ((SortKeySpec)key).direction.brk;
            boolean orderByKey = key.key.isWrapperFor(MemberOrderKeyFunDef.CalcImpl.class);
            if (brk) {
                comp = new BreakTupleComparator(evaluator, key.key, arity);
                comp.preloadValues(tupleList);
                chain.addComparator((Comparator)comp, ((SortKeySpec)key).direction.descending);
                continue;
            }
            if (orderByKey) {
                comp = new HierarchicalTupleKeyComparator(evaluator, key.key, arity);
                comp.preloadValues(tupleList);
                chain.addComparator((Comparator)comp, ((SortKeySpec)key).direction.descending);
                continue;
            }
            comp = new HierarchicalTupleComparator(evaluator, key.key, arity, ((SortKeySpec)key).direction.descending);
            chain.addComparator((Comparator)comp, false);
        }
        Collections.sort(tupleList, chain);
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("FunUtil.sortTuples returned:");
            for (List tuple : tupleList) {
                sb.append("\n");
                sb.append(tuple.toString());
            }
            LOGGER.debug((Object)sb.toString());
        }
        return tupleList;
    }

    public static List<List<Member>> partiallySortTuples(Evaluator evaluator, TupleList list, Calc exp, int limit, boolean desc) {
        assert (list.size() > 0);
        assert (limit <= list.size());
        Comparator<List<Member>> comp = new BreakTupleComparator(evaluator, exp, list.getArity());
        if (desc) {
            comp = Collections.reverseOrder(comp);
        }
        return FunUtil.stablePartialSort(list, comp, limit);
    }

    public static void hierarchizeMemberList(List<Member> memberList, boolean post) {
        if (memberList.size() <= 1) {
            return;
        }
        if (memberList.get(0).getDimension().isHighCardinality()) {
            return;
        }
        HierarchizeComparator comparator = new HierarchizeComparator(post);
        Collections.sort(memberList, comparator);
    }

    public static TupleList hierarchizeTupleList(TupleList tupleList, boolean post) {
        if (tupleList.isEmpty()) {
            TupleCollections.emptyList(tupleList.getArity());
        }
        TupleList fixedList = tupleList.fix();
        if (tupleList.getArity() == 1) {
            FunUtil.hierarchizeMemberList(fixedList.slice(0), post);
            return fixedList;
        }
        HierarchizeTupleComparator comparator = new HierarchizeTupleComparator(fixedList.getArity(), post);
        Collections.sort(fixedList, comparator);
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("FunUtil.hierarchizeTupleList returned:");
            for (List tuple : fixedList) {
                sb.append("\n");
                sb.append(tuple.toString());
            }
        }
        return fixedList;
    }

    public static int compareValues(double d1, double d2) {
        if (Double.isNaN(d1)) {
            if (d2 == Double.POSITIVE_INFINITY) {
                return -1;
            }
            if (Double.isNaN(d2)) {
                return 0;
            }
            return 1;
        }
        if (Double.isNaN(d2)) {
            if (d1 == Double.POSITIVE_INFINITY) {
                return 1;
            }
            return -1;
        }
        if (d1 == d2) {
            return 0;
        }
        if (d1 == 1.2345E-8) {
            if (d2 == Double.NEGATIVE_INFINITY) {
                return 1;
            }
            return -1;
        }
        if (d2 == 1.2345E-8) {
            if (d1 == Double.NEGATIVE_INFINITY) {
                return -1;
            }
            return 1;
        }
        if (d1 < d2) {
            return -1;
        }
        return 1;
    }

    public static int compareValues(Object value0, Object value1) {
        if (value0 == value1) {
            return 0;
        }
        if (value0 == null) {
            return -1;
        }
        if (value1 == null) {
            return 1;
        }
        if (value0 == RolapUtil.valueNotReadyException) {
            return -1;
        }
        if (value1 == RolapUtil.valueNotReadyException) {
            return 1;
        }
        if (value0 == Util.nullValue) {
            return -1;
        }
        if (value1 == Util.nullValue) {
            return 1;
        }
        if (value0 instanceof String) {
            return ((String)value0).compareToIgnoreCase((String)value1);
        }
        if (value0 instanceof Number) {
            return FunUtil.compareValues(((Number)value0).doubleValue(), ((Number)value1).doubleValue());
        }
        if (value0 instanceof Date) {
            return ((Date)value0).compareTo((Date)value1);
        }
        if (value0 instanceof OrderKey) {
            return ((OrderKey)value0).compareTo(value1);
        }
        throw Util.newInternal("cannot compare " + value0);
    }

    static void toPercent(TupleList members, Map<List<Member>, Object> mapMemberToValue) {
        Object o;
        List key;
        int i;
        double total = 0.0;
        int memberCount = members.size();
        for (i = 0; i < memberCount; ++i) {
            key = (List)members.get(i);
            o = mapMemberToValue.get(key);
            if (!(o instanceof Number)) continue;
            total += ((Number)o).doubleValue();
        }
        for (i = 0; i < memberCount; ++i) {
            key = (List)members.get(i);
            o = mapMemberToValue.get(key);
            if (!(o instanceof Number)) continue;
            double d = ((Number)o).doubleValue();
            mapMemberToValue.put(key, d / total * 100.0);
        }
    }

    public static Syntax decodeSyntacticType(String flags) {
        char c = flags.charAt(0);
        switch (c) {
            case 'p': {
                return Syntax.Property;
            }
            case 'f': {
                return Syntax.Function;
            }
            case 'm': {
                return Syntax.Method;
            }
            case 'i': {
                return Syntax.Infix;
            }
            case 'P': {
                return Syntax.Prefix;
            }
            case 'Q': {
                return Syntax.Postfix;
            }
            case 'I': {
                return Syntax.Internal;
            }
        }
        throw FunUtil.newInternal("unknown syntax code '" + c + "' in string '" + flags + "'");
    }

    public static int decodeReturnCategory(String flags) {
        int returnCategory = FunUtil.decodeCategory(flags, 1);
        if ((returnCategory & 0x1F) != returnCategory) {
            throw FunUtil.newInternal("bad return code flag in flags '" + flags + "'");
        }
        return returnCategory;
    }

    public static int decodeCategory(String flags, int offset) {
        char c = flags.charAt(offset);
        switch (c) {
            case 'a': {
                return 1;
            }
            case 'd': {
                return 2;
            }
            case 'h': {
                return 3;
            }
            case 'l': {
                return 4;
            }
            case 'b': {
                return 5;
            }
            case 'm': {
                return 6;
            }
            case 'N': {
                return 71;
            }
            case 'n': {
                return 7;
            }
            case 'I': {
                return 79;
            }
            case 'i': {
                return 15;
            }
            case 'x': {
                return 8;
            }
            case '#': {
                return 73;
            }
            case 'S': {
                return 9;
            }
            case 't': {
                return 10;
            }
            case 'v': {
                return 13;
            }
            case 'y': {
                return 11;
            }
            case 'U': {
                return 16;
            }
            case 'e': {
                return 17;
            }
            case 'D': {
                return 18;
            }
        }
        throw FunUtil.newInternal("unknown type code '" + c + "' in string '" + flags + "'");
    }

    public static int[] decodeParameterCategories(String flags) {
        int[] parameterCategories = new int[flags.length() - 2];
        for (int i = 0; i < parameterCategories.length; ++i) {
            parameterCategories[i] = FunUtil.decodeCategory(flags, i + 2);
        }
        return parameterCategories;
    }

    public static Double box(double d) {
        return d == 1.2345E-8 ? null : Double.valueOf(d);
    }

    public static Integer box(int n) {
        return n == -2147483647 ? null : Integer.valueOf(n);
    }

    static double percentile(Evaluator evaluator, TupleList members, Calc exp, double p) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, (TupleIterable)members, exp);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        if (sw.v.size() == 0) {
            return 1.2345E-8;
        }
        double[] asArray = new double[sw.v.size()];
        for (int i = 0; i < asArray.length; ++i) {
            asArray[i] = (Double)sw.v.get(i);
        }
        Arrays.sort(asArray);
        int length = asArray.length;
        if (p <= 0.0) {
            return asArray[0];
        }
        if (p >= 1.0) {
            return asArray[length - 1];
        }
        if (length == 1) {
            return asArray[0];
        }
        if (p == 0.5) {
            if ((length & 1) == 1) {
                return asArray[length >> 1];
            }
            return (asArray[(length >> 1) - 1] + asArray[length >> 1]) / 2.0;
        }
        double jD = Math.floor((double)length * p);
        int j = jD > 0.0 ? (int)jD - 1 : (int)jD;
        double alpha = p * (double)length - jD;
        assert (alpha >= 0.0);
        assert (alpha <= 1.0);
        return asArray[j] + (asArray[j + 1] - asArray[j]) * alpha;
    }

    protected static double quartile(Evaluator evaluator, TupleList members, Calc exp, int range) {
        assert (range >= 1 && range <= 3);
        SetWrapper sw = FunUtil.evaluateSet(evaluator, (TupleIterable)members, exp);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        if (sw.v.size() == 0) {
            return 1.2345E-8;
        }
        double[] asArray = new double[sw.v.size()];
        for (int i = 0; i < asArray.length; ++i) {
            asArray[i] = (Double)sw.v.get(i);
        }
        Arrays.sort(asArray);
        double dm = 0.25 * (double)asArray.length * (double)range;
        int median = (int)Math.floor(dm);
        return dm == (double)median && median < asArray.length - 1 ? (asArray[median] + asArray[median + 1]) / 2.0 : asArray[median];
    }

    public static Object min(Evaluator evaluator, TupleList members, Calc calc) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, (TupleIterable)members, calc);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        int size = sw.v.size();
        if (size == 0) {
            return Util.nullValue;
        }
        Double min = ((Number)sw.v.get(0)).doubleValue();
        for (int i = 1; i < size; ++i) {
            Double iValue = ((Number)sw.v.get(i)).doubleValue();
            if (!(iValue < min)) continue;
            min = iValue;
        }
        return min;
    }

    public static Object max(Evaluator evaluator, TupleList members, Calc exp) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, (TupleIterable)members, exp);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        int size = sw.v.size();
        if (size == 0) {
            return Util.nullValue;
        }
        Double max = ((Number)sw.v.get(0)).doubleValue();
        for (int i = 1; i < size; ++i) {
            Double iValue = ((Number)sw.v.get(i)).doubleValue();
            if (!(iValue > max)) continue;
            max = iValue;
        }
        return max;
    }

    static Object var(Evaluator evaluator, TupleList members, Calc exp, boolean biased) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, (TupleIterable)members, exp);
        return FunUtil._var(sw, biased);
    }

    private static Object _var(SetWrapper sw, boolean biased) {
        if (sw.errorCount > 0) {
            return new Double(Double.NaN);
        }
        if (sw.v.size() == 0) {
            return Util.nullValue;
        }
        double stdev = 0.0;
        double avg = FunUtil._avg(sw);
        for (int i = 0; i < sw.v.size(); ++i) {
            stdev += Math.pow(((Number)sw.v.get(i)).doubleValue() - avg, 2.0);
        }
        int n = sw.v.size();
        if (!biased) {
            --n;
        }
        return new Double(stdev / (double)n);
    }

    static double correlation(Evaluator evaluator, TupleList memberList, Calc exp1, Calc exp2) {
        SetWrapper sw1 = FunUtil.evaluateSet(evaluator, (TupleIterable)memberList, exp1);
        SetWrapper sw2 = FunUtil.evaluateSet(evaluator, (TupleIterable)memberList, exp2);
        Object covar = FunUtil._covariance(sw1, sw2, false);
        Object var1 = FunUtil._var(sw1, false);
        Object var2 = FunUtil._var(sw2, false);
        return ((Number)covar).doubleValue() / Math.sqrt(((Number)var1).doubleValue() * ((Number)var2).doubleValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object covariance(Evaluator evaluator, TupleList members, Calc exp1, Calc exp2, boolean biased) {
        SetWrapper sw2;
        SetWrapper sw1;
        int savepoint = evaluator.savepoint();
        try {
            sw1 = FunUtil.evaluateSet(evaluator, (TupleIterable)members, exp1);
        }
        finally {
            evaluator.restore(savepoint);
        }
        try {
            sw2 = FunUtil.evaluateSet(evaluator, (TupleIterable)members, exp2);
        }
        finally {
            evaluator.restore(savepoint);
        }
        return FunUtil._covariance(sw1, sw2, biased);
    }

    private static Object _covariance(SetWrapper sw1, SetWrapper sw2, boolean biased) {
        if (sw1.v.size() != sw2.v.size()) {
            return Util.nullValue;
        }
        double avg1 = FunUtil._avg(sw1);
        double avg2 = FunUtil._avg(sw2);
        double covar = 0.0;
        for (int i = 0; i < sw1.v.size(); ++i) {
            double diff1 = ((Number)sw1.v.get(i)).doubleValue() - avg1;
            double diff2 = ((Number)sw2.v.get(i)).doubleValue() - avg2;
            covar += diff1 * diff2;
        }
        int n = sw1.v.size();
        if (!biased) {
            --n;
        }
        return new Double(covar / (double)n);
    }

    static Object stdev(Evaluator evaluator, TupleList members, Calc exp, boolean biased) {
        Object o = FunUtil.var(evaluator, members, exp, biased);
        return o instanceof Double ? new Double(Math.sqrt(((Number)o).doubleValue())) : o;
    }

    public static Object avg(Evaluator evaluator, TupleList members, Calc calc) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, (TupleIterable)members, calc);
        return sw.errorCount > 0 ? new Double(Double.NaN) : (sw.v.size() == 0 ? Util.nullValue : new Double(FunUtil._avg(sw)));
    }

    private static double _avg(SetWrapper sw) {
        double sum = 0.0;
        for (int i = 0; i < sw.v.size(); ++i) {
            sum += ((Number)sw.v.get(i)).doubleValue();
        }
        return sum / (double)sw.v.size();
    }

    public static Object sum(Evaluator evaluator, TupleList members, Calc exp) {
        double d = FunUtil.sumDouble(evaluator, members, exp);
        return d == 1.2345E-8 ? Util.nullValue : new Double(d);
    }

    public static double sumDouble(Evaluator evaluator, TupleList members, Calc exp) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, (TupleIterable)members, exp);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        if (sw.v.size() == 0) {
            return 1.2345E-8;
        }
        double sum = 0.0;
        for (int i = 0; i < sw.v.size(); ++i) {
            sum += ((Number)sw.v.get(i)).doubleValue();
        }
        return sum;
    }

    public static double sumDouble(Evaluator evaluator, TupleIterable iterable, Calc exp) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, iterable, exp);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        if (sw.v.size() == 0) {
            return 1.2345E-8;
        }
        double sum = 0.0;
        for (int i = 0; i < sw.v.size(); ++i) {
            sum += ((Number)sw.v.get(i)).doubleValue();
        }
        return sum;
    }

    public static int count(Evaluator evaluator, TupleIterable iterable, boolean includeEmpty) {
        if (iterable == null) {
            return 0;
        }
        if (includeEmpty) {
            if (iterable instanceof TupleList) {
                return ((TupleList)iterable).size();
            }
            int retval = 0;
            TupleCursor cursor = iterable.tupleCursor();
            while (cursor.forward()) {
                ++retval;
            }
            return retval;
        }
        int retval = 0;
        TupleCursor cursor = iterable.tupleCursor();
        while (cursor.forward()) {
            cursor.setContext(evaluator);
            if (evaluator.currentIsEmpty()) continue;
            ++retval;
        }
        return retval;
    }

    static SetWrapper evaluateSet(Evaluator evaluator, TupleIterable members, Calc calc) {
        assert (members != null);
        assert (calc != null);
        assert (calc.getType() instanceof ScalarType);
        SetWrapper retval = new SetWrapper();
        TupleCursor cursor = members.tupleCursor();
        while (cursor.forward()) {
            cursor.setContext(evaluator);
            Object o = calc.evaluate(evaluator);
            if (o == null || o == Util.nullValue) {
                ++retval.nullCount;
                continue;
            }
            if (o == RolapUtil.valueNotReadyException) {
                ++retval.errorCount;
                continue;
            }
            if (o instanceof Number) {
                retval.v.add(((Number)o).doubleValue());
                continue;
            }
            retval.v.add(o);
        }
        return retval;
    }

    static SetWrapper[] evaluateSet(Evaluator evaluator, TupleList list, DoubleCalc[] calcs) {
        Util.assertPrecondition(calcs != null, "calcs != null");
        SetWrapper[] retvals = new SetWrapper[calcs.length];
        for (int i = 0; i < calcs.length; ++i) {
            retvals[i] = new SetWrapper();
        }
        TupleCursor cursor = list.tupleCursor();
        while (cursor.forward()) {
            cursor.setContext(evaluator);
            for (int i = 0; i < calcs.length; ++i) {
                DoubleCalc calc = calcs[i];
                SetWrapper retval = retvals[i];
                double o = calc.evaluateDouble(evaluator);
                if (o == 1.2345E-8) {
                    ++retval.nullCount;
                    retval.v.add(null);
                    continue;
                }
                retval.v.add(o);
            }
        }
        return retvals;
    }

    static List<Member> periodsToDate(Evaluator evaluator, Level level, Member member) {
        Member m;
        if (member == null) {
            member = evaluator.getContext(level.getHierarchy());
        }
        for (m = member; m != null && m.getLevel() != level; m = m.getParentMember()) {
        }
        ArrayList<Member> members = new ArrayList<Member>();
        if (m != null) {
            SchemaReader reader = evaluator.getSchemaReader();
            m = Util.getFirstDescendantOnLevel(reader, m, member.getLevel());
            reader.getMemberRange(level, m, member, members);
        }
        return members;
    }

    static List<Member> memberRange(Evaluator evaluator, Member startMember, Member endMember) {
        Level level = startMember.getLevel();
        FunUtil.assertTrue(level == endMember.getLevel());
        ArrayList<Member> members = new ArrayList<Member>();
        evaluator.getSchemaReader().getMemberRange(level, startMember, endMember, members);
        if (members.isEmpty()) {
            evaluator.getSchemaReader().getMemberRange(level, endMember, startMember, members);
        }
        return members;
    }

    static Member cousin(SchemaReader schemaReader, Member member, Member ancestorMember) {
        if (ancestorMember.isNull()) {
            return ancestorMember;
        }
        if (member.getHierarchy() != ancestorMember.getHierarchy()) {
            throw MondrianResource.instance().CousinHierarchyMismatch.ex(member.getUniqueName(), ancestorMember.getUniqueName());
        }
        if (member.getLevel().getDepth() < ancestorMember.getLevel().getDepth()) {
            return member.getHierarchy().getNullMember();
        }
        Member cousin = FunUtil.cousin2(schemaReader, member, ancestorMember);
        if (cousin == null) {
            cousin = member.getHierarchy().getNullMember();
        }
        return cousin;
    }

    private static Member cousin2(SchemaReader schemaReader, Member member1, Member member2) {
        if (member1.getLevel() == member2.getLevel()) {
            return member2;
        }
        Member uncle = FunUtil.cousin2(schemaReader, member1.getParentMember(), member2);
        if (uncle == null) {
            return null;
        }
        int ordinal = Util.getMemberOrdinalInParent(schemaReader, member1);
        List<Member> cousins = schemaReader.getMemberChildren(uncle);
        if (cousins.size() <= ordinal) {
            return null;
        }
        return cousins.get(ordinal);
    }

    static Member ancestor(Evaluator evaluator, Member member, int distance, Level targetLevel) {
        if (targetLevel != null && member.getHierarchy() != targetLevel.getHierarchy()) {
            throw MondrianResource.instance().MemberNotInLevelHierarchy.ex(member.getUniqueName(), targetLevel.getUniqueName());
        }
        if (distance == 0) {
            return member;
        }
        if (distance < 0) {
            return member.getHierarchy().getNullMember();
        }
        ArrayList<Member> ancestors = new ArrayList<Member>();
        SchemaReader schemaReader = evaluator.getSchemaReader();
        schemaReader.getMemberAncestors(member, ancestors);
        Member result = member.getHierarchy().getNullMember();
        for (int i = 0; i < ancestors.size(); ++i) {
            Member ancestorMember = (Member)ancestors.get(i);
            if (targetLevel != null) {
                if (ancestorMember.getLevel() != targetLevel) continue;
                if (schemaReader.isVisible(ancestorMember)) {
                    result = ancestorMember;
                    break;
                }
                result = member.getHierarchy().getNullMember();
                break;
            }
            if (!schemaReader.isVisible(ancestorMember) || --distance != 0) continue;
            result = ancestorMember;
            break;
        }
        return result;
    }

    public static int compareHierarchically(Member m1, Member m2, boolean post) {
        Member prev2;
        Member prev1;
        if (FunUtil.equals(m1 = FunUtil.unwrapLimitedRollupMember(m1), m2 = FunUtil.unwrapLimitedRollupMember(m2))) {
            return 0;
        }
        while (true) {
            int depth2;
            int depth1;
            if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                if (!FunUtil.equals(m1, m2 = m2.getParentMember())) continue;
                return post ? 1 : -1;
            }
            if (depth1 > depth2) {
                if (!FunUtil.equals(m1 = m1.getParentMember(), m2)) continue;
                return post ? -1 : 1;
            }
            prev1 = m1;
            prev2 = m2;
            if (FunUtil.equals(m1 = FunUtil.unwrapLimitedRollupMember(m1.getParentMember()), m2 = FunUtil.unwrapLimitedRollupMember(m2.getParentMember()))) break;
        }
        int c = FunUtil.compareSiblingMembers(prev1, prev2);
        assert (c != 0) : "Members " + prev1 + ", " + prev2 + " are not equal, but compare returned 0.";
        return c;
    }

    private static Member unwrapLimitedRollupMember(Member m) {
        if (m instanceof RolapHierarchy.LimitedRollupMember) {
            return ((RolapHierarchy.LimitedRollupMember)m).member;
        }
        return m;
    }

    public static int compareSiblingMembers(Member m1, Member m2) {
        int ordinal2;
        boolean calculated1 = m1.isCalculatedInQuery();
        boolean calculated2 = m2.isCalculatedInQuery();
        if (calculated1) {
            if (!calculated2) {
                return 1;
            }
        } else if (calculated2) {
            return -1;
        }
        Comparable k1 = m1.getOrderKey();
        Comparable k2 = m2.getOrderKey();
        if (k1 != null && k2 != null) {
            return k1.compareTo(k2);
        }
        int ordinal1 = m1.getOrdinal();
        return ordinal1 == (ordinal2 = m2.getOrdinal()) ? m1.compareTo(m2) : (ordinal1 < ordinal2 ? -1 : 1);
    }

    public static boolean tupleContainsNullMember(Member[] tuple) {
        for (Member member : tuple) {
            if (!member.isNull()) continue;
            return true;
        }
        return false;
    }

    public static boolean tupleContainsNullMember(List<Member> tuple) {
        for (Member member : tuple) {
            if (!member.isNull()) continue;
            return true;
        }
        return false;
    }

    public static Member[] makeNullTuple(TupleType tupleType) {
        Type[] elementTypes = tupleType.elementTypes;
        Member[] members = new Member[elementTypes.length];
        for (int i = 0; i < elementTypes.length; ++i) {
            MemberType type = (MemberType)elementTypes[i];
            members[i] = FunUtil.makeNullMember(type);
        }
        return members;
    }

    static Member makeNullMember(MemberType memberType) {
        Hierarchy hierarchy = memberType.getHierarchy();
        if (hierarchy == null) {
            return NullMember;
        }
        return hierarchy.getNullMember();
    }

    public static FunDef resolveFunArgs(Validator validator, FunDef funDef, Exp[] args, Exp[] newArgs, String name, Syntax syntax) {
        for (int i = 0; i < args.length; ++i) {
            newArgs[i] = validator.validate(args[i], false);
        }
        if (funDef == null || validator.alwaysResolveFunDef()) {
            funDef = validator.getDef(newArgs, name, syntax);
        }
        FunUtil.checkNativeCompatible(validator, funDef, newArgs);
        return funDef;
    }

    private static void checkNativeCompatible(Validator validator, FunDef funDef, Exp[] args) {
        int[] paramCategories;
        Query query = validator.getQuery();
        if (!(funDef instanceof SetFunDef) && !(funDef instanceof ParenthesesFunDef) && query != null && query.nativeCrossJoinVirtualCube() && (paramCategories = funDef.getParameterCategories()).length > 0) {
            int cat0 = paramCategories[0];
            Exp arg0 = args[0];
            switch (cat0) {
                case 2: 
                case 3: {
                    if (!(arg0 instanceof DimensionExpr) || !((DimensionExpr)arg0).getDimension().isMeasures() || funDef instanceof HierarchyCurrentMemberFunDef) break;
                    query.setVirtualCubeNonNativeCrossJoin();
                    break;
                }
                case 6: {
                    if (!(arg0 instanceof MemberExpr) || !((MemberExpr)arg0).getMember().isMeasure() || !FunUtil.isMemberOrSet(funDef.getReturnCategory())) break;
                    query.setVirtualCubeNonNativeCrossJoin();
                }
            }
        }
    }

    private static boolean isMemberOrSet(int category) {
        return category == 6 || category == 8;
    }

    static void appendTuple(StringBuilder buf, Member[] members) {
        buf.append("(");
        for (int j = 0; j < members.length; ++j) {
            if (j > 0) {
                buf.append(", ");
            }
            Member member = members[j];
            buf.append(member.getUniqueName());
        }
        buf.append(")");
    }

    static boolean equalTuple(Member[] members0, Member[] members1) {
        int count = members0.length;
        if (count != members1.length) {
            return false;
        }
        block0: for (int i = 0; i < count; ++i) {
            Member member0 = members0[i];
            if (member0.equals(members1[i])) continue;
            for (int j = 0; j < count; ++j) {
                if (i != j && member0.equals(members1[j])) continue block0;
            }
            return false;
        }
        return true;
    }

    static FunDef createDummyFunDef(Resolver resolver, int returnCategory, Exp[] args) {
        int[] argCategories = ExpBase.getTypes(args);
        return new FunDefBase(resolver, returnCategory, argCategories){};
    }

    public static List<Member> getNonEmptyMemberChildren(Evaluator evaluator, Member member) {
        SchemaReader sr = evaluator.getSchemaReader();
        if (evaluator.isNonEmpty()) {
            return sr.getMemberChildren(member, evaluator);
        }
        return sr.getMemberChildren(member);
    }

    public static Map<Member, Access> getNonEmptyMemberChildrenWithDetails(Evaluator evaluator, Member member) {
        SchemaReader sr = evaluator.getSchemaReader();
        if (evaluator.isNonEmpty()) {
            return sr.getMemberChildrenWithDetails(member, evaluator);
        }
        return sr.getMemberChildrenWithDetails(member, null);
    }

    static List<Member> getNonEmptyLevelMembers(Evaluator evaluator, Level level, boolean includeCalcMembers) {
        SchemaReader sr = evaluator.getSchemaReader();
        if (evaluator.isNonEmpty()) {
            List<Member> members = sr.getLevelMembers(level, evaluator);
            if (includeCalcMembers) {
                return FunUtil.addLevelCalculatedMembers(sr, level, members);
            }
            return members;
        }
        return sr.getLevelMembers(level, includeCalcMembers);
    }

    static TupleList levelMembers(Level level, Evaluator evaluator, boolean includeCalcMembers) {
        List<Member> memberList = FunUtil.getNonEmptyLevelMembers(evaluator, level, includeCalcMembers);
        if (!includeCalcMembers) {
            memberList = FunUtil.removeCalculatedMembers(memberList);
        }
        ArrayList<Member> memberListClone = new ArrayList<Member>(memberList);
        UnaryTupleList tupleList = new UnaryTupleList(memberListClone);
        return FunUtil.hierarchizeTupleList(tupleList, false);
    }

    static TupleList hierarchyMembers(Hierarchy hierarchy, Evaluator evaluator, boolean includeCalcMembers) {
        UnaryTupleList tupleList = new UnaryTupleList();
        List<Member> memberList = tupleList.slice(0);
        if (evaluator.isNonEmpty()) {
            for (Level level : hierarchy.getLevels()) {
                List<Member> members = FunUtil.getNonEmptyLevelMembers(evaluator, level, includeCalcMembers);
                memberList.addAll(members);
            }
        } else {
            List<Member> memberList1 = FunUtil.addMembers(evaluator.getSchemaReader(), new ConcatenableList<Member>(), hierarchy);
            if (includeCalcMembers) {
                memberList.addAll(memberList1);
            } else {
                for (Member member1 : memberList1) {
                    if (member1.isCalculated()) continue;
                    memberList.add(member1);
                }
            }
        }
        return FunUtil.hierarchizeTupleList(tupleList, false);
    }

    static <T> void partialSort(T[] items, Comparator<T> comp, int limit) {
        if (comp == null) {
            comp = ComparatorUtils.naturalComparator();
        }
        new Quicksorter<T>(items, comp).partialSort(limit);
    }

    public static <T> List<T> stablePartialSort(List<T> list, Comparator<T> comp, int limit) {
        return FunUtil.stablePartialSort(list, comp, limit, 0);
    }

    public static <T> List<T> stablePartialSort(List<T> list, Comparator<T> comp, int limit, int algorithm) {
        assert (limit <= list.size());
        assert (list.size() > 0);
        block7: while (true) {
            switch (algorithm) {
                case 0: {
                    float ratio = (float)limit / (float)list.size();
                    if ((double)ratio <= 0.05) {
                        algorithm = 4;
                        continue block7;
                    }
                    if ((double)ratio <= 0.35) {
                        algorithm = 2;
                        continue block7;
                    }
                    algorithm = 1;
                    continue block7;
                }
                case 1: {
                    return FunUtil.stablePartialSortArray(list, comp, limit);
                }
                case 2: {
                    return FunUtil.stablePartialSortMarc(list, comp, limit);
                }
                case 3: {
                    return FunUtil.stablePartialSortPedro(list, comp, limit);
                }
                case 4: {
                    return FunUtil.stablePartialSortJulian(list, comp, limit);
                }
            }
            break;
        }
        throw new RuntimeException();
    }

    public static <T> List<T> stablePartialSortArray(List<T> list, Comparator<T> comp, int limit) {
        ArrayList<T> list2 = new ArrayList<T>(list);
        Collections.sort(list2, comp);
        return list2.subList(0, limit);
    }

    public static <T> List<T> stablePartialSortMarc(List<T> list, final Comparator<T> comp, int limit) {
        assert (limit >= 0);
        int n = list.size();
        final ObjIntPair[] pairs = new ObjIntPair[n];
        int i = 0;
        for (T item : list) {
            pairs[i] = new ObjIntPair<T>(item, i);
            ++i;
        }
        Comparator pairComp = new Comparator<ObjIntPair<T>>(){

            @Override
            public int compare(ObjIntPair<T> x, ObjIntPair<T> y) {
                int val = comp.compare(x.t, y.t);
                if (val == 0) {
                    val = x.i - y.i;
                }
                return val;
            }
        };
        final int length = Math.min(limit, n);
        FunUtil.partialSort(pairs, pairComp, length);
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return pairs[index].t;
            }

            @Override
            public int size() {
                return length;
            }
        };
    }

    public static <T> List<T> stablePartialSortPedro(List<T> list, final Comparator<T> comp, int limit) {
        ObjIntPair[] pairs = new ObjIntPair[limit];
        Comparator pairComp = new Comparator<ObjIntPair<T>>(){

            @Override
            public int compare(ObjIntPair<T> x, ObjIntPair<T> y) {
                int val = comp.compare(x.t, y.t);
                if (val == 0) {
                    val = x.i - y.i;
                }
                return val;
            }
        };
        int filled = 0;
        Object maximum = null;
        int maximumIndex = 0;
        int originalIndex = 0;
        for (T item : list) {
            switch (filled) {
                case 0: {
                    maximum = item;
                    pairs[0] = new ObjIntPair<T>(item, originalIndex);
                    ++filled;
                    break;
                }
                default: {
                    if (filled < limit) {
                        pairs[filled] = new ObjIntPair<T>(item, originalIndex);
                        if (comp.compare(item, maximum) > 0) {
                            maximum = item;
                            maximumIndex = filled;
                        }
                        ++filled;
                        break;
                    }
                    if (comp.compare(item, maximum) >= 0) break;
                    pairs[maximumIndex] = new ObjIntPair<T>(item, originalIndex);
                    maximum = pairs[0].t;
                    maximumIndex = 0;
                    for (int i = 0; i < filled; ++i) {
                        if (comp.compare(pairs[i].t, maximum) <= 0) continue;
                        maximum = pairs[i].t;
                        maximumIndex = i;
                    }
                }
            }
            ++originalIndex;
        }
        Arrays.sort(pairs, pairComp);
        ArrayList<T> result = new ArrayList<T>(limit);
        for (int i = 0; i < limit; ++i) {
            result.add(list.get(pairs[i].i));
        }
        return result;
    }

    public static <T> List<T> stablePartialSortJulian(List<T> list, final Comparator<T> comp, int limit) {
        Comparator comp2 = new Comparator<ObjIntPair<T>>(){

            @Override
            public int compare(ObjIntPair<T> o1, ObjIntPair<T> o2) {
                int c = comp.compare(o1.t, o2.t);
                if (c == 0) {
                    c = Util.compare(o1.i, o2.i);
                }
                return -c;
            }
        };
        int filled = 0;
        PriorityQueue<ObjIntPair<T>> queue = new PriorityQueue<ObjIntPair<T>>(limit, comp2);
        for (T element : list) {
            ObjIntPair<T> item;
            if (filled < limit) {
                queue.offer(new ObjIntPair<T>(element, filled++));
                continue;
            }
            ObjIntPair head = (ObjIntPair)queue.element();
            if (comp.compare(element, head.t) > 0 || comp2.compare(item = new ObjIntPair<T>(element, filled++), head) < 0) continue;
            ObjIntPair poll = (ObjIntPair)queue.remove();
            Util.discard((Object)poll);
            queue.offer(item);
        }
        int n = queue.size();
        Object[] elements = new Object[n];
        while (n > 0) {
            elements[--n] = ((ObjIntPair)queue.poll()).t;
        }
        assert (queue.isEmpty());
        return Arrays.asList(elements);
    }

    static TupleList parseTupleList(Evaluator evaluator, String string, List<Hierarchy> hierarchies) {
        IdentifierParser.TupleListBuilder builder = new IdentifierParser.TupleListBuilder(evaluator.getSchemaReader(), evaluator.getCube(), hierarchies);
        IdentifierParser.parseTupleList((IdentifierParser.Builder)builder, (String)string);
        return builder.tupleList;
    }

    private static int parseTuple(Evaluator evaluator, String string, int i, final Member[] members, List<Hierarchy> hierarchies) {
        IdentifierParser.TupleBuilder builder = new IdentifierParser.TupleBuilder(evaluator.getSchemaReader(), evaluator.getCube(), hierarchies){

            public void tupleComplete() {
                super.tupleComplete();
                this.memberList.toArray(members);
            }
        };
        return IdentifierParser.parseTuple((IdentifierParser.Builder)builder, (String)string, (int)i);
    }

    static Member[] parseTuple(Evaluator evaluator, String string, List<Hierarchy> hierarchies) {
        Member[] members = new Member[hierarchies.size()];
        int i = FunUtil.parseTuple(evaluator, string, 0, members, hierarchies);
        if (FunUtil.tupleContainsNullMember(members)) {
            return null;
        }
        return members;
    }

    static List<Member> parseMemberList(Evaluator evaluator, String string, Hierarchy hierarchy) {
        IdentifierParser.MemberListBuilder builder = new IdentifierParser.MemberListBuilder(evaluator.getSchemaReader(), evaluator.getCube(), hierarchy);
        IdentifierParser.parseMemberList((IdentifierParser.Builder)builder, (String)string);
        return builder.memberList;
    }

    private static int parseMember(Evaluator evaluator, String string, int i, final Member[] members, Hierarchy hierarchy) {
        IdentifierParser.MemberListBuilder builder = new IdentifierParser.MemberListBuilder(evaluator.getSchemaReader(), evaluator.getCube(), hierarchy){

            public void memberComplete() {
                members[0] = this.resolveMember((Hierarchy)this.hierarchyList.get(0));
                this.segmentList.clear();
            }
        };
        return IdentifierParser.parseMember((IdentifierParser.Builder)builder, (String)string, (int)i);
    }

    static Member parseMember(Evaluator evaluator, String string, Hierarchy hierarchy) {
        Member[] members = new Member[]{null};
        int i = FunUtil.parseMember(evaluator, string, 0, members, hierarchy);
        Member member = members[0];
        if (member == null) {
            throw MondrianResource.instance().MdxChildObjectNotFound.ex(string, evaluator.getCube().getQualifiedName());
        }
        return member;
    }

    public static boolean worthCaching(Exp exp) {
        ResolvedFunCall call;
        if (exp instanceof Literal) {
            return false;
        }
        if (exp instanceof MemberExpr || exp instanceof LevelExpr || exp instanceof HierarchyExpr || exp instanceof DimensionExpr) {
            return false;
        }
        if (exp instanceof ResolvedFunCall && (call = (ResolvedFunCall)exp).getFunDef() instanceof SetFunDef) {
            for (Exp setArg : call.getArgs()) {
                if (!FunUtil.worthCaching(setArg)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjIntPair<T> {
        final T t;
        final int i;

        public ObjIntPair(T t, int i) {
            this.t = t;
            this.i = i;
        }

        public int hashCode() {
            return Util.hash(this.i, this.t);
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof ObjIntPair && this.i == ((ObjIntPair)obj).i && Util.equals(this.t, ((ObjIntPair)obj).t);
        }

        public String toString() {
            return "<" + this.t + ", " + this.i + ">";
        }
    }

    public static class OrderKey
    implements Comparable {
        private final Member member;

        public OrderKey(Member member) {
            this.member = member;
        }

        public int compareTo(Object o) {
            assert (o instanceof OrderKey);
            Member otherMember = ((OrderKey)o).member;
            boolean thisCalculated = this.member.isCalculatedInQuery();
            boolean otherCalculated = otherMember.isCalculatedInQuery();
            if (thisCalculated) {
                if (!otherCalculated) {
                    return 1;
                }
            } else if (otherCalculated) {
                return -1;
            }
            Comparable thisKey = this.member.getOrderKey();
            Comparable otherKey = otherMember.getOrderKey();
            if (thisKey != null && otherKey != null) {
                return thisKey.compareTo(otherKey);
            }
            return this.member.compareTo(otherMember);
        }
    }

    static class SortKeySpec {
        private final Calc key;
        private final Flag direction;

        SortKeySpec(Calc key, Flag dir) {
            this.key = key;
            this.direction = dir;
        }

        Calc getKey() {
            return this.key;
        }

        Flag getDirection() {
            return this.direction;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Flag {
        ASC(false, false),
        DESC(true, false),
        BASC(false, true),
        BDESC(true, true);

        final boolean descending;
        final boolean brk;

        private Flag(boolean descending, boolean brk) {
            this.descending = descending;
            this.brk = brk;
        }

        public static String[] getNames() {
            ArrayList<String> names = new ArrayList<String>();
            for (Flag flags : (Flag[])Flag.class.getEnumConstants()) {
                names.add(flags.name());
            }
            return names.toArray(new String[names.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullMember
    implements Member {
        private NullMember() {
        }

        @Override
        public Member getParentMember() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Level getLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hierarchy getHierarchy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getParentUniqueName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Member.MemberType getMemberType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isParentChildLeaf() {
            return false;
        }

        @Override
        public boolean isParentChildPhysicalMember() {
            return false;
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAll() {
            return false;
        }

        @Override
        public boolean isMeasure() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public boolean isChildOrEqualTo(Member member) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCalculated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEvaluated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSolveOrder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Exp getExpression() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Member> getAncestorMembers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCalculatedInQuery() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getPropertyValue(String propertyName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getPropertyValue(String propertyName, boolean matchCase) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPropertyFormattedValue(String propertyName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setProperty(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Property[] getProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getOrdinal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Comparable getOrderKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isHidden() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDepth() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Member getDataMember() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUniqueName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getQualifiedName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCaption() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLocalized(OlapElement.LocalizedProperty prop, Locale locale) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isVisible() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Dimension getDimension() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Annotation> getAnnotationMap() {
            throw new UnsupportedOperationException();
        }

        public int compareTo(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }

    public static class DescendingValueComparator
    implements Comparator {
        static final DescendingValueComparator instance = new DescendingValueComparator();

        public int compare(Object o1, Object o2) {
            return -FunUtil.compareValues(o1, o2);
        }
    }

    static class SetWrapper {
        List v = new ArrayList();
        public int errorCount = 0;
        public int nullCount = 0;

        SetWrapper() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HierarchizeComparator
    implements Comparator<Member> {
        private final boolean post;

        HierarchizeComparator(boolean post) {
            this.post = post;
        }

        @Override
        public int compare(Member m1, Member m2) {
            return FunUtil.compareHierarchically(m1, m2, this.post);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HierarchizeTupleComparator
    extends TupleComparator {
        private final boolean post;

        HierarchizeTupleComparator(int arity, boolean post) {
            super(arity);
            this.post = post;
        }

        @Override
        public int compare(List<Member> a1, List<Member> a2) {
            for (int i = 0; i < this.arity; ++i) {
                Member m2;
                Member m1 = a1.get(i);
                int c = FunUtil.compareHierarchically(m1, m2 = a2.get(i), this.post);
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HierarchicalTupleKeyComparator
    extends TupleExpMemoComparator {
        HierarchicalTupleKeyComparator(Evaluator e, Calc calc, int arity) {
            super(e, calc, arity);
        }

        @Override
        public int compare(List<Member> a1, List<Member> a2) {
            OrderKey k1 = (OrderKey)this.eval(a1);
            OrderKey k2 = (OrderKey)this.eval(a2);
            return this.compareMemberOrderKeysHierarchically(k1, k2);
        }

        private int compareMemberOrderKeysHierarchically(OrderKey k1, OrderKey k2) {
            Member prev2;
            Member prev1;
            Member m2;
            if (k1 == Util.nullValue) {
                return -1;
            }
            if (k2 == Util.nullValue) {
                return 1;
            }
            Member m1 = k1.member;
            if (FunUtil.equals(m1, m2 = k2.member)) {
                return 0;
            }
            while (true) {
                int depth2;
                int depth1;
                if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                    if (!FunUtil.equals(m1, m2 = m2.getParentMember())) continue;
                    return -1;
                }
                if (depth1 > depth2) {
                    if (!FunUtil.equals(m1 = m1.getParentMember(), m2)) continue;
                    return 1;
                }
                prev1 = m1;
                prev2 = m2;
                if (FunUtil.equals(m1 = m1.getParentMember(), m2 = m2.getParentMember())) break;
            }
            OrderKey pk1 = new OrderKey(prev1);
            OrderKey pk2 = new OrderKey(prev2);
            return FunUtil.compareValues(pk1, pk2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BreakTupleComparator
    extends TupleExpMemoComparator {
        BreakTupleComparator(Evaluator e, Calc calc, int arity) {
            super(e, calc, arity);
        }

        @Override
        public int compare(List<Member> a1, List<Member> a2) {
            return FunUtil.compareValues(this.eval(a1), this.eval(a2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class TupleExpMemoComparator
    extends TupleExpComparator {
        private final Map<List<Member>, Object> valueMap = new HashMap<List<Member>, Object>();

        TupleExpMemoComparator(Evaluator e, Calc calc, int arity) {
            super(e, calc, arity);
        }

        protected Object eval(List<Member> t) {
            Object val = this.valueMap.get(t);
            if (val != null) {
                return val;
            }
            return this.compute(t);
        }

        private Object compute(List<Member> key) {
            this.evaluator.setContext(key);
            Object val = this.calc.evaluate(this.evaluator);
            if (val == null) {
                val = Util.nullValue;
            }
            this.valueMap.put(key, val);
            return val;
        }

        void preloadValues(TupleList tuples) {
            for (List t : tuples) {
                this.compute(t);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HierarchicalTupleComparator
    extends TupleExpComparator {
        private final boolean desc;

        HierarchicalTupleComparator(Evaluator evaluator, Calc calc, int arity, boolean desc) {
            super(evaluator, calc, arity);
            this.desc = desc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compare(List<Member> a1, List<Member> a2) {
            int c = 0;
            int savepoint = this.evaluator.savepoint();
            try {
                for (int i = 0; i < this.arity; ++i) {
                    Member m2;
                    Member m1 = a1.get(i);
                    c = this.compareHierarchicallyButSiblingsByValue(m1, m2 = a2.get(i));
                    if (c != 0) {
                        break;
                    }
                    assert (m1.equals(m2));
                    this.evaluator.setContext(m1);
                }
            }
            finally {
                this.evaluator.restore(savepoint);
            }
            return c;
        }

        protected int compareHierarchicallyButSiblingsByValue(Member m1, Member m2) {
            Member prev2;
            Member prev1;
            if (FunUtil.equals(m1, m2)) {
                return 0;
            }
            while (true) {
                int depth2;
                int depth1;
                if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                    if (!FunUtil.equals(m1, m2 = m2.getParentMember())) continue;
                    return -1;
                }
                if (depth1 > depth2) {
                    if (!FunUtil.equals(m1 = m1.getParentMember(), m2)) continue;
                    return 1;
                }
                prev1 = m1;
                prev2 = m2;
                if (FunUtil.equals(m1 = m1.getParentMember(), m2 = m2.getParentMember())) break;
            }
            int c = this.compareByValue(prev1, prev2);
            if (c == 0) {
                c = FunUtil.compareSiblingMembers(prev1, prev2);
            }
            return this.desc ? -c : c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int compareByValue(Member m1, Member m2) {
            int savepoint = this.evaluator.savepoint();
            try {
                int c;
                this.evaluator.setContext(m1);
                Object v1 = this.calc.evaluate(this.evaluator);
                this.evaluator.setContext(m2);
                Object v2 = this.calc.evaluate(this.evaluator);
                int n = c = FunUtil.compareValues(v1, v2);
                return n;
            }
            finally {
                this.evaluator.restore(savepoint);
            }
        }
    }

    private static abstract class TupleExpComparator
    extends TupleComparator {
        Evaluator evaluator;
        final Calc calc;

        TupleExpComparator(Evaluator evaluator, Calc calc, int arity) {
            super(arity);
            this.evaluator = evaluator;
            this.calc = calc;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class TupleComparator
    implements Comparator<List<Member>> {
        final int arity;

        TupleComparator(int arity) {
            this.arity = arity;
        }
    }

    private static class BreakMemberComparator
    extends MemberComparator {
        BreakMemberComparator(Evaluator evaluator, Calc exp, boolean desc) {
            super(evaluator, exp, desc);
        }

        public final int compare(Member m1, Member m2) {
            return this.compareByValue(m1, m2);
        }
    }

    private static class HierarchicalMemberComparator
    extends MemberComparator {
        HierarchicalMemberComparator(Evaluator evaluator, Calc exp, boolean desc) {
            super(evaluator, exp, desc);
        }

        public int compare(Member m1, Member m2) {
            return this.compareHierarchicallyButSiblingsByValue(m1, m2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class MemberComparator
    implements Comparator<Member> {
        private static final Logger LOGGER = Logger.getLogger(MemberComparator.class);
        final Evaluator evaluator;
        final Calc exp;
        private final int descMask;
        private final Map<Member, Object> valueMap;

        MemberComparator(Evaluator evaluator, Calc exp, boolean desc) {
            this.evaluator = evaluator;
            this.exp = exp;
            this.descMask = desc ? -1 : 1;
            this.valueMap = new HashMap<Member, Object>();
        }

        private int maybeNegate(int c) {
            return this.descMask * c;
        }

        protected Object eval(Member m) {
            Object val = this.valueMap.get(m);
            if (val == null) {
                this.evaluator.setContext(m);
                val = this.exp.evaluate(this.evaluator);
                if (val == null) {
                    val = Util.nullValue;
                }
                this.valueMap.put(m, val);
            }
            return val;
        }

        Comparator<Member> wrap() {
            final MemberComparator comparator = this;
            if (LOGGER.isDebugEnabled()) {
                return new Comparator<Member>(){

                    @Override
                    public int compare(Member m1, Member m2) {
                        int c = comparator.compare(m1, m2);
                        LOGGER.debug((Object)("compare " + m1.getUniqueName() + "(" + MemberComparator.this.eval(m1) + "), " + m2.getUniqueName() + "(" + MemberComparator.this.eval(m2) + ")" + " yields " + c));
                        return c;
                    }
                };
            }
            return this;
        }

        void preloadValues(Map<Member, Object> map) {
            this.valueMap.putAll(map);
        }

        void preloadValues(Collection<Member> members) {
            for (Member m : members) {
                this.eval(m);
            }
        }

        protected final int compareByValue(Member m1, Member m2) {
            int c = FunUtil.compareValues(this.eval(m1), this.eval(m2));
            return this.maybeNegate(c);
        }

        protected final int compareHierarchicallyButSiblingsByValue(Member m1, Member m2) {
            Member prev2;
            Member prev1;
            if (FunUtil.equals(m1, m2)) {
                return 0;
            }
            while (true) {
                int depth2;
                int depth1;
                if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                    if (!Util.equals(m1, m2 = m2.getParentMember())) continue;
                    return -1;
                }
                if (depth1 > depth2) {
                    if (!Util.equals(m1 = m1.getParentMember(), m2)) continue;
                    return 1;
                }
                prev1 = m1;
                prev2 = m2;
                if (Util.equals(m1 = m1.getParentMember(), m2 = m2.getParentMember())) break;
            }
            int c = this.compareByValue(prev1, prev2);
            if (c != 0) {
                return c;
            }
            c = FunUtil.compareSiblingMembers(prev1, prev2);
            return c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Quicksorter<T> {
        public final int TOO_SMALL = 8;
        private static final Logger LOGGER = Logger.getLogger(Quicksorter.class);
        private final T[] vec;
        private final Comparator<T> comp;
        private final boolean traced;
        private long partitions;
        private long comparisons;
        private long exchanges;

        public Quicksorter(T[] vec, Comparator<T> comp) {
            this.vec = vec;
            this.comp = comp;
            this.exchanges = 0L;
            this.comparisons = 0L;
            this.partitions = 0L;
            this.traced = LOGGER.isDebugEnabled();
        }

        private void traceStats(String prefix) {
            StringBuilder sb = new StringBuilder(prefix);
            sb.append(": ");
            sb.append(this.partitions).append(" partitions, ");
            sb.append(this.comparisons).append(" comparisons, ");
            sb.append(this.exchanges).append(" exchanges.");
            LOGGER.debug((Object)sb.toString());
        }

        private boolean less(T x, T y) {
            ++this.comparisons;
            return this.comp.compare(x, y) < 0;
        }

        private boolean more(T x, T y) {
            ++this.comparisons;
            return this.comp.compare(x, y) > 0;
        }

        private boolean equal(T x, T y) {
            ++this.comparisons;
            return this.comp.compare(x, y) == 0;
        }

        private void swap(int i, int j) {
            ++this.exchanges;
            T temp = this.vec[i];
            this.vec[i] = this.vec[j];
            this.vec[j] = temp;
        }

        private void order3(int i, int j, int k) {
            if (this.more(this.vec[i], this.vec[j])) {
                this.swap(i, j);
            }
            if (this.more(this.vec[i], this.vec[k])) {
                this.swap(i, k);
            }
            if (this.more(this.vec[j], this.vec[k])) {
                this.swap(j, k);
            }
        }

        private void selectionSort(int start, int end) {
            for (int i = start; i < end; ++i) {
                int pmin = i;
                for (int j = i + 1; j <= end; ++j) {
                    if (!this.less(this.vec[j], this.vec[pmin])) continue;
                    pmin = j;
                }
                if (pmin == i) continue;
                this.swap(i, pmin);
            }
        }

        private int partition(int start, int end) {
            ++this.partitions;
            assert (start <= end);
            int mid = (start + end) / 2;
            this.order3(start, mid, end);
            if (end - start <= 2) {
                return mid;
            }
            T pivot = this.vec[mid];
            this.swap(mid, end - 1);
            int left = start + 1;
            int right = end - 2;
            while (left < right) {
                while (this.less(this.vec[left], pivot)) {
                    ++left;
                }
                while (this.less(pivot, this.vec[right])) {
                    --right;
                }
                if (left >= right) continue;
                this.swap(left, right);
                ++left;
                --right;
            }
            if (left == right && this.less(this.vec[left], pivot)) {
                ++left;
            }
            this.swap(left, end - 1);
            return left;
        }

        private void sort(int start, int end) {
            if (end - start < 8) {
                this.selectionSort(start, end);
                return;
            }
            int mid = this.partition(start, end);
            this.sort(start, mid - 1);
            this.sort(mid + 1, end);
        }

        private void select(int limit, int start, int end) {
            if (limit == 0) {
                return;
            }
            if (end - start < 8) {
                this.selectionSort(start, end);
                return;
            }
            int mid = this.partition(start, end);
            int leftSize = mid - start + 1;
            if (limit < leftSize) {
                this.select(limit, start, mid);
            } else {
                this.select(limit -= leftSize, mid + 1, end);
            }
        }

        public void sort() {
            int n = this.vec.length - 1;
            this.sort(0, n);
            if (this.traced) {
                this.traceStats("quicksort on " + n + "items");
            }
        }

        public void select(int limit) {
            int n = this.vec.length - 1;
            this.select(limit, 0, n);
            if (this.traced) {
                this.traceStats("quickselect for " + limit + " from" + n + "items");
            }
        }

        public void partialSort(int limit) {
            int n = this.vec.length - 1;
            this.select(limit, 0, n);
            if (this.traced) {
                this.traceStats("partial sort: quickselect phase for " + limit + "from " + n + "items");
            }
            this.sort(0, limit - 1);
            if (this.traced) {
                this.traceStats("partial sort: quicksort phase on " + n + "items");
            }
        }
    }
}

