/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun.extra;

import mondrian.calc.Calc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.ReflectiveMultiResolver;

public class NthQuartileFunDef
extends AbstractAggregateFunDef {
    private final int range;
    public static final MultiResolver ThirdQResolver = new ReflectiveMultiResolver("ThirdQ", "ThirdQ(<Set>[, <Numeric Expression>])", "Returns the 3rd quartile value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}, NthQuartileFunDef.class);
    public static final MultiResolver FirstQResolver = new ReflectiveMultiResolver("FirstQ", "FirstQ(<Set>[, <Numeric Expression>])", "Returns the 1st quartile value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}, NthQuartileFunDef.class);

    public NthQuartileFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
        this.range = dummyFunDef.getName().equals("FirstQ") ? 1 : 3;
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        final DoubleCalc doubleCalc = call.getArgCount() > 1 ? compiler.compileDouble(call.getArg(1)) : new ValueCalc(call);
        return new AbstractDoubleCalc(call, new Calc[]{listCalc, doubleCalc}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public double evaluateDouble(Evaluator evaluator) {
                int savepoint = evaluator.savepoint();
                try {
                    evaluator.setNonEmpty(false);
                    TupleList members = NthQuartileFunDef.evaluateCurrentList(listCalc, evaluator);
                    double d = NthQuartileFunDef.quartile(evaluator, members, doubleCalc, NthQuartileFunDef.this.range);
                    return d;
                }
                finally {
                    evaluator.restore(savepoint);
                }
            }

            public boolean dependsOn(Hierarchy hierarchy) {
                return 1.anyDependsButFirst(this.getCalcs(), hierarchy);
            }
        };
    }
}

