/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.CacheControl;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.MondrianException;
import mondrian.olap.OlapElement;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.VisualTotalsFunDef;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.CacheControlImpl;
import mondrian.rolap.CellReader;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCacheRegion;
import mondrian.rolap.RolapCell;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.DrillThroughCellRequest;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.agg.OrPredicate;
import mondrian.rolap.agg.RangeColumnPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RolapAggregationManager {
    protected RolapAggregationManager() {
    }

    public static CellRequest makeRequest(Member[] members) {
        return RolapAggregationManager.makeCellRequest(members, false, false, null, null, null);
    }

    public static DrillThroughCellRequest makeDrillThroughRequest(Member[] members, boolean extendedContext, RolapCube cube, List<Exp> fieldsList) {
        assert (cube != null);
        return (DrillThroughCellRequest)RolapAggregationManager.makeCellRequest(members, true, extendedContext, cube, fieldsList, null);
    }

    public static CellRequest makeRequest(RolapEvaluator evaluator) {
        Member[] currentMembers = evaluator.getNonAllMembers();
        List<List<List<Member>>> aggregationLists = evaluator.getAggregationLists();
        RolapStoredMeasure measure = (RolapStoredMeasure)currentMembers[0];
        RolapStar.Measure starMeasure = (RolapStar.Measure)measure.getStarMeasure();
        assert (starMeasure != null);
        int starColumnCount = starMeasure.getStar().getColumnCount();
        CellRequest request = RolapAggregationManager.makeCellRequest(currentMembers, false, false, null, null, evaluator);
        if (request == null) {
            return null;
        }
        if (aggregationLists == null) {
            return request;
        }
        for (List<List<Member>> aggregationList : aggregationLists) {
            BitKey compoundBitKey = BitKey.Factory.makeBitKey(starColumnCount);
            compoundBitKey.clear();
            LinkedHashMap<BitKey, List<RolapCubeMember[]>> compoundGroupMap = new LinkedHashMap<BitKey, List<RolapCubeMember[]>>();
            ArrayList<List<RolapMember>> rolapAggregationList = new ArrayList<List<RolapMember>>();
            for (List<Member> members : aggregationList) {
                List rolapMembers = Util.cast(members);
                rolapAggregationList.add(rolapMembers);
            }
            boolean unsatisfiable = RolapAggregationManager.makeCompoundGroup(starColumnCount, measure.getCube(), rolapAggregationList, compoundGroupMap);
            if (unsatisfiable) {
                return null;
            }
            StarPredicate compoundPredicate = RolapAggregationManager.makeCompoundPredicate(compoundGroupMap, measure.getCube());
            if (compoundPredicate == null) continue;
            for (BitKey bitKey : compoundGroupMap.keySet()) {
                compoundBitKey = compoundBitKey.or(bitKey);
            }
            request.addAggregateList(compoundBitKey, compoundPredicate);
        }
        return request;
    }

    private static CellRequest makeCellRequest(Member[] members, boolean drillThrough, boolean extendedContext, RolapCube cube, List<Exp> fieldsList, Evaluator evaluator) {
        RolapStoredMeasure measure;
        assert (drillThrough == (cube != null));
        if (extendedContext) assert (drillThrough);
        if (drillThrough) {
            if ((cube = RolapCell.chooseDrillThroughCube(members, cube)) == null) {
                return null;
            }
            measure = members.length > 0 && members[0] instanceof RolapStoredMeasure ? (RolapStoredMeasure)members[0] : (RolapStoredMeasure)cube.getMeasures().get(0);
        } else if (members.length > 0 && members[0] instanceof RolapStoredMeasure) {
            measure = (RolapStoredMeasure)members[0];
        } else {
            return null;
        }
        RolapStar.Measure starMeasure = (RolapStar.Measure)measure.getStarMeasure();
        assert (starMeasure != null);
        CellRequest request = drillThrough ? new DrillThroughCellRequest(starMeasure, extendedContext) : new CellRequest(starMeasure, extendedContext, drillThrough);
        if (extendedContext) {
            if (fieldsList != null) {
                SchemaReader reader = cube.getSchemaReader().withLocus();
                for (Exp exp : fieldsList) {
                    OlapElement member = reader.lookupCompound(cube, Util.parseIdentifier(exp.toString()), true, 0);
                    if (member.getHierarchy() instanceof RolapCubeHierarchy && ((RolapCubeHierarchy)member.getHierarchy()).getRolapHierarchy().closureFor != null) continue;
                    RolapAggregationManager.addNonConstrainingColumns(member, cube, request);
                }
            }
            for (int i = 1; i < members.length; ++i) {
                RolapCubeMember member = (RolapCubeMember)members[i];
                if (member.getHierarchy().getRolapHierarchy().closureFor != null) continue;
                RolapAggregationManager.addNonConstrainingColumns(member, cube, request);
                RolapCubeLevel level = member.getLevel();
                boolean needToReturnNull = level.getLevelReader().constrainRequest(member, measure.getCube(), request);
                if (!needToReturnNull) continue;
                return null;
            }
        } else {
            for (int i = 1; i < members.length; ++i) {
                RolapCubeMember member;
                RolapCubeLevel level;
                boolean needToReturnNull;
                if (!(members[i] instanceof RolapCubeMember) || !(needToReturnNull = (level = (member = (RolapCubeMember)members[i]).getLevel()).getLevelReader().constrainRequest(member, measure.getCube(), request)) || evaluator != null && evaluator.mightReturnNullForUnrelatedDimension() && !evaluator.needToReturnNullForUnrelatedDimension(new Member[]{member})) continue;
                return null;
            }
        }
        return request;
    }

    private static void addNonConstrainingColumns(RolapCubeMember member, RolapCube baseCube, CellRequest request) {
        RolapCubeHierarchy hierarchy = member.getHierarchy();
        RolapCubeLevel[] levels = hierarchy.getLevels();
        int depth = member.getLevel().getDepth();
        for (int j = levels.length - 1; j > depth; --j) {
            RolapCubeLevel level = levels[j];
            RolapStar.Column column = level.getBaseStarKeyColumn(baseCube);
            if (column == null) continue;
            request.addConstrainedColumn(column, null);
            if (!request.extendedContext || level.getNameExp() == null) continue;
            RolapStar.Column nameColumn = column.getNameColumn();
            Util.assertTrue(nameColumn != null);
            request.addConstrainedColumn(nameColumn, null);
        }
    }

    private static void addNonConstrainingColumns(OlapElement member, RolapCube baseCube, CellRequest request) {
        RolapCubeLevel level;
        if (member instanceof RolapCubeLevel) {
            level = (RolapCubeLevel)member;
        } else if (member instanceof RolapCubeHierarchy || member instanceof RolapCubeDimension) {
            level = (RolapCubeLevel)member.getHierarchy().getLevels()[0];
            if (level.isAll()) {
                level = level.getChildLevel();
            }
        } else {
            if (member instanceof RolapStar.Measure) {
                ((DrillThroughCellRequest)request).addDrillThroughMeasure((RolapStar.Measure)((Object)member));
                return;
            }
            if (member instanceof RolapBaseCubeMeasure) {
                ((DrillThroughCellRequest)request).addDrillThroughMeasure((RolapStar.Measure)((RolapBaseCubeMeasure)member).getStarMeasure());
                return;
            }
            if (member instanceof RolapHierarchy.RolapCalculatedMeasure) {
                throw MondrianResource.instance().DrillthroughCalculatedMember.ex(member.getUniqueName());
            }
            throw new MondrianException("Unknown member type in DRILLTHROUGH operation.");
        }
        RolapStar.Column column = level.getBaseStarKeyColumn(baseCube);
        if (column != null) {
            request.addConstrainedColumn(column, null);
            ((DrillThroughCellRequest)request).addDrillThroughColumn(column);
            if (request.extendedContext && level.getNameExp() != null) {
                RolapStar.Column nameColumn = column.getNameColumn();
                Util.assertTrue(nameColumn != null);
                request.addConstrainedColumn(nameColumn, null);
            }
        }
    }

    private static boolean makeCompoundGroup(int starColumnCount, RolapCube baseCube, List<List<RolapMember>> aggregationList, Map<BitKey, List<RolapCubeMember[]>> compoundGroupMap) {
        int unsatisfiableTupleCount = 0;
        for (List<RolapMember> aggregation : aggregationList) {
            if (aggregation.size() <= 0 || !(aggregation.get(0) instanceof RolapCubeMember) && !(aggregation.get(0) instanceof VisualTotalsFunDef.VisualTotalMember)) {
                ++unsatisfiableTupleCount;
                continue;
            }
            boolean isTuple = true;
            BitKey bitKey = BitKey.Factory.makeBitKey(starColumnCount);
            RolapCubeMember[] tuple = new RolapCubeMember[aggregation.size()];
            int i = 0;
            for (RolapMember member : aggregation) {
                tuple[i] = member instanceof VisualTotalsFunDef.VisualTotalMember ? (RolapCubeMember)((VisualTotalsFunDef.VisualTotalMember)member).getMember() : (RolapCubeMember)member;
                ++i;
            }
            boolean tupleUnsatisfiable = false;
            for (RolapCubeMember member : tuple) {
                tupleUnsatisfiable = RolapAggregationManager.makeCompoundGroupForMember(member, baseCube, bitKey);
                if (!tupleUnsatisfiable) continue;
                ++unsatisfiableTupleCount;
                break;
            }
            if (tupleUnsatisfiable || bitKey.isEmpty()) continue;
            RolapAggregationManager.addTupleToCompoundGroupMap(tuple, bitKey, compoundGroupMap);
        }
        return unsatisfiableTupleCount == aggregationList.size();
    }

    private static void addTupleToCompoundGroupMap(RolapCubeMember[] tuple, BitKey bitKey, Map<BitKey, List<RolapCubeMember[]>> compoundGroupMap) {
        List<RolapCubeMember[]> compoundGroup = compoundGroupMap.get(bitKey);
        if (compoundGroup == null) {
            compoundGroup = new ArrayList<RolapCubeMember[]>();
            compoundGroupMap.put(bitKey, compoundGroup);
        }
        compoundGroup.add(tuple);
    }

    private static boolean makeCompoundGroupForMember(RolapCubeMember member, RolapCube baseCube, BitKey bitKey) {
        boolean memberUnsatisfiable = false;
        for (RolapCubeMember levelMember = member; levelMember != null; levelMember = levelMember.getParentMember()) {
            RolapCubeLevel level = levelMember.getLevel();
            if (level.isAll()) continue;
            RolapStar.Column column = level.getBaseStarKeyColumn(baseCube);
            if (column != null) {
                bitKey.set(column.getBitPosition());
                continue;
            }
            memberUnsatisfiable = true;
            break;
        }
        return memberUnsatisfiable;
    }

    private static StarPredicate makeCompoundPredicate(Map<BitKey, List<RolapCubeMember[]>> compoundGroupMap, RolapCube baseCube) {
        ArrayList<StarPredicate> compoundPredicateList = new ArrayList<StarPredicate>();
        for (List<RolapCubeMember[]> group : compoundGroupMap.values()) {
            StarPredicate compoundGroupPredicate = null;
            for (RolapCubeMember[] tuple : group) {
                StarPredicate tuplePredicate = null;
                for (RolapCubeMember member : tuple) {
                    tuplePredicate = RolapAggregationManager.makeCompoundPredicateForMember(member, baseCube, tuplePredicate);
                }
                if (tuplePredicate == null) continue;
                if (compoundGroupPredicate == null) {
                    compoundGroupPredicate = tuplePredicate;
                    continue;
                }
                compoundGroupPredicate = compoundGroupPredicate.or(tuplePredicate);
            }
            if (compoundGroupPredicate == null) continue;
            compoundPredicateList.add(compoundGroupPredicate);
        }
        StarPredicate compoundPredicate = null;
        if (compoundPredicateList.size() > 1) {
            compoundPredicate = new OrPredicate(compoundPredicateList);
        } else if (compoundPredicateList.size() == 1) {
            compoundPredicate = (StarPredicate)compoundPredicateList.get(0);
        }
        return compoundPredicate;
    }

    private static StarPredicate makeCompoundPredicateForMember(RolapCubeMember member, RolapCube baseCube, StarPredicate memberPredicate) {
        while (member != null) {
            RolapCubeLevel level = member.getLevel();
            if (!level.isAll()) {
                RolapStar.Column column = level.getBaseStarKeyColumn(baseCube);
                memberPredicate = memberPredicate == null ? new ValueColumnPredicate(column, member.getKey()) : memberPredicate.and(new ValueColumnPredicate(column, member.getKey()));
            }
            if (member.getLevel().isUnique()) break;
            member = member.getParentMember();
        }
        return memberPredicate;
    }

    public abstract Object getCellFromCache(CellRequest var1);

    public abstract Object getCellFromCache(CellRequest var1, PinSet var2);

    public abstract String getDrillThroughSql(DrillThroughCellRequest var1, StarPredicate var2, List<Exp> var3, boolean var4);

    public static RolapCacheRegion makeCacheRegion(RolapStar star, CacheControl.CellRegion region) {
        List<Member> measureList = CacheControlImpl.findMeasures(region);
        ArrayList<RolapStar.Measure> starMeasureList = new ArrayList<RolapStar.Measure>();
        RolapCube baseCube = null;
        for (Member measure : measureList) {
            if (!(measure instanceof RolapStoredMeasure)) continue;
            RolapStoredMeasure storedMeasure = (RolapStoredMeasure)measure;
            RolapStar.Measure starMeasure = (RolapStar.Measure)storedMeasure.getStarMeasure();
            assert (starMeasure != null);
            if (star != starMeasure.getStar()) continue;
            baseCube = storedMeasure.getCube();
            starMeasureList.add(starMeasure);
        }
        RolapCacheRegion cacheRegion = new RolapCacheRegion(star, starMeasureList);
        if (region instanceof CacheControlImpl.CrossjoinCellRegion) {
            CacheControlImpl.CrossjoinCellRegion crossjoin = (CacheControlImpl.CrossjoinCellRegion)region;
            for (CacheControl.CellRegion component : crossjoin.getComponents()) {
                RolapAggregationManager.constrainCacheRegion(cacheRegion, baseCube, component);
            }
        } else {
            RolapAggregationManager.constrainCacheRegion(cacheRegion, baseCube, region);
        }
        return cacheRegion;
    }

    private static void constrainCacheRegion(RolapCacheRegion cacheRegion, RolapCube baseCube, CacheControl.CellRegion region) {
        if (region instanceof CacheControlImpl.MemberCellRegion) {
            CacheControlImpl.MemberCellRegion memberCellRegion = (CacheControlImpl.MemberCellRegion)region;
            List<Member> memberList = memberCellRegion.getMemberList();
            for (Member member : memberList) {
                if (member.isMeasure()) continue;
                RolapCubeMember rolapMember = member instanceof RolapCubeMember ? (RolapCubeMember)member : (RolapCubeMember)baseCube.getSchemaReader().getMemberByUniqueName(Util.parseIdentifier(member.getUniqueName()), true);
                RolapCubeLevel level = rolapMember.getLevel();
                RolapStar.Column column = level.getBaseStarKeyColumn(baseCube);
                level.getLevelReader().constrainRegion(new MemberColumnPredicate(column, rolapMember), baseCube, cacheRegion);
            }
        } else if (region instanceof CacheControlImpl.MemberRangeCellRegion) {
            CacheControlImpl.MemberRangeCellRegion rangeRegion = (CacheControlImpl.MemberRangeCellRegion)region;
            RolapCubeLevel level = (RolapCubeLevel)rangeRegion.getLevel();
            RolapStar.Column column = level.getBaseStarKeyColumn(baseCube);
            level.getLevelReader().constrainRegion(new RangeColumnPredicate(column, rangeRegion.getLowerInclusive(), rangeRegion.getLowerBound() == null ? null : new MemberColumnPredicate(column, rangeRegion.getLowerBound()), rangeRegion.getUpperInclusive(), rangeRegion.getUpperBound() == null ? null : new MemberColumnPredicate(column, rangeRegion.getUpperBound())), baseCube, cacheRegion);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public CellReader getCacheCellReader() {
        return new CellReader(){

            public Object get(RolapEvaluator evaluator) {
                CellRequest request = RolapAggregationManager.makeRequest(evaluator);
                if (request == null || request.isUnsatisfiable()) {
                    return Util.nullValue;
                }
                return RolapAggregationManager.this.getCellFromCache(request);
            }

            public int getMissCount() {
                return 0;
            }

            public boolean isDirty() {
                return false;
            }
        };
    }

    public abstract PinSet createPinSet();

    public static interface PinSet {
    }
}

