/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.olap.Util;
import mondrian.rolap.RolapCalculation;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapEvaluatorRoot;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RolapTupleCalculation
implements RolapCalculation {
    private final List<RolapHierarchy> hierarchyList;
    private final Calc calc;
    private final int hashCode;

    public RolapTupleCalculation(List<RolapHierarchy> hierarchyList, Calc calc) {
        this.hierarchyList = hierarchyList;
        this.calc = calc;
        this.hashCode = Util.hash(((Object)hierarchyList).hashCode(), calc);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RolapTupleCalculation) {
            RolapTupleCalculation calculation = (RolapTupleCalculation)obj;
            return ((Object)this.hierarchyList).equals(calculation.hierarchyList) && this.calc.equals(calculation.calc);
        }
        return false;
    }

    public String toString() {
        return this.calc.toString();
    }

    @Override
    public void setContextIn(RolapEvaluator evaluator) {
        for (RolapHierarchy hierarchy : this.hierarchyList) {
            int ordinal = hierarchy.getOrdinalInCube();
            RolapMember defaultMember = evaluator.root.defaultMembers[ordinal];
            evaluator.setContext(defaultMember);
        }
        evaluator.removeCalculation(this, true);
    }

    @Override
    public int getSolveOrder() {
        return Integer.MIN_VALUE;
    }

    @Override
    public int getHierarchyOrdinal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Calc getCompiledExpression(RolapEvaluatorRoot root) {
        return this.calc;
    }

    @Override
    public boolean containsAggregateFunction() {
        return false;
    }

    @Override
    public boolean isCalculatedInQuery() {
        return true;
    }
}

