/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mondrian.olap.Util;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.rolap.sql.SqlQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListColumnPredicate
extends AbstractColumnPredicate {
    private final List<StarColumnPredicate> children;
    private HashMap<Integer, List<StarColumnPredicate>> childrenHashMap;
    private final Set<Object> values;
    private int hashValue;

    public ListColumnPredicate(RolapStar.Column column, List<StarColumnPredicate> list) {
        super(column);
        this.children = list;
        this.childrenHashMap = null;
        this.hashValue = 0;
        this.values = ListColumnPredicate.createValues(list);
    }

    private static Set<Object> createValues(List<StarColumnPredicate> list) {
        HashSet<Object> set = new HashSet<Object>();
        for (StarColumnPredicate predicate : list) {
            if (predicate instanceof ValueColumnPredicate) {
                set.add(((ValueColumnPredicate)predicate).getValue());
                continue;
            }
            return null;
        }
        return set;
    }

    public List<StarColumnPredicate> getPredicates() {
        return this.children;
    }

    public int hashCode() {
        if (this.hashValue == 0) {
            this.hashValue = 37;
            for (StarColumnPredicate child : this.children) {
                int childHashCode = child.hashCode();
                if (childHashCode == 0) continue;
                this.hashValue *= childHashCode;
            }
            this.hashValue ^= this.children.size();
        }
        return this.hashValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ListColumnPredicate) {
            ListColumnPredicate that = (ListColumnPredicate)obj;
            return ((Object)this.children).equals(that.children);
        }
        return false;
    }

    @Override
    public void values(Collection<Object> collection) {
        if (this.values != null) {
            collection.addAll(this.values);
        } else {
            for (StarColumnPredicate child : this.children) {
                child.values(collection);
            }
        }
    }

    @Override
    public boolean evaluate(Object value) {
        for (StarColumnPredicate childPredicate : this.children) {
            if (!childPredicate.evaluate(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equalConstraint(StarPredicate that) {
        boolean isEqual;
        boolean bl = isEqual = that instanceof ListColumnPredicate && this.getConstrainedColumnBitKey().equals(that.getConstrainedColumnBitKey());
        if (isEqual) {
            ListColumnPredicate thatPred = (ListColumnPredicate)that;
            if (this.getPredicates().size() != thatPred.getPredicates().size()) {
                isEqual = false;
            } else {
                if (this.childrenHashMap == null) {
                    this.childrenHashMap = new HashMap();
                    for (StarColumnPredicate thisChild : this.getPredicates()) {
                        Integer key = thisChild.hashCode();
                        List<StarColumnPredicate> predList = this.childrenHashMap.get(key);
                        if (predList == null) {
                            predList = new ArrayList<StarColumnPredicate>();
                            this.childrenHashMap.put(key, predList);
                        }
                        predList.add(thisChild);
                    }
                }
                for (StarColumnPredicate thatChild : thatPred.getPredicates()) {
                    List<StarColumnPredicate> predList = this.childrenHashMap.get(thatChild.hashCode());
                    if (predList == null) {
                        isEqual = false;
                        break;
                    }
                    boolean foundMatch = false;
                    for (StarColumnPredicate pred : predList) {
                        if (!thatChild.equalConstraint(pred)) continue;
                        foundMatch = true;
                        break;
                    }
                    if (foundMatch) continue;
                    isEqual = false;
                    break;
                }
            }
        }
        return isEqual;
    }

    @Override
    public void describe(StringBuilder buf) {
        buf.append("={");
        for (int j = 0; j < this.children.size(); ++j) {
            if (j > 0) {
                buf.append(", ");
            }
            buf.append(this.children.get(j));
        }
        buf.append('}');
    }

    @Override
    public StarColumnPredicate.Overlap intersect(StarColumnPredicate predicate) {
        int matchCount = 0;
        for (StarColumnPredicate flushPredicate : this.children) {
            StarColumnPredicate.Overlap r2 = flushPredicate.intersect(predicate);
            if (!r2.matched) continue;
            if (r2.remaining == null) {
                return r2;
            }
            predicate = r2.remaining;
            ++matchCount;
        }
        if (matchCount == 0) {
            return new StarColumnPredicate.Overlap(false, null, 0.0f);
        }
        float selectivity = (float)matchCount / (float)this.children.size();
        return new StarColumnPredicate.Overlap(true, predicate, selectivity);
    }

    @Override
    public boolean mightIntersect(StarPredicate other) {
        if (other instanceof LiteralStarPredicate) {
            return ((LiteralStarPredicate)other).getValue();
        }
        if (other instanceof ValueColumnPredicate) {
            ValueColumnPredicate valueColumnPredicate = (ValueColumnPredicate)other;
            return this.evaluate(valueColumnPredicate.getValue());
        }
        if (other instanceof ListColumnPredicate) {
            ArrayList<Object> thatSet = new ArrayList<Object>();
            ((ListColumnPredicate)other).values(thatSet);
            for (Object e : thatSet) {
                if (!this.evaluate(e)) continue;
                return true;
            }
            return false;
        }
        throw Util.newInternal("unknown constraint type " + other);
    }

    @Override
    public StarColumnPredicate minus(StarPredicate predicate) {
        assert (predicate != null);
        if (predicate instanceof LiteralStarPredicate) {
            LiteralStarPredicate literalStarPredicate = (LiteralStarPredicate)predicate;
            if (literalStarPredicate.getValue()) {
                return LiteralStarPredicate.FALSE;
            }
            return this;
        }
        StarColumnPredicate columnPredicate = (StarColumnPredicate)predicate;
        ArrayList<StarColumnPredicate> newChildren = new ArrayList<StarColumnPredicate>(this.children);
        int changeCount = 0;
        Iterator iterator = newChildren.iterator();
        while (iterator.hasNext()) {
            ValueColumnPredicate child = (ValueColumnPredicate)iterator.next();
            if (!columnPredicate.evaluate(child.getValue())) continue;
            ++changeCount;
            iterator.remove();
        }
        if (changeCount > 0) {
            return new ListColumnPredicate(this.getConstrainedColumn(), newChildren);
        }
        return this;
    }

    @Override
    public StarColumnPredicate orColumn(StarColumnPredicate predicate) {
        assert (predicate.getConstrainedColumn() == this.getConstrainedColumn());
        if (predicate instanceof ListColumnPredicate) {
            ListColumnPredicate that = (ListColumnPredicate)predicate;
            ArrayList<StarColumnPredicate> list = new ArrayList<StarColumnPredicate>(this.children);
            list.addAll(that.children);
            return new ListColumnPredicate(this.getConstrainedColumn(), list);
        }
        ArrayList<StarColumnPredicate> list = new ArrayList<StarColumnPredicate>(this.children);
        list.add(predicate);
        return new ListColumnPredicate(this.getConstrainedColumn(), list);
    }

    @Override
    public StarColumnPredicate cloneWithColumn(RolapStar.Column column) {
        return new ListColumnPredicate(column, ListColumnPredicate.cloneListWithColumn(column, this.children));
    }

    @Override
    public void toSql(SqlQuery sqlQuery, StringBuilder buf) {
        List<StarColumnPredicate> predicates = this.getPredicates();
        if (predicates.size() == 1) {
            predicates.get(0).toSql(sqlQuery, buf);
            return;
        }
        int notNullCount = 0;
        RolapStar.Column column = this.getConstrainedColumn();
        String expr = column.generateExprString(sqlQuery);
        int marker = buf.length();
        buf.append(expr);
        ValueColumnPredicate firstNotNull = null;
        buf.append(" in (");
        for (StarColumnPredicate predicate1 : predicates) {
            ValueColumnPredicate predicate2 = (ValueColumnPredicate)predicate1;
            Object key = predicate2.getValue();
            if (key == RolapUtil.sqlNullValue) continue;
            if (notNullCount > 0) {
                buf.append(", ");
            } else {
                firstNotNull = predicate2;
            }
            ++notNullCount;
            sqlQuery.getDialect().quote(buf, key, column.getDatatype());
        }
        buf.append(')');
        if (notNullCount >= predicates.size()) {
            return;
        }
        switch (notNullCount) {
            case 0: {
                buf.setLength(marker);
                buf.append(expr);
                buf.append(" is null");
                break;
            }
            case 1: {
                assert (firstNotNull != null);
                buf.setLength(marker);
                buf.append('(');
                buf.append(expr);
                buf.append(" = ");
                sqlQuery.getDialect().quote(buf, firstNotNull.getValue(), column.getDatatype());
                buf.append(" or ");
                buf.append(expr);
                buf.append(" is null)");
                break;
            }
            default: {
                String save = buf.substring(marker);
                buf.setLength(marker);
                buf.append('(');
                buf.append(save);
                buf.append(" or ");
                buf.append(expr);
                buf.append(" is null)");
            }
        }
    }
}

