/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlStatement;
import mondrian.spi.Dialect;
import mondrian.spi.DialectManager;
import mondrian.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlQuery {
    private final boolean generateFormattedSql;
    private boolean distinct;
    private final ClauseList select;
    private final FromClauseList from;
    private final ClauseList where;
    private final ClauseList groupBy;
    private final ClauseList having;
    private final ClauseList orderBy;
    private final List<ClauseList> groupingSets;
    private final ClauseList groupingFunctions;
    private final List<SqlStatement.Type> types = new ArrayList<SqlStatement.Type>();
    private boolean allowHints;
    private final List<String> fromAliases;
    private final Dialect dialect;
    private final StringBuilder buf;
    private final Set<MondrianDef.Relation> relations = new HashSet<MondrianDef.Relation>();
    private final Map<MondrianDef.Relation, MondrianDef.RelationOrJoin> mapRelationToRoot = new HashMap<MondrianDef.Relation, MondrianDef.RelationOrJoin>();
    private final Map<MondrianDef.RelationOrJoin, List<RelInfo>> mapRootToRelations = new HashMap<MondrianDef.RelationOrJoin, List<RelInfo>>();
    private final Map<String, String> columnAliases = new HashMap<String, String>();
    private static final String INDENT = "    ";

    public SqlQuery(Dialect dialect, boolean formatted) {
        assert (dialect != null);
        this.generateFormattedSql = formatted;
        this.select = new ClauseList(true);
        this.from = new FromClauseList(true);
        this.groupingFunctions = new ClauseList(false);
        this.where = new ClauseList(false);
        this.groupBy = new ClauseList(false);
        this.having = new ClauseList(false);
        this.orderBy = new ClauseList(false);
        this.fromAliases = new ArrayList<String>();
        this.buf = new StringBuilder(128);
        this.groupingSets = new ArrayList<ClauseList>();
        this.dialect = dialect;
        this.allowHints = false;
    }

    public SqlQuery(Dialect dialect) {
        this(dialect, MondrianProperties.instance().GenerateFormattedSql.get());
    }

    public SqlQuery cloneEmpty() {
        return new SqlQuery(this.dialect);
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setAllowHints(boolean t) {
        this.allowHints = t;
    }

    public boolean addFromQuery(String query, String alias, boolean failIfExists) {
        assert (alias != null);
        assert (alias.length() > 0);
        if (this.fromAliases.contains(alias)) {
            if (failIfExists) {
                throw Util.newInternal("query already contains alias '" + alias + "'");
            }
            return false;
        }
        this.buf.setLength(0);
        this.buf.append('(');
        this.buf.append(query);
        this.buf.append(')');
        if (this.dialect.allowsAs()) {
            this.buf.append(" as ");
        } else {
            this.buf.append(' ');
        }
        this.dialect.quoteIdentifier(alias, this.buf);
        this.fromAliases.add(alias);
        this.from.add(this.buf.toString());
        return true;
    }

    boolean addFromTable(String schema, String name, String alias, String filter, Map hints, boolean failIfExists) {
        if (this.fromAliases.contains(alias)) {
            if (failIfExists) {
                throw Util.newInternal("query already contains alias '" + alias + "'");
            }
            return false;
        }
        this.buf.setLength(0);
        this.dialect.quoteIdentifier(this.buf, schema, name);
        if (alias != null) {
            Util.assertTrue(alias.length() > 0);
            if (this.dialect.allowsAs()) {
                this.buf.append(" as ");
            } else {
                this.buf.append(' ');
            }
            this.dialect.quoteIdentifier(alias, this.buf);
            this.fromAliases.add(alias);
        }
        if (this.allowHints) {
            this.dialect.appendHintsAfterFromClause(this.buf, hints);
        }
        this.from.add(this.buf.toString());
        if (filter != null) {
            this.addWhere("(", filter, ")");
        }
        return true;
    }

    public void addFrom(SqlQuery sqlQuery, String alias, boolean failIfExists) {
        this.addFromQuery(sqlQuery.toString(), alias, failIfExists);
    }

    public boolean addFrom(MondrianDef.RelationOrJoin relation, String alias, boolean failIfExists) {
        MondrianDef.Relation relation1;
        this.registerRootRelation(relation);
        if (relation instanceof MondrianDef.Relation && this.relations.add(relation1 = (MondrianDef.Relation)relation) && !MondrianProperties.instance().FilterChildlessSnowflakeMembers.get()) {
            MondrianDef.RelationOrJoin root = this.mapRelationToRoot.get((Object)relation1);
            ArrayList<MondrianDef.Relation> relationsCopy = new ArrayList<MondrianDef.Relation>(this.relations);
            for (MondrianDef.Relation relation2 : relationsCopy) {
                if (relation2 == relation1 || this.mapRelationToRoot.get((Object)relation2) != root) continue;
                this.addJoinBetween(root, relation1, relation2);
            }
        }
        if (relation instanceof MondrianDef.View) {
            MondrianDef.View view = (MondrianDef.View)relation;
            String viewAlias = alias == null ? view.getAlias() : alias;
            String sqlString = view.getCodeSet().chooseQuery(this.dialect);
            return this.addFromQuery(sqlString, viewAlias, false);
        }
        if (relation instanceof MondrianDef.InlineTable) {
            relation1 = RolapUtil.convertInlineTableToRelation((MondrianDef.InlineTable)relation, this.dialect);
            return this.addFrom(relation1, alias, failIfExists);
        }
        if (relation instanceof MondrianDef.Table) {
            MondrianDef.Table table = (MondrianDef.Table)relation;
            String tableAlias = alias == null ? table.getAlias() : alias;
            return this.addFromTable(table.schema, table.name, tableAlias, table.getFilter(), table.getHintMap(), failIfExists);
        }
        if (relation instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relation;
            return this.addJoin(join.left, join.getLeftAlias(), join.leftKey, join.right, join.getRightAlias(), join.rightKey, failIfExists);
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    private boolean addJoin(MondrianDef.RelationOrJoin left, String leftAlias, String leftKey, MondrianDef.RelationOrJoin right, String rightAlias, String rightKey, boolean failIfExists) {
        boolean added;
        boolean addLeft = this.addFrom(left, leftAlias, failIfExists);
        boolean addRight = this.addFrom(right, rightAlias, failIfExists);
        boolean bl = added = addLeft || addRight;
        if (added) {
            this.buf.setLength(0);
            this.dialect.quoteIdentifier(this.buf, leftAlias, leftKey);
            this.buf.append(" = ");
            this.dialect.quoteIdentifier(this.buf, rightAlias, rightKey);
            String condition = this.buf.toString();
            if (this.dialect.allowsJoinOn()) {
                this.from.addOn(leftAlias, leftKey, rightAlias, rightKey, condition);
            } else {
                this.addWhere(condition);
            }
        }
        return added;
    }

    private void addJoinBetween(MondrianDef.RelationOrJoin root, MondrianDef.Relation relation1, MondrianDef.Relation relation2) {
        List<RelInfo> relations = this.mapRootToRelations.get((Object)root);
        int index1 = this.find(relations, relation1);
        int index2 = this.find(relations, relation2);
        assert (index1 != -1);
        assert (index2 != -1);
        int min = Math.min(index1, index2);
        int max = Math.max(index1, index2);
        for (int i = max - 1; i >= min; --i) {
            RelInfo relInfo = relations.get(i);
            this.addJoin(relInfo.relation, relInfo.leftAlias != null ? relInfo.leftAlias : relInfo.relation.getAlias(), relInfo.leftKey, relations.get((int)(i + 1)).relation, relInfo.rightAlias != null ? relInfo.rightAlias : relations.get((int)(i + 1)).relation.getAlias(), relInfo.rightKey, false);
        }
    }

    private int find(List<RelInfo> relations, MondrianDef.Relation relation) {
        int n = relations.size();
        for (int i = 0; i < n; ++i) {
            RelInfo relInfo = relations.get(i);
            if (!relInfo.relation.equals((Object)relation)) continue;
            return i;
        }
        return -1;
    }

    public String addSelect(String expression, SqlStatement.Type type) {
        switch (this.dialect.getDatabaseProduct()) {
            case DB2_AS400: 
            case DERBY: {
                return this.addSelect(expression, type, null);
            }
        }
        return this.addSelect(expression, type, this.nextColumnAlias());
    }

    public String addSelectGroupBy(String expression, SqlStatement.Type type) {
        String alias = this.addSelect(expression, type);
        this.addGroupBy(expression, alias);
        return alias;
    }

    public int getCurrentSelectListSize() {
        return this.select.size();
    }

    public String nextColumnAlias() {
        return "c" + this.select.size();
    }

    public String addSelect(String expression, SqlStatement.Type type, String alias) {
        this.buf.setLength(0);
        this.buf.append(expression);
        if (alias != null) {
            this.buf.append(" as ");
            this.dialect.quoteIdentifier(alias, this.buf);
        }
        this.select.add(this.buf.toString());
        this.addType(type);
        this.columnAliases.put(expression, alias);
        return alias;
    }

    public String getAlias(String expression) {
        return this.columnAliases.get(expression);
    }

    public void addWhere(String exprLeft, String exprMid, String exprRight) {
        int len = exprLeft.length() + exprMid.length() + exprRight.length();
        StringBuilder buf = new StringBuilder(len);
        buf.append(exprLeft);
        buf.append(exprMid);
        buf.append(exprRight);
        this.addWhere(buf.toString());
    }

    public void addWhere(RolapStar.Condition joinCondition) {
        String left = joinCondition.getLeft().getTableAlias();
        String right = joinCondition.getRight().getTableAlias();
        if (this.fromAliases.contains(left) && this.fromAliases.contains(right)) {
            this.addWhere(joinCondition.getLeft(this), " = ", joinCondition.getRight(this));
        }
    }

    public void addWhere(String expression) {
        assert (expression != null && !expression.equals(""));
        this.where.add(expression);
    }

    public void addGroupBy(String expression) {
        assert (expression != null && !expression.equals(""));
        this.groupBy.add(expression);
    }

    public void addGroupBy(String expression, String alias) {
        if (this.dialect.requiresGroupByAlias()) {
            this.addGroupBy(this.dialect.quoteIdentifier(alias));
        } else {
            this.addGroupBy(expression);
        }
    }

    public void addHaving(String expression) {
        assert (expression != null && !expression.equals(""));
        this.having.add(expression);
    }

    public void addOrderBy(String expr, boolean ascending, boolean prepend, boolean nullable) {
        this.addOrderBy(expr, expr, ascending, prepend, nullable, true);
    }

    public void addOrderBy(String expr, String alias, boolean ascending, boolean prepend, boolean nullable, boolean collateNullsLast) {
        String orderExpr = this.dialect.generateOrderItem(this.dialect.requiresOrderByAlias() ? this.dialect.quoteIdentifier(alias) : expr, nullable, ascending, collateNullsLast);
        if (prepend) {
            this.orderBy.add(0, orderExpr);
        } else {
            this.orderBy.add(orderExpr);
        }
    }

    public String toString() {
        this.buf.setLength(0);
        this.toBuffer(this.buf, "");
        return this.buf.toString();
    }

    public void toBuffer(StringBuilder buf, String prefix) {
        String first = this.distinct ? "select distinct " : "select ";
        this.select.toBuffer(buf, this.generateFormattedSql, prefix, first, ", ", "", "");
        this.groupingFunctionsToBuffer(buf, prefix);
        this.from.toBuffer(buf, this.generateFormattedSql, prefix, " from ", ", ", "", "");
        this.where.toBuffer(buf, this.generateFormattedSql, prefix, " where ", " and ", "", "");
        if (this.groupingSets.isEmpty()) {
            this.groupBy.toBuffer(buf, this.generateFormattedSql, prefix, " group by ", ", ", "", "");
        } else {
            ClauseList.listToBuffer(buf, this.groupingSets, this.generateFormattedSql, prefix, " group by grouping sets (", ", ", ")");
        }
        this.having.toBuffer(buf, this.generateFormattedSql, prefix, " having ", " and ", "", "");
        this.orderBy.toBuffer(buf, this.generateFormattedSql, prefix, " order by ", ", ", "", "");
    }

    private void groupingFunctionsToBuffer(StringBuilder buf, String prefix) {
        if (this.groupingSets.isEmpty()) {
            return;
        }
        int n = 0;
        for (String groupingFunction : this.groupingFunctions) {
            if (this.generateFormattedSql) {
                buf.append(",").append(Util.nl).append(INDENT).append(prefix);
            } else {
                buf.append(", ");
            }
            buf.append("grouping(").append(groupingFunction).append(") as ");
            this.dialect.quoteIdentifier("g" + n++, buf);
        }
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public static SqlQuery newQuery(DataSource dataSource, String err) {
        Dialect dialect = DialectManager.createDialect(dataSource, null);
        return new SqlQuery(dialect);
    }

    public void addGroupingSet(List<String> groupingColumnsExpr) {
        ClauseList groupingList = new ClauseList(false);
        for (String columnExp : groupingColumnsExpr) {
            groupingList.add(columnExp);
        }
        this.groupingSets.add(groupingList);
    }

    public void addGroupingFunction(String columnExpr) {
        this.groupingFunctions.add(columnExpr);
        this.types.add(null);
    }

    private void addType(SqlStatement.Type type) {
        this.types.add(type);
    }

    public Pair<String, List<SqlStatement.Type>> toSqlAndTypes() {
        assert (this.types.size() == this.select.size() + this.groupingFunctions.size()) : this.types.size() + " types, " + (this.select.size() + this.groupingFunctions.size()) + " select items in query " + this;
        return Pair.of(this.toString(), this.types);
    }

    public void registerRootRelation(MondrianDef.RelationOrJoin root) {
        if (this.mapRelationToRoot.containsKey((Object)root)) {
            return;
        }
        if (this.mapRootToRelations.containsKey((Object)root)) {
            return;
        }
        ArrayList<RelInfo> relations = new ArrayList<RelInfo>();
        this.flatten(relations, root, null, null, null, null);
        for (RelInfo relation : relations) {
            this.mapRelationToRoot.put(relation.relation, root);
        }
        this.mapRootToRelations.put(root, relations);
    }

    private void flatten(List<RelInfo> relations, MondrianDef.RelationOrJoin root, String leftKey, String leftAlias, String rightKey, String rightAlias) {
        if (root instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)root;
            this.flatten(relations, join.left, join.leftKey, join.leftAlias, join.rightKey, join.rightAlias);
            this.flatten(relations, join.right, leftKey, leftAlias, rightKey, rightAlias);
        } else {
            relations.add(new RelInfo((MondrianDef.Relation)root, leftKey, leftAlias, rightKey, rightAlias));
        }
    }

    private static class RelInfo {
        final MondrianDef.Relation relation;
        final String leftKey;
        final String leftAlias;
        final String rightKey;
        final String rightAlias;

        public RelInfo(MondrianDef.Relation relation, String leftKey, String leftAlias, String rightKey, String rightAlias) {
            this.relation = relation;
            this.leftKey = leftKey;
            this.leftAlias = leftAlias;
            this.rightKey = rightKey;
            this.rightAlias = rightAlias;
        }
    }

    public static class CodeSet {
        private final Map<String, String> dialectCodes = new HashMap<String, String>();

        public String put(String dialect, String code) {
            return this.dialectCodes.put(dialect, code);
        }

        public String chooseQuery(Dialect dialect) {
            String best = CodeSet.getBestName(dialect);
            String bestCode = this.dialectCodes.get(best);
            if (bestCode != null) {
                return bestCode;
            }
            String genericCode = this.dialectCodes.get("generic");
            if (genericCode == null) {
                throw Util.newError("View has no 'generic' variant");
            }
            return genericCode;
        }

        private static String getBestName(Dialect dialect) {
            String dialectName = dialect.getDatabaseProduct().getFamily().name().toLowerCase();
            if (dialectName.equals("postgresql")) {
                return "postgres";
            }
            return dialectName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClauseList
    extends ArrayList<String> {
        protected final boolean allowDups;

        ClauseList(boolean allowDups) {
            this.allowDups = allowDups;
        }

        @Override
        public boolean add(String element) {
            if (this.allowDups || !this.contains(element)) {
                return super.add(element);
            }
            return false;
        }

        final void toBuffer(StringBuilder buf, boolean generateFormattedSql, String prefix, String first, String sep, String last, String empty) {
            if (this.isEmpty()) {
                buf.append(empty);
                return;
            }
            first = ClauseList.foo(generateFormattedSql, prefix, first);
            sep = ClauseList.foo(generateFormattedSql, prefix, sep);
            this.toBuffer(buf, first, sep, last);
        }

        static String foo(boolean generateFormattedSql, String prefix, String s) {
            if (generateFormattedSql) {
                if (s.startsWith(" ")) {
                    s = Util.nl + prefix + s.substring(1);
                }
                if (s.endsWith(" ")) {
                    s = s.substring(0, s.length() - 1) + Util.nl + prefix + SqlQuery.INDENT;
                } else if (s.endsWith("(")) {
                    s = s + Util.nl + prefix + SqlQuery.INDENT;
                }
            }
            return s;
        }

        final void toBuffer(StringBuilder buf, String first, String sep, String last) {
            int n = 0;
            buf.append(first);
            for (String s : this) {
                if (n++ > 0) {
                    buf.append(sep);
                }
                buf.append(s);
            }
            buf.append(last);
        }

        static void listToBuffer(StringBuilder buf, List<ClauseList> clauseListList, boolean generateFormattedSql, String prefix, String first, String sep, String last) {
            first = ClauseList.foo(generateFormattedSql, prefix, first);
            sep = ClauseList.foo(generateFormattedSql, prefix, sep);
            buf.append(first);
            int n = 0;
            for (ClauseList clauseList : clauseListList) {
                if (n++ > 0) {
                    buf.append(sep);
                }
                clauseList.toBuffer(buf, false, prefix, "(", ", ", ")", "()");
            }
            buf.append(last);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FromClauseList
    extends ClauseList {
        private final List<JoinOnClause> joinOnClauses = new ArrayList<JoinOnClause>();

        FromClauseList(boolean allowsDups) {
            super(allowsDups);
        }

        public void addOn(String leftAlias, String leftKey, String rightAlias, String rightKey, String condition) {
            if (leftAlias != null || rightAlias != null) {
                if (leftAlias == null) {
                    leftAlias = rightAlias;
                } else if (rightAlias == null) {
                    rightAlias = leftAlias;
                }
            }
            this.joinOnClauses.add(new JoinOnClause(condition, leftAlias, rightAlias));
        }

        public void toBuffer(StringBuilder buf, List<String> fromAliases) {
            int n = 0;
            for (int i = 0; i < this.size(); ++i) {
                String s = (String)this.get(i);
                String alias = fromAliases.get(i);
                if (n++ == 0) {
                    buf.append(" from ");
                    buf.append(s);
                    continue;
                }
                this.appendJoin(fromAliases.subList(0, i), s, alias, buf);
            }
        }

        void appendJoin(List<String> addedTables, String from, String alias, StringBuilder buf) {
            int n = 0;
            for (JoinOnClause joinOnClause : this.joinOnClauses) {
                if (!(addedTables.size() == 1 && addedTables.get(0).equals(joinOnClause.left) && joinOnClause.left.equals(joinOnClause.right) || alias.equals(joinOnClause.left) && addedTables.contains(joinOnClause.right)) && (!alias.equals(joinOnClause.right) || !addedTables.contains(joinOnClause.left))) continue;
                if (n++ == 0) {
                    buf.append(" join ").append(from).append(" on ");
                } else {
                    buf.append(" and ");
                }
                buf.append(joinOnClause.condition);
            }
            if (n == 0) {
                buf.append(this.joinOnClauses.isEmpty() ? ", " : " cross join ").append(from);
            }
        }
    }

    private static class JoinOnClause {
        private final String condition;
        private final String left;
        private final String right;

        JoinOnClause(String condition, String left, String right) {
            this.condition = condition;
            this.left = left;
            this.right = right;
        }
    }
}

