/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.olap4j.IMondrianOlap4jProperty;
import mondrian.util.CompositeList;
import mondrian.xmla.Enumeration;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.Rowset;
import mondrian.xmla.RowsetDefinition;
import mondrian.xmla.SaxWriter;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaRequest;
import mondrian.xmla.XmlaResponse;
import mondrian.xmla.XmlaUtil;
import mondrian.xmla.impl.DefaultSaxWriter;
import org.apache.log4j.Logger;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.CellSetAxisMetaData;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.Position;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Database;
import org.olap4j.metadata.Datatype;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.olap4j.metadata.Property;
import org.olap4j.metadata.Schema;
import org.olap4j.metadata.XmlaConstants;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlaHandler {
    private static final Logger LOGGER = Logger.getLogger(XmlaHandler.class);
    private static final String JDBC_USER = "user";
    private static final String JDBC_PASSWORD = "password";
    public static final String JDBC_LOCALE = "locale";
    final ConnectionFactory connectionFactory;
    private final String prefix;
    private static final String EMPTY_ROW_SET_XML_SCHEMA = XmlaHandler.computeEmptyXsd(SetType.ROW_SET);
    private static final String MD_DATA_SET_XML_SCHEMA = XmlaHandler.computeXsd(SetType.MD_DATA_SET);
    private static final String EMPTY_MD_DATA_SET_XML_SCHEMA = XmlaHandler.computeEmptyXsd(SetType.MD_DATA_SET);
    private static final String NS_XML_SQL = "urn:schemas-microsoft-com:xml-sql";
    public static final String XSD_BOOLEAN = "xsd:boolean";
    public static final String XSD_STRING = "xsd:string";
    public static final String XSD_UNSIGNED_INT = "xsd:unsignedInt";
    public static final String XSD_BYTE = "xsd:byte";
    public static final byte XSD_BYTE_MAX_INCLUSIVE = 127;
    public static final byte XSD_BYTE_MIN_INCLUSIVE = -128;
    public static final String XSD_SHORT = "xsd:short";
    public static final short XSD_SHORT_MAX_INCLUSIVE = Short.MAX_VALUE;
    public static final short XSD_SHORT_MIN_INCLUSIVE = Short.MIN_VALUE;
    public static final String XSD_INT = "xsd:int";
    public static final int XSD_INT_MAX_INCLUSIVE = Integer.MAX_VALUE;
    public static final int XSD_INT_MIN_INCLUSIVE = Integer.MIN_VALUE;
    public static final String XSD_LONG = "xsd:long";
    public static final long XSD_LONG_MAX_INCLUSIVE = Long.MAX_VALUE;
    public static final long XSD_LONG_MIN_INCLUSIVE = Long.MIN_VALUE;
    public static final String XSD_DOUBLE = "xsd:double";
    public static final String XSD_FLOAT = "xsd:float";
    public static final String XSD_DECIMAL = "xsd:decimal";
    public static final String XSD_INTEGER = "xsd:integer";

    public static XmlaExtra getExtra(OlapConnection connection) {
        block5: {
            try {
                XmlaExtra extra = (XmlaExtra)connection.unwrap(XmlaExtra.class);
                if (extra != null) {
                    return extra;
                }
            }
            catch (SQLException e) {
            }
            catch (UndeclaredThrowableException ute) {
                Throwable cause = ute.getCause();
                if (cause instanceof InvocationTargetException) {
                    cause = cause.getCause();
                }
                if (cause instanceof SQLException) break block5;
                throw ute;
            }
        }
        return new XmlaExtraImpl();
    }

    public OlapConnection getConnection(XmlaRequest request, Map<String, String> propMap) {
        String sessionId = request.getSessionId();
        if (sessionId == null) {
            sessionId = "<no_session>";
        }
        LOGGER.debug((Object)("Creating new connection for user [" + request.getUsername() + "] and session [" + sessionId + "]"));
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : propMap.entrySet()) {
            props.put(entry.getKey(), entry.getValue());
        }
        if (request.getUsername() != null) {
            props.put(JDBC_USER, request.getUsername());
        }
        if (request.getPassword() != null) {
            props.put(JDBC_PASSWORD, request.getPassword());
        }
        String databaseName = request.getProperties().get(PropertyDefinition.DataSourceInfo.name());
        String catalogName = request.getProperties().get(PropertyDefinition.Catalog.name());
        if (catalogName == null && request.getMethod() == XmlaConstants.Method.DISCOVER && request.getRestrictions().containsKey(Property.StandardMemberProperty.CATALOG_NAME.name())) {
            Object restriction = request.getRestrictions().get(Property.StandardMemberProperty.CATALOG_NAME.name());
            if (restriction instanceof List) {
                List requiredValues = (List)restriction;
                catalogName = String.valueOf(requiredValues.get(0));
            } else {
                throw Util.newInternal("unexpected restriction type: " + restriction.getClass());
            }
        }
        return this.getConnection(databaseName, catalogName, request.getRoleName(), props);
    }

    public static boolean isValidXsdInt(long l) {
        return l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE;
    }

    private static String computeXsd(SetType setType) {
        StringWriter sw = new StringWriter();
        DefaultSaxWriter writer = new DefaultSaxWriter(new PrintWriter(sw), 3);
        XmlaHandler.writeDatasetXmlSchema(writer, setType);
        writer.flush();
        return sw.toString();
    }

    private static String computeEmptyXsd(SetType setType) {
        StringWriter sw = new StringWriter();
        DefaultSaxWriter writer = new DefaultSaxWriter(new PrintWriter(sw), 3);
        XmlaHandler.writeEmptyDatasetXmlSchema(writer, setType);
        writer.flush();
        return sw.toString();
    }

    public XmlaHandler(ConnectionFactory connectionFactory, String prefix) {
        assert (prefix != null);
        this.connectionFactory = connectionFactory;
        this.prefix = prefix;
    }

    public void process(XmlaRequest request, XmlaResponse response) throws XmlaException {
        XmlaConstants.Method method = request.getMethod();
        long start = System.currentTimeMillis();
        switch (method) {
            case DISCOVER: {
                this.discover(request, response);
                break;
            }
            case EXECUTE: {
                this.execute(request, response);
                break;
            }
            default: {
                throw new XmlaException("Client", "00HSBB02", "XMLA SOAP bad method", new IllegalArgumentException("Unsupported XML/A method: " + method));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            LOGGER.debug((Object)("XmlaHandler.process: time = " + (end - start)));
            LOGGER.debug((Object)("XmlaHandler.process: " + Util.printMemory()));
        }
    }

    private void checkFormat(XmlaRequest request) throws XmlaException {
        Map<String, String> properties = request.getProperties();
        if (request.isDrillThrough()) {
            XmlaConstants.Format format = XmlaHandler.getFormat(request, null);
            if (format != XmlaConstants.Format.Tabular) {
                throw new XmlaException("Client", "00HSBE02", "XMLA Drill Through format error", new UnsupportedOperationException("<Format>: only 'Tabular' allowed when drilling through"));
            }
        } else {
            XmlaConstants.AxisFormat axisFormat;
            XmlaConstants.Format format;
            String formatName = properties.get(PropertyDefinition.Format.name());
            if (formatName != null && (format = XmlaHandler.getFormat(request, null)) != XmlaConstants.Format.Multidimensional && format != XmlaConstants.Format.Tabular) {
                throw new UnsupportedOperationException("<Format>: only 'Multidimensional', 'Tabular' currently supported");
            }
            String axisFormatName = properties.get(PropertyDefinition.AxisFormat.name());
            if (axisFormatName != null && (axisFormat = (XmlaConstants.AxisFormat)Util.lookup(XmlaConstants.AxisFormat.class, axisFormatName, null)) != XmlaConstants.AxisFormat.TupleFormat) {
                throw new UnsupportedOperationException("<AxisFormat>: only 'TupleFormat' currently supported");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void execute(XmlaRequest request, XmlaResponse response) throws XmlaException {
        Map<String, String> properties = request.getProperties();
        Enumeration.ResponseMimeType responseMimeType = XmlaHandler.getResponseMimeType(request);
        String contentName = properties.get(PropertyDefinition.Content.name());
        XmlaConstants.Content content = Util.lookup(XmlaConstants.Content.class, contentName, responseMimeType == Enumeration.ResponseMimeType.JSON ? XmlaConstants.Content.Data : XmlaConstants.Content.DEFAULT);
        QueryResult result = null;
        try {
            result = request.isDrillThrough() ? this.executeDrillThroughQuery(request) : this.executeQuery(request);
            SaxWriter writer = response.getWriter();
            writer.startDocument();
            writer.startElement(this.prefix + ":ExecuteResponse", "xmlns:" + this.prefix, "urn:schemas-microsoft-com:xml-analysis");
            writer.startElement(this.prefix + ":return");
            boolean rowset = request.isDrillThrough() || XmlaConstants.Format.Tabular.name().equals(request.getProperties().get(PropertyDefinition.Format.name()));
            writer.startElement("root", "xmlns", result == null ? "urn:schemas-microsoft-com:xml-analysis:empty" : (rowset ? "urn:schemas-microsoft-com:xml-analysis:rowset" : "urn:schemas-microsoft-com:xml-analysis:mddataset"), "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "xmlns:EX", "urn:schemas-microsoft-com:xml-analysis:exception");
            switch (content) {
                case Schema: 
                case SchemaData: {
                    if (result != null) {
                        result.metadata(writer);
                        break;
                    }
                    if (rowset) {
                        writer.verbatim(EMPTY_ROW_SET_XML_SCHEMA);
                        break;
                    }
                    writer.verbatim(EMPTY_MD_DATA_SET_XML_SCHEMA);
                    break;
                }
            }
            try {
                switch (content) {
                    case SchemaData: 
                    case Data: 
                    case DataOmitDefaultSlicer: 
                    case DataIncludeDefaultSlicer: {
                        if (result == null) break;
                        result.unparse(writer);
                        break;
                    }
                }
            }
            catch (XmlaException xex) {
                throw xex;
            }
            catch (Throwable t) {
                throw new XmlaException("Server", "00HSBE03", "XMLA Execute unparse results error", t);
            }
            finally {
                writer.endElement();
                writer.endElement();
                writer.endElement();
            }
            writer.endDocument();
            return;
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    static void writeDatasetXmlSchema(SaxWriter writer, SetType settype) {
        String setNsXmla = settype == SetType.ROW_SET ? "urn:schemas-microsoft-com:xml-analysis:rowset" : "urn:schemas-microsoft-com:xml-analysis:mddataset";
        writer.startElement("xsd:schema", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "targetNamespace", setNsXmla, "xmlns", setNsXmla, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:sql", NS_XML_SQL, "elementFormDefault", "qualified");
        writer.startElement("xsd:complexType", "name", "MemberType");
        writer.startElement("xsd:sequence");
        writer.element("xsd:element", "name", "UName", "type", XSD_STRING);
        writer.element("xsd:element", "name", "Caption", "type", XSD_STRING);
        writer.element("xsd:element", "name", "LName", "type", XSD_STRING);
        writer.element("xsd:element", "name", "LNum", "type", XSD_UNSIGNED_INT);
        writer.element("xsd:element", "name", "DisplayInfo", "type", XSD_UNSIGNED_INT);
        writer.startElement("xsd:sequence", "maxOccurs", "unbounded", "minOccurs", 0);
        writer.element("xsd:any", "processContents", "lax", "maxOccurs", "unbounded");
        writer.endElement();
        writer.endElement();
        writer.element("xsd:attribute", "name", "Hierarchy", "type", XSD_STRING);
        writer.endElement();
        writer.startElement("xsd:complexType", "name", "PropType");
        writer.element("xsd:attribute", "name", "name", "type", XSD_STRING);
        writer.endElement();
        writer.startElement("xsd:complexType", "name", "TupleType");
        writer.startElement("xsd:sequence", "maxOccurs", "unbounded");
        writer.element("xsd:element", "name", "Member", "type", "MemberType");
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:complexType", "name", "MembersType");
        writer.startElement("xsd:sequence", "maxOccurs", "unbounded");
        writer.element("xsd:element", "name", "Member", "type", "MemberType");
        writer.endElement();
        writer.element("xsd:attribute", "name", "Hierarchy", "type", XSD_STRING);
        writer.endElement();
        writer.startElement("xsd:complexType", "name", "TuplesType");
        writer.startElement("xsd:sequence", "maxOccurs", "unbounded");
        writer.element("xsd:element", "name", "Tuple", "type", "TupleType");
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:complexType", "name", "CrossProductType");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:choice", "minOccurs", 0, "maxOccurs", "unbounded");
        writer.element("xsd:element", "name", "Members", "type", "MembersType");
        writer.element("xsd:element", "name", "Tuples", "type", "TuplesType");
        writer.endElement();
        writer.endElement();
        writer.element("xsd:attribute", "name", "Size", "type", XSD_UNSIGNED_INT);
        writer.endElement();
        writer.startElement("xsd:complexType", "name", "OlapInfo");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:element", "name", "CubeInfo");
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:element", "name", "Cube", "maxOccurs", "unbounded");
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.element("xsd:element", "name", "CubeName", "type", XSD_STRING);
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:element", "name", "AxesInfo");
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:element", "name", "AxisInfo", "maxOccurs", "unbounded");
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:element", "name", "HierarchyInfo", "minOccurs", 0, "maxOccurs", "unbounded");
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:sequence", "maxOccurs", "unbounded");
        writer.element("xsd:element", "name", "UName", "type", "PropType");
        writer.element("xsd:element", "name", "Caption", "type", "PropType");
        writer.element("xsd:element", "name", "LName", "type", "PropType");
        writer.element("xsd:element", "name", "LNum", "type", "PropType");
        writer.element("xsd:element", "name", "DisplayInfo", "type", "PropType", "minOccurs", 0, "maxOccurs", "unbounded");
        writer.endElement();
        writer.startElement("xsd:sequence");
        writer.element("xsd:any", "processContents", "lax", "minOccurs", 0, "maxOccurs", "unbounded");
        writer.endElement();
        writer.endElement();
        writer.element("xsd:attribute", "name", "name", "type", XSD_STRING, "use", "required");
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.element("xsd:attribute", "name", "name", "type", XSD_STRING);
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:element", "name", "CellInfo");
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:sequence", "minOccurs", 0, "maxOccurs", "unbounded");
        writer.startElement("xsd:choice");
        writer.element("xsd:element", "name", "Value", "type", "PropType");
        writer.element("xsd:element", "name", "FmtValue", "type", "PropType");
        writer.element("xsd:element", "name", "BackColor", "type", "PropType");
        writer.element("xsd:element", "name", "ForeColor", "type", "PropType");
        writer.element("xsd:element", "name", "FontName", "type", "PropType");
        writer.element("xsd:element", "name", "FontSize", "type", "PropType");
        writer.element("xsd:element", "name", "FontFlags", "type", "PropType");
        writer.element("xsd:element", "name", "FormatString", "type", "PropType");
        writer.element("xsd:element", "name", "NonEmptyBehavior", "type", "PropType");
        writer.element("xsd:element", "name", "SolveOrder", "type", "PropType");
        writer.element("xsd:element", "name", "Updateable", "type", "PropType");
        writer.element("xsd:element", "name", "Visible", "type", "PropType");
        writer.element("xsd:element", "name", "Expression", "type", "PropType");
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:sequence", "maxOccurs", "unbounded", "minOccurs", 0);
        writer.element("xsd:any", "processContents", "lax", "maxOccurs", "unbounded");
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:complexType", "name", "Axes");
        writer.startElement("xsd:sequence", "maxOccurs", "unbounded");
        writer.startElement("xsd:element", "name", "Axis");
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:choice", "minOccurs", 0, "maxOccurs", "unbounded");
        writer.element("xsd:element", "name", "CrossProduct", "type", "CrossProductType");
        writer.element("xsd:element", "name", "Tuples", "type", "TuplesType");
        writer.element("xsd:element", "name", "Members", "type", "MembersType");
        writer.endElement();
        writer.element("xsd:attribute", "name", "name", "type", XSD_STRING);
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:complexType", "name", "CellData");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:element", "name", "Cell", "minOccurs", 0, "maxOccurs", "unbounded");
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence", "maxOccurs", "unbounded");
        writer.startElement("xsd:choice");
        writer.element("xsd:element", "name", "Value");
        writer.element("xsd:element", "name", "FmtValue", "type", XSD_STRING);
        writer.element("xsd:element", "name", "BackColor", "type", XSD_UNSIGNED_INT);
        writer.element("xsd:element", "name", "ForeColor", "type", XSD_UNSIGNED_INT);
        writer.element("xsd:element", "name", "FontName", "type", XSD_STRING);
        writer.element("xsd:element", "name", "FontSize", "type", "xsd:unsignedShort");
        writer.element("xsd:element", "name", "FontFlags", "type", XSD_UNSIGNED_INT);
        writer.element("xsd:element", "name", "FormatString", "type", XSD_STRING);
        writer.element("xsd:element", "name", "NonEmptyBehavior", "type", "xsd:unsignedShort");
        writer.element("xsd:element", "name", "SolveOrder", "type", XSD_UNSIGNED_INT);
        writer.element("xsd:element", "name", "Updateable", "type", XSD_UNSIGNED_INT);
        writer.element("xsd:element", "name", "Visible", "type", XSD_UNSIGNED_INT);
        writer.element("xsd:element", "name", "Expression", "type", XSD_STRING);
        writer.endElement();
        writer.endElement();
        writer.element("xsd:attribute", "name", "CellOrdinal", "type", XSD_UNSIGNED_INT, "use", "required");
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:element", "name", "root");
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence", "maxOccurs", "unbounded");
        writer.element("xsd:element", "name", "OlapInfo", "type", "OlapInfo");
        writer.element("xsd:element", "name", "Axes", "type", "Axes");
        writer.element("xsd:element", "name", "CellData", "type", "CellData");
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
    }

    static void writeEmptyDatasetXmlSchema(SaxWriter writer, SetType setType) {
        String setNsXmla = "urn:schemas-microsoft-com:xml-analysis:rowset";
        writer.startElement("xsd:schema", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "targetNamespace", setNsXmla, "xmlns", setNsXmla, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:sql", NS_XML_SQL, "elementFormDefault", "qualified");
        writer.element("xsd:element", "name", "root");
        writer.endElement();
    }

    private QueryResult executeDrillThroughQuery(XmlaRequest request) throws XmlaException {
        int[] nArray;
        this.checkFormat(request);
        Map<String, String> properties = request.getProperties();
        String tabFields = properties.get(PropertyDefinition.TableFields.name());
        if (tabFields != null && tabFields.length() == 0) {
            tabFields = null;
        }
        String advancedFlag = properties.get(PropertyDefinition.AdvancedFlag.name());
        boolean advanced = Boolean.parseBoolean(advancedFlag);
        boolean enableRowCount = MondrianProperties.instance().EnableTotalCount.booleanValue();
        if (enableRowCount) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = null;
        }
        int[] rowCountSlot = nArray;
        OlapConnection connection = null;
        OlapStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection(request, Collections.<String, String>emptyMap());
            statement = connection.createStatement();
            resultSet = XmlaHandler.getExtra(connection).executeDrillthrough(statement, request.getStatement(), advanced, tabFields, rowCountSlot);
            int rowCount = enableRowCount ? rowCountSlot[0] : -1;
            TabularRowSet tabularRowSet = new TabularRowSet(resultSet, rowCount);
            return tabularRowSet;
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (SQLException sqle) {
            throw new XmlaException("Server", "00HSBF02", "XMLA Drill Through SQL error", Util.newError(sqle, "Error in drill through"));
        }
        catch (RuntimeException e) {
            throw new XmlaException("Server", "00HSBF02", "XMLA Drill Through SQL error", e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    private static String sqlToXsdType(int sqlType, int scale) {
        switch (sqlType) {
            case -6: 
            case 4: 
            case 5: {
                return XSD_INT;
            }
            case 2: 
            case 3: {
                if (scale == 0) {
                    return XSD_INT;
                }
                return XSD_DECIMAL;
            }
            case -5: {
                return XSD_INTEGER;
            }
            case 6: 
            case 8: {
                return XSD_DOUBLE;
            }
            case 91: 
            case 92: 
            case 93: {
                return XSD_STRING;
            }
        }
        return XSD_STRING;
    }

    /*
     * Exception decompiling
     */
    private QueryResult executeQuery(XmlaRequest request) throws XmlaException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static XmlaConstants.Format getFormat(XmlaRequest request, XmlaConstants.Format defaultValue) {
        String formatName = request.getProperties().get(PropertyDefinition.Format.name());
        return Util.lookup(XmlaConstants.Format.class, formatName, defaultValue);
    }

    private static XmlaConstants.Content getContent(XmlaRequest request) {
        String contentName = request.getProperties().get(PropertyDefinition.Content.name());
        return Util.lookup(XmlaConstants.Content.class, contentName, XmlaConstants.Content.DEFAULT);
    }

    private static Enumeration.ResponseMimeType getResponseMimeType(XmlaRequest request) {
        Enumeration.ResponseMimeType mimeType = Enumeration.ResponseMimeType.MAP.get(request.getProperties().get(PropertyDefinition.ResponseMimeType.name()));
        if (mimeType == null) {
            mimeType = Enumeration.ResponseMimeType.SOAP;
        }
        return mimeType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void discover(XmlaRequest request, XmlaResponse response) throws XmlaException {
        RowsetDefinition rowsetDefinition = RowsetDefinition.valueOf(request.getRequestType());
        Rowset rowset = rowsetDefinition.getRowset(request, this);
        XmlaConstants.Format format = XmlaHandler.getFormat(request, XmlaConstants.Format.Tabular);
        if (format != XmlaConstants.Format.Tabular) {
            throw new XmlaException("Client", "00HSBE01", "XMLA Discover format error", new UnsupportedOperationException("<Format>: only 'Tabular' allowed in Discover method type"));
        }
        XmlaConstants.Content content = XmlaHandler.getContent(request);
        SaxWriter writer = response.getWriter();
        writer.startDocument();
        writer.startElement(this.prefix + ":DiscoverResponse", "xmlns:" + this.prefix, "urn:schemas-microsoft-com:xml-analysis");
        writer.startElement(this.prefix + ":return");
        writer.startElement("root", "xmlns", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "xmlns:EX", "urn:schemas-microsoft-com:xml-analysis:exception");
        switch (content) {
            case Schema: 
            case SchemaData: {
                rowset.rowsetDefinition.writeRowsetXmlSchema(writer);
                break;
            }
        }
        try {
            switch (content) {
                case SchemaData: 
                case Data: {
                    rowset.unparse(response);
                    break;
                }
            }
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (Throwable t) {
            throw new XmlaException("Server", "00HSBE02", "XMLA Discover unparse results error", t);
        }
        finally {
            try {
                writer.endElement();
                writer.endElement();
                writer.endElement();
            }
            catch (Throwable e) {}
        }
        writer.endDocument();
    }

    protected OlapConnection getConnection(String catalog, String schema, String role) throws XmlaException {
        return this.getConnection(catalog, schema, role, new Properties());
    }

    protected OlapConnection getConnection(String catalog, String schema, String role, Properties props) throws XmlaException {
        try {
            return this.connectionFactory.getConnection(catalog, schema, role, props);
        }
        catch (SecurityException e) {
            throw new XmlaException("Client", "00HSBC02", "XMLA connection with role must be authenticated", e);
        }
        catch (SQLException e) {
            throw new XmlaException("Client", "00HSBC01", "XMLA connection datasource not found", e);
        }
    }

    private static String createCsv(Iterable<? extends Object> iterable) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object object : iterable) {
            if (!first) {
                sb.append(',');
            }
            sb.append(object);
            first = false;
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ConnectionFactory {
        public OlapConnection getConnection(String var1, String var2, String var3, Properties var4) throws SQLException;

        public Map<String, Object> getPreConfiguredDiscoverDatasourcesResponse();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XmlaExtraImpl
    implements XmlaExtra {
        private XmlaExtraImpl() {
        }

        @Override
        public ResultSet executeDrillthrough(OlapStatement olapStatement, String mdx, boolean advanced, String tabFields, int[] rowCountSlot) throws SQLException {
            return olapStatement.executeQuery(mdx);
        }

        @Override
        public void setPreferList(OlapConnection connection) {
        }

        @Override
        public Date getSchemaLoadDate(Schema schema) {
            return new Date();
        }

        @Override
        public int getLevelCardinality(Level level) {
            return level.getCardinality();
        }

        @Override
        public void getSchemaFunctionList(List<XmlaExtra.FunctionDefinition> funDefs, Schema schema, Util.Functor1<Boolean, String> functionFilter) {
        }

        @Override
        public int getHierarchyCardinality(Hierarchy hierarchy) {
            int cardinality = 0;
            for (Level level : hierarchy.getLevels()) {
                cardinality += level.getCardinality();
            }
            return cardinality;
        }

        @Override
        public int getHierarchyStructure(Hierarchy hierarchy) {
            return 0;
        }

        @Override
        public boolean isHierarchyParentChild(Hierarchy hierarchy) {
            return false;
        }

        @Override
        public int getMeasureAggregator(Member member) {
            return 0;
        }

        @Override
        public void checkMemberOrdinal(Member member) {
        }

        @Override
        public boolean shouldReturnCellProperty(CellSet cellSet, Property cellProperty, boolean evenEmpty) {
            return true;
        }

        @Override
        public List<String> getSchemaRoleNames(Schema schema) {
            return Collections.emptyList();
        }

        @Override
        public String getSchemaId(Schema schema) {
            return schema.getName();
        }

        @Override
        public String getCubeType(Cube cube) {
            return "CUBE";
        }

        @Override
        public boolean isLevelUnique(Level level) {
            return false;
        }

        @Override
        public List<Property> getLevelProperties(Level level) {
            return level.getProperties();
        }

        @Override
        public boolean isPropertyInternal(Property property) {
            return property instanceof Property.StandardMemberProperty && ((Property.StandardMemberProperty)property).isInternal() || property instanceof Property.StandardCellProperty && ((Property.StandardCellProperty)property).isInternal();
        }

        @Override
        public List<Map<String, Object>> getDataSources(OlapConnection connection) throws OlapException {
            Database olapDb = connection.getOlapDatabase();
            String modes = XmlaHandler.createCsv(olapDb.getAuthenticationModes());
            String providerTypes = XmlaHandler.createCsv(olapDb.getProviderTypes());
            return Collections.singletonList(Olap4jUtil.mapOf((Object)"DataSourceName", (Object)olapDb.getName(), (Object[])new Object[]{"DataSourceDescription", olapDb.getDescription(), "URL", olapDb.getURL(), "DataSourceInfo", olapDb.getDataSourceInfo(), "ProviderName", olapDb.getProviderName(), "ProviderType", providerTypes, "AuthenticationMode", modes}));
        }

        @Override
        public Map<String, Object> getAnnotationMap(MetadataElement element) {
            return Collections.emptyMap();
        }

        @Override
        public boolean canDrillThrough(Cell cell) {
            return false;
        }

        @Override
        public int getDrillThroughCount(Cell cell) {
            return -1;
        }

        @Override
        public void flushSchemaCache(OlapConnection conn) {
        }

        @Override
        public Object getMemberKey(Member m) throws OlapException {
            return m.getPropertyValue((Property)Property.StandardMemberProperty.MEMBER_KEY);
        }

        @Override
        public Object getOrderKey(Member m) throws OlapException {
            return m.getOrdinal();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface XmlaExtra {
        public ResultSet executeDrillthrough(OlapStatement var1, String var2, boolean var3, String var4, int[] var5) throws SQLException;

        public void setPreferList(OlapConnection var1);

        public Date getSchemaLoadDate(Schema var1);

        public int getLevelCardinality(Level var1) throws OlapException;

        public void getSchemaFunctionList(List<FunctionDefinition> var1, Schema var2, Util.Functor1<Boolean, String> var3);

        public int getHierarchyCardinality(Hierarchy var1) throws OlapException;

        public int getHierarchyStructure(Hierarchy var1);

        public boolean isHierarchyParentChild(Hierarchy var1);

        public int getMeasureAggregator(Member var1);

        public void checkMemberOrdinal(Member var1) throws OlapException;

        public boolean shouldReturnCellProperty(CellSet var1, Property var2, boolean var3);

        public List<String> getSchemaRoleNames(Schema var1);

        public String getSchemaId(Schema var1);

        public String getCubeType(Cube var1);

        public boolean isLevelUnique(Level var1);

        public List<Property> getLevelProperties(Level var1);

        public boolean isPropertyInternal(Property var1);

        public List<Map<String, Object>> getDataSources(OlapConnection var1) throws OlapException;

        public Map<String, Object> getAnnotationMap(MetadataElement var1) throws SQLException;

        public boolean canDrillThrough(Cell var1);

        public int getDrillThroughCount(Cell var1);

        public void flushSchemaCache(OlapConnection var1) throws OlapException;

        public Object getMemberKey(Member var1) throws OlapException;

        public Object getOrderKey(Member var1) throws OlapException;

        public static class FunctionDefinition {
            public final String functionName;
            public final String description;
            public final String parameterList;
            public final int returnType;
            public final int origin;
            public final String interfaceName;
            public final String caption;

            public FunctionDefinition(String functionName, String description, String parameterList, int returnType, int origin, String interfaceName, String caption) {
                this.functionName = functionName;
                this.description = description;
                this.parameterList = parameterList;
                this.returnType = returnType;
                this.origin = origin;
                this.interfaceName = interfaceName;
                this.caption = caption;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IntList
    extends AbstractList<Integer> {
        private final int[] ints;

        IntList(int[] ints) {
            this.ints = ints;
        }

        @Override
        public Integer get(int index) {
            return this.ints[index];
        }

        @Override
        public int size() {
            return this.ints.length;
        }
    }

    static class MDDataSet_Tabular
    extends MDDataSet {
        private final boolean empty;
        private final int[] pos;
        private final List<Integer> posList;
        private final int axisCount;
        private int cellOrdinal;
        private static final List<Property> MemberCaptionIdArray = Collections.singletonList(Property.StandardMemberProperty.MEMBER_CAPTION);
        private final Member[] members;
        private final ColumnHandler[] columnHandlers;

        public MDDataSet_Tabular(CellSet cellSet) {
            super(cellSet);
            List axes = cellSet.getAxes();
            this.axisCount = axes.size();
            this.pos = new int[this.axisCount];
            this.posList = new IntList(this.pos);
            boolean empty = false;
            int dimensionCount = 0;
            for (int i = axes.size() - 1; i > 0; --i) {
                CellSetAxis axis = (CellSetAxis)axes.get(i);
                if (axis.getPositions().size() == 0) {
                    empty = true;
                    continue;
                }
                dimensionCount += ((Position)axis.getPositions().get(0)).getMembers().size();
            }
            this.empty = empty;
            Level[] levels = new Level[dimensionCount];
            ArrayList<ColumnHandler> columnHandlerList = new ArrayList<ColumnHandler>();
            int memberOrdinal = 0;
            if (!empty) {
                for (int i = axes.size() - 1; i > 0; --i) {
                    CellSetAxis axis = (CellSetAxis)axes.get(i);
                    int z0 = memberOrdinal;
                    List positions = axis.getPositions();
                    int jj = 0;
                    for (Position position : positions) {
                        memberOrdinal = z0;
                        for (Member member : position.getMembers()) {
                            if (jj == 0 || member.getLevel().getDepth() > levels[memberOrdinal].getDepth()) {
                                levels[memberOrdinal] = member.getLevel();
                            }
                            ++memberOrdinal;
                        }
                        ++jj;
                    }
                    List<Property> dimProps = axis.getAxisMetaData().getProperties();
                    if (dimProps.size() == 0) {
                        dimProps = MemberCaptionIdArray;
                    }
                    for (int j = z0; j < memberOrdinal; ++j) {
                        Level level = levels[j];
                        for (int k = 0; k <= level.getDepth(); ++k) {
                            Level level2 = (Level)level.getHierarchy().getLevels().get(k);
                            if (level2.getLevelType() == Level.Type.ALL) continue;
                            for (Property dimProp : dimProps) {
                                columnHandlerList.add(new MemberColumnHandler(dimProp, level2, j));
                            }
                        }
                    }
                }
            }
            this.members = new Member[memberOrdinal + 1];
            if (axes.size() > 0) {
                CellSetAxis columnsAxis = (CellSetAxis)axes.get(0);
                for (Position position : columnsAxis.getPositions()) {
                    String name = null;
                    int j = 0;
                    for (Member member : position.getMembers()) {
                        name = j == 0 ? member.getUniqueName() : name + "." + member.getUniqueName();
                        ++j;
                    }
                    columnHandlerList.add(new CellColumnHandler(name));
                }
            }
            this.columnHandlers = columnHandlerList.toArray(new ColumnHandler[columnHandlerList.size()]);
        }

        public void metadata(SaxWriter writer) {
            writer.startElement("xsd:schema", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "targetNamespace", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:sql", XmlaHandler.NS_XML_SQL, "elementFormDefault", "qualified");
            writer.startElement("xsd:element", "name", "root");
            writer.startElement("xsd:complexType");
            writer.startElement("xsd:sequence");
            writer.element("xsd:element", "maxOccurs", "unbounded", "minOccurs", 0, "name", "row", "type", "row");
            writer.endElement();
            writer.endElement();
            writer.endElement();
            writer.startElement("xsd:simpleType", "name", "uuid");
            writer.startElement("xsd:restriction", "base", XmlaHandler.XSD_STRING);
            writer.element("xsd:pattern", "value", "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}");
            writer.endElement();
            writer.endElement();
            writer.startElement("xsd:complexType", "name", "row");
            writer.startElement("xsd:sequence");
            for (ColumnHandler columnHandler : this.columnHandlers) {
                columnHandler.metadata(writer);
            }
            writer.endElement();
            writer.endElement();
            writer.endElement();
        }

        public void unparse(SaxWriter writer) throws SAXException, OlapException {
            if (this.empty) {
                return;
            }
            this.cellData(writer);
        }

        private void cellData(SaxWriter writer) throws SAXException, OlapException {
            this.cellOrdinal = 0;
            this.iterate(writer);
        }

        private void iterate(SaxWriter writer) throws SAXException, OlapException {
            switch (this.axisCount) {
                case 0: {
                    this.emitCell(writer, this.cellSet.getCell(this.posList));
                    return;
                }
            }
            this.iterate(writer, this.axisCount - 1, 0);
        }

        private void iterate(SaxWriter writer, int axis, int xxx) throws OlapException {
            List positions = ((CellSetAxis)this.cellSet.getAxes().get(axis)).getPositions();
            int axisLength = axis == 0 ? 1 : positions.size();
            for (int i = 0; i < axisLength; ++i) {
                Position position = (Position)positions.get(i);
                int ho = xxx;
                List members = position.getMembers();
                for (int j = 0; j < members.size() && ho < this.members.length; ++j, ++ho) {
                    this.members[ho] = (Member)position.getMembers().get(j);
                }
                ++this.cellOrdinal;
                Util.discard((int)this.cellOrdinal);
                if (axis >= 2) {
                    this.iterate(writer, axis - 1, ho);
                    continue;
                }
                writer.startElement("row");
                this.pos[axis] = i;
                this.pos[0] = 0;
                for (ColumnHandler columnHandler : this.columnHandlers) {
                    if (columnHandler instanceof MemberColumnHandler) {
                        columnHandler.write(writer, null, this.members);
                        continue;
                    }
                    if (!(columnHandler instanceof CellColumnHandler)) continue;
                    columnHandler.write(writer, this.cellSet.getCell(this.posList), null);
                    this.pos[0] = this.pos[0] + 1;
                }
                writer.endElement();
            }
        }

        private void emitCell(SaxWriter writer, Cell cell) throws OlapException {
            ++this.cellOrdinal;
            Util.discard((int)this.cellOrdinal);
            Object cellValue = cell.getValue();
            if (cellValue == null) {
                return;
            }
            writer.startElement("row");
            for (ColumnHandler columnHandler : this.columnHandlers) {
                columnHandler.write(writer, cell, this.members);
            }
            writer.endElement();
        }
    }

    static class MemberColumnHandler
    extends ColumnHandler {
        private final Property property;
        private final Level level;
        private final int memberOrdinal;

        public MemberColumnHandler(Property property, Level level, int memberOrdinal) {
            super(level.getUniqueName() + "." + Util.quoteMdxIdentifier(property.getName()));
            this.property = property;
            this.level = level;
            this.memberOrdinal = memberOrdinal;
        }

        public void metadata(SaxWriter writer) {
            writer.element("xsd:element", "minOccurs", 0, "name", this.encodedName, "sql:field", this.name, "type", XmlaHandler.XSD_STRING);
        }

        public void write(SaxWriter writer, Cell cell, Member[] members) throws OlapException {
            Member member = members[this.memberOrdinal];
            int depth = this.level.getDepth();
            if (member.getDepth() < depth) {
                return;
            }
            while (member.getDepth() > depth) {
                member = member.getParentMember();
            }
            Object propertyValue = member.getPropertyValue(this.property);
            if (propertyValue == null) {
                return;
            }
            writer.startElement(this.encodedName);
            writer.characters(propertyValue.toString());
            writer.endElement();
        }
    }

    static class CellColumnHandler
    extends ColumnHandler {
        CellColumnHandler(String name) {
            super(name);
        }

        public void metadata(SaxWriter writer) {
            writer.element("xsd:element", "minOccurs", 0, "name", this.encodedName, "sql:field", this.name);
        }

        public void write(SaxWriter writer, Cell cell, Member[] members) {
            if (cell.isNull()) {
                return;
            }
            Object value = cell.getValue();
            String dataType = (String)cell.getPropertyValue((Property)Property.StandardCellProperty.DATATYPE);
            ValueInfo vi = new ValueInfo(dataType, value);
            String valueType = vi.valueType;
            value = vi.value;
            boolean isDecimal = vi.isDecimal;
            String valueString = value.toString();
            writer.startElement(this.encodedName, "xsi:type", valueType);
            if (isDecimal) {
                valueString = XmlaUtil.normalizeNumericString(valueString);
            }
            writer.characters(valueString);
            writer.endElement();
        }
    }

    static abstract class ColumnHandler {
        protected final String name;
        protected final String encodedName;

        protected ColumnHandler(String name) {
            this.name = name;
            this.encodedName = XmlaUtil.ElementNameEncoder.INSTANCE.encode(name);
        }

        abstract void write(SaxWriter var1, Cell var2, Member[] var3) throws OlapException;

        abstract void metadata(SaxWriter var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MDDataSet_Multidimensional
    extends MDDataSet {
        private List<Hierarchy> slicerAxisHierarchies;
        private final boolean omitDefaultSlicerInfo;
        private final boolean json;
        private XmlaUtil.ElementNameEncoder encoder = XmlaUtil.ElementNameEncoder.INSTANCE;
        private XmlaExtra extra;

        protected MDDataSet_Multidimensional(CellSet cellSet, boolean omitDefaultSlicerInfo, boolean json) throws SQLException {
            super(cellSet);
            this.omitDefaultSlicerInfo = omitDefaultSlicerInfo;
            this.json = json;
            this.extra = XmlaHandler.getExtra(cellSet.getStatement().getConnection());
        }

        @Override
        public void unparse(SaxWriter writer) throws SAXException, OlapException {
            this.olapInfo(writer);
            this.axes(writer);
            this.cellData(writer);
        }

        @Override
        public void metadata(SaxWriter writer) {
            writer.verbatim(MD_DATA_SET_XML_SCHEMA);
        }

        private void olapInfo(SaxWriter writer) throws OlapException {
            List<Hierarchy> hierarchies;
            Cube cube = this.cellSet.getMetaData().getCube();
            writer.startElement("OlapInfo");
            writer.startElement("CubeInfo");
            writer.startElement("Cube");
            writer.textElement("CubeName", cube.getName());
            writer.endElement();
            writer.endElement();
            writer.startSequence("AxesInfo", "AxisInfo");
            List axes = this.cellSet.getAxes();
            ArrayList<Hierarchy> axisHierarchyList = new ArrayList<Hierarchy>();
            for (int i = 0; i < axes.size(); ++i) {
                List<Hierarchy> hiers = this.axisInfo(writer, (CellSetAxis)axes.get(i), "Axis" + i);
                axisHierarchyList.addAll(hiers);
            }
            CellSetAxis slicerAxis = this.cellSet.getFilterAxis();
            if (this.omitDefaultSlicerInfo) {
                hierarchies = this.axisInfo(writer, slicerAxis, "SlicerAxis");
            } else {
                ArrayList unseenDimensionList = new ArrayList(cube.getDimensions());
                for (Hierarchy hier1 : axisHierarchyList) {
                    unseenDimensionList.remove(hier1.getDimension());
                }
                hierarchies = new ArrayList<Hierarchy>();
                for (Dimension dimension : unseenDimensionList) {
                    for (Hierarchy hierarchy : dimension.getHierarchies()) {
                        hierarchies.add(hierarchy);
                    }
                }
                writer.startElement("AxisInfo", "name", "SlicerAxis");
                this.writeHierarchyInfo(writer, hierarchies, this.getProps(slicerAxis.getAxisMetaData()));
                writer.endElement();
            }
            this.slicerAxisHierarchies = hierarchies;
            writer.endSequence();
            writer.startElement("CellInfo");
            this.cellProperty(writer, Property.StandardCellProperty.VALUE, true, "Value");
            this.cellProperty(writer, Property.StandardCellProperty.FORMATTED_VALUE, true, "FmtValue");
            this.cellProperty(writer, Property.StandardCellProperty.FORMAT_STRING, true, "FormatString");
            this.cellProperty(writer, Property.StandardCellProperty.LANGUAGE, false, "Language");
            this.cellProperty(writer, Property.StandardCellProperty.BACK_COLOR, false, "BackColor");
            this.cellProperty(writer, Property.StandardCellProperty.FORE_COLOR, false, "ForeColor");
            this.cellProperty(writer, Property.StandardCellProperty.FONT_FLAGS, false, "FontFlags");
            writer.endElement();
            writer.endElement();
        }

        private void cellProperty(SaxWriter writer, Property.StandardCellProperty cellProperty, boolean evenEmpty, String elementName) {
            if (this.extra.shouldReturnCellProperty(this.cellSet, (Property)cellProperty, evenEmpty)) {
                writer.element(elementName, "name", cellProperty.getName());
            }
        }

        private List<Hierarchy> axisInfo(SaxWriter writer, CellSetAxis axis, String axisName) {
            ArrayList<Hierarchy> hierarchies;
            writer.startElement("AxisInfo", "name", axisName);
            Iterator it = axis.getPositions().iterator();
            if (it.hasNext()) {
                Position position = (Position)it.next();
                hierarchies = new ArrayList<Hierarchy>();
                for (Member member : position.getMembers()) {
                    hierarchies.add(member.getHierarchy());
                }
            } else {
                hierarchies = axis.getAxisMetaData().getHierarchies();
            }
            List<Property> props = this.getProps(axis.getAxisMetaData());
            this.writeHierarchyInfo(writer, hierarchies, props);
            writer.endElement();
            return hierarchies;
        }

        private void writeHierarchyInfo(SaxWriter writer, List<Hierarchy> hierarchies, List<Property> props) {
            writer.startSequence(null, "HierarchyInfo");
            for (Hierarchy hierarchy : hierarchies) {
                writer.startElement("HierarchyInfo", "name", hierarchy.getName());
                for (Property prop : props) {
                    if (prop instanceof IMondrianOlap4jProperty) {
                        this.writeProperty(writer, hierarchy, prop);
                        continue;
                    }
                    this.writeElement(writer, hierarchy, prop);
                }
                writer.endElement();
            }
            writer.endSequence();
        }

        private void writeProperty(SaxWriter writer, Hierarchy hierarchy, Property prop) {
            String thatHierarchiName;
            IMondrianOlap4jProperty currentProperty = (IMondrianOlap4jProperty)prop;
            String thisHierarchyName = hierarchy.getName();
            if (thisHierarchyName.equals(thatHierarchiName = currentProperty.getLevel().getHierarchy().getName())) {
                this.writeElement(writer, hierarchy, prop);
            }
        }

        private void writeElement(SaxWriter writer, Hierarchy hierarchy, Property prop) {
            String encodedProp = this.encoder.encode(prop.getName());
            Object[] attributes = this.getAttributes(prop, hierarchy);
            writer.element(encodedProp, attributes);
        }

        private Object[] getAttributes(Property prop, Hierarchy hierarchy) {
            Property longProp = (Property)longProps.get(prop.getName());
            if (longProp == null) {
                longProp = prop;
            }
            ArrayList<String> values = new ArrayList<String>();
            values.add("name");
            values.add(hierarchy.getUniqueName() + "." + Util.quoteMdxIdentifier(longProp.getName()));
            if (longProp == prop) {
                values.add("type");
                values.add(this.getXsdType(longProp));
            }
            return values.toArray();
        }

        private String getXsdType(Property property) {
            Datatype datatype = property.getDatatype();
            switch (datatype) {
                case UNSIGNED_INTEGER: {
                    return RowsetDefinition.Type.UnsignedInteger.columnType;
                }
                case BOOLEAN: {
                    return RowsetDefinition.Type.Boolean.columnType;
                }
            }
            return RowsetDefinition.Type.String.columnType;
        }

        private void axes(SaxWriter writer) throws OlapException {
            writer.startSequence("Axes", "Axis");
            List axes = this.cellSet.getAxes();
            for (int i = 0; i < axes.size(); ++i) {
                CellSetAxis axis = (CellSetAxis)axes.get(i);
                List<Property> props = this.getProps(axis.getAxisMetaData());
                this.axis(writer, axis, props, "Axis" + i);
            }
            if (this.omitDefaultSlicerInfo) {
                CellSetAxis slicerAxis = this.cellSet.getFilterAxis();
                this.axis(writer, slicerAxis, this.getProps(slicerAxis.getAxisMetaData()), "SlicerAxis");
            } else {
                List<Hierarchy> hierarchies = this.slicerAxisHierarchies;
                writer.startElement("Axis", "name", "SlicerAxis");
                writer.startSequence("Tuples", "Tuple");
                writer.startSequence("Tuple", "Member");
                HashMap<String, Integer> memberMap = new HashMap<String, Integer>();
                CellSetAxis slicerAxis = this.cellSet.getFilterAxis();
                List slicerPositions = slicerAxis.getPositions();
                if (slicerPositions != null && slicerPositions.size() > 0) {
                    Position pos0 = (Position)slicerPositions.get(0);
                    int i = 0;
                    for (Member member : pos0.getMembers()) {
                        memberMap.put(member.getHierarchy().getName(), i++);
                    }
                }
                List slicerMembers = slicerPositions.isEmpty() ? Collections.emptyList() : ((Position)slicerPositions.get(0)).getMembers();
                for (Hierarchy hierarchy : hierarchies) {
                    Member member;
                    member = hierarchy.getDefaultMember();
                    Integer indexPosition = (Integer)memberMap.get(hierarchy.getName());
                    Member positionMember = indexPosition != null ? (Member)slicerMembers.get(indexPosition) : null;
                    for (Member slicerMember : slicerMembers) {
                        if (!slicerMember.getHierarchy().equals(hierarchy)) continue;
                        member = slicerMember;
                        break;
                    }
                    if (member != null) {
                        if (positionMember != null) {
                            this.writeMember(writer, positionMember, null, (Position)slicerPositions.get(0), indexPosition, this.getProps(slicerAxis.getAxisMetaData()));
                            continue;
                        }
                        this.slicerAxis(writer, member, this.getProps(slicerAxis.getAxisMetaData()));
                        continue;
                    }
                    LOGGER.warn((Object)("Can not create SlicerAxis: null default member for Hierarchy " + hierarchy.getUniqueName()));
                }
                writer.endSequence();
                writer.endSequence();
                writer.endElement();
            }
            writer.endSequence();
        }

        private List<Property> getProps(CellSetAxisMetaData queryAxis) {
            if (queryAxis == null) {
                return defaultProps;
            }
            return CompositeList.of(defaultProps, queryAxis.getProperties());
        }

        private void axis(SaxWriter writer, CellSetAxis axis, List<Property> props, String axisName) throws OlapException {
            Position nextPosition;
            writer.startElement("Axis", "name", axisName);
            writer.startSequence("Tuples", "Tuple");
            List positions = axis.getPositions();
            Iterator pit = positions.iterator();
            Position prevPosition = null;
            Position position = pit.hasNext() ? (Position)pit.next() : null;
            Position position2 = nextPosition = pit.hasNext() ? (Position)pit.next() : null;
            while (position != null) {
                writer.startSequence("Tuple", "Member");
                int k = 0;
                for (Member member : position.getMembers()) {
                    this.writeMember(writer, member, prevPosition, nextPosition, k++, props);
                }
                writer.endSequence();
                prevPosition = position;
                position = nextPosition;
                nextPosition = pit.hasNext() ? (Position)pit.next() : null;
            }
            writer.endSequence();
            writer.endElement();
        }

        private void writeMember(SaxWriter writer, Member member, Position prevPosition, Position nextPosition, int k, List<Property> props) throws OlapException {
            writer.startElement("Member", "Hierarchy", member.getHierarchy().getName());
            for (Property prop : props) {
                Property longProp;
                Object value = null;
                Property property = longProp = longProps.get(prop.getName()) != null ? (Property)longProps.get(prop.getName()) : prop;
                if (longProp == Property.StandardMemberProperty.DISPLAY_INFO) {
                    Integer childrenCard = (Integer)member.getPropertyValue((Property)Property.StandardMemberProperty.CHILDREN_CARDINALITY);
                    value = this.calculateDisplayInfo(prevPosition, nextPosition, member, k, childrenCard);
                } else if (longProp == Property.StandardMemberProperty.DEPTH) {
                    value = member.getDepth();
                } else {
                    Object object = value = longProp instanceof IMondrianOlap4jProperty ? this.getCurrentHierarchyProperty(member, longProp) : member.getPropertyValue(longProp);
                }
                if (value == null) continue;
                writer.textElement(this.encoder.encode(prop.getName()), value);
            }
            writer.endElement();
        }

        private Object getCurrentHierarchyProperty(Member member, Property longProp) throws OlapException {
            String thatHierarchyName;
            IMondrianOlap4jProperty currentProperty = (IMondrianOlap4jProperty)longProp;
            String thisHierarchyName = member.getHierarchy().getName();
            if (thisHierarchyName.equals(thatHierarchyName = currentProperty.getLevel().getHierarchy().getName())) {
                return member.getPropertyValue((Property)currentProperty);
            }
            return null;
        }

        private void slicerAxis(SaxWriter writer, Member member, List<Property> props) throws OlapException {
            writer.startElement("Member", "Hierarchy", member.getHierarchy().getName());
            for (Property prop : props) {
                Object value;
                Property longProp = (Property)longProps.get(prop.getName());
                if (longProp == null) {
                    longProp = prop;
                }
                if (longProp == Property.StandardMemberProperty.DISPLAY_INFO) {
                    Integer childrenCard = (Integer)member.getPropertyValue((Property)Property.StandardMemberProperty.CHILDREN_CARDINALITY);
                    int displayInfo = 0xFFFF & childrenCard;
                    value = displayInfo;
                } else {
                    value = longProp == Property.StandardMemberProperty.DEPTH ? Integer.valueOf(member.getDepth()) : member.getPropertyValue(longProp);
                }
                if (value == null) continue;
                writer.textElement(this.encoder.encode(prop.getName()), value);
            }
            writer.endElement();
        }

        private int calculateDisplayInfo(Position prevPosition, Position nextPosition, Member currentMember, int memberOrdinal, int childrenCount) {
            Member nextMember;
            String nextParentUName;
            String currentUName;
            int displayInfo = 0xFFFF & childrenCount;
            if (nextPosition != null && (currentUName = currentMember.getUniqueName()).equals(nextParentUName = this.parentUniqueName(nextMember = (Member)nextPosition.getMembers().get(memberOrdinal)))) {
                displayInfo |= 0x10000;
            }
            if (prevPosition != null) {
                String currentParentUName = this.parentUniqueName(currentMember);
                Member prevMember = (Member)prevPosition.getMembers().get(memberOrdinal);
                String prevParentUName = this.parentUniqueName(prevMember);
                if (currentParentUName != null && currentParentUName.equals(prevParentUName)) {
                    displayInfo |= 0x20000;
                }
            }
            return displayInfo;
        }

        private String parentUniqueName(Member member) {
            Member parent = member.getParentMember();
            if (parent == null) {
                return null;
            }
            return parent.getUniqueName();
        }

        private void cellData(SaxWriter writer) {
            writer.startSequence("CellData", "Cell");
            int axisCount = this.cellSet.getAxes().size();
            ArrayList<Integer> pos = new ArrayList<Integer>();
            for (int i = 0; i < axisCount; ++i) {
                pos.add(-1);
            }
            int[] cellOrdinal = new int[]{0};
            int axisOrdinal = axisCount - 1;
            this.recurse(writer, pos, axisOrdinal, cellOrdinal);
            writer.endSequence();
        }

        private void recurse(SaxWriter writer, List<Integer> pos, int axisOrdinal, int[] cellOrdinal) {
            if (axisOrdinal < 0) {
                int n = cellOrdinal[0];
                cellOrdinal[0] = n + 1;
                this.emitCell(writer, pos, n);
            } else {
                CellSetAxis axis = (CellSetAxis)this.cellSet.getAxes().get(axisOrdinal);
                List positions = axis.getPositions();
                int n = positions.size();
                for (int i = 0; i < n; ++i) {
                    pos.set(axisOrdinal, i);
                    this.recurse(writer, pos, axisOrdinal - 1, cellOrdinal);
                }
            }
        }

        private void emitCell(SaxWriter writer, List<Integer> pos, int ordinal) {
            Cell cell = this.cellSet.getCell(pos);
            if (cell.isNull() && ordinal != 0) {
                return;
            }
            writer.startElement("Cell", "CellOrdinal", ordinal);
            for (int i = 0; i < cellProps.size(); ++i) {
                Property cellPropLong = (Property)cellPropLongs.get(i);
                Object value = cell.getPropertyValue(cellPropLong);
                if (value == null || !this.extra.shouldReturnCellProperty(this.cellSet, cellPropLong, true)) continue;
                if (!this.json && cellPropLong == Property.StandardCellProperty.VALUE) {
                    if (cell.isNull()) continue;
                    String dataType = (String)cell.getPropertyValue((Property)Property.StandardCellProperty.DATATYPE);
                    ValueInfo vi = new ValueInfo(dataType, value);
                    String valueType = vi.valueType;
                    String valueString = vi.isDecimal ? XmlaUtil.normalizeNumericString(vi.value.toString()) : vi.value.toString();
                    writer.startElement(((Property)cellProps.get(i)).getName(), "xsi:type", valueType);
                    writer.characters(valueString);
                    writer.endElement();
                    continue;
                }
                writer.textElement(((Property)cellProps.get(i)).getName(), value);
            }
            writer.endElement();
        }
    }

    static abstract class MDDataSet
    implements QueryResult {
        protected final CellSet cellSet;
        protected static final List<Property> cellProps = Arrays.asList(MDDataSet.rename((Property)Property.StandardCellProperty.VALUE, "Value"), MDDataSet.rename((Property)Property.StandardCellProperty.FORMATTED_VALUE, "FmtValue"), MDDataSet.rename((Property)Property.StandardCellProperty.FORMAT_STRING, "FormatString"));
        protected static final List<Property.StandardCellProperty> cellPropLongs = Arrays.asList(Property.StandardCellProperty.VALUE, Property.StandardCellProperty.FORMATTED_VALUE, Property.StandardCellProperty.FORMAT_STRING);
        protected static final List<Property> defaultProps = Arrays.asList(MDDataSet.rename((Property)Property.StandardMemberProperty.MEMBER_UNIQUE_NAME, "UName"), MDDataSet.rename((Property)Property.StandardMemberProperty.MEMBER_CAPTION, "Caption"), MDDataSet.rename((Property)Property.StandardMemberProperty.LEVEL_UNIQUE_NAME, "LName"), MDDataSet.rename((Property)Property.StandardMemberProperty.LEVEL_NUMBER, "LNum"), MDDataSet.rename((Property)Property.StandardMemberProperty.DISPLAY_INFO, "DisplayInfo"));
        protected static final Map<String, Property.StandardMemberProperty> longProps = new HashMap<String, Property.StandardMemberProperty>();

        protected MDDataSet(CellSet cellSet) {
            this.cellSet = cellSet;
        }

        public void close() throws SQLException {
            this.cellSet.getStatement().getConnection().close();
        }

        private static Property rename(final Property property, final String name) {
            return new Property(){

                public Datatype getDatatype() {
                    return property.getDatatype();
                }

                public Set<Property.TypeFlag> getType() {
                    return property.getType();
                }

                public Property.ContentType getContentType() {
                    return property.getContentType();
                }

                public String getName() {
                    return name;
                }

                public String getUniqueName() {
                    return property.getUniqueName();
                }

                public String getCaption() {
                    return property.getCaption();
                }

                public String getDescription() {
                    return property.getDescription();
                }

                public boolean isVisible() {
                    return property.isVisible();
                }
            };
        }

        static {
            longProps.put("UName", Property.StandardMemberProperty.MEMBER_UNIQUE_NAME);
            longProps.put("Caption", Property.StandardMemberProperty.MEMBER_CAPTION);
            longProps.put("LName", Property.StandardMemberProperty.LEVEL_UNIQUE_NAME);
            longProps.put("LNum", Property.StandardMemberProperty.LEVEL_NUMBER);
            longProps.put("DisplayInfo", Property.StandardMemberProperty.DISPLAY_INFO);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TabularRowSet
    implements QueryResult {
        private final List<Column> columns = new ArrayList<Column>();
        private final List<Object[]> rows;
        private int totalCount;

        public TabularRowSet(ResultSet rs, int totalCount) throws SQLException {
            this.totalCount = totalCount;
            ResultSetMetaData md = rs.getMetaData();
            int columnCount = md.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                this.columns.add(new Column(md.getColumnLabel(i + 1), md.getColumnType(i + 1), md.getScale(i + 1)));
            }
            this.rows = new ArrayList<Object[]>();
            while (rs.next()) {
                Object[] row = new Object[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    row[i] = rs.getObject(i + 1);
                }
                this.rows.add(row);
            }
        }

        public TabularRowSet(Map<String, List<String>> tableFieldMap, List<String> tableList) {
            for (String tableName : tableList) {
                List<String> fieldNames = tableFieldMap.get(tableName);
                for (String fieldName : fieldNames) {
                    this.columns.add(new Column(tableName + "." + fieldName, 12, 0));
                }
            }
            this.rows = new ArrayList<Object[]>();
            Object[] row = new Object[this.columns.size()];
            for (int k = 0; k < row.length; ++k) {
                row[k] = k;
            }
            this.rows.add(row);
        }

        @Override
        public void close() {
        }

        @Override
        public void unparse(SaxWriter writer) throws SAXException {
            if (this.totalCount >= 0) {
                String countStr = Integer.toString(this.totalCount);
                writer.startElement("row");
                for (Column column : this.columns) {
                    writer.startElement(column.encodedName);
                    writer.characters(countStr);
                    writer.endElement();
                }
                writer.endElement();
            }
            for (Object[] row : this.rows) {
                writer.startElement("row");
                for (int i = 0; i < row.length; ++i) {
                    writer.startElement(this.columns.get(i).encodedName, "xsi:type", this.columns.get(i).xsdType);
                    Object value = row[i];
                    if (value == null) {
                        writer.characters("null");
                    } else {
                        String valueString = value.toString();
                        if (value instanceof Number) {
                            valueString = XmlaUtil.normalizeNumericString(valueString);
                        }
                        writer.characters(valueString);
                    }
                    writer.endElement();
                }
                writer.endElement();
            }
        }

        @Override
        public void metadata(SaxWriter writer) {
            writer.startElement("xsd:schema", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "targetNamespace", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:sql", XmlaHandler.NS_XML_SQL, "elementFormDefault", "qualified");
            writer.startElement("xsd:element", "name", "root");
            writer.startElement("xsd:complexType");
            writer.startElement("xsd:sequence");
            writer.element("xsd:element", "maxOccurs", "unbounded", "minOccurs", 0, "name", "row", "type", "row");
            writer.endElement();
            writer.endElement();
            writer.endElement();
            writer.startElement("xsd:simpleType", "name", "uuid");
            writer.startElement("xsd:restriction", "base", XmlaHandler.XSD_STRING);
            writer.element("xsd:pattern", "value", "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}");
            writer.endElement();
            writer.endElement();
            writer.startElement("xsd:complexType", "name", "row");
            writer.startElement("xsd:sequence");
            for (Column column : this.columns) {
                writer.element("xsd:element", "minOccurs", 0, "name", column.encodedName, "sql:field", column.name, "type", column.xsdType);
            }
            writer.endElement();
            writer.endElement();
            writer.endElement();
        }
    }

    static class Column {
        private final String name;
        private final String encodedName;
        private final String xsdType;

        Column(String name, int type, int scale) {
            this.name = name;
            this.encodedName = XmlaUtil.ElementNameEncoder.INSTANCE.encode(name);
            this.xsdType = XmlaHandler.sqlToXsdType(type, scale);
        }
    }

    private static interface QueryResult {
        public void unparse(SaxWriter var1) throws SAXException, OlapException;

        public void close() throws SQLException;

        public void metadata(SaxWriter var1);
    }

    static class ValueInfo {
        String valueType;
        Object value;
        boolean isDecimal;

        static String getValueTypeHint(String dataType) {
            if (dataType != null) {
                return dataType.equals("Integer") ? XmlaHandler.XSD_INT : (dataType.equals("Numeric") ? XmlaHandler.XSD_DOUBLE : XmlaHandler.XSD_STRING);
            }
            return null;
        }

        ValueInfo(String dataType, Object inputValue) {
            String valueTypeHint = ValueInfo.getValueTypeHint(dataType);
            if (valueTypeHint != null) {
                if (valueTypeHint.equals(XmlaHandler.XSD_STRING)) {
                    this.valueType = valueTypeHint;
                    this.value = inputValue;
                    this.isDecimal = false;
                } else if (valueTypeHint.equals(XmlaHandler.XSD_INT)) {
                    if (inputValue instanceof Integer) {
                        this.valueType = valueTypeHint;
                        this.value = inputValue;
                        this.isDecimal = false;
                    } else if (inputValue instanceof Byte) {
                        this.valueType = XmlaHandler.XSD_BYTE;
                        this.value = inputValue;
                        this.isDecimal = false;
                    } else if (inputValue instanceof Short) {
                        this.valueType = XmlaHandler.XSD_SHORT;
                        this.value = inputValue;
                        this.isDecimal = false;
                    } else if (inputValue instanceof Long) {
                        long lval = (Long)inputValue;
                        this.setValueAndType(lval);
                    } else if (inputValue instanceof BigInteger) {
                        BigInteger bi = (BigInteger)inputValue;
                        long lval = bi.longValue();
                        if (bi.equals(BigInteger.valueOf(lval))) {
                            this.setValueAndType(lval);
                        } else {
                            this.valueType = XmlaHandler.XSD_INTEGER;
                            this.value = inputValue;
                            this.isDecimal = false;
                        }
                    } else if (inputValue instanceof Float) {
                        Float f = (Float)inputValue;
                        long lval = f.longValue();
                        if (f.equals(new Float(lval))) {
                            this.setValueAndType(lval);
                        } else {
                            this.valueType = XmlaHandler.XSD_FLOAT;
                            this.value = inputValue;
                            this.isDecimal = true;
                        }
                    } else if (inputValue instanceof Double) {
                        Double d = (Double)inputValue;
                        long lval = d.longValue();
                        if (d.equals(new Double(lval))) {
                            this.setValueAndType(lval);
                        } else {
                            this.valueType = XmlaHandler.XSD_DOUBLE;
                            this.value = inputValue;
                            this.isDecimal = true;
                        }
                    } else if (inputValue instanceof BigDecimal) {
                        BigDecimal bd = (BigDecimal)inputValue;
                        try {
                            long lval = bd.longValue();
                            this.setValueAndType(lval);
                        }
                        catch (ArithmeticException ex) {
                            try {
                                BigInteger bi = bd.toBigIntegerExact();
                                this.valueType = XmlaHandler.XSD_INTEGER;
                                this.value = bi;
                                this.isDecimal = false;
                            }
                            catch (ArithmeticException ex1) {
                                this.valueType = XmlaHandler.XSD_DECIMAL;
                                this.value = inputValue;
                                this.isDecimal = true;
                            }
                        }
                    } else if (inputValue instanceof Number) {
                        this.value = ((Number)inputValue).longValue();
                        this.valueType = valueTypeHint;
                        this.isDecimal = false;
                    } else {
                        this.valueType = valueTypeHint;
                        this.value = inputValue;
                        this.isDecimal = false;
                    }
                } else if (valueTypeHint.equals(XmlaHandler.XSD_DOUBLE)) {
                    if (inputValue instanceof Double) {
                        this.valueType = valueTypeHint;
                        this.value = inputValue;
                        this.isDecimal = true;
                    } else if (inputValue instanceof Byte || inputValue instanceof Short || inputValue instanceof Integer || inputValue instanceof Long) {
                        this.value = ((Number)inputValue).doubleValue();
                        this.valueType = valueTypeHint;
                        this.isDecimal = true;
                    } else if (inputValue instanceof Float) {
                        this.value = inputValue;
                        this.valueType = XmlaHandler.XSD_FLOAT;
                        this.isDecimal = true;
                    } else if (inputValue instanceof BigDecimal) {
                        BigDecimal bd = (BigDecimal)inputValue;
                        double dval = bd.doubleValue();
                        try {
                            BigDecimal bd2 = Util.makeBigDecimalFromDouble(dval);
                            if (bd.compareTo(bd2) == 0) {
                                this.valueType = XmlaHandler.XSD_DOUBLE;
                                this.value = dval;
                            } else {
                                this.valueType = XmlaHandler.XSD_DECIMAL;
                                this.value = inputValue;
                            }
                        }
                        catch (NumberFormatException ex) {
                            this.valueType = XmlaHandler.XSD_DECIMAL;
                            this.value = inputValue;
                        }
                        this.isDecimal = true;
                    } else if (inputValue instanceof BigInteger) {
                        BigInteger bi = (BigInteger)inputValue;
                        long lval = bi.longValue();
                        if (bi.equals(BigInteger.valueOf(lval))) {
                            this.setValueAndType(lval);
                        } else {
                            this.valueType = XmlaHandler.XSD_INTEGER;
                            this.value = inputValue;
                            this.isDecimal = true;
                        }
                    } else if (inputValue instanceof Number) {
                        this.value = ((Number)inputValue).doubleValue();
                        this.valueType = valueTypeHint;
                        this.isDecimal = true;
                    } else {
                        this.valueType = valueTypeHint;
                        this.value = inputValue;
                        this.isDecimal = true;
                    }
                }
            } else if (inputValue instanceof String) {
                this.valueType = XmlaHandler.XSD_STRING;
                this.value = inputValue;
                this.isDecimal = false;
            } else if (inputValue instanceof Integer) {
                this.valueType = XmlaHandler.XSD_INT;
                this.value = inputValue;
                this.isDecimal = false;
            } else if (inputValue instanceof Byte) {
                Byte b = (Byte)inputValue;
                this.valueType = XmlaHandler.XSD_BYTE;
                this.value = b.intValue();
                this.isDecimal = false;
            } else if (inputValue instanceof Short) {
                Short s = (Short)inputValue;
                this.valueType = XmlaHandler.XSD_SHORT;
                this.value = s.intValue();
                this.isDecimal = false;
            } else if (inputValue instanceof Long) {
                this.setValueAndType((Long)inputValue);
            } else if (inputValue instanceof BigInteger) {
                BigInteger bi = (BigInteger)inputValue;
                long lval = bi.longValue();
                if (bi.equals(BigInteger.valueOf(lval))) {
                    this.setValueAndType(lval);
                } else {
                    this.valueType = XmlaHandler.XSD_INTEGER;
                    this.value = inputValue;
                    this.isDecimal = false;
                }
            } else if (inputValue instanceof Float) {
                this.valueType = XmlaHandler.XSD_FLOAT;
                this.value = inputValue;
                this.isDecimal = true;
            } else if (inputValue instanceof Double) {
                this.valueType = XmlaHandler.XSD_DOUBLE;
                this.value = inputValue;
                this.isDecimal = true;
            } else if (inputValue instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)inputValue;
                double dval = bd.doubleValue();
                try {
                    BigDecimal bd2 = Util.makeBigDecimalFromDouble(dval);
                    if (bd.compareTo(bd2) == 0) {
                        this.valueType = XmlaHandler.XSD_DOUBLE;
                        this.value = dval;
                    } else {
                        this.valueType = XmlaHandler.XSD_DECIMAL;
                        this.value = inputValue;
                    }
                }
                catch (NumberFormatException ex) {
                    this.valueType = XmlaHandler.XSD_DECIMAL;
                    this.value = inputValue;
                }
                this.isDecimal = true;
            } else if (inputValue instanceof Number) {
                this.value = ((Number)inputValue).longValue();
                this.valueType = XmlaHandler.XSD_LONG;
                this.isDecimal = false;
            } else if (inputValue instanceof Boolean) {
                this.value = inputValue;
                this.valueType = XmlaHandler.XSD_BOOLEAN;
                this.isDecimal = false;
            } else {
                this.valueType = XmlaHandler.XSD_STRING;
                this.value = inputValue;
                this.isDecimal = false;
            }
        }

        private void setValueAndType(long lval) {
            if (!XmlaHandler.isValidXsdInt(lval)) {
                this.valueType = XmlaHandler.XSD_LONG;
                this.value = lval;
            } else {
                this.valueType = XmlaHandler.XSD_INT;
                this.value = (int)lval;
            }
            this.isDecimal = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SetType {
        ROW_SET,
        MD_DATA_SET;

    }
}

