/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3.vfs;

import java.util.Collection;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticationData;
import org.apache.commons.vfs.UserAuthenticator;
import org.apache.commons.vfs.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.URLFileName;
import org.jets3t.service.S3Service;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;
import org.pentaho.s3.vfs.S3FileObject;
import org.pentaho.s3.vfs.S3FileProvider;

public class S3FileSystem
extends AbstractFileSystem
implements FileSystem {
    private S3Service service;

    protected S3FileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(S3FileProvider.capabilities);
    }

    protected FileObject createFile(FileName name) throws Exception {
        return new S3FileObject(name, this);
    }

    public S3Service getS3Service() {
        if (this.service == null || this.service.getProviderCredentials() == null || this.service.getProviderCredentials().getAccessKey() == null) {
            UserAuthenticator userAuthenticator = DefaultFileSystemConfigBuilder.getInstance().getUserAuthenticator(this.getFileSystemOptions());
            String awsAccessKey = null;
            String awsSecretKey = null;
            if (userAuthenticator != null) {
                UserAuthenticationData data = userAuthenticator.requestAuthentication(S3FileProvider.AUTHENTICATOR_TYPES);
                awsAccessKey = String.valueOf(data.getData(UserAuthenticationData.USERNAME));
                awsSecretKey = String.valueOf(data.getData(UserAuthenticationData.PASSWORD));
            } else {
                awsAccessKey = ((URLFileName)this.getRootName()).getUserName();
                awsSecretKey = ((URLFileName)this.getRootName()).getPassword();
            }
            AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
            try {
                this.service = new RestS3Service((ProviderCredentials)awsCredentials);
            }
            catch (Throwable t) {
                System.out.println("Could not getS3Service() for " + awsCredentials.getLogString());
                t.printStackTrace();
            }
        }
        return this.service;
    }
}

