/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.core.Const;
import org.pentaho.ui.xul.containers.XulMenupopup;

public class ConstUI {
    public static final int ICON_SIZE = 32;
    public static final int SMALL_ICON_SIZE = 16;
    public static final int MEDIUM_ICON_SIZE = 24;
    public static final int LINE_WIDTH = 1;
    public static final int GRID_SIZE = 20;
    public static final int NOTE_MIN_SIZE = 20;
    public static final int TOOLTIP_OFFSET = 5;
    public static final int COLOR_BACKGROUND_RED = 255;
    public static final int COLOR_BACKGROUND_GREEN = 255;
    public static final int COLOR_BACKGROUND_BLUE = 255;
    public static final int COLOR_GRAPH_RED = 255;
    public static final int COLOR_GRAPH_GREEN = 255;
    public static final int COLOR_GRAPH_BLUE = 255;
    public static final int COLOR_TAB_RED = 240;
    public static final int COLOR_TAB_GREEN = 240;
    public static final int COLOR_TAB_BLUE = 240;
    public static final int INTERVAL_MS_TRANS_CANVAS_REFRESH = 1000;
    public static final int SMALL_MARGIN = 5;
    public static final int MEDUIM_MARGIN = 10;

    public static final int getTreeLevel(TreeItem ti) {
        int level = 0;
        for (TreeItem parent = ti.getParentItem(); parent != null; parent = parent.getParentItem()) {
            ++level;
        }
        return level;
    }

    public static final String[] getTreeStrings(TreeItem ti) {
        int nrlevels = ConstUI.getTreeLevel(ti) + 1;
        String[] retval = new String[nrlevels];
        int level = 0;
        retval[nrlevels - 1] = ti.getText();
        for (TreeItem parent = ti.getParentItem(); parent != null; parent = parent.getParentItem()) {
            retval[nrlevels - ++level - 1] = parent.getText();
        }
        return retval;
    }

    public static final String getTreePath(TreeItem ti, int from) {
        String[] path = ConstUI.getTreeStrings(ti);
        if (path == null) {
            return null;
        }
        String retval = "";
        for (int i = from; i < path.length; ++i) {
            if (path[i].equalsIgnoreCase(Const.FILE_SEPARATOR)) continue;
            retval = retval + Const.FILE_SEPARATOR + path[i];
        }
        return retval;
    }

    public static final void flipExpanded(TreeItem ti) {
        ti.setExpanded(!ti.getExpanded());
    }

    public static final TreeItem findTreeItem(TreeItem parent, String name) {
        return ConstUI.findTreeItem(parent, null, name);
    }

    public static final TreeItem findTreeItem(TreeItem parent, String parentName, String name) {
        return ConstUI.findTreeItem(null, parent, parentName, name);
    }

    private static final TreeItem findTreeItem(TreeItem grandParent, TreeItem parent, String parentName, String name) {
        if (Const.isEmpty((String)parentName)) {
            if (parent.getText().equalsIgnoreCase(name)) {
                return parent;
            }
        } else {
            if (grandParent != null && grandParent.getText().equalsIgnoreCase("OTHER")) {
                System.out.println("Other");
            }
            if (grandParent != null && grandParent.getText().equalsIgnoreCase(parentName) && parent.getText().equalsIgnoreCase(name)) {
                return parent;
            }
        }
        TreeItem[] ti = parent.getItems();
        for (int i = 0; i < ti.length; ++i) {
            TreeItem child = ConstUI.findTreeItem(parent, ti[i], parentName, name);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    public static void displayMenu(XulMenupopup xulMenuPopup, Control control) {
        MenuManager menuMgr = (MenuManager)xulMenuPopup.getManagedObject();
        Menu menu = menuMgr.createContextMenu(control);
        menuMgr.updateAll(true);
        ConstUI.displayMenu(menu, control);
    }

    public static void displayMenu(Menu menu, Control control) {
        Menu oldMenu = control.getMenu();
        if (oldMenu != null && oldMenu != menu) {
            oldMenu.setVisible(false);
        }
        menu.setVisible(true);
    }
}

