/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.database.wizard;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.InformixDatabaseMeta;
import org.pentaho.di.core.database.OracleDatabaseMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.wizard.CreateDatabaseWizard;

public class CreateDatabaseWizardPageJDBC
extends WizardPage {
    private static Class<?> PKG = CreateDatabaseWizard.class;
    private Label wlHostname;
    private Text wHostname;
    private FormData fdlHostname;
    private FormData fdHostname;
    private Label wlPort;
    private Text wPort;
    private FormData fdlPort;
    private FormData fdPort;
    private Label wlDBName;
    private Text wDBName;
    private FormData fdlDBName;
    private FormData fdDBName;
    private PropsUI props;
    private DatabaseMeta databaseMeta;

    public CreateDatabaseWizardPageJDBC(String arg, PropsUI props, DatabaseMeta info) {
        super(arg);
        this.props = props;
        this.databaseMeta = info;
        this.setTitle(BaseMessages.getString(PKG, (String)"CreateDatabaseWizardPageJDBC.DialogTitle", (String[])new String[0]));
        this.setDescription(BaseMessages.getString(PKG, (String)"CreateDatabaseWizardPageJDBC.DialogMessage", (String[])new String[0]));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        int margin = 4;
        int middle = this.props.getMiddlePct();
        Composite composite = new Composite(parent, 0);
        this.props.setLook((Control)composite);
        FormLayout compLayout = new FormLayout();
        compLayout.marginHeight = 5;
        compLayout.marginWidth = 5;
        composite.setLayout((Layout)compLayout);
        this.wlHostname = new Label(composite, 131072);
        this.wlHostname.setText(BaseMessages.getString(PKG, (String)"CreateDatabaseWizardPageJDBC.Hostname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlHostname);
        this.fdlHostname = new FormData();
        this.fdlHostname.top = new FormAttachment(0, 0);
        this.fdlHostname.left = new FormAttachment(0, 0);
        this.fdlHostname.right = new FormAttachment(middle, 0);
        this.wlHostname.setLayoutData((Object)this.fdlHostname);
        this.wHostname = new Text(composite, 2052);
        this.props.setLook((Control)this.wHostname);
        this.fdHostname = new FormData();
        this.fdHostname.top = new FormAttachment(0, 0);
        this.fdHostname.left = new FormAttachment(middle, margin);
        this.fdHostname.right = new FormAttachment(100, 0);
        this.wHostname.setLayoutData((Object)this.fdHostname);
        this.wHostname.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CreateDatabaseWizardPageJDBC.this.setPageComplete(false);
            }
        });
        this.wlPort = new Label(composite, 131072);
        this.wlPort.setText(BaseMessages.getString(PKG, (String)"CreateDatabaseWizardPageJDBC.Port.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPort);
        this.fdlPort = new FormData();
        this.fdlPort.top = new FormAttachment((Control)this.wHostname, margin);
        this.fdlPort.left = new FormAttachment(0, 0);
        this.fdlPort.right = new FormAttachment(middle, 0);
        this.wlPort.setLayoutData((Object)this.fdlPort);
        this.wPort = new Text(composite, 2052);
        this.props.setLook((Control)this.wPort);
        this.wPort.setText(this.databaseMeta.getDatabasePortNumberString());
        this.fdPort = new FormData();
        this.fdPort.top = new FormAttachment((Control)this.wHostname, margin);
        this.fdPort.left = new FormAttachment(middle, margin);
        this.fdPort.right = new FormAttachment(100, 0);
        this.wPort.setLayoutData((Object)this.fdPort);
        this.wPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CreateDatabaseWizardPageJDBC.this.setPageComplete(false);
            }
        });
        this.wlDBName = new Label(composite, 131072);
        this.wlDBName.setText(BaseMessages.getString(PKG, (String)"CreateDatabaseWizardPageJDBC.DBName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDBName);
        this.fdlDBName = new FormData();
        this.fdlDBName.top = new FormAttachment((Control)this.wPort, margin);
        this.fdlDBName.left = new FormAttachment(0, 0);
        this.fdlDBName.right = new FormAttachment(middle, 0);
        this.wlDBName.setLayoutData((Object)this.fdlDBName);
        this.wDBName = new Text(composite, 2052);
        this.props.setLook((Control)this.wDBName);
        this.fdDBName = new FormData();
        this.fdDBName.top = new FormAttachment((Control)this.wPort, margin);
        this.fdDBName.left = new FormAttachment(middle, margin);
        this.fdDBName.right = new FormAttachment(100, 0);
        this.wDBName.setLayoutData((Object)this.fdDBName);
        this.wDBName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CreateDatabaseWizardPageJDBC.this.setPageComplete(false);
            }
        });
        this.setControl((Control)composite);
    }

    public void setData() {
        this.wHostname.setText(Const.NVL((String)this.databaseMeta.getHostname(), (String)""));
        this.wPort.setText(this.databaseMeta.getDatabasePortNumberString());
        this.wDBName.setText(Const.NVL((String)this.databaseMeta.getDatabaseName(), (String)""));
    }

    public boolean canFlipToNextPage() {
        String dbname;
        String port;
        String server;
        String string = this.wHostname.getText() != null ? (this.wHostname.getText().length() > 0 ? this.wHostname.getText() : null) : (server = null);
        String string2 = this.wPort.getText() != null ? (this.wPort.getText().length() > 0 ? this.wPort.getText() : null) : (port = null);
        String string3 = this.wDBName.getText() != null ? (this.wDBName.getText().length() > 0 ? this.wDBName.getText() : null) : (dbname = null);
        if (server == null || port == null || dbname == null) {
            this.setErrorMessage(BaseMessages.getString(PKG, (String)"CreateDatabaseWizardPageJDBC.ErrorMessage.InvalidInput", (String[])new String[0]));
            return false;
        }
        this.getDatabaseInfo();
        this.setErrorMessage(null);
        this.setMessage(BaseMessages.getString(PKG, (String)"CreateDatabaseWizardPageJDBC.Message.Input", (String[])new String[0]));
        return true;
    }

    public DatabaseMeta getDatabaseInfo() {
        if (this.wHostname.getText() != null && this.wHostname.getText().length() > 0) {
            this.databaseMeta.setHostname(this.wHostname.getText());
        }
        if (this.wPort.getText() != null && this.wPort.getText().length() > 0) {
            this.databaseMeta.setDBPort(this.wPort.getText());
        }
        if (this.wDBName.getText() != null && this.wDBName.getText().length() > 0) {
            this.databaseMeta.setDBName(this.wDBName.getText());
        }
        return this.databaseMeta;
    }

    public IWizardPage getNextPage() {
        IWizard wiz = this.getWizard();
        IWizardPage nextPage = this.databaseMeta.getDatabaseInterface() instanceof OracleDatabaseMeta ? wiz.getPage("oracle") : (this.databaseMeta.getDatabaseInterface() instanceof InformixDatabaseMeta ? wiz.getPage("ifx") : wiz.getPage("2"));
        return nextPage;
    }
}

