/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.connectedtorepository;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.connectedtorepository.JobEntryConnectedToRepository;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class JobEntryConnectedToRepositoryDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntryConnectedToRepository.class;
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private JobEntryConnectedToRepository jobEntry;
    private Shell shell;
    private SelectionAdapter lsDef;
    private boolean changed;
    private Label wlspecificRep;
    private Button wspecificRep;
    private FormData fdlspecificRep;
    private FormData fdspecificRep;
    private Label wlspecificUser;
    private Button wspecificUser;
    private FormData fdlspecificUser;
    private FormData fdspecificUser;
    private Label wlRepName;
    private TextVar wRepName;
    private FormData fdlRepName;
    private FormData fdRepName;
    private Label wlUserName;
    private TextVar wUserName;
    private FormData fdlUserName;
    private FormData fdUserName;
    private Button wbRepositoryname;
    private FormData fdbRepositoryname;

    public JobEntryConnectedToRepositoryDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryConnectedToRepository)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.Jobname.Label", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryConnectedToRepositoryDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlName = new Label((Composite)this.shell, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.right = new FormAttachment(middle, -margin);
        this.fdlName.top = new FormAttachment(0, margin);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, 0);
        this.fdName.top = new FormAttachment(0, margin);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        this.wlspecificRep = new Label((Composite)this.shell, 131072);
        this.wlspecificRep.setText(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.specificRep.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlspecificRep);
        this.fdlspecificRep = new FormData();
        this.fdlspecificRep.left = new FormAttachment(0, 0);
        this.fdlspecificRep.top = new FormAttachment((Control)this.wName, margin);
        this.fdlspecificRep.right = new FormAttachment(middle, -margin);
        this.wlspecificRep.setLayoutData((Object)this.fdlspecificRep);
        this.wspecificRep = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wspecificRep);
        this.wspecificRep.setToolTipText(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.specificRep.Tooltip", (String[])new String[0]));
        this.fdspecificRep = new FormData();
        this.fdspecificRep.left = new FormAttachment(middle, 0);
        this.fdspecificRep.top = new FormAttachment((Control)this.wName, margin);
        this.fdspecificRep.right = new FormAttachment(100, 0);
        this.wspecificRep.setLayoutData((Object)this.fdspecificRep);
        this.wspecificRep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntryConnectedToRepositoryDialog.this.jobEntry.setChanged();
                JobEntryConnectedToRepositoryDialog.this.activeSpecRep();
            }
        });
        this.wlRepName = new Label((Composite)this.shell, 131072);
        this.wlRepName.setText(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.RepName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlRepName);
        this.fdlRepName = new FormData();
        this.fdlRepName.left = new FormAttachment(0, 0);
        this.fdlRepName.right = new FormAttachment(middle, -margin);
        this.fdlRepName.top = new FormAttachment((Control)this.wspecificRep, margin);
        this.wlRepName.setLayoutData((Object)this.fdlRepName);
        this.wbRepositoryname = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbRepositoryname);
        this.wbRepositoryname.setText(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.ListRepositories.Label", (String[])new String[0]));
        this.wbRepositoryname.setToolTipText(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.ListRepositories.Tooltip", (String[])new String[0]));
        this.fdbRepositoryname = new FormData();
        this.fdbRepositoryname.right = new FormAttachment(100, 0);
        this.fdbRepositoryname.top = new FormAttachment((Control)this.wspecificRep, 0);
        this.wbRepositoryname.setLayoutData((Object)this.fdbRepositoryname);
        this.wbRepositoryname.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntryConnectedToRepositoryDialog.this.getListRepositories();
            }
        });
        this.wRepName = new TextVar((VariableSpace)this.jobMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wRepName);
        this.wRepName.setToolTipText(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.RepName.Tooltip", (String[])new String[0]));
        this.wRepName.addModifyListener(lsMod);
        this.fdRepName = new FormData();
        this.fdRepName.left = new FormAttachment(middle, 0);
        this.fdRepName.top = new FormAttachment((Control)this.wspecificRep, margin);
        this.fdRepName.right = new FormAttachment((Control)this.wbRepositoryname, -margin);
        this.wRepName.setLayoutData(this.fdRepName);
        this.wlspecificUser = new Label((Composite)this.shell, 131072);
        this.wlspecificUser.setText(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.specificUser.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlspecificUser);
        this.fdlspecificUser = new FormData();
        this.fdlspecificUser.left = new FormAttachment(0, 0);
        this.fdlspecificUser.top = new FormAttachment((Control)this.wRepName, margin);
        this.fdlspecificUser.right = new FormAttachment(middle, -margin);
        this.wlspecificUser.setLayoutData((Object)this.fdlspecificUser);
        this.wspecificUser = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wspecificUser);
        this.wspecificUser.setToolTipText(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.specificUser.Tooltip", (String[])new String[0]));
        this.fdspecificUser = new FormData();
        this.fdspecificUser.left = new FormAttachment(middle, 0);
        this.fdspecificUser.top = new FormAttachment((Control)this.wRepName, margin);
        this.fdspecificUser.right = new FormAttachment(100, 0);
        this.wspecificUser.setLayoutData((Object)this.fdspecificUser);
        this.wspecificUser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntryConnectedToRepositoryDialog.this.jobEntry.setChanged();
                JobEntryConnectedToRepositoryDialog.this.activeSpecUser();
            }
        });
        this.wlUserName = new Label((Composite)this.shell, 131072);
        this.wlUserName.setText(BaseMessages.getString(PKG, (String)"JobEntryConnectedToUserositoryDialog.UserName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUserName);
        this.fdlUserName = new FormData();
        this.fdlUserName.left = new FormAttachment(0, 0);
        this.fdlUserName.right = new FormAttachment(middle, -margin);
        this.fdlUserName.top = new FormAttachment((Control)this.wspecificUser, margin);
        this.wlUserName.setLayoutData((Object)this.fdlUserName);
        this.wUserName = new TextVar((VariableSpace)this.jobMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wUserName);
        this.wUserName.setToolTipText(BaseMessages.getString(PKG, (String)"JobEntryConnectedToUserositoryDialog.UserName.Tooltip", (String[])new String[0]));
        this.wUserName.addModifyListener(lsMod);
        this.fdUserName = new FormData();
        this.fdUserName.left = new FormAttachment(middle, 0);
        this.fdUserName.top = new FormAttachment((Control)this.wspecificUser, margin);
        this.fdUserName.right = new FormAttachment(100, -margin);
        this.wUserName.setLayoutData(this.fdUserName);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wUserName);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntryConnectedToRepositoryDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntryConnectedToRepositoryDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntryConnectedToRepositoryDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryConnectedToRepositoryDialog.this.cancel();
            }
        });
        this.getData();
        this.activeSpecRep();
        this.activeSpecUser();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobSuccessDialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    private void activeSpecRep() {
        this.wlRepName.setEnabled(this.wspecificRep.getSelection());
        this.wRepName.setEnabled(this.wspecificRep.getSelection());
        this.wbRepositoryname.setEnabled(this.wspecificRep.getSelection());
    }

    private void activeSpecUser() {
        this.wlUserName.setEnabled(this.wspecificUser.getSelection());
        this.wUserName.setEnabled(this.wspecificUser.getSelection());
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        if (this.jobEntry.getName() != null) {
            this.wName.setText(this.jobEntry.getName());
        }
        this.wspecificRep.setSelection(this.jobEntry.isSpecificRep());
        if (this.jobEntry.getRepName() != null) {
            this.wRepName.setText(this.jobEntry.getRepName());
        }
        this.wspecificUser.setSelection(this.jobEntry.isSpecificUser());
        if (this.jobEntry.getUserName() != null) {
            this.wUserName.setText(this.jobEntry.getUserName());
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setSpecificRep(this.wspecificRep.getSelection());
        this.jobEntry.setRepName(this.wRepName.getText());
        this.jobEntry.setSpecificUser(this.wspecificUser.getSelection());
        this.jobEntry.setUserName(this.wUserName.getText());
        this.dispose();
    }

    private void displayMsg(String title, String message, boolean error) {
        if (error) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(message + Const.CR);
            mb.setText(title);
            mb.open();
        } else {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(message + Const.CR);
            mb.setText(title);
            mb.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getListRepositories() {
        RepositoriesMeta reps_info = null;
        try {
            reps_info = new RepositoriesMeta();
            try {
                reps_info.readData();
                int nrRepositories = reps_info.nrRepositories();
                if (nrRepositories == 0) {
                    this.displayMsg(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.Error.NoRep.DialogMessage", (String[])new String[0]), true);
                } else {
                    String[] available = new String[nrRepositories];
                    for (int i = 0; i < nrRepositories; ++i) {
                        RepositoryMeta ri = reps_info.getRepository(i);
                        available[i] = ri.getName();
                    }
                    String[] source = new String[]{this.wRepName.getText()};
                    int[] idxSource = Const.indexsOfStrings((String[])source, (String[])available);
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, available, BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.SelectRepository.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.SelectRepository.Message", (String[])new String[0]));
                    dialog.setMulti(false);
                    dialog.setAvoidQuickSearch();
                    dialog.setSelectedNrs(idxSource);
                    if (dialog.open() != null) {
                        int[] idx = dialog.getSelectionIndeces();
                        this.wRepName.setText(available[idx[0]]);
                    }
                }
            }
            catch (Exception e) {
                this.displayMsg(BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.Error.NoRepsDefined", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.Error.NoRepsDefinedMsg", (String[])new String[0]), true);
            }
        }
        catch (Exception e) {
            this.displayMsg(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryConnectedToRepositoryDialog.ErrorGettingRepositories.DialogMessage", (String[])new String[0]) + Const.CR + ":" + e.getMessage(), true);
        }
        finally {
            reps_info.clear();
        }
    }
}

