/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.ping;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.ping.JobEntryPing;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class JobEntryPingDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntryPing.class;
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private Label wlHostname;
    private TextVar wHostname;
    private FormData fdlHostname;
    private FormData fdHostname;
    private Label wlTimeOut;
    private TextVar wTimeOut;
    private FormData fdlTimeOut;
    private FormData fdTimeOut;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private JobEntryPing jobEntry;
    private Shell shell;
    private SelectionAdapter lsDef;
    private Label wlPingType;
    private CCombo wPingType;
    private FormData fdlPingType;
    private FormData fdPingType;
    private Label wlNbrPackets;
    private TextVar wNbrPackets;
    private FormData fdNbrPackets;
    private FormData fdlNbrPackets;
    private boolean changed;

    public JobEntryPingDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryPing)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobPing.Name.Default", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryPingDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobPing.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlName = new Label((Composite)this.shell, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"JobPing.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.right = new FormAttachment(middle, -margin);
        this.fdlName.top = new FormAttachment(0, margin);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, 0);
        this.fdName.top = new FormAttachment(0, margin);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        this.wlHostname = new Label((Composite)this.shell, 131072);
        this.wlHostname.setText(BaseMessages.getString(PKG, (String)"JobPing.Hostname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlHostname);
        this.fdlHostname = new FormData();
        this.fdlHostname.left = new FormAttachment(0, 0);
        this.fdlHostname.top = new FormAttachment((Control)this.wName, margin);
        this.fdlHostname.right = new FormAttachment(middle, 0);
        this.wlHostname.setLayoutData((Object)this.fdlHostname);
        this.wHostname = new TextVar((VariableSpace)this.jobMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wHostname);
        this.wHostname.addModifyListener(lsMod);
        this.fdHostname = new FormData();
        this.fdHostname.left = new FormAttachment(middle, 0);
        this.fdHostname.top = new FormAttachment((Control)this.wName, margin);
        this.fdHostname.right = new FormAttachment(100, 0);
        this.wHostname.setLayoutData(this.fdHostname);
        this.wHostname.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryPingDialog.this.wHostname.setToolTipText(JobEntryPingDialog.this.jobMeta.environmentSubstitute(JobEntryPingDialog.this.wHostname.getText()));
            }
        });
        this.wlPingType = new Label((Composite)this.shell, 131072);
        this.wlPingType.setText(BaseMessages.getString(PKG, (String)"JobPing.PingType.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPingType);
        this.fdlPingType = new FormData();
        this.fdlPingType.left = new FormAttachment(0, 0);
        this.fdlPingType.right = new FormAttachment(middle, 0);
        this.fdlPingType.top = new FormAttachment((Control)this.wHostname, margin);
        this.wlPingType.setLayoutData((Object)this.fdlPingType);
        this.wPingType = new CCombo((Composite)this.shell, 2060);
        this.wPingType.add(BaseMessages.getString(PKG, (String)"JobPing.ClassicPing.Label", (String[])new String[0]));
        this.wPingType.add(BaseMessages.getString(PKG, (String)"JobPing.SystemPing.Label", (String[])new String[0]));
        this.wPingType.add(BaseMessages.getString(PKG, (String)"JobPing.BothPings.Label", (String[])new String[0]));
        this.wPingType.select(1);
        this.props.setLook((Control)this.wPingType);
        this.fdPingType = new FormData();
        this.fdPingType.left = new FormAttachment(middle, 0);
        this.fdPingType.top = new FormAttachment((Control)this.wHostname, margin);
        this.fdPingType.right = new FormAttachment(100, 0);
        this.wPingType.setLayoutData((Object)this.fdPingType);
        this.wPingType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntryPingDialog.this.setPingType();
                JobEntryPingDialog.this.jobEntry.setChanged();
            }
        });
        this.wlTimeOut = new Label((Composite)this.shell, 131072);
        this.wlTimeOut.setText(BaseMessages.getString(PKG, (String)"JobPing.TimeOut.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTimeOut);
        this.fdlTimeOut = new FormData();
        this.fdlTimeOut.left = new FormAttachment(0, 0);
        this.fdlTimeOut.right = new FormAttachment(middle, 0);
        this.fdlTimeOut.top = new FormAttachment((Control)this.wPingType, margin);
        this.wlTimeOut.setLayoutData((Object)this.fdlTimeOut);
        this.wTimeOut = new TextVar((VariableSpace)this.jobMeta, (Composite)this.shell, 18436);
        this.wlTimeOut.setToolTipText(BaseMessages.getString(PKG, (String)"JobPing.TimeOut.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTimeOut);
        this.wTimeOut.addModifyListener(lsMod);
        this.fdTimeOut = new FormData();
        this.fdTimeOut.left = new FormAttachment(middle, 0);
        this.fdTimeOut.top = new FormAttachment((Control)this.wPingType, margin);
        this.fdTimeOut.right = new FormAttachment(100, 0);
        this.wTimeOut.setLayoutData(this.fdTimeOut);
        this.wlNbrPackets = new Label((Composite)this.shell, 131072);
        this.wlNbrPackets.setText(BaseMessages.getString(PKG, (String)"JobPing.NrPackets.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlNbrPackets);
        this.fdlNbrPackets = new FormData();
        this.fdlNbrPackets.left = new FormAttachment(0, 0);
        this.fdlNbrPackets.right = new FormAttachment(middle, 0);
        this.fdlNbrPackets.top = new FormAttachment((Control)this.wTimeOut, margin);
        this.wlNbrPackets.setLayoutData((Object)this.fdlNbrPackets);
        this.wNbrPackets = new TextVar((VariableSpace)this.jobMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wNbrPackets);
        this.wNbrPackets.addModifyListener(lsMod);
        this.fdNbrPackets = new FormData();
        this.fdNbrPackets.left = new FormAttachment(middle, 0);
        this.fdNbrPackets.top = new FormAttachment((Control)this.wTimeOut, margin);
        this.fdNbrPackets.right = new FormAttachment(100, 0);
        this.wNbrPackets.setLayoutData(this.fdNbrPackets);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fd = new FormData();
        fd.right = new FormAttachment(50, -10);
        fd.bottom = new FormAttachment(100, 0);
        fd.width = 100;
        this.wOK.setLayoutData((Object)fd);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(50, 10);
        fd.bottom = new FormAttachment(100, 0);
        fd.width = 100;
        this.wCancel.setLayoutData((Object)fd);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntryPingDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntryPingDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntryPingDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.wHostname.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryPingDialog.this.cancel();
            }
        });
        this.getData();
        this.setPingType();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobPingDialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    private void setPingType() {
        this.wlTimeOut.setEnabled(this.wPingType.getSelectionIndex() == this.jobEntry.isystemPing || this.wPingType.getSelectionIndex() == this.jobEntry.ibothPings);
        this.wTimeOut.setEnabled(this.wPingType.getSelectionIndex() == this.jobEntry.isystemPing || this.wPingType.getSelectionIndex() == this.jobEntry.ibothPings);
        this.wlNbrPackets.setEnabled(this.wPingType.getSelectionIndex() == this.jobEntry.iclassicPing || this.wPingType.getSelectionIndex() == this.jobEntry.ibothPings);
        this.wNbrPackets.setEnabled(this.wPingType.getSelectionIndex() == this.jobEntry.iclassicPing || this.wPingType.getSelectionIndex() == this.jobEntry.ibothPings);
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.jobEntry.getName()));
        if (this.jobEntry.getHostname() != null) {
            this.wHostname.setText(this.jobEntry.getHostname());
        }
        if (this.jobEntry.getNbrPackets() != null) {
            this.wNbrPackets.setText(this.jobEntry.getNbrPackets());
        } else {
            this.wNbrPackets.setText("2");
        }
        if (this.jobEntry.getTimeOut() != null) {
            this.wTimeOut.setText(this.jobEntry.getTimeOut());
        } else {
            this.wTimeOut.setText("3000");
        }
        this.wPingType.select(this.jobEntry.ipingtype);
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setHostname(this.wHostname.getText());
        this.jobEntry.setNbrPackets(this.wNbrPackets.getText());
        this.jobEntry.setTimeOut(this.wTimeOut.getText());
        this.jobEntry.ipingtype = this.wPingType.getSelectionIndex();
        this.jobEntry.pingtype = this.wPingType.getSelectionIndex() == this.jobEntry.isystemPing ? this.jobEntry.systemPing : (this.wPingType.getSelectionIndex() == this.jobEntry.ibothPings ? this.jobEntry.bothPings : this.jobEntry.classicPing);
        this.dispose();
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }
}

