/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.sftp;

import java.net.InetAddress;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.sftp.JobEntrySFTP;
import org.pentaho.di.job.entries.sftp.SFTPClient;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.LabelTextVar;
import org.pentaho.di.ui.core.widget.PasswordTextVar;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class JobEntrySFTPDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntrySFTP.class;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"JobSFTP.Filetype.Pem", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSFTP.Filetype.All", (String[])new String[0])};
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private Label wlServerName;
    private TextVar wServerName;
    private FormData fdlServerName;
    private FormData fdServerName;
    private Label wlServerPort;
    private TextVar wServerPort;
    private FormData fdlServerPort;
    private FormData fdServerPort;
    private Label wlUserName;
    private TextVar wUserName;
    private FormData fdlUserName;
    private FormData fdUserName;
    private Label wlPassword;
    private TextVar wPassword;
    private FormData fdlPassword;
    private FormData fdPassword;
    private Label wlScpDirectory;
    private TextVar wScpDirectory;
    private FormData fdlScpDirectory;
    private FormData fdScpDirectory;
    private Label wlTargetDirectory;
    private TextVar wTargetDirectory;
    private FormData fdlTargetDirectory;
    private FormData fdTargetDirectory;
    private Label wlWildcard;
    private TextVar wWildcard;
    private FormData fdlWildcard;
    private FormData fdWildcard;
    private Label wlRemove;
    private Button wRemove;
    private FormData fdlRemove;
    private FormData fdRemove;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Listener lsCheckChangeFolder;
    private JobEntrySFTP jobEntry;
    private Shell shell;
    private SelectionAdapter lsDef;
    private boolean changed;
    private Button wTest;
    private FormData fdTest;
    private Listener lsTest;
    private Button wbTestChangeFolderExists;
    private FormData fdbTestChangeFolderExists;
    private Button wbTargetDirectory;
    private FormData fdbTargetDirectory;
    private Group wServerSettings;
    private FormData fdServerSettings;
    private Group wSourceFiles;
    private FormData fdSourceFiles;
    private Group wTargetFiles;
    private FormData fdTargetFiles;
    private Label wlAddFilenameToResult;
    private Button wAddFilenameToResult;
    private FormData fdlAddFilenameToResult;
    private FormData fdAddFilenameToResult;
    private Label wlCreateTargetFolder;
    private Button wCreateTargetFolder;
    private FormData fdlCreateTargetFolder;
    private FormData fdCreateTargetFolder;
    private Label wlgetPrevious;
    private Button wgetPrevious;
    private FormData fdlgetPrevious;
    private FormData fdgetPrevious;
    private LabelTextVar wkeyfilePass;
    private FormData fdkeyfilePass;
    private Label wlusePublicKey;
    private Button wusePublicKey;
    private FormData fdlusePublicKey;
    private FormData fdusePublicKey;
    private Label wlKeyFilename;
    private Button wbKeyFilename;
    private TextVar wKeyFilename;
    private FormData fdlKeyFilename;
    private FormData fdbKeyFilename;
    private FormData fdKeyFilename;
    private CTabFolder wTabFolder;
    private Composite wGeneralComp;
    private Composite wFilesComp;
    private CTabItem wGeneralTab;
    private CTabItem wFilesTab;
    private FormData fdGeneralComp;
    private FormData fdFilesComp;
    private FormData fdTabFolder;
    private SFTPClient sftpclient = null;
    private Label wlCompression;
    private FormData fdlCompression;
    private CCombo wCompression;
    private FormData fdCompression;
    private Label wlProxyType;
    private FormData fdlProxyType;
    private CCombo wProxyType;
    private FormData fdProxyType;
    private LabelTextVar wProxyHost;
    private FormData fdProxyHost;
    private LabelTextVar wProxyPort;
    private FormData fdProxyPort;
    private LabelTextVar wProxyUsername;
    private FormData fdProxyUsername;
    private LabelTextVar wProxyPassword;
    private FormData fdProxyPasswd;

    public JobEntrySFTPDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntrySFTP)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobSFTP.Name.Default", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntrySFTPDialog.this.sftpclient = null;
                JobEntrySFTPDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobSFTP.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlName = new Label((Composite)this.shell, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"JobSFTP.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.right = new FormAttachment(middle, -margin);
        this.fdlName.top = new FormAttachment(0, margin);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, 0);
        this.fdName.top = new FormAttachment(0, margin);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wGeneralTab = new CTabItem(this.wTabFolder, 0);
        this.wGeneralTab.setText(BaseMessages.getString(PKG, (String)"JobSFTP.Tab.General.Label", (String[])new String[0]));
        this.wGeneralComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        this.wGeneralComp.setLayout((Layout)generalLayout);
        this.wServerSettings = new Group(this.wGeneralComp, 32);
        this.props.setLook((Control)this.wServerSettings);
        this.wServerSettings.setText(BaseMessages.getString(PKG, (String)"JobSFTP.ServerSettings.Group.Label", (String[])new String[0]));
        FormLayout ServerSettingsgroupLayout = new FormLayout();
        ServerSettingsgroupLayout.marginWidth = 10;
        ServerSettingsgroupLayout.marginHeight = 10;
        this.wServerSettings.setLayout((Layout)ServerSettingsgroupLayout);
        this.wlServerName = new Label((Composite)this.wServerSettings, 131072);
        this.wlServerName.setText(BaseMessages.getString(PKG, (String)"JobSFTP.Server.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlServerName);
        this.fdlServerName = new FormData();
        this.fdlServerName.left = new FormAttachment(0, 0);
        this.fdlServerName.top = new FormAttachment((Control)this.wName, margin);
        this.fdlServerName.right = new FormAttachment(middle, -margin);
        this.wlServerName.setLayoutData((Object)this.fdlServerName);
        this.wServerName = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, 18436);
        this.props.setLook((Control)this.wServerName);
        this.wServerName.addModifyListener(lsMod);
        this.fdServerName = new FormData();
        this.fdServerName.left = new FormAttachment(middle, 0);
        this.fdServerName.top = new FormAttachment((Control)this.wName, margin);
        this.fdServerName.right = new FormAttachment(100, 0);
        this.wServerName.setLayoutData(this.fdServerName);
        this.wlServerPort = new Label((Composite)this.wServerSettings, 131072);
        this.wlServerPort.setText(BaseMessages.getString(PKG, (String)"JobSFTP.Port.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlServerPort);
        this.fdlServerPort = new FormData();
        this.fdlServerPort.left = new FormAttachment(0, 0);
        this.fdlServerPort.top = new FormAttachment((Control)this.wServerName, margin);
        this.fdlServerPort.right = new FormAttachment(middle, -margin);
        this.wlServerPort.setLayoutData((Object)this.fdlServerPort);
        this.wServerPort = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, 18436);
        this.props.setLook((Control)this.wServerPort);
        this.wServerPort.setToolTipText(BaseMessages.getString(PKG, (String)"JobSFTP.Port.Tooltip", (String[])new String[0]));
        this.wServerPort.addModifyListener(lsMod);
        this.fdServerPort = new FormData();
        this.fdServerPort.left = new FormAttachment(middle, 0);
        this.fdServerPort.top = new FormAttachment((Control)this.wServerName, margin);
        this.fdServerPort.right = new FormAttachment(100, 0);
        this.wServerPort.setLayoutData(this.fdServerPort);
        this.wlUserName = new Label((Composite)this.wServerSettings, 131072);
        this.wlUserName.setText(BaseMessages.getString(PKG, (String)"JobSFTP.Username.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUserName);
        this.fdlUserName = new FormData();
        this.fdlUserName.left = new FormAttachment(0, 0);
        this.fdlUserName.top = new FormAttachment((Control)this.wServerPort, margin);
        this.fdlUserName.right = new FormAttachment(middle, -margin);
        this.wlUserName.setLayoutData((Object)this.fdlUserName);
        this.wUserName = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, 18436);
        this.props.setLook((Control)this.wUserName);
        this.wUserName.addModifyListener(lsMod);
        this.fdUserName = new FormData();
        this.fdUserName.left = new FormAttachment(middle, 0);
        this.fdUserName.top = new FormAttachment((Control)this.wServerPort, margin);
        this.fdUserName.right = new FormAttachment(100, 0);
        this.wUserName.setLayoutData(this.fdUserName);
        this.wlPassword = new Label((Composite)this.wServerSettings, 131072);
        this.wlPassword.setText(BaseMessages.getString(PKG, (String)"JobSFTP.Password.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPassword);
        this.fdlPassword = new FormData();
        this.fdlPassword.left = new FormAttachment(0, 0);
        this.fdlPassword.top = new FormAttachment((Control)this.wUserName, margin);
        this.fdlPassword.right = new FormAttachment(middle, -margin);
        this.wlPassword.setLayoutData((Object)this.fdlPassword);
        this.wPassword = new PasswordTextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, 18436);
        this.props.setLook((Control)this.wPassword);
        this.wPassword.addModifyListener(lsMod);
        this.fdPassword = new FormData();
        this.fdPassword.left = new FormAttachment(middle, 0);
        this.fdPassword.top = new FormAttachment((Control)this.wUserName, margin);
        this.fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData(this.fdPassword);
        this.wlusePublicKey = new Label((Composite)this.wServerSettings, 131072);
        this.wlusePublicKey.setText(BaseMessages.getString(PKG, (String)"JobSFTP.useKeyFile.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlusePublicKey);
        this.fdlusePublicKey = new FormData();
        this.fdlusePublicKey.left = new FormAttachment(0, 0);
        this.fdlusePublicKey.top = new FormAttachment((Control)this.wPassword, margin);
        this.fdlusePublicKey.right = new FormAttachment(middle, -margin);
        this.wlusePublicKey.setLayoutData((Object)this.fdlusePublicKey);
        this.wusePublicKey = new Button((Composite)this.wServerSettings, 32);
        this.wusePublicKey.setToolTipText(BaseMessages.getString(PKG, (String)"JobSFTP.useKeyFile.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wusePublicKey);
        this.fdusePublicKey = new FormData();
        this.fdusePublicKey.left = new FormAttachment(middle, 0);
        this.fdusePublicKey.top = new FormAttachment((Control)this.wPassword, margin);
        this.fdusePublicKey.right = new FormAttachment(100, 0);
        this.wusePublicKey.setLayoutData((Object)this.fdusePublicKey);
        this.wusePublicKey.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntrySFTPDialog.this.activeUseKey();
                JobEntrySFTPDialog.this.jobEntry.setChanged();
            }
        });
        this.wlKeyFilename = new Label((Composite)this.wServerSettings, 131072);
        this.wlKeyFilename.setText(BaseMessages.getString(PKG, (String)"JobSFTP.KeyFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlKeyFilename);
        this.fdlKeyFilename = new FormData();
        this.fdlKeyFilename.left = new FormAttachment(0, 0);
        this.fdlKeyFilename.top = new FormAttachment((Control)this.wusePublicKey, margin);
        this.fdlKeyFilename.right = new FormAttachment(middle, -margin);
        this.wlKeyFilename.setLayoutData((Object)this.fdlKeyFilename);
        this.wbKeyFilename = new Button((Composite)this.wServerSettings, 0x1000008);
        this.props.setLook((Control)this.wbKeyFilename);
        this.wbKeyFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbKeyFilename = new FormData();
        this.fdbKeyFilename.right = new FormAttachment(100, 0);
        this.fdbKeyFilename.top = new FormAttachment((Control)this.wusePublicKey, 0);
        this.wbKeyFilename.setLayoutData((Object)this.fdbKeyFilename);
        this.wKeyFilename = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, 18436);
        this.wKeyFilename.setToolTipText(BaseMessages.getString(PKG, (String)"JobSFTP.KeyFilename.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wKeyFilename);
        this.wKeyFilename.addModifyListener(lsMod);
        this.fdKeyFilename = new FormData();
        this.fdKeyFilename.left = new FormAttachment(middle, 0);
        this.fdKeyFilename.top = new FormAttachment((Control)this.wusePublicKey, margin);
        this.fdKeyFilename.right = new FormAttachment((Control)this.wbKeyFilename, -margin);
        this.wKeyFilename.setLayoutData(this.fdKeyFilename);
        this.wbKeyFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(JobEntrySFTPDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*.pem", "*"});
                if (JobEntrySFTPDialog.this.wKeyFilename.getText() != null) {
                    dialog.setFileName(JobEntrySFTPDialog.this.jobMeta.environmentSubstitute(JobEntrySFTPDialog.this.wKeyFilename.getText()));
                }
                dialog.setFilterNames(FILETYPES);
                if (dialog.open() != null) {
                    JobEntrySFTPDialog.this.wKeyFilename.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        this.wkeyfilePass = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, BaseMessages.getString(PKG, (String)"JobSFTP.keyfilePass.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSFTP.keyfilePass.Tooltip", (String[])new String[0]), true);
        this.props.setLook((Control)this.wkeyfilePass);
        this.wkeyfilePass.addModifyListener(lsMod);
        this.fdkeyfilePass = new FormData();
        this.fdkeyfilePass.left = new FormAttachment(0, -2 * margin);
        this.fdkeyfilePass.top = new FormAttachment((Control)this.wKeyFilename, margin);
        this.fdkeyfilePass.right = new FormAttachment(100, 0);
        this.wkeyfilePass.setLayoutData(this.fdkeyfilePass);
        this.wlProxyType = new Label((Composite)this.wServerSettings, 131072);
        this.wlProxyType.setText(BaseMessages.getString(PKG, (String)"JobSFTP.ProxyType.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlProxyType);
        this.fdlProxyType = new FormData();
        this.fdlProxyType.left = new FormAttachment(0, 0);
        this.fdlProxyType.right = new FormAttachment(middle, -margin);
        this.fdlProxyType.top = new FormAttachment((Control)this.wkeyfilePass, 2 * margin);
        this.wlProxyType.setLayoutData((Object)this.fdlProxyType);
        this.wProxyType = new CCombo((Composite)this.wServerSettings, 2060);
        this.wProxyType.add("HTTP");
        this.wProxyType.add("SOCKS5");
        this.wProxyType.select(0);
        this.props.setLook((Control)this.wProxyType);
        this.fdProxyType = new FormData();
        this.fdProxyType.left = new FormAttachment(middle, 0);
        this.fdProxyType.top = new FormAttachment((Control)this.wkeyfilePass, 2 * margin);
        this.fdProxyType.right = new FormAttachment(100, 0);
        this.wProxyType.setLayoutData((Object)this.fdProxyType);
        this.wProxyType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntrySFTPDialog.this.setDefaulProxyPort();
            }
        });
        this.wProxyHost = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, BaseMessages.getString(PKG, (String)"JobSFTP.ProxyHost.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSFTP.ProxyHost.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyHost);
        this.wProxyHost.addModifyListener(lsMod);
        this.fdProxyHost = new FormData();
        this.fdProxyHost.left = new FormAttachment(0, -2 * margin);
        this.fdProxyHost.top = new FormAttachment((Control)this.wProxyType, margin);
        this.fdProxyHost.right = new FormAttachment(100, 0);
        this.wProxyHost.setLayoutData(this.fdProxyHost);
        this.wProxyPort = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, BaseMessages.getString(PKG, (String)"JobSFTP.ProxyPort.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSFTP.ProxyPort.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyPort);
        this.wProxyPort.addModifyListener(lsMod);
        this.fdProxyPort = new FormData();
        this.fdProxyPort.left = new FormAttachment(0, -2 * margin);
        this.fdProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        this.fdProxyPort.right = new FormAttachment(100, 0);
        this.wProxyPort.setLayoutData(this.fdProxyPort);
        this.wProxyUsername = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, BaseMessages.getString(PKG, (String)"JobSFTP.ProxyUsername.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSFTP.ProxyUsername.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyUsername);
        this.wProxyUsername.addModifyListener(lsMod);
        this.fdProxyUsername = new FormData();
        this.fdProxyUsername.left = new FormAttachment(0, -2 * margin);
        this.fdProxyUsername.top = new FormAttachment((Control)this.wProxyPort, margin);
        this.fdProxyUsername.right = new FormAttachment(100, 0);
        this.wProxyUsername.setLayoutData(this.fdProxyUsername);
        this.wProxyPassword = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, BaseMessages.getString(PKG, (String)"JobSFTP.ProxyPassword.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSFTP.ProxyPassword.Tooltip", (String[])new String[0]), true);
        this.props.setLook((Control)this.wProxyPassword);
        this.wProxyPassword.addModifyListener(lsMod);
        this.fdProxyPasswd = new FormData();
        this.fdProxyPasswd.left = new FormAttachment(0, -2 * margin);
        this.fdProxyPasswd.top = new FormAttachment((Control)this.wProxyUsername, margin);
        this.fdProxyPasswd.right = new FormAttachment(100, 0);
        this.wProxyPassword.setLayoutData(this.fdProxyPasswd);
        this.wTest = new Button((Composite)this.wServerSettings, 8);
        this.wTest.setText(BaseMessages.getString(PKG, (String)"JobSFTP.TestConnection.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wTest);
        this.fdTest = new FormData();
        this.wTest.setToolTipText(BaseMessages.getString(PKG, (String)"JobSFTP.TestConnection.Tooltip", (String[])new String[0]));
        this.fdTest.top = new FormAttachment((Control)this.wProxyPassword, margin);
        this.fdTest.right = new FormAttachment(100, 0);
        this.wTest.setLayoutData((Object)this.fdTest);
        this.fdServerSettings = new FormData();
        this.fdServerSettings.left = new FormAttachment(0, margin);
        this.fdServerSettings.top = new FormAttachment((Control)this.wName, margin);
        this.fdServerSettings.right = new FormAttachment(100, -margin);
        this.wServerSettings.setLayoutData((Object)this.fdServerSettings);
        this.wlCompression = new Label(this.wGeneralComp, 131072);
        this.wlCompression.setText(BaseMessages.getString(PKG, (String)"JobSFTP.Compression.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCompression);
        this.fdlCompression = new FormData();
        this.fdlCompression.left = new FormAttachment(0, -margin);
        this.fdlCompression.right = new FormAttachment(middle, 0);
        this.fdlCompression.top = new FormAttachment((Control)this.wServerSettings, margin);
        this.wlCompression.setLayoutData((Object)this.fdlCompression);
        this.wCompression = new CCombo(this.wGeneralComp, 2060);
        this.wCompression.add("none");
        this.wCompression.add("zlib");
        this.wCompression.select(0);
        this.props.setLook((Control)this.wCompression);
        this.fdCompression = new FormData();
        this.fdCompression.left = new FormAttachment(middle, margin);
        this.fdCompression.top = new FormAttachment((Control)this.wServerSettings, margin);
        this.fdCompression.right = new FormAttachment(100, 0);
        this.wCompression.setLayoutData((Object)this.fdCompression);
        this.fdGeneralComp = new FormData();
        this.fdGeneralComp.left = new FormAttachment(0, 0);
        this.fdGeneralComp.top = new FormAttachment(0, 0);
        this.fdGeneralComp.right = new FormAttachment(100, 0);
        this.fdGeneralComp.bottom = new FormAttachment(100, 0);
        this.wGeneralComp.setLayoutData((Object)this.fdGeneralComp);
        this.wGeneralComp.layout();
        this.wGeneralTab.setControl((Control)this.wGeneralComp);
        this.props.setLook((Control)this.wGeneralComp);
        this.wFilesTab = new CTabItem(this.wTabFolder, 0);
        this.wFilesTab.setText(BaseMessages.getString(PKG, (String)"JobSFTP.Tab.Files.Label", (String[])new String[0]));
        this.wFilesComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wFilesComp);
        FormLayout FilesLayout = new FormLayout();
        FilesLayout.marginWidth = 3;
        FilesLayout.marginHeight = 3;
        this.wFilesComp.setLayout((Layout)FilesLayout);
        this.wSourceFiles = new Group(this.wFilesComp, 32);
        this.props.setLook((Control)this.wSourceFiles);
        this.wSourceFiles.setText(BaseMessages.getString(PKG, (String)"JobSFTP.SourceFiles.Group.Label", (String[])new String[0]));
        FormLayout SourceFilesgroupLayout = new FormLayout();
        SourceFilesgroupLayout.marginWidth = 10;
        SourceFilesgroupLayout.marginHeight = 10;
        this.wSourceFiles.setLayout((Layout)SourceFilesgroupLayout);
        this.wlgetPrevious = new Label((Composite)this.wSourceFiles, 131072);
        this.wlgetPrevious.setText(BaseMessages.getString(PKG, (String)"JobSFTP.getPrevious.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlgetPrevious);
        this.fdlgetPrevious = new FormData();
        this.fdlgetPrevious.left = new FormAttachment(0, 0);
        this.fdlgetPrevious.top = new FormAttachment((Control)this.wServerSettings, 2 * margin);
        this.fdlgetPrevious.right = new FormAttachment(middle, -margin);
        this.wlgetPrevious.setLayoutData((Object)this.fdlgetPrevious);
        this.wgetPrevious = new Button((Composite)this.wSourceFiles, 32);
        this.props.setLook((Control)this.wgetPrevious);
        this.wgetPrevious.setToolTipText(BaseMessages.getString(PKG, (String)"JobSFTP.getPrevious.Tooltip", (String[])new String[0]));
        this.fdgetPrevious = new FormData();
        this.fdgetPrevious.left = new FormAttachment(middle, 0);
        this.fdgetPrevious.top = new FormAttachment((Control)this.wServerSettings, 2 * margin);
        this.fdgetPrevious.right = new FormAttachment(100, 0);
        this.wgetPrevious.setLayoutData((Object)this.fdgetPrevious);
        this.wgetPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntrySFTPDialog.this.activeCopyFromPrevious();
                JobEntrySFTPDialog.this.jobEntry.setChanged();
            }
        });
        this.wlScpDirectory = new Label((Composite)this.wSourceFiles, 131072);
        this.wlScpDirectory.setText(BaseMessages.getString(PKG, (String)"JobSFTP.RemoteDir.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlScpDirectory);
        this.fdlScpDirectory = new FormData();
        this.fdlScpDirectory.left = new FormAttachment(0, 0);
        this.fdlScpDirectory.top = new FormAttachment((Control)this.wgetPrevious, 2 * margin);
        this.fdlScpDirectory.right = new FormAttachment(middle, -margin);
        this.wlScpDirectory.setLayoutData((Object)this.fdlScpDirectory);
        this.wbTestChangeFolderExists = new Button((Composite)this.wSourceFiles, 0x1000008);
        this.props.setLook((Control)this.wbTestChangeFolderExists);
        this.wbTestChangeFolderExists.setText(BaseMessages.getString(PKG, (String)"JobSFTP.TestFolderExists.Label", (String[])new String[0]));
        this.fdbTestChangeFolderExists = new FormData();
        this.fdbTestChangeFolderExists.right = new FormAttachment(100, 0);
        this.fdbTestChangeFolderExists.top = new FormAttachment((Control)this.wgetPrevious, 2 * margin);
        this.wbTestChangeFolderExists.setLayoutData((Object)this.fdbTestChangeFolderExists);
        this.wScpDirectory = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wSourceFiles, 18436, BaseMessages.getString(PKG, (String)"JobSFTP.RemoteDir.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wScpDirectory);
        this.wScpDirectory.addModifyListener(lsMod);
        this.fdScpDirectory = new FormData();
        this.fdScpDirectory.left = new FormAttachment(middle, 0);
        this.fdScpDirectory.top = new FormAttachment((Control)this.wgetPrevious, 2 * margin);
        this.fdScpDirectory.right = new FormAttachment((Control)this.wbTestChangeFolderExists, -margin);
        this.wScpDirectory.setLayoutData(this.fdScpDirectory);
        this.wlWildcard = new Label((Composite)this.wSourceFiles, 131072);
        this.wlWildcard.setText(BaseMessages.getString(PKG, (String)"JobSFTP.Wildcard.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlWildcard);
        this.fdlWildcard = new FormData();
        this.fdlWildcard.left = new FormAttachment(0, 0);
        this.fdlWildcard.top = new FormAttachment((Control)this.wScpDirectory, margin);
        this.fdlWildcard.right = new FormAttachment(middle, -margin);
        this.wlWildcard.setLayoutData((Object)this.fdlWildcard);
        this.wWildcard = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wSourceFiles, 18436, BaseMessages.getString(PKG, (String)"JobSFTP.Wildcard.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wWildcard);
        this.wWildcard.addModifyListener(lsMod);
        this.fdWildcard = new FormData();
        this.fdWildcard.left = new FormAttachment(middle, 0);
        this.fdWildcard.top = new FormAttachment((Control)this.wScpDirectory, margin);
        this.fdWildcard.right = new FormAttachment(100, 0);
        this.wWildcard.setLayoutData(this.fdWildcard);
        this.wlRemove = new Label((Composite)this.wSourceFiles, 131072);
        this.wlRemove.setText(BaseMessages.getString(PKG, (String)"JobSFTP.RemoveFiles.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlRemove);
        this.fdlRemove = new FormData();
        this.fdlRemove.left = new FormAttachment(0, 0);
        this.fdlRemove.top = new FormAttachment((Control)this.wWildcard, margin);
        this.fdlRemove.right = new FormAttachment(middle, -margin);
        this.wlRemove.setLayoutData((Object)this.fdlRemove);
        this.wRemove = new Button((Composite)this.wSourceFiles, 32);
        this.props.setLook((Control)this.wRemove);
        this.wRemove.setToolTipText(BaseMessages.getString(PKG, (String)"JobSFTP.RemoveFiles.Tooltip", (String[])new String[0]));
        this.fdRemove = new FormData();
        this.fdRemove.left = new FormAttachment(middle, 0);
        this.fdRemove.top = new FormAttachment((Control)this.wWildcard, margin);
        this.fdRemove.right = new FormAttachment(100, 0);
        this.wRemove.setLayoutData((Object)this.fdRemove);
        this.fdSourceFiles = new FormData();
        this.fdSourceFiles.left = new FormAttachment(0, margin);
        this.fdSourceFiles.top = new FormAttachment((Control)this.wServerSettings, 2 * margin);
        this.fdSourceFiles.right = new FormAttachment(100, -margin);
        this.wSourceFiles.setLayoutData((Object)this.fdSourceFiles);
        this.wTargetFiles = new Group(this.wFilesComp, 32);
        this.props.setLook((Control)this.wTargetFiles);
        this.wTargetFiles.setText(BaseMessages.getString(PKG, (String)"JobSFTP.TargetFiles.Group.Label", (String[])new String[0]));
        FormLayout TargetFilesgroupLayout = new FormLayout();
        TargetFilesgroupLayout.marginWidth = 10;
        TargetFilesgroupLayout.marginHeight = 10;
        this.wTargetFiles.setLayout((Layout)TargetFilesgroupLayout);
        this.wlTargetDirectory = new Label((Composite)this.wTargetFiles, 131072);
        this.wlTargetDirectory.setText(BaseMessages.getString(PKG, (String)"JobSFTP.TargetDir.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTargetDirectory);
        this.fdlTargetDirectory = new FormData();
        this.fdlTargetDirectory.left = new FormAttachment(0, 0);
        this.fdlTargetDirectory.top = new FormAttachment((Control)this.wSourceFiles, margin);
        this.fdlTargetDirectory.right = new FormAttachment(middle, -margin);
        this.wlTargetDirectory.setLayoutData((Object)this.fdlTargetDirectory);
        this.wbTargetDirectory = new Button((Composite)this.wTargetFiles, 0x1000008);
        this.props.setLook((Control)this.wbTargetDirectory);
        this.wbTargetDirectory.setText(BaseMessages.getString(PKG, (String)"JobSFTP.BrowseFolders.Label", (String[])new String[0]));
        this.fdbTargetDirectory = new FormData();
        this.fdbTargetDirectory.right = new FormAttachment(100, 0);
        this.fdbTargetDirectory.top = new FormAttachment((Control)this.wSourceFiles, margin);
        this.wbTargetDirectory.setLayoutData((Object)this.fdbTargetDirectory);
        this.wbTargetDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir;
                DirectoryDialog ddialog = new DirectoryDialog(JobEntrySFTPDialog.this.shell, 4096);
                if (JobEntrySFTPDialog.this.wTargetDirectory.getText() != null) {
                    ddialog.setFilterPath(JobEntrySFTPDialog.this.jobMeta.environmentSubstitute(JobEntrySFTPDialog.this.wTargetDirectory.getText()));
                }
                if ((dir = ddialog.open()) != null) {
                    JobEntrySFTPDialog.this.wTargetDirectory.setText(dir);
                }
            }
        });
        this.wTargetDirectory = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wTargetFiles, 18436, BaseMessages.getString(PKG, (String)"JobSFTP.TargetDir.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTargetDirectory);
        this.wTargetDirectory.addModifyListener(lsMod);
        this.fdTargetDirectory = new FormData();
        this.fdTargetDirectory.left = new FormAttachment(middle, 0);
        this.fdTargetDirectory.top = new FormAttachment((Control)this.wSourceFiles, margin);
        this.fdTargetDirectory.right = new FormAttachment((Control)this.wbTargetDirectory, -margin);
        this.wTargetDirectory.setLayoutData(this.fdTargetDirectory);
        this.wlCreateTargetFolder = new Label((Composite)this.wTargetFiles, 131072);
        this.wlCreateTargetFolder.setText(BaseMessages.getString(PKG, (String)"JobSFTP.CreateTargetFolder.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCreateTargetFolder);
        this.fdlCreateTargetFolder = new FormData();
        this.fdlCreateTargetFolder.left = new FormAttachment(0, 0);
        this.fdlCreateTargetFolder.top = new FormAttachment((Control)this.wTargetDirectory, margin);
        this.fdlCreateTargetFolder.right = new FormAttachment(middle, -margin);
        this.wlCreateTargetFolder.setLayoutData((Object)this.fdlCreateTargetFolder);
        this.wCreateTargetFolder = new Button((Composite)this.wTargetFiles, 32);
        this.wCreateTargetFolder.setToolTipText(BaseMessages.getString(PKG, (String)"JobSFTP.CreateTargetFolder.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCreateTargetFolder);
        this.fdCreateTargetFolder = new FormData();
        this.fdCreateTargetFolder.left = new FormAttachment(middle, 0);
        this.fdCreateTargetFolder.top = new FormAttachment((Control)this.wTargetDirectory, margin);
        this.fdCreateTargetFolder.right = new FormAttachment(100, 0);
        this.wCreateTargetFolder.setLayoutData((Object)this.fdCreateTargetFolder);
        this.wlAddFilenameToResult = new Label((Composite)this.wTargetFiles, 131072);
        this.wlAddFilenameToResult.setText(BaseMessages.getString(PKG, (String)"JobSFTP.AddfilenametoResult.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddFilenameToResult);
        this.fdlAddFilenameToResult = new FormData();
        this.fdlAddFilenameToResult.left = new FormAttachment(0, 0);
        this.fdlAddFilenameToResult.top = new FormAttachment((Control)this.wCreateTargetFolder, margin);
        this.fdlAddFilenameToResult.right = new FormAttachment(middle, -margin);
        this.wlAddFilenameToResult.setLayoutData((Object)this.fdlAddFilenameToResult);
        this.wAddFilenameToResult = new Button((Composite)this.wTargetFiles, 32);
        this.wAddFilenameToResult.setToolTipText(BaseMessages.getString(PKG, (String)"JobSFTP.AddfilenametoResult.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAddFilenameToResult);
        this.fdAddFilenameToResult = new FormData();
        this.fdAddFilenameToResult.left = new FormAttachment(middle, 0);
        this.fdAddFilenameToResult.top = new FormAttachment((Control)this.wCreateTargetFolder, margin);
        this.fdAddFilenameToResult.right = new FormAttachment(100, 0);
        this.wAddFilenameToResult.setLayoutData((Object)this.fdAddFilenameToResult);
        this.fdTargetFiles = new FormData();
        this.fdTargetFiles.left = new FormAttachment(0, margin);
        this.fdTargetFiles.top = new FormAttachment((Control)this.wSourceFiles, margin);
        this.fdTargetFiles.right = new FormAttachment(100, -margin);
        this.wTargetFiles.setLayoutData((Object)this.fdTargetFiles);
        this.fdFilesComp = new FormData();
        this.fdFilesComp.left = new FormAttachment(0, 0);
        this.fdFilesComp.top = new FormAttachment(0, 0);
        this.fdFilesComp.right = new FormAttachment(100, 0);
        this.fdFilesComp.bottom = new FormAttachment(100, 0);
        this.wFilesComp.setLayoutData((Object)this.fdFilesComp);
        this.wFilesComp.layout();
        this.wFilesTab.setControl((Control)this.wFilesComp);
        this.props.setLook((Control)this.wFilesComp);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wName, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wTabFolder);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntrySFTPDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntrySFTPDialog.this.ok();
            }
        };
        this.lsTest = new Listener(){

            public void handleEvent(Event e) {
                JobEntrySFTPDialog.this.test();
            }
        };
        this.lsCheckChangeFolder = new Listener(){

            public void handleEvent(Event e) {
                JobEntrySFTPDialog.this.checkRemoteFolder();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.wTest.addListener(13, this.lsTest);
        this.wbTestChangeFolderExists.addListener(13, this.lsCheckChangeFolder);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntrySFTPDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.wServerName.addSelectionListener(this.lsDef);
        this.wUserName.addSelectionListener(this.lsDef);
        this.wPassword.addSelectionListener(this.lsDef);
        this.wScpDirectory.addSelectionListener(this.lsDef);
        this.wTargetDirectory.addSelectionListener(this.lsDef);
        this.wWildcard.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntrySFTPDialog.this.cancel();
            }
        });
        this.getData();
        this.activeCopyFromPrevious();
        this.activeUseKey();
        BaseStepDialog.setSize(this.shell);
        this.wTabFolder.setSelection(0);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobSFTPDialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    private void test() {
        if (this.connectToSFTP(false, null)) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"JobSFTP.Connected.OK", (String[])new String[]{this.wServerName.getText()}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"JobSFTP.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        }
    }

    private void activeCopyFromPrevious() {
        this.wlWildcard.setEnabled(!this.wgetPrevious.getSelection());
        this.wWildcard.setEnabled(!this.wgetPrevious.getSelection());
    }

    private void closeFTPConnections() {
        if (this.sftpclient != null) {
            try {
                this.sftpclient.disconnect();
                this.sftpclient = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean connectToSFTP(boolean checkFolder, String Remotefoldername) {
        boolean retval = false;
        try {
            if (this.sftpclient == null) {
                this.sftpclient = new SFTPClient(InetAddress.getByName(this.jobMeta.environmentSubstitute(this.wServerName.getText())), Const.toInt((String)this.jobMeta.environmentSubstitute(this.wServerPort.getText()), (int)22), this.jobMeta.environmentSubstitute(this.wUserName.getText()), this.jobMeta.environmentSubstitute(this.wKeyFilename.getText()), this.jobMeta.environmentSubstitute(this.wkeyfilePass.getText()));
                String realProxyHost = this.jobMeta.environmentSubstitute(this.wProxyHost.getText());
                if (!Const.isEmpty((String)realProxyHost)) {
                    this.sftpclient.setProxy(realProxyHost, this.jobMeta.environmentSubstitute(this.wProxyPort.getText()), this.jobMeta.environmentSubstitute(this.wProxyUsername.getText()), this.jobMeta.environmentSubstitute(this.wProxyPassword.getText()), this.wProxyType.getText());
                }
                this.sftpclient.login(this.jobMeta.environmentSubstitute(this.wPassword.getText()));
                retval = true;
            }
            if (checkFolder) {
                retval = this.sftpclient.folderExists(Remotefoldername);
            }
        }
        catch (Exception e) {
            if (this.sftpclient != null) {
                try {
                    this.sftpclient.disconnect();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                this.sftpclient = null;
            }
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"JobSFTP.ErrorConnect.NOK", (String[])new String[]{this.wServerName.getText(), e.getMessage()}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"JobSFTP.ErrorConnect.Title.Bad", (String[])new String[0]));
            mb.open();
        }
        return retval;
    }

    private void checkRemoteFolder() {
        String changeFTPFolder = this.jobMeta.environmentSubstitute(this.wScpDirectory.getText());
        if (!Const.isEmpty((String)changeFTPFolder) && this.connectToSFTP(true, changeFTPFolder)) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"JobSFTP.FolderExists.OK", (String[])new String[]{changeFTPFolder}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"JobSFTP.FolderExists.Title.Ok", (String[])new String[0]));
            mb.open();
        }
    }

    public void dispose() {
        this.closeFTPConnections();
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.jobEntry.getName()));
        this.wServerName.setText(Const.NVL((String)this.jobEntry.getServerName(), (String)""));
        this.wServerPort.setText(this.jobEntry.getServerPort());
        this.wUserName.setText(Const.NVL((String)this.jobEntry.getUserName(), (String)""));
        this.wPassword.setText(Const.NVL((String)this.jobEntry.getPassword(), (String)""));
        this.wScpDirectory.setText(Const.NVL((String)this.jobEntry.getScpDirectory(), (String)""));
        this.wTargetDirectory.setText(Const.NVL((String)this.jobEntry.getTargetDirectory(), (String)""));
        this.wWildcard.setText(Const.NVL((String)this.jobEntry.getWildcard(), (String)""));
        this.wRemove.setSelection(this.jobEntry.getRemove());
        this.wAddFilenameToResult.setSelection(this.jobEntry.isAddToResult());
        this.wCreateTargetFolder.setSelection(this.jobEntry.iscreateTargetFolder());
        this.wgetPrevious.setSelection(this.jobEntry.isCopyPrevious());
        this.wusePublicKey.setSelection(this.jobEntry.isUseKeyFile());
        this.wKeyFilename.setText(Const.NVL((String)this.jobEntry.getKeyFilename(), (String)""));
        this.wkeyfilePass.setText(Const.NVL((String)this.jobEntry.getKeyPassPhrase(), (String)""));
        this.wCompression.setText(Const.NVL((String)this.jobEntry.getCompression(), (String)"none"));
        this.wProxyType.setText(Const.NVL((String)this.jobEntry.getProxyType(), (String)""));
        this.wProxyHost.setText(Const.NVL((String)this.jobEntry.getProxyHost(), (String)""));
        this.wProxyPort.setText(Const.NVL((String)this.jobEntry.getProxyPort(), (String)""));
        this.wProxyUsername.setText(Const.NVL((String)this.jobEntry.getProxyUsername(), (String)""));
        this.wProxyPassword.setText(Const.NVL((String)this.jobEntry.getProxyPassword(), (String)""));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setServerName(this.wServerName.getText());
        this.jobEntry.setServerPort(this.wServerPort.getText());
        this.jobEntry.setUserName(this.wUserName.getText());
        this.jobEntry.setPassword(this.wPassword.getText());
        this.jobEntry.setScpDirectory(this.wScpDirectory.getText());
        this.jobEntry.setTargetDirectory(this.wTargetDirectory.getText());
        this.jobEntry.setWildcard(this.wWildcard.getText());
        this.jobEntry.setRemove(this.wRemove.getSelection());
        this.jobEntry.setAddToResult(this.wAddFilenameToResult.getSelection());
        this.jobEntry.setcreateTargetFolder(this.wCreateTargetFolder.getSelection());
        this.jobEntry.setCopyPrevious(this.wgetPrevious.getSelection());
        this.jobEntry.setUseKeyFile(this.wusePublicKey.getSelection());
        this.jobEntry.setKeyFilename(this.wKeyFilename.getText());
        this.jobEntry.setKeyPassPhrase(this.wkeyfilePass.getText());
        this.jobEntry.setCompression(this.wCompression.getText());
        this.jobEntry.setProxyType(this.wProxyType.getText());
        this.jobEntry.setProxyHost(this.wProxyHost.getText());
        this.jobEntry.setProxyPort(this.wProxyPort.getText());
        this.jobEntry.setProxyUsername(this.wProxyUsername.getText());
        this.jobEntry.setProxyPassword(this.wProxyPassword.getText());
        this.dispose();
    }

    private void activeUseKey() {
        this.wlKeyFilename.setEnabled(this.wusePublicKey.getSelection());
        this.wKeyFilename.setEnabled(this.wusePublicKey.getSelection());
        this.wbKeyFilename.setEnabled(this.wusePublicKey.getSelection());
        this.wkeyfilePass.setEnabled(this.wusePublicKey.getSelection());
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    private void setDefaulProxyPort() {
        if (this.wProxyType.getText().equals("HTTP")) {
            if (Const.isEmpty((String)this.wProxyPort.getText()) || !Const.isEmpty((String)this.wProxyPort.getText()) && this.wProxyPort.getText().equals("1080")) {
                this.wProxyPort.setText("80");
            }
        } else if (Const.isEmpty((String)this.wProxyPort.getText()) || !Const.isEmpty((String)this.wProxyPort.getText()) && this.wProxyPort.getText().equals("80")) {
            this.wProxyPort.setText("1080");
        }
    }
}

