/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.ui.core.gui.GUIResource;

public class RepositoryDirectoryUI {
    public static void getTreeWithNames(TreeItem ti, Repository rep, Color dircolor, int sortPosition, boolean includeDeleted, boolean ascending, boolean getTransformations, boolean getJobs, RepositoryDirectoryInterface dir, String filterString, Pattern pattern) throws KettleDatabaseException {
        ti.setText(dir.getName());
        ti.setData((Object)dir);
        ti.setData("isFolder", (Object)true);
        for (int i = 0; i < dir.getNrSubdirectories(); ++i) {
            RepositoryDirectory subdir = dir.getSubdirectory(i);
            TreeItem subti = new TreeItem(ti, 0);
            subti.setImage(GUIResource.getInstance().getImageArrow());
            subti.setData("isFolder", (Object)true);
            RepositoryDirectoryUI.getTreeWithNames(subti, rep, dircolor, sortPosition, includeDeleted, ascending, getTransformations, getJobs, (RepositoryDirectoryInterface)subdir, filterString, pattern);
        }
        try {
            List repositoryObjects = new ArrayList();
            if (dir.getRepositoryObjects() != null) {
                repositoryObjects.addAll(dir.getRepositoryObjects());
            }
            if (getTransformations && !getJobs) {
                if (repositoryObjects.size() == 0) {
                    repositoryObjects = rep.getTransformationObjects(dir.getObjectId(), includeDeleted);
                } else {
                    for (int i = repositoryObjects.size() - 1; i >= 0; --i) {
                        if (((RepositoryElementMetaInterface)repositoryObjects.get(i)).getObjectType().equals((Object)RepositoryObjectType.TRANSFORMATION)) continue;
                        repositoryObjects.remove(i);
                    }
                }
            } else if (getJobs && !getTransformations) {
                if (repositoryObjects.size() == 0) {
                    repositoryObjects = rep.getJobObjects(dir.getObjectId(), includeDeleted);
                } else {
                    for (int i = repositoryObjects.size() - 1; i >= 0; --i) {
                        if (((RepositoryElementMetaInterface)repositoryObjects.get(i)).getObjectType().equals((Object)RepositoryObjectType.JOB)) continue;
                        repositoryObjects.remove(i);
                    }
                }
            } else if (getJobs && getTransformations) {
                if (repositoryObjects.size() == 0) {
                    repositoryObjects = rep.getJobAndTransformationObjects(dir.getObjectId(), includeDeleted);
                } else {
                    for (int i = repositoryObjects.size() - 1; i >= 0; --i) {
                        if (((RepositoryElementMetaInterface)repositoryObjects.get(i)).getObjectType().equals((Object)RepositoryObjectType.JOB) || ((RepositoryElementMetaInterface)repositoryObjects.get(i)).getObjectType().equals((Object)RepositoryObjectType.TRANSFORMATION)) continue;
                        repositoryObjects.remove(i);
                    }
                }
            }
            RepositoryObject.sortRepositoryObjects(repositoryObjects, (int)sortPosition, (boolean)ascending);
            for (int i = 0; i < repositoryObjects.size(); ++i) {
                boolean add = false;
                RepositoryElementMetaInterface repositoryObject = (RepositoryElementMetaInterface)repositoryObjects.get(i);
                if (filterString == null && pattern == null) {
                    add = true;
                } else {
                    add = RepositoryDirectoryUI.addItem(repositoryObject.getName(), filterString, pattern);
                    if (!add) {
                        add = RepositoryDirectoryUI.addItem(repositoryObject.getDescription(), filterString, pattern);
                    }
                    if (!add) {
                        add = RepositoryDirectoryUI.addItem(repositoryObject.getModifiedUser(), filterString, pattern);
                    }
                    if (!add && repositoryObject.getModifiedDate() != null) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                        add = RepositoryDirectoryUI.addItem(simpleDateFormat.format(repositoryObject.getModifiedDate()), filterString, pattern);
                    }
                    if (!add && repositoryObject.getObjectType() != null) {
                        add = RepositoryDirectoryUI.addItem(repositoryObject.getObjectType().getTypeDescription(), filterString, pattern);
                    }
                }
                if (!add) continue;
                TreeItem tiObject = new TreeItem(ti, 0);
                tiObject.setData((Object)repositoryObject);
                if (repositoryObject.getObjectType() == RepositoryObjectType.TRANSFORMATION) {
                    tiObject.setImage(GUIResource.getInstance().getImageTransGraph());
                } else if (repositoryObject.getObjectType() == RepositoryObjectType.JOB) {
                    tiObject.setImage(GUIResource.getInstance().getImageJobGraph());
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                tiObject.setText(0, Const.NVL((String)repositoryObject.getName(), (String)""));
                tiObject.setText(1, Const.NVL((String)repositoryObject.getObjectType().getTypeDescription(), (String)"").toUpperCase());
                tiObject.setText(2, Const.NVL((String)repositoryObject.getModifiedUser(), (String)""));
                tiObject.setText(3, repositoryObject.getModifiedDate() != null ? simpleDateFormat.format(repositoryObject.getModifiedDate()) : "");
                tiObject.setText(4, Const.NVL((String)repositoryObject.getDescription(), (String)""));
                if (!repositoryObject.isDeleted()) continue;
                tiObject.setForeground(GUIResource.getInstance().getColorRed());
            }
        }
        catch (KettleException dbe) {
            throw new KettleDatabaseException("Unable to populate tree with repository objects", (Throwable)dbe);
        }
        ti.setExpanded(dir.isRoot());
    }

    private static boolean addItem(String name, String filter, Pattern pattern) {
        boolean add = false;
        if (name != null) {
            if (pattern != null) {
                Matcher matcher = pattern.matcher(name);
                if (matcher.matches()) {
                    add = true;
                }
            } else if (name.toUpperCase().indexOf(filter) >= 0) {
                add = true;
            }
        }
        return add;
    }

    public static void getDirectoryTree(TreeItem ti, Color dircolor, RepositoryDirectoryInterface dir) {
        ti.setText(dir.getName());
        ti.setForeground(dircolor);
        for (int i = 0; i < dir.getNrSubdirectories(); ++i) {
            RepositoryDirectory subdir = dir.getSubdirectory(i);
            TreeItem subti = new TreeItem(ti, 0);
            subti.setImage(GUIResource.getInstance().getImageArrow());
            RepositoryDirectoryUI.getDirectoryTree(subti, dircolor, (RepositoryDirectoryInterface)subdir);
        }
    }
}

