/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.controllers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.repository.repositoryexplorer.ContextChangeVetoer;
import org.pentaho.di.ui.repository.repositoryexplorer.ContextChangeVetoerCollection;
import org.pentaho.di.ui.repository.repositoryexplorer.ControllerInitializationException;
import org.pentaho.di.ui.repository.repositoryexplorer.IUISupportController;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorer;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.LazilyInitializedController;
import org.pentaho.di.ui.repository.repositoryexplorer.controllers.MainController;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIDatabaseConnection;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIDatabaseConnections;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectCreationException;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectRegistry;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

public class ConnectionsController
extends LazilyInitializedController
implements IUISupportController {
    private static Class<?> PKG = RepositoryExplorer.class;
    private XulTree connectionsTable = null;
    protected BindingFactory bf = null;
    private boolean isRepReadOnly = true;
    private Binding bindButtonNew = null;
    private Binding bindButtonEdit = null;
    private Binding bindButtonRemove = null;
    private Shell shell = null;
    private UIDatabaseConnections dbConnectionList = new UIDatabaseConnections();
    private DatabaseDialog databaseDialog;
    private MainController mainController;
    protected ContextChangeVetoerCollection contextChangeVetoers;
    protected List<UIDatabaseConnection> selectedConnections;
    protected List<UIDatabaseConnection> repositoryConnections;

    @Override
    public String getName() {
        return "connectionsController";
    }

    @Override
    public void init(Repository repository) throws ControllerInitializationException {
        this.repository = repository;
    }

    private DatabaseDialog getDatabaseDialog() {
        if (this.databaseDialog != null) {
            return this.databaseDialog;
        }
        this.databaseDialog = new DatabaseDialog(this.shell);
        return this.databaseDialog;
    }

    private void createBindings() {
        block3: {
            this.refreshConnectionList();
            this.connectionsTable = (XulTree)this.document.getElementById("connections-table");
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            try {
                this.bf.createBinding((Object)this.dbConnectionList, "children", (Object)this.connectionsTable, "elements", new BindingConvertor[0]).fireSourceChanged();
                this.bindButtonNew = this.bf.createBinding((Object)this, "repReadOnly", "connections-new", "disabled", new BindingConvertor[0]);
                this.bindButtonNew.fireSourceChanged();
                this.bindButtonEdit = this.bf.createBinding((Object)this, "repReadOnly", "connections-edit", "disabled", new BindingConvertor[0]);
                this.bindButtonEdit.fireSourceChanged();
                this.bindButtonRemove = this.bf.createBinding((Object)this, "repReadOnly", "connections-remove", "disabled", new BindingConvertor[0]);
                this.bindButtonRemove.fireSourceChanged();
                if (this.repository != null) {
                    this.bf.createBinding((Object)this.connectionsTable, "selectedItems", (Object)this, "selectedConnections", new BindingConvertor[0]);
                }
            }
            catch (Exception ex) {
                if (this.mainController != null && this.mainController.handleLostRepository(ex)) break block3;
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    protected boolean doLazyInit() {
        try {
            this.mainController = (MainController)this.getXulDomContainer().getEventHandler("mainController");
        }
        catch (XulException e) {
            return false;
        }
        try {
            this.setRepReadOnly(this.repository.getRepositoryMeta().getRepositoryCapabilities().isReadOnly());
            this.shell = ((SwtDialog)this.document.getElementById("repository-explorer-dialog")).getShell();
            this.bf = new DefaultBindingFactory();
            this.bf.setDocument(this.getXulDomContainer().getDocumentRoot());
            if (this.bf != null) {
                this.createBindings();
            }
            this.enableButtons(true, false, false);
            return true;
        }
        catch (Exception e) {
            if (this.mainController == null || !this.mainController.handleLostRepository(e)) {
                return false;
            }
            return false;
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepReadOnly(boolean isRepReadOnly) {
        block4: {
            try {
                if (this.isRepReadOnly != isRepReadOnly) {
                    this.isRepReadOnly = isRepReadOnly;
                    if (this.initialized) {
                        this.bindButtonNew.fireSourceChanged();
                        this.bindButtonEdit.fireSourceChanged();
                        this.bindButtonRemove.fireSourceChanged();
                    }
                }
            }
            catch (Exception e) {
                if (this.mainController != null && this.mainController.handleLostRepository(e)) break block4;
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isRepReadOnly() {
        return this.isRepReadOnly;
    }

    private void refreshConnectionList() {
        final ArrayList tmpList = new ArrayList();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                block5: {
                    try {
                        ObjectId[] dbIdList;
                        for (ObjectId dbId : dbIdList = ConnectionsController.this.repository.getDatabaseIDs(false)) {
                            DatabaseMeta dbMeta = ConnectionsController.this.repository.loadDatabaseMeta(dbId, null);
                            try {
                                tmpList.add(UIObjectRegistry.getInstance().constructUIDatabaseConnection(dbMeta, ConnectionsController.this.repository));
                            }
                            catch (UIObjectCreationException uoe) {
                                tmpList.add(new UIDatabaseConnection(dbMeta, ConnectionsController.this.repository));
                            }
                        }
                    }
                    catch (KettleException e) {
                        if (ConnectionsController.this.mainController != null && ConnectionsController.this.mainController.handleLostRepository(e)) break block5;
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        this.doWithBusyIndicator(r);
        this.dbConnectionList.setChildren(tmpList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createConnection() {
        try {
            DatabaseMeta databaseMeta = new DatabaseMeta();
            databaseMeta.initializeVariablesFrom(null);
            this.getDatabaseDialog().setDatabaseMeta(databaseMeta);
            String dbName = this.getDatabaseDialog().open();
            if (dbName != null && !dbName.equals("")) {
                ObjectId idDatabase = this.repository.getDatabaseID(dbName);
                if (idDatabase == null) {
                    this.repository.insertLogEntry(BaseMessages.getString(PKG, (String)"ConnectionsController.Message.CreatingDatabase", (String[])new String[]{this.getDatabaseDialog().getDatabaseMeta().getName()}));
                    this.repository.save((RepositoryElementInterface)this.getDatabaseDialog().getDatabaseMeta(), "Creation of initial version", null);
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.AlreadyExists.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.AlreadyExists.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        }
        catch (KettleException e) {
            if (this.mainController == null || !this.mainController.handleLostRepository(e)) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
            }
        }
        finally {
            this.refreshConnectionList();
        }
    }

    List<ContextChangeVetoer.TYPE> pollContextChangeVetoResults() {
        if (this.contextChangeVetoers != null) {
            return this.contextChangeVetoers.fireContextChange();
        }
        ArrayList<ContextChangeVetoer.TYPE> returnValue = new ArrayList<ContextChangeVetoer.TYPE>();
        returnValue.add(ContextChangeVetoer.TYPE.NO_OP);
        return returnValue;
    }

    public void addContextChangeVetoer(ContextChangeVetoer listener) {
        if (this.contextChangeVetoers == null) {
            this.contextChangeVetoers = new ContextChangeVetoerCollection();
        }
        this.contextChangeVetoers.add(listener);
    }

    public void removeContextChangeVetoer(ContextChangeVetoer listener) {
        if (this.contextChangeVetoers != null) {
            this.contextChangeVetoers.remove(listener);
        }
    }

    private boolean contains(ContextChangeVetoer.TYPE type, List<ContextChangeVetoer.TYPE> typeList) {
        for (ContextChangeVetoer.TYPE t : typeList) {
            if (!t.equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    boolean compareConnections(List<UIDatabaseConnection> ro1, List<UIDatabaseConnection> ro2) {
        if (ro1 != null && ro2 != null) {
            if (ro1.size() != ro2.size()) {
                return false;
            }
            for (int i = 0; i < ro1.size(); ++i) {
                if (ro1.get(i) == null || ro2.get(i) == null || ro1.get(i).getName().equals(ro2.get(i).getName())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editConnection() {
        try {
            Collection connections = this.connectionsTable.getSelectedItems();
            if (connections != null && !connections.isEmpty()) {
                DatabaseMeta databaseMeta = ((UIDatabaseConnection)((Object)connections.toArray()[0])).getDatabaseMeta();
                ObjectId idDatabase = this.repository.getDatabaseID(databaseMeta.getName());
                if (idDatabase == null) {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Edit.DoesNotExists.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Edit.DoesNotExists.Title", (String[])new String[0]));
                    mb.open();
                } else {
                    this.getDatabaseDialog().setDatabaseMeta(databaseMeta);
                    String dbName = this.getDatabaseDialog().open();
                    if (dbName != null && !dbName.equals("")) {
                        this.repository.insertLogEntry(BaseMessages.getString(PKG, (String)"ConnectionsController.Message.UpdatingDatabase", (String[])new String[]{databaseMeta.getName()}));
                        this.repository.save((RepositoryElementInterface)databaseMeta, "Modification by user", null);
                    }
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Edit.NoItemSelected.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Edit.NoItemSelected.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException e) {
            if (this.mainController == null || !this.mainController.handleLostRepository(e)) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Edit.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
            }
        }
        finally {
            this.refreshConnectionList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection() {
        try {
            Collection connections = this.connectionsTable.getSelectedItems();
            if (connections != null && !connections.isEmpty()) {
                for (Object obj : connections) {
                    if (obj == null || !(obj instanceof UIDatabaseConnection)) continue;
                    UIDatabaseConnection connection = (UIDatabaseConnection)((Object)obj);
                    DatabaseMeta databaseMeta = connection.getDatabaseMeta();
                    ObjectId idDatabase = this.repository.getDatabaseID(databaseMeta.getName());
                    if (idDatabase == null) {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Delete.DoesNotExists.Message", (String[])new String[]{databaseMeta.getName()}));
                        mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Delete.Title", (String[])new String[0]));
                        mb.open();
                        continue;
                    }
                    this.repository.deleteDatabaseMeta(databaseMeta.getName());
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Edit.NoItemSelected.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Delete.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException e) {
            if (this.mainController == null || !this.mainController.handleLostRepository(e)) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Remove.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
            }
        }
        finally {
            this.refreshConnectionList();
        }
    }

    public void setSelectedConnections(List<UIDatabaseConnection> connections) {
        if (!this.compareConnections(connections, this.selectedConnections)) {
            List<ContextChangeVetoer.TYPE> pollResults = this.pollContextChangeVetoResults();
            if (!this.contains(ContextChangeVetoer.TYPE.CANCEL, pollResults)) {
                this.selectedConnections = connections;
                this.setRepositoryConnections(connections);
            } else {
                this.connectionsTable.setSelectedItems(this.selectedConnections);
                return;
            }
        }
        boolean enableEdit = false;
        boolean enableRemove = false;
        if (connections != null && connections.size() > 0) {
            enableRemove = true;
            if (connections.size() == 1) {
                enableEdit = true;
            }
        }
        this.enableButtons(true, enableEdit, enableRemove);
    }

    public List<UIDatabaseConnection> getRepositoryConnections() {
        return this.repositoryConnections;
    }

    public void setRepositoryConnections(List<UIDatabaseConnection> connections) {
        this.repositoryConnections = connections;
        this.firePropertyChange("repositoryConnections", null, connections);
    }

    public void enableButtons(boolean enableNew, boolean enableEdit, boolean enableRemove) {
        XulButton bNew = (XulButton)this.document.getElementById("connections-new");
        XulButton bEdit = (XulButton)this.document.getElementById("connections-edit");
        XulButton bRemove = (XulButton)this.document.getElementById("connections-remove");
        bNew.setDisabled(!enableNew);
        bEdit.setDisabled(!enableEdit);
        bRemove.setDisabled(!enableRemove);
    }

    public void tabClicked() {
        this.lazyInit();
    }
}

