/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.delegates;

import java.util.List;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.cluster.dialog.ClusterSchemaDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.delegates.SpoonSharedObjectDelegate;

public class SpoonClustersDelegate
extends SpoonSharedObjectDelegate {
    public SpoonClustersDelegate(Spoon spoon) {
        super(spoon);
    }

    public void newClusteringSchema(TransMeta transMeta) {
        ClusterSchema clusterSchema = new ClusterSchema();
        ClusterSchemaDialog dialog = new ClusterSchemaDialog(this.spoon.getShell(), clusterSchema, transMeta.getSlaveServers());
        if (dialog.open()) {
            List clusterSchemas = transMeta.getClusterSchemas();
            if (SpoonClustersDelegate.isDuplicate(clusterSchemas, (SharedObjectInterface)clusterSchema)) {
                new ErrorDialog(this.spoon.getShell(), SpoonClustersDelegate.getMessage("Spoon.Dialog.ErrorSavingCluster.Title"), SpoonClustersDelegate.getMessage("Spoon.Dialog.ErrorSavingCluster.Message", clusterSchema.getName()), (Exception)((Object)new KettleException(SpoonClustersDelegate.getMessage("Spoon.Dialog.ErrorSavingCluster.NotUnique"))));
                return;
            }
            clusterSchemas.add(clusterSchema);
            if (this.spoon.rep != null) {
                try {
                    if (this.spoon.rep.getSecurityProvider().isReadOnly()) {
                        throw new KettleException(BaseMessages.getString((Class)PKG, (String)"Spoon.Dialog.Exception.ReadOnlyRepositoryUser", (String[])new String[0]));
                    }
                    this.spoon.rep.save((RepositoryElementInterface)clusterSchema, "Creation of initial version", null);
                }
                catch (KettleException e) {
                    new ErrorDialog(this.spoon.getShell(), SpoonClustersDelegate.getMessage("Spoon.Dialog.ErrorSavingCluster.Title"), SpoonClustersDelegate.getMessage("Spoon.Dialog.ErrorSavingCluster.Message", clusterSchema.getName()), (Exception)((Object)e));
                }
            }
            this.spoon.refreshTree();
        }
    }
}

