/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.job;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.pentaho.di.core.AddUndoPositionInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.dnd.DragAndDropContainer;
import org.pentaho.di.core.dnd.XMLTransfer;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.gui.AreaOwner;
import org.pentaho.di.core.gui.GCInterface;
import org.pentaho.di.core.gui.GUIPositionInterface;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.Rectangle;
import org.pentaho.di.core.gui.Redrawable;
import org.pentaho.di.core.gui.ScrollBarInterface;
import org.pentaho.di.core.gui.SnapAllignDistribute;
import org.pentaho.di.core.gui.UndoInterface;
import org.pentaho.di.core.logging.HasLogChannelInterface;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogParentProvidedInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobAdapter;
import org.pentaho.di.job.JobEntryListener;
import org.pentaho.di.job.JobEntryResult;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobHopMeta;
import org.pentaho.di.job.JobListener;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.JobPainter;
import org.pentaho.di.job.entries.job.JobEntryJob;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.KettleRepositoryLostException;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.RepositoryOperation;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPainter;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.CheckBoxToolTip;
import org.pentaho.di.ui.core.widget.CheckBoxToolTipListener;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.repository.RepositorySecurityUI;
import org.pentaho.di.ui.repository.dialog.RepositoryExplorerDialog;
import org.pentaho.di.ui.repository.dialog.RepositoryRevisionBrowserDialogInterface;
import org.pentaho.di.ui.spoon.AbstractGraph;
import org.pentaho.di.ui.spoon.SWTGC;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPluginManager;
import org.pentaho.di.ui.spoon.SwtScrollBar;
import org.pentaho.di.ui.spoon.TabItemInterface;
import org.pentaho.di.ui.spoon.TabMapEntry;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.di.ui.spoon.dialog.DeleteMessageBox;
import org.pentaho.di.ui.spoon.dialog.NotePadDialog;
import org.pentaho.di.ui.spoon.job.JobGraphExtension;
import org.pentaho.di.ui.spoon.job.JobGraphJobEntryMenuExtension;
import org.pentaho.di.ui.spoon.job.JobGridDelegate;
import org.pentaho.di.ui.spoon.job.JobHistoryDelegate;
import org.pentaho.di.ui.spoon.job.JobLogDelegate;
import org.pentaho.di.ui.spoon.job.JobMetricsDelegate;
import org.pentaho.di.ui.spoon.job.RefreshListener;
import org.pentaho.di.ui.spoon.trans.DelayListener;
import org.pentaho.di.ui.spoon.trans.DelayTimer;
import org.pentaho.di.ui.spoon.trans.TransGraph;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.components.XulToolbarbutton;
import org.pentaho.ui.xul.containers.XulMenu;
import org.pentaho.ui.xul.containers.XulMenupopup;
import org.pentaho.ui.xul.containers.XulToolbar;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.jface.tags.JfaceMenuitem;
import org.pentaho.ui.xul.jface.tags.JfaceMenupopup;

public class JobGraph
extends AbstractGraph
implements XulEventHandler,
Redrawable,
TabItemInterface,
LogParentProvidedInterface,
MouseListener,
MouseMoveListener,
MouseTrackListener,
MouseWheelListener,
KeyListener {
    private static Class<?> PKG = JobGraph.class;
    private static final String XUL_FILE_JOB_GRAPH = "ui/job-graph.xul";
    public static final String START_TEXT = BaseMessages.getString(PKG, (String)"JobLog.Button.Start", (String[])new String[0]);
    public static final String STOP_TEXT = BaseMessages.getString(PKG, (String)"JobLog.Button.Stop", (String[])new String[0]);
    private static final String STRING_PARALLEL_WARNING_PARAMETER = "ParallelJobEntriesWarning";
    private static final int HOP_SEL_MARGIN = 9;
    protected Shell shell;
    protected LogChannelInterface log;
    protected JobMeta jobMeta;
    public Job job;
    protected PropsUI props;
    protected int iconsize;
    protected int linewidth;
    protected Point lastclick;
    protected List<JobEntryCopy> selectedEntries;
    protected JobEntryCopy selectedEntry;
    protected Point[] previousLocations;
    private List<NotePadMeta> selectedNotes;
    protected NotePadMeta selectedNote;
    protected Point previous_note_location;
    protected Point lastMove;
    protected JobHopMeta hop_candidate;
    protected Point drop_candidate;
    protected Spoon spoon;
    protected boolean split_hop;
    protected int lastButton;
    protected JobHopMeta last_hop_split;
    protected Rectangle selectionRegion;
    protected static final double theta = Math.toRadians(10.0);
    protected static final int size = 30;
    protected int shadowsize;
    protected Map<String, XulMenupopup> menuMap = new HashMap<String, XulMenupopup>();
    protected int currentMouseX = 0;
    protected int currentMouseY = 0;
    protected JobEntryCopy jobEntry;
    protected NotePadMeta ni = null;
    protected JobHopMeta currentHop;
    private SashForm sashForm;
    public Composite extraViewComposite;
    public CTabFolder extraViewTabFolder;
    private XulToolbar toolbar;
    public JobLogDelegate jobLogDelegate;
    public JobHistoryDelegate jobHistoryDelegate;
    public JobGridDelegate jobGridDelegate;
    public JobMetricsDelegate jobMetricsDelegate;
    private Composite mainComposite;
    private List<RefreshListener> refreshListeners;
    private Label closeButton;
    private Label minMaxButton;
    private CheckBoxToolTip helpTip;
    private List<AreaOwner> areaOwners;
    private List<JobEntryCopy> mouseOverEntries;
    private Map<JobEntryCopy, String> entryLogMap;
    private Map<JobEntryCopy, DelayTimer> delayTimers;
    private JobEntryCopy startHopEntry;
    private Point endHopLocation;
    private JobEntryCopy endHopEntry;
    private JobEntryCopy noInputEntry;
    private DefaultToolTip toolTip;
    private Point[] previous_step_locations;
    private Point[] previous_note_locations;
    private JobEntryCopy currentEntry;
    private JobEntryCopy lastChained = null;

    public JobGraph(Composite par, final Spoon spoon, final JobMeta jobMeta) {
        super(par, 0);
        this.shell = par.getShell();
        this.log = spoon.getLog();
        this.spoon = spoon;
        this.jobMeta = jobMeta;
        this.props = PropsUI.getInstance();
        this.areaOwners = new ArrayList<AreaOwner>();
        this.mouseOverEntries = new ArrayList<JobEntryCopy>();
        this.delayTimers = new HashMap<JobEntryCopy, DelayTimer>();
        this.jobLogDelegate = new JobLogDelegate(spoon, this);
        this.jobHistoryDelegate = new JobHistoryDelegate(spoon, this);
        this.jobGridDelegate = new JobGridDelegate(spoon, this);
        this.jobMetricsDelegate = new JobMetricsDelegate(spoon, this);
        this.refreshListeners = new ArrayList<RefreshListener>();
        try {
            KettleXulLoader loader = new KettleXulLoader();
            loader.setIconsSize(16, 16);
            loader.setSettingsManager(XulSpoonSettingsManager.getInstance());
            XulSpoonResourceBundle bundle = new XulSpoonResourceBundle(JobGraph.class);
            XulDomContainer container = loader.loadXul(XUL_FILE_JOB_GRAPH, bundle);
            container.addEventHandler((XulEventHandler)this);
            SpoonPluginManager.getInstance().applyPluginsForContainer("job-graph", this.xulDomContainer);
            this.setXulDomContainer(container);
        }
        catch (XulException e1) {
            this.log.logError(this.toString(), new Object[]{Const.getStackTracker((Throwable)e1)});
        }
        this.setLayout((Layout)new FormLayout());
        this.setLayoutData(new GridData(1808));
        this.addToolBar();
        this.mainComposite = new Composite((Composite)this, 0);
        this.mainComposite.setLayout((Layout)new FillLayout());
        Control toolbarControl = (Control)this.toolbar.getManagedObject();
        FormData toolbarFd = new FormData();
        toolbarFd.left = new FormAttachment(0, 0);
        toolbarFd.right = new FormAttachment(100, 0);
        toolbarControl.setLayoutData((Object)toolbarFd);
        toolbarControl.setParent((Composite)this);
        FormData fdMainComposite = new FormData();
        fdMainComposite.left = new FormAttachment(0, 0);
        fdMainComposite.top = new FormAttachment((Control)this.toolbar.getManagedObject(), 0);
        fdMainComposite.right = new FormAttachment(100, 0);
        fdMainComposite.bottom = new FormAttachment(100, 0);
        this.mainComposite.setLayoutData((Object)fdMainComposite);
        this.sashForm = new SashForm(this.mainComposite, 512);
        this.canvas = new Canvas((Composite)this.sashForm, 264960);
        this.sashForm.setWeights(new int[]{100});
        try {
            Document doc = this.xulDomContainer.getDocumentRoot();
            this.menuMap.put("job-graph-hop", (XulMenupopup)doc.getElementById("job-graph-hop"));
            this.menuMap.put("job-graph-note", (XulMenupopup)doc.getElementById("job-graph-note"));
            this.menuMap.put("job-graph-background", (XulMenupopup)doc.getElementById("job-graph-background"));
            this.menuMap.put("job-graph-entry", (XulMenupopup)doc.getElementById("job-graph-entry"));
        }
        catch (Throwable t) {
            this.log.logError(Const.getStackTracker((Throwable)t));
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JobGraph.Exception.ErrorReadingXULFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobGraph.Exception.ErrorReadingXULFile.Message", (String[])new String[]{"ui/menus.xul"}), new Exception(t));
        }
        this.toolTip = new DefaultToolTip((Control)this.canvas, 2, true);
        this.toolTip.setRespectMonitorBounds(true);
        this.toolTip.setRespectDisplayBounds(true);
        this.toolTip.setPopupDelay(350);
        this.toolTip.setShift(new org.eclipse.swt.graphics.Point(5, 5));
        this.helpTip = new CheckBoxToolTip((Control)this.canvas);
        this.helpTip.addCheckBoxToolTipListener(new CheckBoxToolTipListener(){

            @Override
            public void checkBoxSelected(boolean enabled) {
                spoon.props.setShowingHelpToolTips(enabled);
            }
        });
        this.newProps();
        this.selectionRegion = null;
        this.hop_candidate = null;
        this.last_hop_split = null;
        this.selectedEntries = null;
        this.selectedNote = null;
        this.hori = this.canvas.getHorizontalBar();
        this.vert = this.canvas.getVerticalBar();
        this.hori.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobGraph.this.redraw();
            }
        });
        this.vert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobGraph.this.redraw();
            }
        });
        this.hori.setThumb(100);
        this.vert.setThumb(100);
        this.hori.setVisible(true);
        this.vert.setVisible(true);
        this.setVisible(true);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                JobGraph.this.paintControl(e);
            }
        });
        this.selectedEntries = null;
        this.lastclick = null;
        this.canvas.addMouseListener((MouseListener)this);
        this.canvas.addMouseMoveListener((MouseMoveListener)this);
        this.canvas.addMouseTrackListener((MouseTrackListener)this);
        this.canvas.addMouseWheelListener((MouseWheelListener)this);
        Transfer[] ttypes = new Transfer[]{XMLTransfer.getInstance()};
        DropTarget ddTarget = new DropTarget((Control)this.canvas, 2);
        ddTarget.setTransfer(ttypes);
        ddTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                JobGraph.this.drop_candidate = PropsUI.calculateGridPosition(JobGraph.this.getRealPosition((Composite)JobGraph.this.canvas, event.x, event.y));
                JobGraph.this.redraw();
            }

            public void dragLeave(DropTargetEvent event) {
                JobGraph.this.drop_candidate = null;
                JobGraph.this.redraw();
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                JobGraph.this.drop_candidate = PropsUI.calculateGridPosition(JobGraph.this.getRealPosition((Composite)JobGraph.this.canvas, event.x, event.y));
                JobGraph.this.redraw();
            }

            public void drop(DropTargetEvent event) {
                if (event.data == null) {
                    event.detail = 0;
                    return;
                }
                Point p = JobGraph.this.getRealPosition((Composite)JobGraph.this.canvas, event.x, event.y);
                try {
                    DragAndDropContainer container = (DragAndDropContainer)event.data;
                    String entry = container.getData();
                    switch (container.getType()) {
                        case 7: {
                            JobEntryCopy jge = spoon.newJobEntry(jobMeta, entry, false);
                            if (jge == null) break;
                            PropsUI.setLocation((GUIPositionInterface)jge, p.x, p.y);
                            jge.setDrawn();
                            JobGraph.this.redraw();
                            if (jobMeta.nrJobEntries() <= 1 || jobMeta.nrJobEntries() >= 5 || !spoon.props.isShowingHelpToolTips()) break;
                            JobGraph.this.showHelpTip(p.x, p.y, BaseMessages.getString((Class)PKG, (String)"JobGraph.HelpToolTip.CreatingHops.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"JobGraph.HelpToolTip.CreatingHops.Message", (String[])new String[0]));
                            break;
                        }
                        case 6: {
                            JobEntryCopy jge = jobMeta.findJobEntry(entry, 0, true);
                            if (jge != null) {
                                if (jge.isStart() && jge.isDrawn()) {
                                    JobGraph.showOnlyStartOnceMessage(JobGraph.this.shell);
                                    return;
                                }
                                boolean jge_changed = false;
                                JobEntryCopy before = (JobEntryCopy)jge.clone_deep();
                                JobEntryCopy newjge = jge;
                                if (jge.isDrawn()) {
                                    newjge = (JobEntryCopy)jge.clone();
                                    if (newjge != null) {
                                        if (JobGraph.this.log.isDebug()) {
                                            JobGraph.this.log.logDebug("entry aft = " + jge.getEntry().toString());
                                        }
                                        newjge.setNr(jobMeta.findUnusedNr(newjge.getName()));
                                        jobMeta.addJobEntry(newjge);
                                        spoon.addUndoNew((UndoInterface)jobMeta, new JobEntryCopy[]{newjge}, new int[]{jobMeta.indexOfJobEntry(newjge)});
                                    } else if (JobGraph.this.log.isDebug()) {
                                        JobGraph.this.log.logDebug("jge is not cloned!");
                                    }
                                } else {
                                    if (JobGraph.this.log.isDebug()) {
                                        JobGraph.this.log.logDebug(jge.toString() + " is not drawn");
                                    }
                                    jge_changed = true;
                                }
                                PropsUI.setLocation((GUIPositionInterface)newjge, p.x, p.y);
                                newjge.setDrawn();
                                if (jge_changed) {
                                    spoon.addUndoChange((UndoInterface)jobMeta, new JobEntryCopy[]{before}, new JobEntryCopy[]{newjge}, new int[]{jobMeta.indexOfJobEntry(newjge)});
                                }
                                JobGraph.this.redraw();
                                spoon.refreshTree();
                                JobGraph.this.log.logBasic("DropTargetEvent", new Object[]{"DROP " + newjge.toString() + "!, type=" + newjge.getEntry().getPluginId()});
                                break;
                            }
                            JobGraph.this.log.logError("Unknown job entry dropped onto the canvas.");
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    new ErrorDialog(JobGraph.this.shell, BaseMessages.getString((Class)PKG, (String)"JobGraph.Dialog.ErrorDroppingObject.Message", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"JobGraph.Dialog.ErrorDroppingObject.Title", (String[])new String[0]), e);
                }
            }

            public void dropAccept(DropTargetEvent event) {
                JobGraph.this.drop_candidate = null;
            }
        });
        this.canvas.addKeyListener((KeyListener)this);
        this.setBackground(GUIResource.getInstance().getColorBackground());
        this.setControlStates();
        final Timer timer = new Timer("JobGraph.setControlStates Timer: " + this.getMeta().getName());
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                block2: {
                    try {
                        JobGraph.this.setControlStates();
                    }
                    catch (KettleRepositoryLostException krle) {
                        if (!JobGraph.this.log.isBasic()) break block2;
                        JobGraph.this.log.logBasic(krle.getLocalizedMessage());
                    }
                }
            }
        };
        timer.schedule(timerTask, 2000L, 1000L);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                timer.cancel();
            }
        });
    }

    protected void hideToolTips() {
        this.toolTip.hide();
        this.helpTip.hide();
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.clearSettings();
        Point real = this.screen2real(e.x, e.y);
        this.hideToolTips();
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.JobGraphMouseDoubleClick.id, (Object)new JobGraphExtension(this, e, real));
        }
        catch (Exception ex) {
            LogChannel.GENERAL.logError("Error calling JobGraphMouseDoubleClick extension point", (Throwable)ex);
        }
        JobEntryCopy jobentry = this.jobMeta.getJobEntryCopy(real.x, real.y, this.iconsize);
        if (jobentry != null) {
            if (e.button == 1) {
                this.editEntry(jobentry);
            } else {
                this.launchStuff(jobentry);
            }
        } else {
            JobHopMeta online = this.findJobHop(real.x, real.y);
            if (online == null) {
                NotePadMeta ni = this.jobMeta.getNote(real.x, real.y);
                if (ni != null) {
                    this.editNote(ni);
                } else {
                    this.editJobProperties();
                }
            }
        }
    }

    public void mouseDown(MouseEvent e) {
        boolean control = (e.stateMask & SWT.MOD1) != 0;
        boolean shift = (e.stateMask & 0x20000) != 0;
        this.lastButton = e.button;
        Point real = this.screen2real(e.x, e.y);
        this.lastclick = new Point(real.x, real.y);
        this.hideToolTips();
        if (e.button == 3) {
            this.setMenu(real.x, real.y);
            return;
        }
        try {
            ExtensionPointHandler.callExtensionPoint((LogChannelInterface)LogChannel.GENERAL, (String)KettleExtensionPoint.JobGraphMouseDown.id, (Object)new JobGraphExtension(this, e, real));
        }
        catch (Exception ex) {
            LogChannel.GENERAL.logError("Error calling JobGraphMouseDown extension point", (Throwable)ex);
        }
        if (e.button == 1 || e.button == 2) {
            AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
            if (areaOwner != null) {
                switch (areaOwner.getAreaType()) {
                    case JOB_ENTRY_MINI_ICON_OUTPUT: {
                        this.selectedEntry = null;
                        this.startHopEntry = (JobEntryCopy)areaOwner.getOwner();
                        break;
                    }
                    case JOB_ENTRY_MINI_ICON_INPUT: {
                        this.selectedEntry = null;
                        this.startHopEntry = null;
                        this.endHopEntry = (JobEntryCopy)areaOwner.getOwner();
                        break;
                    }
                    case JOB_ENTRY_MINI_ICON_EDIT: {
                        this.clearSettings();
                        this.currentEntry = (JobEntryCopy)areaOwner.getOwner();
                        this.stopEntryMouseOverDelayTimer(this.currentEntry);
                        this.editEntry(this.currentEntry);
                        break;
                    }
                    case JOB_ENTRY_MINI_ICON_CONTEXT: {
                        this.clearSettings();
                        JobEntryCopy jobEntryCopy = (JobEntryCopy)areaOwner.getOwner();
                        this.setMenu(jobEntryCopy.getLocation().x, jobEntryCopy.getLocation().y);
                        break;
                    }
                    case JOB_ENTRY_ICON: {
                        JobEntryCopy jobEntryCopy;
                        this.currentEntry = jobEntryCopy = (JobEntryCopy)areaOwner.getOwner();
                        if (this.hop_candidate != null) {
                            this.addCandidateAsHop();
                        } else if (e.button == 2 || e.button == 1 && shift) {
                            this.startHopEntry = jobEntryCopy;
                        } else {
                            this.selectedEntries = this.jobMeta.getSelectedEntries();
                            this.selectedEntry = jobEntryCopy;
                            this.previous_step_locations = this.jobMeta.getSelectedLocations();
                            Point p = jobEntryCopy.getLocation();
                            this.iconoffset = new Point(real.x - p.x, real.y - p.y);
                        }
                        this.redraw();
                        break;
                    }
                    case NOTE: {
                        this.ni = (NotePadMeta)areaOwner.getOwner();
                        this.selectedNotes = this.jobMeta.getSelectedNotes();
                        this.selectedNote = this.ni;
                        Point loc = this.ni.getLocation();
                        this.previous_note_locations = this.jobMeta.getSelectedNoteLocations();
                        this.noteoffset = new Point(real.x - loc.x, real.y - loc.y);
                        this.redraw();
                        break;
                    }
                    case JOB_HOP_ICON: {
                        JobHopMeta hop = (JobHopMeta)areaOwner.getOwner();
                        if (!hop.getFromEntry().evaluates()) break;
                        if (hop.isUnconditional()) {
                            hop.setUnconditional(false);
                            hop.setEvaluation(true);
                        } else if (hop.getEvaluation()) {
                            hop.setEvaluation(false);
                        } else {
                            hop.setUnconditional(true);
                        }
                        this.spoon.setShellText();
                        this.redraw();
                        break;
                    }
                }
            } else {
                JobHopMeta hop = this.findJobHop(real.x, real.y);
                if (hop != null) {
                    JobHopMeta before = (JobHopMeta)hop.clone();
                    hop.setEnabled(!hop.isEnabled());
                    JobHopMeta after = (JobHopMeta)hop.clone();
                    this.spoon.addUndoChange((UndoInterface)this.jobMeta, new JobHopMeta[]{before}, new JobHopMeta[]{after}, new int[]{this.jobMeta.indexOfJobHop(hop)});
                    this.spoon.setShellText();
                    this.redraw();
                } else {
                    this.startHopEntry = null;
                    if (!control) {
                        this.selectionRegion = new Rectangle(real.x, real.y, 0, 0);
                    }
                    this.redraw();
                }
            }
        }
    }

    public void mouseUp(MouseEvent e) {
        boolean control;
        boolean bl = control = (e.stateMask & SWT.MOD1) != 0;
        if (this.iconoffset == null) {
            this.iconoffset = new Point(0, 0);
        }
        Point real = this.screen2real(e.x, e.y);
        Point icon = new Point(real.x - this.iconoffset.x, real.y - this.iconoffset.y);
        if (this.hop_candidate != null) {
            this.addCandidateAsHop();
            this.redraw();
        } else if (this.selectionRegion != null) {
            this.selectionRegion.width = real.x - this.selectionRegion.x;
            this.selectionRegion.height = real.y - this.selectionRegion.y;
            this.jobMeta.unselectAll();
            this.selectInRect(this.jobMeta, this.selectionRegion);
            this.selectionRegion = null;
            this.stopEntryMouseOverDelayTimers();
            this.redraw();
        } else if (this.selectedEntry != null && this.startHopEntry == null) {
            if (e.button == 1) {
                Point realclick = this.screen2real(e.x, e.y);
                if (this.lastclick.x == realclick.x && this.lastclick.y == realclick.y) {
                    if (control) {
                        this.selectedEntry.flipSelected();
                    } else {
                        this.jobMeta.unselectAll();
                        this.selectedEntry.setSelected(true);
                    }
                } else {
                    int[] indexes;
                    this.selectedEntries = this.jobMeta.getSelectedEntries();
                    this.selectedNotes = this.jobMeta.getSelectedNotes();
                    boolean also = false;
                    if (this.selectedNotes != null && this.selectedNotes.size() > 0 && this.previous_note_locations != null) {
                        indexes = this.jobMeta.getNoteIndexes(this.selectedNotes);
                        this.addUndoPosition(this.selectedNotes.toArray(new NotePadMeta[this.selectedNotes.size()]), indexes, this.previous_note_locations, this.jobMeta.getSelectedNoteLocations(), also);
                        boolean bl2 = also = this.selectedEntries != null && this.selectedEntries.size() > 0;
                    }
                    if (this.selectedEntries != null && this.selectedEntries.size() > 0 && this.previous_step_locations != null) {
                        indexes = this.jobMeta.getEntryIndexes(this.selectedEntries);
                        this.addUndoPosition(this.selectedEntries.toArray(new JobEntryCopy[this.selectedEntries.size()]), indexes, this.previous_step_locations, this.jobMeta.getSelectedLocations(), also);
                    }
                }
            }
            if (this.split_hop) {
                JobHopMeta hi = this.findHop(icon.x + this.iconsize / 2, icon.y + this.iconsize / 2, this.selectedEntry);
                if (hi != null) {
                    int id = 0;
                    if (!this.spoon.props.getAutoSplit()) {
                        MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"TransGraph.Dialog.SplitHop.Title", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"TransGraph.Dialog.SplitHop.Message", (String[])new String[0]) + Const.CR + hi.toString(), 3, new String[]{BaseMessages.getString(PKG, (String)"System.Button.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0])}, 0, BaseMessages.getString(PKG, (String)"TransGraph.Dialog.Option.SplitHop.DoNotAskAgain", (String[])new String[0]), this.spoon.props.getAutoSplit());
                        MessageDialogWithToggle.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
                        id = md.open();
                        this.spoon.props.setAutoSplit(md.getToggleState());
                    }
                    if ((id & 0xFF) == 0 && this.jobMeta.findJobHop(this.selectedEntry, hi.getFromEntry()) == null && this.jobMeta.findJobHop(hi.getToEntry(), this.selectedEntry) == null) {
                        if (this.jobMeta.findJobHop(hi.getFromEntry(), this.selectedEntry, true) == null) {
                            JobHopMeta newhop1 = new JobHopMeta(hi.getFromEntry(), this.selectedEntry);
                            if (hi.getFromEntry().getEntry().isUnconditional()) {
                                newhop1.setUnconditional();
                            }
                            this.jobMeta.addJobHop(newhop1);
                            this.spoon.addUndoNew((UndoInterface)this.jobMeta, new JobHopMeta[]{newhop1}, new int[]{this.jobMeta.indexOfJobHop(newhop1)}, true);
                        }
                        if (this.jobMeta.findJobHop(this.selectedEntry, hi.getToEntry(), true) == null) {
                            JobHopMeta newhop2 = new JobHopMeta(this.selectedEntry, hi.getToEntry());
                            if (this.selectedEntry.getEntry().isUnconditional()) {
                                newhop2.setUnconditional();
                            }
                            this.jobMeta.addJobHop(newhop2);
                            this.spoon.addUndoNew((UndoInterface)this.jobMeta, new JobHopMeta[]{newhop2}, new int[]{this.jobMeta.indexOfJobHop(newhop2)}, true);
                        }
                        int idx = this.jobMeta.indexOfJobHop(hi);
                        this.spoon.addUndoDelete((UndoInterface)this.jobMeta, new JobHopMeta[]{hi}, new int[]{idx}, true);
                        this.jobMeta.removeJobHop(idx);
                        this.spoon.refreshTree();
                    }
                }
                this.split_hop = false;
            }
            this.selectedEntries = null;
            this.selectedNotes = null;
            this.selectedEntry = null;
            this.selectedNote = null;
            this.startHopEntry = null;
            this.endHopLocation = null;
            this.redraw();
            this.spoon.setShellText();
        } else if (this.selectedNote != null) {
            if (e.button == 1) {
                if (this.lastclick.x == e.x && this.lastclick.y == e.y) {
                    if (control) {
                        this.selectedNote.flipSelected();
                    } else {
                        this.jobMeta.unselectAll();
                        this.selectedNote.setSelected(true);
                    }
                } else {
                    int[] indexes;
                    this.selectedEntries = this.jobMeta.getSelectedEntries();
                    this.selectedNotes = this.jobMeta.getSelectedNotes();
                    boolean also = false;
                    if (this.selectedNotes != null && this.selectedNotes.size() > 0 && this.previous_note_locations != null) {
                        indexes = this.jobMeta.getNoteIndexes(this.selectedNotes);
                        this.addUndoPosition(this.selectedNotes.toArray(new NotePadMeta[this.selectedNotes.size()]), indexes, this.previous_note_locations, this.jobMeta.getSelectedNoteLocations(), also);
                        boolean bl3 = also = this.selectedEntries != null && this.selectedEntries.size() > 0;
                    }
                    if (this.selectedEntries != null && this.selectedEntries.size() > 0 && this.previous_step_locations != null) {
                        indexes = this.jobMeta.getEntryIndexes(this.selectedEntries);
                        this.addUndoPosition(this.selectedEntries.toArray(new JobEntryCopy[this.selectedEntries.size()]), indexes, this.previous_step_locations, this.jobMeta.getSelectedLocations(), also);
                    }
                }
            }
            this.selectedNotes = null;
            this.selectedEntries = null;
            this.selectedEntry = null;
            this.selectedNote = null;
            this.startHopEntry = null;
            this.endHopLocation = null;
        } else {
            AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
            if (areaOwner == null && this.selectionRegion == null) {
                this.clearSettings();
            }
        }
        this.lastButton = 0;
    }

    public void mouseMove(MouseEvent e) {
        int dy;
        JobEntryCopy jobEntryCopy;
        Point real;
        boolean shift = (e.stateMask & 0x20000) != 0;
        this.noInputEntry = null;
        this.toolTip.hide();
        this.lastMove = real = this.screen2real(e.x, e.y);
        if (this.iconoffset == null) {
            this.iconoffset = new Point(0, 0);
        }
        Point icon = new Point(real.x - this.iconoffset.x, real.y - this.iconoffset.y);
        if (this.noteoffset == null) {
            this.noteoffset = new Point(0, 0);
        }
        Point note = new Point(real.x - this.noteoffset.x, real.y - this.noteoffset.y);
        AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
        if (areaOwner != null) {
            jobEntryCopy = null;
            switch (areaOwner.getAreaType()) {
                case JOB_ENTRY_ICON: {
                    jobEntryCopy = (JobEntryCopy)areaOwner.getOwner();
                    this.resetDelayTimer(jobEntryCopy);
                    break;
                }
                case MINI_ICONS_BALLOON: {
                    jobEntryCopy = (JobEntryCopy)areaOwner.getOwner();
                    this.resetDelayTimer(jobEntryCopy);
                    break;
                }
            }
        }
        if (this.selectedEntry != null && !this.selectedEntry.isSelected()) {
            this.jobMeta.unselectAll();
            this.selectedEntry.setSelected(true);
            this.selectedEntries = new ArrayList<JobEntryCopy>();
            this.selectedEntries.add(this.selectedEntry);
            this.previous_step_locations = new Point[]{this.selectedEntry.getLocation()};
            this.redraw();
        } else if (this.selectedNote != null && !this.selectedNote.isSelected()) {
            this.jobMeta.unselectAll();
            this.selectedNote.setSelected(true);
            this.selectedNotes = new ArrayList<NotePadMeta>();
            this.selectedNotes.add(this.selectedNote);
            this.previous_note_locations = new Point[]{this.selectedNote.getLocation()};
            this.redraw();
        } else if (this.selectionRegion != null && this.startHopEntry == null) {
            this.selectionRegion.width = real.x - this.selectionRegion.x;
            this.selectionRegion.height = real.y - this.selectionRegion.y;
            this.redraw();
        } else if (this.selectedEntry != null && this.lastButton == 1 && !shift && this.startHopEntry == null) {
            int i;
            int dx = icon.x - this.selectedEntry.getLocation().x;
            dy = icon.y - this.selectedEntry.getLocation().y;
            JobHopMeta hi = this.findHop(icon.x + this.iconsize / 2, icon.y + this.iconsize / 2, this.selectedEntry);
            if (hi != null) {
                if (!hi.getFromEntry().equals((Object)this.selectedEntry) && !hi.getToEntry().equals((Object)this.selectedEntry)) {
                    this.split_hop = true;
                    this.last_hop_split = hi;
                    hi.split = true;
                }
            } else if (this.last_hop_split != null) {
                this.last_hop_split.split = false;
                this.last_hop_split = null;
                this.split_hop = false;
            }
            this.selectedNotes = this.jobMeta.getSelectedNotes();
            this.selectedEntries = this.jobMeta.getSelectedEntries();
            if (this.selectedEntries != null) {
                for (i = 0; i < this.selectedEntries.size(); ++i) {
                    JobEntryCopy jobEntryCopy2 = this.selectedEntries.get(i);
                    PropsUI.setLocation((GUIPositionInterface)jobEntryCopy2, jobEntryCopy2.getLocation().x + dx, jobEntryCopy2.getLocation().y + dy);
                    this.stopEntryMouseOverDelayTimer(jobEntryCopy2);
                }
            }
            if (this.selectedNotes != null) {
                for (i = 0; i < this.selectedNotes.size(); ++i) {
                    NotePadMeta ni = this.selectedNotes.get(i);
                    PropsUI.setLocation((GUIPositionInterface)ni, ni.getLocation().x + dx, ni.getLocation().y + dy);
                }
            }
            this.redraw();
        } else if (this.startHopEntry != null && this.endHopEntry == null || this.endHopEntry != null && this.startHopEntry == null) {
            jobEntryCopy = this.jobMeta.getJobEntryCopy(real.x, real.y, this.iconsize);
            this.endHopLocation = new Point(real.x, real.y);
            if (jobEntryCopy != null && (this.startHopEntry != null && !this.startHopEntry.equals((Object)jobEntryCopy) || this.endHopEntry != null && !this.endHopEntry.equals((Object)jobEntryCopy))) {
                if (this.hop_candidate == null) {
                    if (this.startHopEntry != null) {
                        if (!jobEntryCopy.isStart()) {
                            this.hop_candidate = new JobHopMeta(this.startHopEntry, jobEntryCopy);
                            this.endHopLocation = null;
                        } else {
                            this.noInputEntry = jobEntryCopy;
                            this.toolTip.setImage(null);
                            this.toolTip.setText("The start entry can only be used at the start of a Job");
                            this.toolTip.show(new org.eclipse.swt.graphics.Point(real.x, real.y));
                        }
                    } else if (this.endHopEntry != null) {
                        this.hop_candidate = new JobHopMeta(jobEntryCopy, this.endHopEntry);
                        this.endHopLocation = null;
                    }
                }
            } else if (this.hop_candidate != null) {
                this.hop_candidate = null;
                this.redraw();
            }
            this.redraw();
        }
        if (this.selectedNote != null && this.lastButton == 1 && !shift) {
            int dx = note.x - this.selectedNote.getLocation().x;
            dy = note.y - this.selectedNote.getLocation().y;
            this.selectedNotes = this.jobMeta.getSelectedNotes();
            this.selectedEntries = this.jobMeta.getSelectedEntries();
            if (this.selectedEntries != null) {
                for (int i = 0; i < this.selectedEntries.size(); ++i) {
                    JobEntryCopy jobEntryCopy3 = this.selectedEntries.get(i);
                    PropsUI.setLocation((GUIPositionInterface)jobEntryCopy3, jobEntryCopy3.getLocation().x + dx, jobEntryCopy3.getLocation().y + dy);
                }
            }
            if (this.selectedNotes != null) {
                for (int i = 0; i < this.selectedNotes.size(); ++i) {
                    NotePadMeta ni = this.selectedNotes.get(i);
                    PropsUI.setLocation((GUIPositionInterface)ni, ni.getLocation().x + dx, ni.getLocation().y + dy);
                }
            }
            this.redraw();
        }
    }

    public void mouseHover(MouseEvent e) {
        boolean tip = true;
        Point real = this.screen2real(e.x, e.y);
        AreaOwner areaOwner = this.getVisibleAreaOwner(real.x, real.y);
        if (areaOwner != null) {
            switch (areaOwner.getAreaType()) {
                case JOB_ENTRY_ICON: {
                    JobEntryCopy jobEntryCopy = (JobEntryCopy)areaOwner.getOwner();
                    if (this.mouseOverEntries.contains(jobEntryCopy)) break;
                    this.addEntryMouseOverDelayTimer(jobEntryCopy);
                    this.redraw();
                    tip = false;
                    break;
                }
            }
        }
        if (tip && !this.helpTip.isVisible()) {
            this.setToolTip(real.x, real.y, e.x, e.y);
        }
    }

    public void mouseEnter(MouseEvent event) {
    }

    public void mouseExit(MouseEvent event) {
    }

    public void mouseScrolled(MouseEvent e) {
    }

    private void addCandidateAsHop() {
        if (this.hop_candidate != null) {
            if (!this.hop_candidate.getFromEntry().evaluates() && this.hop_candidate.getFromEntry().isUnconditional()) {
                this.hop_candidate.setUnconditional();
            } else {
                this.hop_candidate.setConditional();
                int nr = this.jobMeta.findNrNextJobEntries(this.hop_candidate.getFromEntry());
                if (nr == 1) {
                    JobEntryCopy jge = this.jobMeta.findNextJobEntry(this.hop_candidate.getFromEntry(), 0);
                    JobHopMeta other = this.jobMeta.findJobHop(this.hop_candidate.getFromEntry(), jge);
                    if (other != null) {
                        this.hop_candidate.setEvaluation(!other.getEvaluation());
                    }
                }
            }
            if (this.checkIfHopAlreadyExists(this.jobMeta, this.hop_candidate)) {
                this.jobMeta.addJobHop(this.hop_candidate);
                this.spoon.addUndoNew((UndoInterface)this.jobMeta, new JobHopMeta[]{this.hop_candidate}, new int[]{this.jobMeta.indexOfJobHop(this.hop_candidate)});
                this.spoon.refreshTree();
                this.clearSettings();
                this.redraw();
            }
        }
    }

    public boolean checkIfHopAlreadyExists(JobMeta jobMeta, JobHopMeta newHop) {
        boolean ok = true;
        if (jobMeta.findJobHop(newHop.getFromEntry(), newHop.getToEntry(), true) != null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"JobGraph.Dialog.HopExists.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"JobGraph.Dialog.HopExists.Title", (String[])new String[0]));
            mb.open();
            ok = false;
        }
        return ok;
    }

    public AreaOwner getVisibleAreaOwner(int x, int y) {
        for (int i = this.areaOwners.size() - 1; i >= 0; --i) {
            AreaOwner areaOwner = this.areaOwners.get(i);
            if (!areaOwner.contains(x, y)) continue;
            return areaOwner;
        }
        return null;
    }

    private synchronized void addEntryMouseOverDelayTimer(final JobEntryCopy jobEntryCopy) {
        if (this.mouseOverEntries.contains(jobEntryCopy)) {
            return;
        }
        this.mouseOverEntries.add(jobEntryCopy);
        DelayTimer delayTimer = new DelayTimer(500, new DelayListener(){

            @Override
            public void expired() {
                JobGraph.this.mouseOverEntries.remove(jobEntryCopy);
                JobGraph.this.delayTimers.remove(jobEntryCopy);
                JobGraph.this.asyncRedraw();
            }
        }, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                AreaOwner.AreaType areaType;
                AreaOwner areaOwner;
                Point cursor = JobGraph.this.getLastMove();
                if (cursor != null && (areaOwner = JobGraph.this.getVisibleAreaOwner(cursor.x, cursor.y)) != null && ((areaType = areaOwner.getAreaType()) == AreaOwner.AreaType.JOB_ENTRY_ICON || areaType.belongsToJobContextMenu())) {
                    JobEntryCopy selectedJobEntryCopy = (JobEntryCopy)areaOwner.getOwner();
                    return selectedJobEntryCopy == jobEntryCopy;
                }
                return false;
            }
        });
        new Thread(delayTimer).start();
        this.delayTimers.put(jobEntryCopy, delayTimer);
    }

    private void stopEntryMouseOverDelayTimer(JobEntryCopy jobEntryCopy) {
        DelayTimer delayTimer = this.delayTimers.get(jobEntryCopy);
        if (delayTimer != null) {
            delayTimer.stop();
        }
    }

    private void stopEntryMouseOverDelayTimers() {
        for (DelayTimer timer : this.delayTimers.values()) {
            timer.stop();
        }
    }

    private void resetDelayTimer(JobEntryCopy jobEntryCopy) {
        DelayTimer delayTimer = this.delayTimers.get(jobEntryCopy);
        if (delayTimer != null) {
            delayTimer.reset();
        }
    }

    protected void asyncRedraw() {
        this.spoon.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!JobGraph.this.isDisposed()) {
                    JobGraph.this.redraw();
                }
            }
        });
    }

    private void addToolBar() {
        try {
            this.toolbar = (XulToolbar)this.getXulDomContainer().getDocumentRoot().getElementById("nav-toolbar");
            ToolBar swtToolbar = (ToolBar)this.toolbar.getManagedObject();
            swtToolbar.setBackground(GUIResource.getInstance().getColorDemoGray());
            swtToolbar.pack();
            ToolItem sep = new ToolItem(swtToolbar, 2);
            this.zoomLabel = new Combo((Composite)swtToolbar, 4);
            this.zoomLabel.setItems(TransPainter.magnificationDescriptions);
            this.zoomLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    JobGraph.this.readMagnification();
                }
            });
            this.zoomLabel.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (event.character == '\r') {
                        JobGraph.this.readMagnification();
                    }
                }
            });
            this.setZoomLabel();
            this.zoomLabel.pack();
            sep.setWidth(80);
            sep.setControl((Control)this.zoomLabel);
            swtToolbar.pack();
        }
        catch (Throwable t) {
            this.log.logError(Const.getStackTracker((Throwable)t));
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Message", (String[])new String[]{XUL_FILE_JOB_GRAPH}), new Exception(t));
        }
    }

    private void readMagnification() {
        String possibleText = this.zoomLabel.getText();
        possibleText = possibleText.replace("%", "");
        try {
            float possibleFloatMagnification;
            this.magnification = possibleFloatMagnification = Float.parseFloat(possibleText) / 100.0f;
            if (this.zoomLabel.getText().indexOf(37) < 0) {
                this.zoomLabel.setText(this.zoomLabel.getText().concat("%"));
            }
        }
        catch (Exception e) {
            MessageBox mb = new MessageBox(this.shell, 65);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TransGraph.Dialog.InvalidZoomMeasurement.Message", (String[])new String[]{this.zoomLabel.getText()}));
            mb.setText(BaseMessages.getString(PKG, (String)"TransGraph.Dialog.InvalidZoomMeasurement.Title", (String[])new String[0]));
            mb.open();
        }
        this.redraw();
    }

    public void keyPressed(KeyEvent e) {
        List copies;
        if (e.keyCode == 127 && (copies = this.jobMeta.getSelectedEntries()) != null && copies.size() > 0) {
            this.delSelected();
        }
        if (e.keyCode == 0x100000A) {
            this.spoon.browseVersionHistory();
        }
        if (e.keyCode == 0x1000001 && (e.stateMask & SWT.MOD1) != 0) {
            this.alligntop();
        }
        if (e.keyCode == 0x1000002 && (e.stateMask & SWT.MOD1) != 0) {
            this.allignbottom();
        }
        if (e.keyCode == 0x1000003 && (e.stateMask & SWT.MOD1) != 0) {
            this.allignleft();
        }
        if (e.keyCode == 0x1000004 && (e.stateMask & SWT.MOD1) != 0) {
            this.allignright();
        }
        if (e.keyCode == 0x1000004 && (e.stateMask & 0x10000) != 0) {
            this.distributehorizontal();
        }
        if (e.keyCode == 0x1000001 && (e.stateMask & 0x10000) != 0) {
            this.distributevertical();
        }
        if (e.keyCode == 0x1000007 && (e.stateMask & 0x10000) != 0) {
            this.snaptogrid(20);
        }
        if (e.keyCode == 119 && (e.stateMask & SWT.MOD1) != 0 || e.keyCode == 0x100000D && (e.stateMask & SWT.MOD1) != 0) {
            this.spoon.tabCloseSelected();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void selectInRect(JobMeta jobMeta, Rectangle rect) {
        int i;
        for (i = 0; i < jobMeta.nrJobEntries(); ++i) {
            JobEntryCopy je = jobMeta.getJobEntry(i);
            Point p = je.getLocation();
            if ((p.x < rect.x || p.x > rect.x + rect.width) && (p.x < rect.x + rect.width || p.x > rect.x) || (p.y < rect.y || p.y > rect.y + rect.height) && (p.y < rect.y + rect.height || p.y > rect.y)) continue;
            je.setSelected(true);
        }
        for (i = 0; i < jobMeta.nrNotes(); ++i) {
            NotePadMeta ni = jobMeta.getNote(i);
            Point a = ni.getLocation();
            Point b = new Point(a.x + ni.width, a.y + ni.height);
            if (!rect.contains(a.x, a.y) || !rect.contains(b.x, b.y)) continue;
            ni.setSelected(true);
        }
    }

    @Override
    public boolean setFocus() {
        this.xulDomContainer.addEventHandler((XulEventHandler)this);
        return this.canvas.setFocus();
    }

    public void renameJobEntry(JobEntryCopy jobEntry, String newName) {
        JobEntryCopy[] jobs = this.jobMeta.getAllJobGraphEntries(newName);
        if (jobs != null && jobs.length > 0) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.JobEntryNameExists.Message", (String[])new String[]{newName}));
            mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.JobEntryNameExists.Title", (String[])new String[0]));
            mb.open();
        } else {
            jobEntry.setName(newName);
            jobEntry.setChanged();
            this.spoon.refreshTree();
            this.spoon.refreshGraph();
        }
    }

    public static void showOnlyStartOnceMessage(Shell shell) {
        MessageBox mb = new MessageBox(shell, 65);
        mb.setMessage(BaseMessages.getString(PKG, (String)"JobGraph.Dialog.OnlyUseStartOnce.Message", (String[])new String[0]));
        mb.setText(BaseMessages.getString(PKG, (String)"JobGraph.Dialog.OnlyUseStartOnce.Title", (String[])new String[0]));
        mb.open();
    }

    public void delSelected() {
        List copies = this.jobMeta.getSelectedEntries();
        int nrsels = copies.size();
        if (nrsels == 0) {
            return;
        }
        ArrayList<String> stepList = new ArrayList<String>();
        for (int i = 0; i < copies.size(); ++i) {
            stepList.add(((JobEntryCopy)copies.get(i)).toString());
        }
        DeleteMessageBox mb = new DeleteMessageBox(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.DeletionConfirm.Message", (String[])new String[0]), stepList);
        int answer = mb.open();
        if (answer == 64) {
            for (int i = 0; i < copies.size(); ++i) {
                this.spoon.deleteJobEntryCopies(this.jobMeta, (JobEntryCopy)copies.get(i));
            }
            this.spoon.refreshTree();
            this.spoon.refreshGraph();
        }
    }

    public void clearSettings() {
        this.selectedEntry = null;
        this.selectedNote = null;
        this.selectedEntries = null;
        this.selectedNotes = null;
        this.selectionRegion = null;
        this.hop_candidate = null;
        this.last_hop_split = null;
        this.lastButton = 0;
        this.startHopEntry = null;
        this.endHopEntry = null;
        this.iconoffset = null;
        for (int i = 0; i < this.jobMeta.nrJobHops(); ++i) {
            this.jobMeta.getJobHop(i).setSplit(false);
        }
        this.stopEntryMouseOverDelayTimers();
    }

    public Point getRealPosition(Composite canvas, int x, int y) {
        Point p = new Point(0, 0);
        for (Composite follow = canvas; follow != null; follow = follow.getParent()) {
            Point xy = new Point(follow.getLocation().x, follow.getLocation().y);
            p.x += xy.x;
            p.y += xy.y;
        }
        p.x = x - p.x - 8;
        p.y = y - p.y - 48;
        return this.screen2real(p.x, p.y);
    }

    private JobHopMeta findJobHop(int x, int y) {
        return this.findHop(x, y, null);
    }

    private JobHopMeta findHop(int x, int y, JobEntryCopy exclude) {
        JobHopMeta online = null;
        for (int i = 0; i < this.jobMeta.nrJobHops(); ++i) {
            int[] line;
            JobHopMeta hi = this.jobMeta.getJobHop(i);
            JobEntryCopy fs = hi.getFromEntry();
            JobEntryCopy ts = hi.getToEntry();
            if (fs == null || ts == null) {
                return null;
            }
            if (exclude != null && (exclude.equals((Object)fs) || exclude.equals((Object)ts)) || !this.pointOnLine(x, y, line = this.getLine(fs, ts))) continue;
            online = hi;
        }
        return online;
    }

    protected int[] getLine(JobEntryCopy fs, JobEntryCopy ts) {
        if (fs == null || ts == null) {
            return null;
        }
        Point from = fs.getLocation();
        Point to = ts.getLocation();
        this.offset = this.getOffset();
        int x1 = from.x + this.iconsize / 2;
        int y1 = from.y + this.iconsize / 2;
        int x2 = to.x + this.iconsize / 2;
        int y2 = to.y + this.iconsize / 2;
        return new int[]{x1, y1, x2, y2};
    }

    private void showHelpTip(int x, int y, String tipTitle, String tipMessage) {
        this.helpTip.setTitle(tipTitle);
        this.helpTip.setMessage(tipMessage);
        this.helpTip.setCheckBoxMessage(BaseMessages.getString(PKG, (String)"JobGraph.HelpToolTip.DoNotShowAnyMoreCheckBox.Message", (String[])new String[0]));
        org.eclipse.swt.graphics.Point location = new org.eclipse.swt.graphics.Point(x - 5, y - 5);
        this.helpTip.show(location);
    }

    public void setJobEntry(JobEntryCopy jobEntry) {
        this.jobEntry = jobEntry;
    }

    public JobEntryCopy getJobEntry() {
        return this.jobEntry;
    }

    public void openTransformation() {
        JobEntryCopy jobEntryCopy = this.getJobEntry();
        JobEntryInterface entry = jobEntryCopy.getEntry();
        this.openTransformation((JobEntryTrans)entry, jobEntryCopy);
    }

    public void openJob() {
        JobEntryCopy jobEntryCopy = this.getJobEntry();
        JobEntryInterface entry = jobEntryCopy.getEntry();
        this.openJob((JobEntryJob)entry, jobEntryCopy);
    }

    public void newHopClick() {
        this.selectedEntries = null;
        this.newHop();
    }

    public void editEntryClick() {
        this.selectedEntries = null;
        this.editEntry(this.getJobEntry());
    }

    public void editEntryDescription() {
        String message;
        String title = BaseMessages.getString(PKG, (String)"JobGraph.Dialog.EditDescription.Title", (String[])new String[0]);
        EnterTextDialog dd = new EnterTextDialog(this.shell, title, message = BaseMessages.getString(PKG, (String)"JobGraph.Dialog.EditDescription.Message", (String[])new String[0]), this.getJobEntry().getDescription());
        String des = dd.open();
        if (des != null) {
            this.jobEntry.setDescription(des);
            this.jobEntry.setChanged();
            this.spoon.setShellText();
        }
    }

    public void editEntryParallel() {
        JobEntryCopy je = this.getJobEntry();
        JobEntryCopy jeOld = (JobEntryCopy)je.clone_deep();
        je.setLaunchingInParallel(!je.isLaunchingInParallel());
        JobEntryCopy jeNew = (JobEntryCopy)je.clone_deep();
        this.spoon.addUndoChange((UndoInterface)this.jobMeta, new JobEntryCopy[]{jeOld}, new JobEntryCopy[]{jeNew}, new int[]{this.jobMeta.indexOfJobEntry(jeNew)});
        this.jobMeta.setChanged();
        if (this.getJobEntry().isLaunchingInParallel() && "Y".equalsIgnoreCase(this.spoon.props.getCustomParameter(STRING_PARALLEL_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"JobGraph.ParallelJobEntriesWarning.DialogTitle", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"JobGraph.ParallelJobEntriesWarning.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 4, new String[]{BaseMessages.getString(PKG, (String)"JobGraph.ParallelJobEntriesWarning.Option1", (String[])new String[0])}, 0, BaseMessages.getString(PKG, (String)"JobGraph.ParallelJobEntriesWarning.Option2", (String[])new String[0]), "N".equalsIgnoreCase(this.spoon.props.getCustomParameter(STRING_PARALLEL_WARNING_PARAMETER, "Y")));
            MessageDialogWithToggle.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            md.open();
            this.spoon.props.setCustomParameter(STRING_PARALLEL_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
            this.spoon.props.saveProps();
        }
        this.spoon.refreshGraph();
    }

    public void duplicateEntry() throws KettleException {
        if (!this.canDup(this.jobEntry)) {
            JobGraph.showOnlyStartOnceMessage(this.spoon.getShell());
        }
        this.spoon.delegates.jobs.dupeJobEntry(this.jobMeta, this.jobEntry);
    }

    public void copyEntry() {
        if (RepositorySecurityUI.verifyOperations(this.shell, this.spoon.rep, RepositoryOperation.MODIFY_JOB, RepositoryOperation.EXECUTE_JOB)) {
            return;
        }
        List entries = this.jobMeta.getSelectedEntries();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            JobEntryCopy entry = (JobEntryCopy)iterator.next();
            if (this.canDup(entry)) continue;
            iterator.remove();
        }
        this.spoon.delegates.jobs.copyJobEntries(this.jobMeta, entries);
    }

    private boolean canDup(JobEntryCopy entry) {
        return !entry.isStart();
    }

    public void detachEntry() {
        this.detach(this.getJobEntry());
        this.jobMeta.unselectAll();
    }

    public void hideEntry() {
        this.getJobEntry().setDrawn(false);
        if (this.jobEntry.getNr() > 0) {
            int ind = this.jobMeta.indexOfJobEntry(this.jobEntry);
            this.jobMeta.removeJobEntry(ind);
            this.spoon.addUndoDelete((UndoInterface)this.jobMeta, new JobEntryCopy[]{this.getJobEntry()}, new int[]{ind});
        }
        this.redraw();
    }

    public void deleteEntry() {
        this.spoon.deleteJobEntryCopies(this.jobMeta, this.getJobEntry());
        this.redraw();
    }

    protected synchronized void setMenu(int x, int y) {
        this.currentMouseX = x;
        this.currentMouseY = y;
        final JobEntryCopy jobEntry = this.jobMeta.getJobEntryCopy(x, y, this.iconsize);
        this.setJobEntry(jobEntry);
        Document doc = this.xulDomContainer.getDocumentRoot();
        if (jobEntry != null) {
            XulMenupopup menu = (XulMenupopup)doc.getElementById("job-graph-entry");
            if (menu != null) {
                List selection = this.jobMeta.getSelectedEntries();
                int sels = selection.size();
                XulMenuitem item = (XulMenuitem)doc.getElementById("job-graph-entry-newhop");
                item.setDisabled(sels < 2);
                JfaceMenupopup launchMenu = (JfaceMenupopup)doc.getElementById("job-graph-entry-launch-popup");
                String[] referencedObjects = jobEntry.getEntry().getReferencedObjectDescriptions();
                boolean[] enabledObjects = jobEntry.getEntry().isReferencedObjectEnabled();
                launchMenu.setDisabled(Const.isEmpty((String[])referencedObjects));
                launchMenu.removeChildren();
                if (!Const.isEmpty((String[])referencedObjects)) {
                    for (int i = 0; i < referencedObjects.length; ++i) {
                        final int index = i;
                        String referencedObject = referencedObjects[i];
                        Action action = new Action(referencedObject, 4){

                            public void run() {
                                JobGraph.this.loadReferencedObject(jobEntry, index);
                            }
                        };
                        JfaceMenuitem child = new JfaceMenuitem(null, (XulComponent)launchMenu, this.xulDomContainer, referencedObject, i, action);
                        child.setLabel(referencedObject);
                        child.setDisabled(!enabledObjects[i]);
                    }
                }
                item = (XulMenuitem)doc.getElementById("job-graph-entry-align-snap");
                item.setAcceltext("ALT-HOME");
                item.setLabel(BaseMessages.getString(PKG, (String)"JobGraph.PopupMenu.JobEntry.AllignDistribute.SnapToGrid", (String[])new String[0]) + 20 + ")");
                item.setAccesskey("alt-home");
                XulMenu aMenu = (XulMenu)doc.getElementById("job-graph-entry-align");
                if (aMenu != null) {
                    aMenu.setDisabled(sels < 1);
                }
                if ((item = (XulMenuitem)doc.getElementById("job-graph-entry-detach")) != null) {
                    item.setDisabled(!this.jobMeta.isEntryUsedInHops(jobEntry));
                }
                if ((item = (XulMenuitem)doc.getElementById("job-graph-entry-hide")) != null) {
                    item.setDisabled(!jobEntry.isDrawn() || this.jobMeta.isEntryUsedInHops(jobEntry));
                }
                if ((item = (XulMenuitem)doc.getElementById("job-graph-entry-delete")) != null) {
                    item.setDisabled(!jobEntry.isDrawn());
                }
                if ((item = (XulMenuitem)doc.getElementById("job-graph-entry-parallel")) != null) {
                    item.setSelected(jobEntry.isLaunchingInParallel());
                }
                try {
                    JobGraphJobEntryMenuExtension extension = new JobGraphJobEntryMenuExtension(this.xulDomContainer, doc, this.jobMeta, jobEntry, this);
                    ExtensionPointHandler.callExtensionPoint((LogChannelInterface)this.log, (String)KettleExtensionPoint.JobGraphJobEntrySetMenu.id, (Object)extension);
                }
                catch (Exception e) {
                    this.log.logError("Error handling menu right click on job entry through extension point", (Throwable)e);
                }
                ConstUI.displayMenu(menu, (Control)this.canvas);
            }
        } else {
            JobHopMeta hi = this.findJobHop(x, y);
            this.setCurrentHop(hi);
            if (hi != null) {
                XulMenupopup menu = (XulMenupopup)doc.getElementById("job-graph-hop");
                if (menu != null) {
                    XulMenuitem miPopEvalUncond = (XulMenuitem)doc.getElementById("job-graph-hop-evaluation-uncond");
                    XulMenuitem miPopEvalTrue = (XulMenuitem)doc.getElementById("job-graph-hop-evaluation-true");
                    XulMenuitem miPopEvalFalse = (XulMenuitem)doc.getElementById("job-graph-hop-evaluation-false");
                    XulMenuitem miDisHop = (XulMenuitem)doc.getElementById("job-graph-hop-enabled");
                    if (miPopEvalUncond != null && miPopEvalTrue != null && miPopEvalFalse != null) {
                        if (hi.isUnconditional()) {
                            miPopEvalUncond.setSelected(true);
                            miPopEvalTrue.setSelected(false);
                            miPopEvalFalse.setSelected(false);
                        } else if (hi.getEvaluation()) {
                            miPopEvalUncond.setSelected(false);
                            miPopEvalTrue.setSelected(true);
                            miPopEvalFalse.setSelected(false);
                        } else {
                            miPopEvalUncond.setSelected(false);
                            miPopEvalTrue.setSelected(false);
                            miPopEvalFalse.setSelected(true);
                        }
                        if (!hi.getFromEntry().evaluates()) {
                            miPopEvalTrue.setDisabled(true);
                            miPopEvalFalse.setDisabled(true);
                        } else {
                            miPopEvalTrue.setDisabled(false);
                            miPopEvalFalse.setDisabled(false);
                        }
                        if (!hi.getFromEntry().isUnconditional()) {
                            miPopEvalUncond.setDisabled(true);
                        } else {
                            miPopEvalUncond.setDisabled(false);
                        }
                    }
                    if (miDisHop != null) {
                        if (hi.isEnabled()) {
                            miDisHop.setLabel(BaseMessages.getString(PKG, (String)"JobGraph.PopupMenu.Hop.Disable", (String[])new String[0]));
                        } else {
                            miDisHop.setLabel(BaseMessages.getString(PKG, (String)"JobGraph.PopupMenu.Hop.Enable", (String[])new String[0]));
                        }
                    }
                    ConstUI.displayMenu(menu, (Control)this.canvas);
                }
            } else {
                NotePadMeta ni = this.jobMeta.getNote(x, y);
                this.setCurrentNote(ni);
                if (ni != null) {
                    XulMenupopup menu = (XulMenupopup)doc.getElementById("job-graph-note");
                    if (menu != null) {
                        ConstUI.displayMenu(menu, (Control)this.canvas);
                    }
                } else {
                    XulMenupopup menu = (XulMenupopup)doc.getElementById("job-graph-background");
                    if (menu != null) {
                        String clipcontent = this.spoon.fromClipboard();
                        XulMenuitem item = (XulMenuitem)doc.getElementById("job-graph-note-paste");
                        if (item != null) {
                            item.setDisabled(clipcontent == null);
                        }
                        ConstUI.displayMenu(menu, (Control)this.canvas);
                    }
                }
            }
        }
    }

    public void selectAll() {
        this.spoon.editSelectAll();
    }

    public void clearSelection() {
        this.spoon.editUnselectAll();
    }

    public void editJobProperties() {
        JobGraph.editProperties(this.jobMeta, this.spoon, this.spoon.getRepository(), true);
    }

    public void pasteNote() {
        String clipcontent = this.spoon.fromClipboard();
        Point loc = new Point(this.currentMouseX, this.currentMouseY);
        this.spoon.pasteXML(this.jobMeta, clipcontent, loc);
    }

    public void newNote() {
        String message;
        String title = BaseMessages.getString(PKG, (String)"JobGraph.Dialog.EditNote.Title", (String[])new String[0]);
        EnterTextDialog dd = new EnterTextDialog(this.shell, title, message = BaseMessages.getString(PKG, (String)"JobGraph.Dialog.EditNote.Message", (String[])new String[0]), "");
        String n = dd.open();
        if (n != null) {
            NotePadMeta npi = new NotePadMeta(n, this.lastclick.x, this.lastclick.y, 20, 20);
            this.jobMeta.addNote(npi);
            this.spoon.addUndoNew((UndoInterface)this.jobMeta, new NotePadMeta[]{npi}, new int[]{this.jobMeta.indexOfNote(npi)});
            this.redraw();
        }
    }

    public void setCurrentNote(NotePadMeta ni) {
        this.ni = ni;
    }

    public NotePadMeta getCurrentNote() {
        return this.ni;
    }

    public void editNote() {
        this.selectionRegion = null;
        this.editNote(this.getCurrentNote());
    }

    public void deleteNote() {
        this.selectionRegion = null;
        int idx = this.jobMeta.indexOfNote(this.getCurrentNote());
        if (idx >= 0) {
            this.jobMeta.removeNote(idx);
            this.spoon.addUndoDelete((UndoInterface)this.jobMeta, new NotePadMeta[]{this.getCurrentNote()}, new int[]{idx});
        }
        this.redraw();
    }

    public void raiseNote() {
        this.selectionRegion = null;
        int idx = this.jobMeta.indexOfNote(this.getCurrentNote());
        if (idx >= 0) {
            this.jobMeta.raiseNote(idx);
        }
        this.redraw();
    }

    public void lowerNote() {
        this.selectionRegion = null;
        int idx = this.jobMeta.indexOfNote(this.getCurrentNote());
        if (idx >= 0) {
            this.jobMeta.lowerNote(idx);
        }
        this.redraw();
    }

    public void flipHop() {
        this.selectionRegion = null;
        JobEntryCopy dummy = this.currentHop.getFromEntry();
        this.currentHop.setFromEntry(this.currentHop.getToEntry());
        this.currentHop.setToEntry(dummy);
        if (this.jobMeta.hasLoop(this.currentHop.getFromEntry())) {
            this.spoon.refreshGraph();
            MessageBox mb = new MessageBox(this.shell, 72);
            mb.setMessage(BaseMessages.getString(PKG, (String)"JobGraph.Dialog.HopFlipCausesLoop.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"JobGraph.Dialog.HopFlipCausesLoop.Title", (String[])new String[0]));
            mb.open();
            dummy = this.currentHop.getFromEntry();
            this.currentHop.setFromEntry(this.currentHop.getToEntry());
            this.currentHop.setToEntry(dummy);
            this.spoon.refreshGraph();
        } else {
            this.currentHop.setChanged();
            this.spoon.refreshGraph();
            this.spoon.refreshTree();
            this.spoon.setShellText();
        }
    }

    public void disableHop() {
        this.selectionRegion = null;
        this.currentHop.setEnabled(!this.currentHop.isEnabled());
        this.spoon.refreshGraph();
        this.spoon.refreshTree();
    }

    public void deleteHop() {
        this.selectionRegion = null;
        int idx = this.jobMeta.indexOfJobHop(this.currentHop);
        this.jobMeta.removeJobHop(idx);
        this.spoon.refreshTree();
        this.spoon.refreshGraph();
    }

    public void setHopUnconditional() {
        this.currentHop.setUnconditional();
        this.spoon.refreshGraph();
    }

    public void setHopEvaluationTrue() {
        this.currentHop.setConditional();
        this.currentHop.setEvaluation(true);
        this.spoon.refreshGraph();
    }

    public void setHopEvaluationFalse() {
        this.currentHop.setConditional();
        this.currentHop.setEvaluation(false);
        this.spoon.refreshGraph();
    }

    protected void setCurrentHop(JobHopMeta hop) {
        this.currentHop = hop;
    }

    protected JobHopMeta getCurrentHop() {
        return this.currentHop;
    }

    public void enableHopsBetweenSelectedEntries() {
        this.enableHopsBetweenSelectedEntries(true);
    }

    public void disableHopsBetweenSelectedEntries() {
        this.enableHopsBetweenSelectedEntries(false);
    }

    public void enableHopsBetweenSelectedEntries(boolean enabled) {
        List list = this.jobMeta.getSelectedEntries();
        for (int i = 0; i < this.jobMeta.nrJobHops(); ++i) {
            JobHopMeta hop = this.jobMeta.getJobHop(i);
            if (!list.contains(hop.getFromEntry()) || !list.contains(hop.getToEntry())) continue;
            JobHopMeta before = (JobHopMeta)hop.clone();
            hop.setEnabled(enabled);
            JobHopMeta after = (JobHopMeta)hop.clone();
            this.spoon.addUndoChange((UndoInterface)this.jobMeta, new JobHopMeta[]{before}, new JobHopMeta[]{after}, new int[]{this.jobMeta.indexOfJobHop(hop)});
        }
        this.spoon.refreshGraph();
    }

    public void enableHopsDownstream() {
        this.enableDisableHopsDownstream(true);
    }

    public void disableHopsDownstream() {
        this.enableDisableHopsDownstream(false);
    }

    public void enableDisableHopsDownstream(boolean enabled) {
        if (this.currentHop == null) {
            return;
        }
        JobHopMeta before = (JobHopMeta)this.currentHop.clone();
        this.currentHop.setEnabled(enabled);
        JobHopMeta after = (JobHopMeta)this.currentHop.clone();
        this.spoon.addUndoChange((UndoInterface)this.jobMeta, new JobHopMeta[]{before}, new JobHopMeta[]{after}, new int[]{this.jobMeta.indexOfJobHop(this.currentHop)});
        this.enableDisableNextHops(this.currentHop.getToEntry(), enabled, 1);
        this.spoon.refreshGraph();
    }

    private void enableDisableNextHops(JobEntryCopy from, boolean enabled, int level) {
        if (level > 100) {
            return;
        }
        for (JobEntryCopy to : this.jobMeta.getJobCopies()) {
            JobHopMeta hop = this.jobMeta.findJobHop(from, to, true);
            if (hop == null) continue;
            JobHopMeta before = (JobHopMeta)hop.clone();
            hop.setEnabled(enabled);
            JobHopMeta after = (JobHopMeta)hop.clone();
            this.spoon.addUndoChange((UndoInterface)this.jobMeta, new JobHopMeta[]{before}, new JobHopMeta[]{after}, new int[]{this.jobMeta.indexOfJobHop(hop)});
            this.enableDisableNextHops(to, enabled, level++);
        }
    }

    protected void setToolTip(int x, int y, int screenX, int screenY) {
        if (!this.spoon.getProperties().showToolTips()) {
            return;
        }
        this.canvas.setToolTipText("-");
        this.canvas.setToolTipText(null);
        Image tipImage = null;
        JobHopMeta hi = this.findJobHop(x, y);
        StringBuffer tip = new StringBuffer();
        AreaOwner areaOwner = this.getVisibleAreaOwner(x, y);
        if (areaOwner != null) {
            switch (areaOwner.getAreaType()) {
                case JOB_HOP_ICON: {
                    hi = (JobHopMeta)areaOwner.getOwner();
                    if (hi.isUnconditional()) {
                        tipImage = GUIResource.getInstance().getImageUnconditionalHop();
                        tip.append(BaseMessages.getString(PKG, (String)"JobGraph.Hop.Tooltip.Unconditional", (String[])new String[]{hi.getFromEntry().getName(), Const.CR}));
                        break;
                    }
                    if (hi.getEvaluation()) {
                        tip.append(BaseMessages.getString(PKG, (String)"JobGraph.Hop.Tooltip.EvaluatingTrue", (String[])new String[]{hi.getFromEntry().getName(), Const.CR}));
                        tipImage = GUIResource.getInstance().getImageTrue();
                        break;
                    }
                    tip.append(BaseMessages.getString(PKG, (String)"JobGraph.Hop.Tooltip.EvaluatingFalse", (String[])new String[]{hi.getFromEntry().getName(), Const.CR}));
                    tipImage = GUIResource.getInstance().getImageFalse();
                    break;
                }
                case JOB_HOP_PARALLEL_ICON: {
                    hi = (JobHopMeta)areaOwner.getOwner();
                    tip.append(BaseMessages.getString(PKG, (String)"JobGraph.Hop.Tooltip.Parallel", (String[])new String[]{hi.getFromEntry().getName(), Const.CR}));
                    tipImage = GUIResource.getInstance().getImageParallelHop();
                    break;
                }
                case CUSTOM: {
                    String message = (String)areaOwner.getOwner();
                    tip.append(message);
                    tipImage = null;
                    GUIResource.getInstance().getImageTransGraph();
                    break;
                }
                case JOB_ENTRY_MINI_ICON_INPUT: {
                    tip.append(BaseMessages.getString(PKG, (String)"JobGraph.EntryInputConnector.Tooltip", (String[])new String[0]));
                    tipImage = GUIResource.getInstance().getImageHopInput();
                    this.resetDelayTimer((JobEntryCopy)areaOwner.getOwner());
                    break;
                }
                case JOB_ENTRY_MINI_ICON_OUTPUT: {
                    tip.append(BaseMessages.getString(PKG, (String)"JobGraph.EntryOutputConnector.Tooltip", (String[])new String[0]));
                    tipImage = GUIResource.getInstance().getImageHopOutput();
                    this.resetDelayTimer((JobEntryCopy)areaOwner.getOwner());
                    break;
                }
                case JOB_ENTRY_MINI_ICON_EDIT: {
                    tip.append(BaseMessages.getString(PKG, (String)"JobGraph.EditStep.Tooltip", (String[])new String[0]));
                    tipImage = GUIResource.getInstance().getImageEdit();
                    this.resetDelayTimer((JobEntryCopy)areaOwner.getOwner());
                    break;
                }
                case JOB_ENTRY_MINI_ICON_CONTEXT: {
                    tip.append(BaseMessages.getString(PKG, (String)"JobGraph.ShowMenu.Tooltip", (String[])new String[0]));
                    tipImage = GUIResource.getInstance().getImageContextMenu();
                    this.resetDelayTimer((JobEntryCopy)areaOwner.getOwner());
                    break;
                }
                case JOB_ENTRY_RESULT_FAILURE: 
                case JOB_ENTRY_RESULT_SUCCESS: {
                    JobEntryResult jobEntryResult = (JobEntryResult)areaOwner.getOwner();
                    JobEntryCopy jobEntryCopy = (JobEntryCopy)areaOwner.getParent();
                    Result result = jobEntryResult.getResult();
                    tip.append("'").append(jobEntryCopy.getName()).append("' ");
                    if (result.getResult()) {
                        tipImage = GUIResource.getInstance().getImageTrue();
                        tip.append("finished successfully.");
                    } else {
                        tipImage = GUIResource.getInstance().getImageFalse();
                        tip.append("failed.");
                    }
                    tip.append(Const.CR).append("------------------------").append(Const.CR).append(Const.CR);
                    tip.append("Result         : ").append(result.getResult()).append(Const.CR);
                    tip.append("Errors         : ").append(result.getNrErrors()).append(Const.CR);
                    if (result.getNrLinesRead() > 0L) {
                        tip.append("Lines read     : ").append(result.getNrLinesRead()).append(Const.CR);
                    }
                    if (result.getNrLinesWritten() > 0L) {
                        tip.append("Lines written  : ").append(result.getNrLinesWritten()).append(Const.CR);
                    }
                    if (result.getNrLinesInput() > 0L) {
                        tip.append("Lines input    : ").append(result.getNrLinesInput()).append(Const.CR);
                    }
                    if (result.getNrLinesOutput() > 0L) {
                        tip.append("Lines output   : ").append(result.getNrLinesOutput()).append(Const.CR);
                    }
                    if (result.getNrLinesUpdated() > 0L) {
                        tip.append("Lines updated  : ").append(result.getNrLinesUpdated()).append(Const.CR);
                    }
                    if (result.getNrLinesDeleted() > 0L) {
                        tip.append("Lines deleted  : ").append(result.getNrLinesDeleted()).append(Const.CR);
                    }
                    if (result.getNrLinesRejected() > 0L) {
                        tip.append("Lines rejected : ").append(result.getNrLinesRejected()).append(Const.CR);
                    }
                    if (result.getResultFiles() != null && !result.getResultFiles().isEmpty()) {
                        tip.append(Const.CR).append("Result files:").append(Const.CR);
                        if (result.getResultFiles().size() > 10) {
                            tip.append(" (10 files of ").append(result.getResultFiles().size()).append(" shown");
                        }
                        ArrayList files = new ArrayList(result.getResultFiles().values());
                        for (int i = 0; i < files.size(); ++i) {
                            ResultFile file = (ResultFile)files.get(i);
                            tip.append("  - ").append(file.toString()).append(Const.CR);
                        }
                    }
                    if (result.getRows() == null || result.getRows().isEmpty()) break;
                    tip.append(Const.CR).append("Result rows: ");
                    if (result.getRows().size() > 10) {
                        tip.append(" (10 rows of ").append(result.getRows().size()).append(" shown");
                    }
                    tip.append(Const.CR);
                    for (int i = 0; i < result.getRows().size() && i < 10; ++i) {
                        RowMetaAndData row = (RowMetaAndData)result.getRows().get(i);
                        tip.append("  - ").append(row.toString()).append(Const.CR);
                    }
                    break;
                }
                case JOB_ENTRY_RESULT_CHECKPOINT: {
                    tip.append("The job started here since this is the furthest checkpoint that was reached last time the transformation was executed.");
                    tipImage = GUIResource.getInstance().getImageCheckpoint();
                    break;
                }
            }
        }
        if (hi != null && tip.length() == 0) {
            tip.append(BaseMessages.getString(PKG, (String)"JobGraph.Dialog.HopInfo", (String[])new String[0])).append(Const.CR);
            tip.append(BaseMessages.getString(PKG, (String)"JobGraph.Dialog.HopInfo.SourceEntry", (String[])new String[0])).append(" ").append(hi.getFromEntry().getName()).append(Const.CR);
            tip.append(BaseMessages.getString(PKG, (String)"JobGraph.Dialog.HopInfo.TargetEntry", (String[])new String[0])).append(" ").append(hi.getToEntry().getName()).append(Const.CR);
            tip.append(BaseMessages.getString(PKG, (String)"TransGraph.Dialog.HopInfo.Status", (String[])new String[0])).append(" ");
            tip.append(hi.isEnabled() ? BaseMessages.getString(PKG, (String)"JobGraph.Dialog.HopInfo.Enable", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"JobGraph.Dialog.HopInfo.Disable", (String[])new String[0]));
            tipImage = hi.isUnconditional() ? GUIResource.getInstance().getImageUnconditionalHop() : (hi.getEvaluation() ? GUIResource.getInstance().getImageTrue() : GUIResource.getInstance().getImageFalse());
        }
        if (tip == null || tip.length() == 0) {
            this.toolTip.hide();
        } else if (!tip.toString().equalsIgnoreCase(this.getToolTipText())) {
            if (tipImage != null) {
                this.toolTip.setImage(tipImage);
            } else {
                this.toolTip.setImage(GUIResource.getInstance().getImageSpoon());
            }
            this.toolTip.setText(tip.toString());
            this.toolTip.hide();
            this.toolTip.show(new org.eclipse.swt.graphics.Point(screenX, screenY));
        }
    }

    public void launchStuff(JobEntryCopy jobEntryCopy) {
        String[] references = jobEntryCopy.getEntry().getReferencedObjectDescriptions();
        if (!Const.isEmpty((String[])references)) {
            this.loadReferencedObject(jobEntryCopy, 0);
        }
    }

    public void launchStuff() {
        if (this.jobEntry != null) {
            this.launchStuff(this.jobEntry);
        }
    }

    protected void loadReferencedObject(JobEntryCopy jobEntryCopy, int index) {
        try {
            Object referencedMeta = jobEntryCopy.getEntry().loadReferencedObject(index, this.spoon.rep, (IMetaStore)this.spoon.metaStore, (VariableSpace)this.jobMeta);
            if (referencedMeta == null) {
                referencedMeta = this.compatibleJobEntryLoadReferencedObject(jobEntryCopy.getEntry(), index, this.spoon.rep, this.jobMeta);
            }
            if (referencedMeta != null && referencedMeta instanceof TransMeta) {
                TransMeta launchTransMeta = (TransMeta)referencedMeta;
                TabMapEntry tabEntry = this.spoon.delegates.tabs.findTabForTransformation(launchTransMeta);
                if (tabEntry != null) {
                    this.spoon.tabfolder.setSelected(tabEntry.getTabItem());
                    return;
                }
                JobGraph.copyInternalJobVariables(this.jobMeta, launchTransMeta);
                this.spoon.setParametersAsVariablesInUI((NamedParams)launchTransMeta, (VariableSpace)launchTransMeta);
                launchTransMeta.clearChanged();
                this.spoon.addTransGraph(launchTransMeta);
                TransGraph transGraph = this.spoon.getActiveTransGraph();
                this.attachActiveTrans(transGraph, launchTransMeta, jobEntryCopy);
                this.spoon.refreshTree();
                this.spoon.applyVariables();
            }
            if (referencedMeta != null && referencedMeta instanceof JobMeta) {
                JobMeta launchJobMeta = (JobMeta)referencedMeta;
                String tabName = this.spoon.delegates.tabs.makeTabName((EngineMetaInterface)launchJobMeta, true);
                TabMapEntry tabEntry = this.spoon.delegates.tabs.findTabMapEntry(tabName, TabMapEntry.ObjectType.JOB_GRAPH);
                if (tabEntry != null) {
                    this.spoon.tabfolder.setSelected(tabEntry.getTabItem());
                    return;
                }
                this.spoon.setParametersAsVariablesInUI((NamedParams)launchJobMeta, (VariableSpace)launchJobMeta);
                launchJobMeta.clearChanged();
                this.spoon.addJobGraph(launchJobMeta);
                JobGraph jobGraph = this.spoon.getActiveJobGraph();
                this.attachActiveJob(jobGraph, launchJobMeta, jobEntryCopy);
                this.spoon.refreshTree();
                this.spoon.applyVariables();
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JobGraph.Dialog.ErrorLaunchingSpoonCanNotLoadTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobGraph.Dialog.ErrorLaunchingSpoonCanNotLoadTransformation.Message", (String[])new String[0]), e);
        }
    }

    private Object compatibleJobEntryLoadReferencedObject(JobEntryInterface entry, int index, Repository rep, JobMeta jobMeta2) throws KettleException {
        return entry.loadReferencedObject(index, this.spoon.rep, (VariableSpace)this.jobMeta);
    }

    protected void openTransformation(JobEntryTrans entry, JobEntryCopy jobEntryCopy) {
        try {
            TransMeta launchTransMeta = null;
            switch (entry.getSpecificationMethod()) {
                case FILENAME: {
                    String exactFilename = this.jobMeta.environmentSubstitute(entry.getFilename());
                    if (Const.isEmpty((String)exactFilename)) {
                        throw new Exception(BaseMessages.getString(PKG, (String)"JobGraph.Exception.NoFilenameSpecified", (String[])new String[0]));
                    }
                    launchTransMeta = KettleVFS.fileExists((String)exactFilename) ? new TransMeta(exactFilename) : new TransMeta();
                    launchTransMeta.setFilename(exactFilename);
                    break;
                }
                case REPOSITORY_BY_NAME: {
                    boolean exists;
                    String exactTransname = this.jobMeta.environmentSubstitute(entry.getTransname());
                    String exactDirectory = this.jobMeta.environmentSubstitute(entry.getDirectory());
                    if (Const.isEmpty((String)exactTransname)) {
                        throw new Exception(BaseMessages.getString(PKG, (String)"JobGraph.Exception.NoTransNameSpecified", (String[])new String[0]));
                    }
                    if (Const.isEmpty((String)exactDirectory)) {
                        throw new Exception(BaseMessages.getString(PKG, (String)"JobGraph.Exception.NoTransDirectorySpecified", (String[])new String[0]));
                    }
                    RepositoryDirectoryInterface repositoryDirectoryInterface = this.spoon.rep.findDirectory(this.jobMeta.environmentSubstitute(entry.getDirectory()));
                    if (repositoryDirectoryInterface == null) {
                        throw new Exception(BaseMessages.getString(PKG, (String)"JobGraph.Exception.DirectoryDoesNotExist", (String[])new String[]{this.jobMeta.environmentSubstitute(entry.getDirectory())}));
                    }
                    boolean bl = exists = this.spoon.rep.getTransformationID(exactTransname, repositoryDirectoryInterface) != null;
                    if (!exists) {
                        launchTransMeta = new TransMeta(null, exactTransname);
                        break;
                    }
                    launchTransMeta = this.spoon.rep.loadTransformation(exactTransname, this.spoon.rep.findDirectory(this.jobMeta.environmentSubstitute(entry.getDirectory())), null, true, null);
                    break;
                }
                case REPOSITORY_BY_REFERENCE: {
                    if (entry.getTransObjectId() == null) {
                        throw new Exception(BaseMessages.getString(PKG, (String)"JobGraph.Exception.NoTransReferenceSpecified", (String[])new String[0]));
                    }
                    launchTransMeta = this.spoon.rep.loadTransformation(entry.getTransObjectId(), null);
                    break;
                }
            }
            if (launchTransMeta == null) {
                throw new Exception(BaseMessages.getString(PKG, (String)"JobGraph.Exception.NoValidTransSpecified", (String[])new String[0]));
            }
            launchTransMeta.setRepository(this.spoon.getRepository());
            launchTransMeta.setMetaStore((IMetaStore)this.spoon.getMetaStore());
            TabMapEntry tabEntry = this.spoon.delegates.tabs.findTabForTransformation(launchTransMeta);
            if (tabEntry != null) {
                this.spoon.tabfolder.setSelected(tabEntry.getTabItem());
                return;
            }
            JobGraph.copyInternalJobVariables(this.jobMeta, launchTransMeta);
            this.spoon.setParametersAsVariablesInUI((NamedParams)launchTransMeta, (VariableSpace)launchTransMeta);
            this.spoon.addTransGraph(launchTransMeta);
            launchTransMeta.clearChanged();
            TransGraph transGraph = this.spoon.getActiveTransGraph();
            this.attachActiveTrans(transGraph, launchTransMeta, jobEntryCopy);
            this.spoon.refreshTree();
            this.spoon.applyVariables();
        }
        catch (Throwable e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JobGraph.Dialog.ErrorLaunchingSpoonCanNotLoadTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobGraph.Dialog.ErrorLaunchingSpoonCanNotLoadTransformation.Message", (String[])new String[0]), (Exception)e);
        }
    }

    public void openJob(JobEntryJob entry, JobEntryCopy jobEntryCopy) {
        try {
            JobMeta launchJobMeta = null;
            switch (entry.getSpecificationMethod()) {
                case FILENAME: {
                    String exactFilename = this.jobMeta.environmentSubstitute(entry.getFilename());
                    if (Const.isEmpty((String)exactFilename)) {
                        throw new Exception(BaseMessages.getString(PKG, (String)"JobGraph.Exception.NoFilenameSpecified", (String[])new String[0]));
                    }
                    launchJobMeta = KettleVFS.fileExists((String)exactFilename) ? new JobMeta((VariableSpace)this.jobMeta, exactFilename, this.spoon.rep, (IMetaStore)this.spoon.metaStore, null) : new JobMeta();
                    launchJobMeta.setFilename(exactFilename);
                    break;
                }
                case REPOSITORY_BY_NAME: {
                    String exactJobname = this.jobMeta.environmentSubstitute(entry.getJobName());
                    String exactDirectory = this.jobMeta.environmentSubstitute(entry.getDirectory());
                    if (Const.isEmpty((String)exactJobname)) {
                        throw new Exception(BaseMessages.getString(PKG, (String)"JobGraph.Exception.NoJobNameSpecified", (String[])new String[0]));
                    }
                    if (Const.isEmpty((String)exactDirectory)) {
                        throw new Exception(BaseMessages.getString(PKG, (String)"JobGraph.Exception.NoJobDirectorySpecified", (String[])new String[0]));
                    }
                    RepositoryDirectoryInterface repDir = this.spoon.rep.findDirectory(entry.getDirectory());
                    boolean exists = this.spoon.rep.exists(exactJobname, repDir, RepositoryObjectType.JOB);
                    if (!exists) {
                        launchJobMeta = new JobMeta();
                        launchJobMeta.setName(exactJobname);
                        launchJobMeta.setRepositoryDirectory(repDir);
                        break;
                    }
                    launchJobMeta = this.spoon.rep.loadJob(exactJobname, repDir, null, null);
                    break;
                }
                case REPOSITORY_BY_REFERENCE: {
                    if (entry.getJobObjectId() == null) {
                        throw new Exception(BaseMessages.getString(PKG, (String)"JobGraph.Exception.NoJobReferenceSpecified", (String[])new String[0]));
                    }
                    launchJobMeta = this.spoon.rep.loadJob(entry.getJobObjectId(), null);
                    break;
                }
            }
            if (launchJobMeta == null) {
                throw new Exception(BaseMessages.getString(PKG, (String)"JobGraph.Exception.NoValidJobSpecified", (String[])new String[0]));
            }
            launchJobMeta.setRepository(this.spoon.getRepository());
            launchJobMeta.setMetaStore((IMetaStore)this.spoon.getMetaStore());
            String tabName = this.spoon.delegates.tabs.makeTabName((EngineMetaInterface)launchJobMeta, true);
            TabMapEntry tabEntry = this.spoon.delegates.tabs.findTabMapEntry(tabName, TabMapEntry.ObjectType.JOB_GRAPH);
            if (tabEntry != null) {
                this.spoon.tabfolder.setSelected(tabEntry.getTabItem());
                return;
            }
            this.spoon.setParametersAsVariablesInUI((NamedParams)launchJobMeta, (VariableSpace)launchJobMeta);
            this.spoon.addJobGraph(launchJobMeta);
            launchJobMeta.clearChanged();
            JobGraph jobGraph = this.spoon.getActiveJobGraph();
            this.attachActiveJob(jobGraph, launchJobMeta, jobEntryCopy);
            this.spoon.refreshTree();
            this.spoon.applyVariables();
        }
        catch (Throwable e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JobGraph.Dialog.ErrorLaunchingChefCanNotLoadJob.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobGraph.Dialog.ErrorLaunchingChefCanNotLoadJob.Message", (String[])new String[0]), e);
        }
    }

    private void attachActiveTrans(TransGraph transGraph, TransMeta newTrans, JobEntryCopy jobEntryCopy) {
        if (this.job != null && transGraph != null) {
            Trans trans = this.spoon.findActiveTrans(this.job, jobEntryCopy);
            transGraph.setTrans(trans);
            if (!transGraph.isExecutionResultsPaneVisible()) {
                transGraph.showExecutionResults();
            }
            transGraph.setControlStates();
        }
    }

    private void attachActiveJob(JobGraph jobGraph, JobMeta newJobMeta, JobEntryCopy jobEntryCopy) {
        Job subJob;
        if (this.job != null && jobGraph != null && (subJob = this.spoon.findActiveJob(this.job, jobEntryCopy)) != null) {
            jobGraph.setJob(subJob);
            jobGraph.jobGridDelegate.setJobTracker(subJob.getJobTracker());
            if (!jobGraph.isExecutionResultsPaneVisible()) {
                jobGraph.showExecutionResults();
            }
            jobGraph.setControlStates();
        }
    }

    public synchronized void setJob(Job job) {
        this.job = job;
    }

    public static void copyInternalJobVariables(JobMeta sourceJobMeta, TransMeta targetTransMeta) {
        String[] internalVariables;
        for (String variableName : internalVariables = Const.INTERNAL_JOB_VARIABLES) {
            targetTransMeta.setVariable(variableName, sourceJobMeta.getVariable(variableName));
        }
    }

    public void paintControl(PaintEvent e) {
        Point area = this.getArea();
        if (area.x == 0 || area.y == 0) {
            return;
        }
        Display disp = this.shell.getDisplay();
        Image img = this.getJobImage((Device)disp, area.x, area.y, this.magnification);
        e.gc.drawImage(img, 0, 0);
        if (this.jobMeta.nrJobEntries() == 0) {
            e.gc.setForeground(GUIResource.getInstance().getColorCrystalTextPentaho());
            e.gc.setBackground(GUIResource.getInstance().getColorBackground());
            e.gc.setFont(GUIResource.getInstance().getFontMedium());
            String message = BaseMessages.getString(PKG, (String)"JobGraph.EmptyJob.Message", (String[])new String[0]);
            Image pentahoImage = GUIResource.getInstance().getImageDropHere();
            org.eclipse.swt.graphics.Point messageSize = e.gc.textExtent(message);
            int leftPosition = (area.x - messageSize.x - pentahoImage.getBounds().width - 10) / 2;
            int topPosition = (area.y - messageSize.y) / 2;
            e.gc.drawText(message, leftPosition, topPosition);
            e.gc.drawImage(pentahoImage, leftPosition - pentahoImage.getBounds().width - 10, topPosition + messageSize.y / 2 - pentahoImage.getBounds().height / 2);
        }
        img.dispose();
    }

    public Image getJobImage(Device device, int x, int y, float magnificationFactor) {
        SWTGC gc = new SWTGC(device, new Point(x, y), this.iconsize);
        JobPainter jobPainter = new JobPainter((GCInterface)gc, this.jobMeta, new Point(x, y), (ScrollBarInterface)new SwtScrollBar(this.hori), (ScrollBarInterface)new SwtScrollBar(this.vert), this.hop_candidate, this.drop_candidate, this.selectionRegion, this.areaOwners, this.mouseOverEntries, PropsUI.getInstance().getIconSize(), PropsUI.getInstance().getLineWidth(), PropsUI.getInstance().getCanvasGridSize(), PropsUI.getInstance().getShadowSize(), PropsUI.getInstance().isAntiAliasingEnabled(), PropsUI.getInstance().getNoteFont().getName(), PropsUI.getInstance().getNoteFont().getHeight());
        jobPainter.setMagnification(magnificationFactor);
        jobPainter.setEntryLogMap(this.entryLogMap);
        jobPainter.setStartHopEntry(this.startHopEntry);
        jobPainter.setEndHopLocation(this.endHopLocation);
        jobPainter.setEndHopEntry(this.endHopEntry);
        jobPainter.setNoInputEntry(this.noInputEntry);
        if (this.job != null) {
            jobPainter.setJobEntryResults(this.job.getJobEntryResults());
        } else {
            jobPainter.setJobEntryResults(new ArrayList());
        }
        ArrayList activeJobEntries = new ArrayList();
        if (this.job != null) {
            if (this.job.getActiveJobEntryJobs().size() > 0) {
                activeJobEntries.addAll(this.job.getActiveJobEntryJobs().keySet());
            }
            if (this.job.getActiveJobEntryTransformations().size() > 0) {
                activeJobEntries.addAll(this.job.getActiveJobEntryTransformations().keySet());
            }
        }
        jobPainter.setActiveJobEntries(activeJobEntries);
        jobPainter.drawJob();
        return (Image)gc.getImage();
    }

    @Override
    protected Point getOffset() {
        Point area = this.getArea();
        Point max = this.jobMeta.getMaximum();
        Point thumb = this.getThumb(area, max);
        return this.getOffset(thumb, area);
    }

    protected void newHop() {
        List selection = this.jobMeta.getSelectedEntries();
        if (selection == null || selection.size() < 2) {
            return;
        }
        JobEntryCopy fr = (JobEntryCopy)selection.get(0);
        JobEntryCopy to = (JobEntryCopy)selection.get(1);
        this.spoon.newJobHop(this.jobMeta, fr, to);
    }

    protected void editEntry(JobEntryCopy je) {
        this.spoon.editJobEntry(this.jobMeta, je);
    }

    protected void editNote(NotePadMeta ni) {
        NotePadMeta before = (NotePadMeta)ni.clone();
        String title = BaseMessages.getString(PKG, (String)"JobGraph.Dialog.EditNote.Title", (String[])new String[0]);
        NotePadDialog dd = new NotePadDialog((VariableSpace)this.jobMeta, this.shell, title, ni);
        NotePadMeta n = dd.open();
        if (n != null) {
            ni.setChanged();
            ni.setNote(n.getNote());
            ni.setFontName(n.getFontName());
            ni.setFontSize(n.getFontSize());
            ni.setFontBold(n.isFontBold());
            ni.setFontItalic(n.isFontItalic());
            ni.setFontColorRed(n.getFontColorRed());
            ni.setFontColorGreen(n.getFontColorGreen());
            ni.setFontColorBlue(n.getFontColorBlue());
            ni.setBackGroundColorRed(n.getBackGroundColorRed());
            ni.setBackGroundColorGreen(n.getBackGroundColorGreen());
            ni.setBackGroundColorBlue(n.getBackGroundColorBlue());
            ni.setBorderColorRed(n.getBorderColorRed());
            ni.setBorderColorGreen(n.getBorderColorGreen());
            ni.setBorderColorBlue(n.getBorderColorBlue());
            ni.setDrawShadow(n.isDrawShadow());
            this.spoon.addUndoChange((UndoInterface)this.jobMeta, new NotePadMeta[]{before}, new NotePadMeta[]{ni}, new int[]{this.jobMeta.indexOfNote(ni)});
            ni.width = 20;
            ni.height = 20;
            this.spoon.refreshGraph();
        }
    }

    protected void drawArrow(GC gc, int[] line) {
        int x1 = line[0] + this.offset.x;
        int y1 = line[1] + this.offset.y;
        int x2 = line[2] + this.offset.x;
        int y2 = line[3] + this.offset.y;
        gc.drawLine(x1, y1, x2, y2);
        int a = Math.abs(x2 - x1);
        int b = Math.abs(y2 - y1);
        int dist = (int)Math.sqrt(a * a + b * b);
        double factor = dist >= 2 * this.iconsize ? 1.5 : 1.2;
        int mx = (int)((double)x1 + factor * (double)(x2 - x1) / 2.0);
        int my = (int)((double)y1 + factor * (double)(y2 - y1) / 2.0);
        double angle = Math.atan2(y2 - y1, x2 - x1) + Math.PI;
        int x3 = (int)((double)mx + Math.cos(angle - theta) * 30.0);
        int y3 = (int)((double)my + Math.sin(angle - theta) * 30.0);
        int x4 = (int)((double)mx + Math.cos(angle + theta) * 30.0);
        int y4 = (int)((double)my + Math.sin(angle + theta) * 30.0);
        Color fore = gc.getForeground();
        Color back = gc.getBackground();
        gc.setBackground(fore);
        gc.fillPolygon(new int[]{mx, my, x3, y3, x4, y4});
        gc.setBackground(back);
    }

    protected boolean pointOnLine(int x, int y, int[] line) {
        int pm = 4;
        boolean retval = false;
        for (int dx = -pm; dx <= pm && !retval; ++dx) {
            for (int dy = -pm; dy <= pm && !retval; ++dy) {
                retval = this.pointOnThinLine(x + dx, y + dy, line);
            }
        }
        return retval;
    }

    protected boolean pointOnThinLine(int x, int y, int[] line) {
        int x1 = line[0];
        int y1 = line[1];
        int x2 = line[2];
        int y2 = line[3];
        if (!((x >= x1 && x <= x2 || x >= x2 && x <= x1) && (y >= y1 && y <= y2 || y >= y2 && y <= y1))) {
            return false;
        }
        double angle_line = Math.atan2(y2 - y1, x2 - x1) + Math.PI;
        double angle_point = Math.atan2(y - y1, x - x1) + Math.PI;
        return angle_point >= angle_line - 0.01 && angle_point <= angle_line + 0.01;
    }

    protected SnapAllignDistribute createSnapAllignDistribute() {
        List elements = this.jobMeta.getSelectedEntries();
        int[] indices = this.jobMeta.getEntryIndexes(elements);
        return new SnapAllignDistribute((UndoInterface)this.jobMeta, elements, indices, (AddUndoPositionInterface)this.spoon, (Redrawable)this);
    }

    public void snaptogrid() {
        this.snaptogrid(20);
    }

    protected void snaptogrid(int size) {
        this.createSnapAllignDistribute().snaptogrid(size);
    }

    public void allignleft() {
        this.createSnapAllignDistribute().allignleft();
    }

    public void allignright() {
        this.createSnapAllignDistribute().allignright();
    }

    public void alligntop() {
        this.createSnapAllignDistribute().alligntop();
    }

    public void allignbottom() {
        this.createSnapAllignDistribute().allignbottom();
    }

    public void distributehorizontal() {
        this.createSnapAllignDistribute().distributehorizontal();
    }

    public void distributevertical() {
        this.createSnapAllignDistribute().distributevertical();
    }

    protected void drawRect(GC gc, org.eclipse.swt.graphics.Rectangle rect) {
        if (rect == null) {
            return;
        }
        gc.setLineStyle(4);
        gc.setLineWidth(1);
        gc.setForeground(GUIResource.getInstance().getColorDarkGray());
        Point s = new Point(rect.x + this.offset.x, rect.y + this.offset.y);
        if (rect.width < 0) {
            s.x += rect.width;
        }
        if (rect.height < 0) {
            s.y += rect.height;
        }
        gc.drawRoundRectangle(s.x, s.y, Math.abs(rect.width), Math.abs(rect.height), 3, 3);
        gc.setLineStyle(1);
    }

    protected void detach(JobEntryCopy je) {
        int toidx;
        int fromidx;
        JobHopMeta hfrom = this.jobMeta.findJobHopTo(je);
        JobHopMeta hto = this.jobMeta.findJobHopFrom(je);
        if (hfrom != null && hto != null && this.jobMeta.findJobHop(hfrom.getFromEntry(), hto.getToEntry()) == null) {
            JobHopMeta hnew = new JobHopMeta(hfrom.getFromEntry(), hto.getToEntry());
            this.jobMeta.addJobHop(hnew);
            this.spoon.addUndoNew((UndoInterface)this.jobMeta, new JobHopMeta[]{(JobHopMeta)hnew.clone()}, new int[]{this.jobMeta.indexOfJobHop(hnew)});
        }
        if (hfrom != null && (fromidx = this.jobMeta.indexOfJobHop(hfrom)) >= 0) {
            this.jobMeta.removeJobHop(fromidx);
            this.spoon.addUndoDelete((UndoInterface)this.jobMeta, new JobHopMeta[]{hfrom}, new int[]{fromidx});
        }
        if (hto != null && (toidx = this.jobMeta.indexOfJobHop(hto)) >= 0) {
            this.jobMeta.removeJobHop(toidx);
            this.spoon.addUndoDelete((UndoInterface)this.jobMeta, new JobHopMeta[]{hto}, new int[]{toidx});
        }
        this.spoon.refreshTree();
        this.redraw();
    }

    public void newProps() {
        this.iconsize = this.spoon.props.getIconSize();
        this.linewidth = this.spoon.props.getLineWidth();
    }

    public String toString() {
        if (this.jobMeta == null) {
            return Spoon.APP_NAME;
        }
        return this.jobMeta.getName();
    }

    @Override
    public EngineMetaInterface getMeta() {
        return this.jobMeta;
    }

    public void setJobMeta(JobMeta jobMeta) {
        this.jobMeta = jobMeta;
    }

    @Override
    public boolean applyChanges() throws KettleException {
        return this.spoon.saveToFile((EngineMetaInterface)this.jobMeta);
    }

    @Override
    public boolean canBeClosed() {
        return !this.jobMeta.hasChanged();
    }

    public JobMeta getManagedObject() {
        return this.jobMeta;
    }

    @Override
    public boolean hasContentChanged() {
        return this.jobMeta.hasChanged();
    }

    public static int showChangedWarning(Shell shell, String name) {
        MessageBox mb = new MessageBox(shell, 456);
        mb.setMessage(BaseMessages.getString(PKG, (String)"JobGraph.Dialog.PromptSave.Message", (String[])new String[]{name}));
        mb.setText(BaseMessages.getString(PKG, (String)"JobGraph.Dialog.PromptSave.Title", (String[])new String[0]));
        return mb.open();
    }

    public static boolean editProperties(JobMeta jobMeta, Spoon spoon, Repository rep, boolean allowDirectoryChange) {
        if (jobMeta == null) {
            return false;
        }
        JobDialog jd = new JobDialog(spoon.getShell(), 0, jobMeta, rep);
        jd.setDirectoryChangeAllowed(allowDirectoryChange);
        JobMeta ji = jd.open();
        if (jd.isSharedObjectsFileChanged()) {
            try {
                SharedObjects sharedObjects = rep != null ? rep.readJobMetaSharedObjects(jobMeta) : jobMeta.readSharedObjects();
                spoon.sharedObjectsFileMap.put(sharedObjects.getFilename(), sharedObjects);
            }
            catch (Exception e) {
                new ErrorDialog(spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorReadingSharedObjects.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorReadingSharedObjects.Message", (String[])new String[]{spoon.delegates.tabs.makeTabName((EngineMetaInterface)jobMeta, true)}), e);
            }
        }
        spoon.setParametersAsVariablesInUI((NamedParams)jobMeta, (VariableSpace)jobMeta);
        if (jd.isSharedObjectsFileChanged() || ji != null) {
            spoon.refreshTree();
            spoon.delegates.tabs.renameTabs();
        }
        spoon.setShellText();
        return ji != null;
    }

    public Point getLastMove() {
        return this.lastMove;
    }

    public void setLastMove(Point lastMove) {
        this.lastMove = lastMove;
    }

    public void addExtraView() {
        this.extraViewComposite = new Composite((Composite)this.sashForm, 0);
        FormLayout extraCompositeFormLayout = new FormLayout();
        extraCompositeFormLayout.marginWidth = 2;
        extraCompositeFormLayout.marginHeight = 2;
        this.extraViewComposite.setLayout((Layout)extraCompositeFormLayout);
        this.closeButton = new Label(this.extraViewComposite, 0);
        this.closeButton.setImage(GUIResource.getInstance().getImageClosePanel());
        this.closeButton.setToolTipText(BaseMessages.getString(PKG, (String)"JobGraph.ExecutionResultsPanel.CloseButton.Tooltip", (String[])new String[0]));
        FormData fdClose = new FormData();
        fdClose.right = new FormAttachment(100, 0);
        fdClose.top = new FormAttachment(0, 0);
        this.closeButton.setLayoutData((Object)fdClose);
        this.closeButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                JobGraph.this.disposeExtraView();
            }
        });
        this.minMaxButton = new Label(this.extraViewComposite, 0);
        this.minMaxButton.setImage(GUIResource.getInstance().getImageMaximizePanel());
        this.minMaxButton.setToolTipText(BaseMessages.getString(PKG, (String)"JobGraph.ExecutionResultsPanel.MaxButton.Tooltip", (String[])new String[0]));
        FormData fdMinMax = new FormData();
        fdMinMax.right = new FormAttachment((Control)this.closeButton, -4);
        fdMinMax.top = new FormAttachment(0, 0);
        this.minMaxButton.setLayoutData((Object)fdMinMax);
        this.minMaxButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                JobGraph.this.minMaxExtraView();
            }
        });
        Label wResultsLabel = new Label(this.extraViewComposite, 16384);
        wResultsLabel.setFont(GUIResource.getInstance().getFontMediumBold());
        wResultsLabel.setBackground(GUIResource.getInstance().getColorWhite());
        wResultsLabel.setText(BaseMessages.getString(PKG, (String)"JobLog.ResultsPanel.NameLabel", (String[])new String[0]));
        FormData fdResultsLabel = new FormData();
        fdResultsLabel.left = new FormAttachment(0, 0);
        fdResultsLabel.right = new FormAttachment(100, 0);
        fdResultsLabel.top = new FormAttachment(0, 0);
        wResultsLabel.setLayoutData((Object)fdResultsLabel);
        this.extraViewTabFolder = new CTabFolder(this.extraViewComposite, 2);
        this.spoon.props.setLook((Control)this.extraViewTabFolder, 5);
        this.extraViewTabFolder.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                if (JobGraph.this.sashForm.getMaximizedControl() == null) {
                    JobGraph.this.sashForm.setMaximizedControl((Control)JobGraph.this.extraViewComposite);
                } else {
                    JobGraph.this.sashForm.setMaximizedControl(null);
                }
            }
        });
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.top = new FormAttachment((Control)wResultsLabel, 4);
        fdTabFolder.bottom = new FormAttachment(100, 0);
        this.extraViewTabFolder.setLayoutData((Object)fdTabFolder);
        this.sashForm.setWeights(new int[]{60, 40});
    }

    public void checkEmptyExtraView() {
        if (this.extraViewTabFolder.getItemCount() == 0) {
            this.disposeExtraView();
        }
    }

    private void disposeExtraView() {
        this.extraViewComposite.dispose();
        this.sashForm.layout();
        this.sashForm.setWeights(new int[]{100});
        XulToolbarbutton button = (XulToolbarbutton)this.toolbar.getElementById("job-show-results");
        button.setTooltiptext(BaseMessages.getString(PKG, (String)"Spoon.Tooltip.ShowExecutionResults", (String[])new String[0]));
        ToolItem swtToolItem = (ToolItem)button.getManagedObject();
        swtToolItem.setImage(GUIResource.getInstance().getImageShowResults());
    }

    private void minMaxExtraView() {
        boolean maximized;
        boolean bl = maximized = this.sashForm.getMaximizedControl() != null;
        if (maximized) {
            this.sashForm.setMaximizedControl(null);
            this.minMaxButton.setImage(GUIResource.getInstance().getImageMaximizePanel());
            this.minMaxButton.setToolTipText(BaseMessages.getString(PKG, (String)"JobGraph.ExecutionResultsPanel.MaxButton.Tooltip", (String[])new String[0]));
        } else {
            this.sashForm.setMaximizedControl((Control)this.extraViewComposite);
            this.minMaxButton.setImage(GUIResource.getInstance().getImageMinimizePanel());
            this.minMaxButton.setToolTipText(BaseMessages.getString(PKG, (String)"JobGraph.ExecutionResultsPanel.MinButton.Tooltip", (String[])new String[0]));
        }
    }

    public boolean isExecutionResultsPaneVisible() {
        return this.extraViewComposite != null && !this.extraViewComposite.isDisposed();
    }

    public void showExecutionResults() {
        if (this.isExecutionResultsPaneVisible()) {
            this.disposeExtraView();
        } else {
            this.addAllTabs();
        }
    }

    public void addAllTabs() {
        CTabItem tabItemSelection = null;
        if (this.extraViewTabFolder != null && !this.extraViewTabFolder.isDisposed()) {
            tabItemSelection = this.extraViewTabFolder.getSelection();
        }
        this.jobHistoryDelegate.addJobHistory();
        this.jobLogDelegate.addJobLog();
        this.jobGridDelegate.addJobGrid();
        this.jobMetricsDelegate.addJobMetrics();
        if (tabItemSelection != null) {
            this.extraViewTabFolder.setSelection(tabItemSelection);
        } else {
            this.extraViewTabFolder.setSelection(this.jobGridDelegate.getJobGridTab());
        }
        XulToolbarbutton button = (XulToolbarbutton)this.toolbar.getElementById("job-show-results");
        button.setTooltiptext(BaseMessages.getString(PKG, (String)"Spoon.Tooltip.HideExecutionResults", (String[])new String[0]));
        ToolItem swtToolItem = (ToolItem)button.getManagedObject();
        swtToolItem.setImage(GUIResource.getInstance().getImageHideResults());
    }

    public void openFile() {
        this.spoon.openFile();
    }

    public void saveFile() throws KettleException {
        this.spoon.saveFile();
    }

    public void saveFileAs() throws KettleException {
        this.spoon.saveFileAs();
    }

    public void saveXMLFileToVfs() {
        this.spoon.saveXMLFileToVfs();
    }

    public void printFile() {
        this.spoon.printFile();
    }

    public void runJob() {
        this.spoon.runFile();
    }

    public void getSQL() {
        this.spoon.getSQL();
    }

    public XulToolbar getToolbar() {
        return this.toolbar;
    }

    public void exploreDatabase() {
        this.spoon.exploreDatabase();
    }

    public void browseVersionHistory() {
        try {
            RepositoryRevisionBrowserDialogInterface dialog = RepositoryExplorerDialog.getVersionBrowserDialog(this.shell, this.spoon.rep, (RepositoryElementInterface)this.jobMeta);
            String versionLabel = dialog.open();
            if (versionLabel != null) {
                this.spoon.loadObjectFromRepository(this.jobMeta.getName(), this.jobMeta.getRepositoryElementType(), this.jobMeta.getRepositoryDirectory(), versionLabel);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JobGraph.VersionBrowserException.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobGraph.VersionBrowserException.Message", (String[])new String[0]), e);
        }
    }

    public synchronized void startJob(JobExecutionConfiguration executionConfiguration) throws KettleException {
        if (this.job == null || this.job.isFinished() && !this.job.isActive()) {
            this.handleJobMetaChanges(this.jobMeta);
            if ((this.jobMeta.getName() != null && this.jobMeta.getObjectId() != null && this.spoon.rep != null || this.jobMeta.getFilename() != null && this.spoon.rep == null) && !this.jobMeta.hasChanged()) {
                if (this.job == null || this.job != null && !this.job.isActive()) {
                    try {
                        if (executionConfiguration.isClearingLog()) {
                            this.jobLogDelegate.clearLog();
                        }
                        if (this.job != null) {
                            KettleLogStore.discardLines((String)this.job.getLogChannelId(), (boolean)true);
                        }
                        JobMeta runJobMeta = this.spoon.rep != null ? this.spoon.rep.loadJob(this.jobMeta.getName(), this.jobMeta.getRepositoryDirectory(), null, null) : new JobMeta(null, this.jobMeta.getFilename(), null, this.jobMeta.getMetaStore(), null);
                        String spoonObjectId = UUID.randomUUID().toString();
                        SimpleLoggingObject spoonLoggingObject = new SimpleLoggingObject("SPOON", LoggingObjectType.SPOON, null);
                        spoonLoggingObject.setContainerObjectId(spoonObjectId);
                        spoonLoggingObject.setLogLevel(executionConfiguration.getLogLevel());
                        this.job = new Job(this.spoon.rep, runJobMeta, (LoggingObjectInterface)spoonLoggingObject);
                        this.job.setLogLevel(executionConfiguration.getLogLevel());
                        this.job.shareVariablesWith((VariableSpace)this.jobMeta);
                        this.job.setInteractive(true);
                        this.job.setGatheringMetrics(executionConfiguration.isGatheringMetrics());
                        this.job.setArguments(executionConfiguration.getArgumentStrings());
                        this.job.getExtensionDataMap().putAll(executionConfiguration.getExtensionOptions());
                        this.job.addJobEntryListener(this.createRefreshJobEntryListener());
                        if (!Const.isEmpty((String)executionConfiguration.getStartCopyName())) {
                            JobEntryCopy startJobEntryCopy = runJobMeta.findJobEntry(executionConfiguration.getStartCopyName(), executionConfiguration.getStartCopyNr(), false);
                            this.job.setStartJobEntryCopy(startJobEntryCopy);
                        }
                        Map paramMap = executionConfiguration.getParams();
                        Set keys = paramMap.keySet();
                        for (String key : keys) {
                            this.job.getJobMeta().setParameterValue(key, Const.NVL((String)((String)paramMap.get(key)), (String)""));
                        }
                        this.job.getJobMeta().activateParameters();
                        this.log.logMinimal(BaseMessages.getString(PKG, (String)"JobLog.Log.StartingJob", (String[])new String[0]));
                        this.job.start();
                        this.jobGridDelegate.previousNrItems = -1;
                        this.jobGridDelegate.jobTracker = this.job.getJobTracker();
                        this.job.addJobListener((JobListener)new JobAdapter(){

                            public void jobFinished(Job job) {
                                JobGraph.this.jobFinished();
                            }
                        });
                        this.addAllTabs();
                    }
                    catch (KettleException e) {
                        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JobLog.Dialog.CanNotOpenJob.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobLog.Dialog.CanNotOpenJob.Message", (String[])new String[0]), (Exception)((Object)e));
                        this.job = null;
                    }
                } else {
                    MessageBox m = new MessageBox(this.shell, 40);
                    m.setText(BaseMessages.getString(PKG, (String)"JobLog.Dialog.JobIsAlreadyRunning.Title", (String[])new String[0]));
                    m.setMessage(BaseMessages.getString(PKG, (String)"JobLog.Dialog.JobIsAlreadyRunning.Message", (String[])new String[0]));
                    m.open();
                }
            } else if (this.jobMeta.hasChanged()) {
                MessageBox m = new MessageBox(this.shell, 40);
                m.setText(BaseMessages.getString(PKG, (String)"JobLog.Dialog.JobHasChangedSave.Title", (String[])new String[0]));
                m.setMessage(BaseMessages.getString(PKG, (String)"JobLog.Dialog.JobHasChangedSave.Message", (String[])new String[0]));
                m.open();
            } else if (this.spoon.rep != null && this.jobMeta.getName() == null) {
                MessageBox m = new MessageBox(this.shell, 40);
                m.setText(BaseMessages.getString(PKG, (String)"JobLog.Dialog.PleaseGiveThisJobAName.Title", (String[])new String[0]));
                m.setMessage(BaseMessages.getString(PKG, (String)"JobLog.Dialog.PleaseGiveThisJobAName.Message", (String[])new String[0]));
                m.open();
            } else {
                MessageBox m = new MessageBox(this.shell, 40);
                m.setText(BaseMessages.getString(PKG, (String)"JobLog.Dialog.NoFilenameSaveYourJobFirst.Title", (String[])new String[0]));
                m.setMessage(BaseMessages.getString(PKG, (String)"JobLog.Dialog.NoFilenameSaveYourJobFirst.Message", (String[])new String[0]));
                m.open();
            }
            this.setControlStates();
        }
    }

    private JobEntryListener createRefreshJobEntryListener() {
        return new JobEntryListener(){

            public void beforeExecution(Job job, JobEntryCopy jobEntryCopy, JobEntryInterface jobEntryInterface) {
                JobGraph.this.asyncRedraw();
            }

            public void afterExecution(Job job, JobEntryCopy jobEntryCopy, JobEntryInterface jobEntryInterface, Result result) {
                JobGraph.this.asyncRedraw();
            }
        };
    }

    protected void jobFinished() {
        if (this.job != null && this.job.isInitialized() && this.job.isFinished()) {
            for (RefreshListener listener : this.refreshListeners) {
                listener.refreshNeeded();
            }
            this.jobMetricsDelegate.resetLastRefreshTime();
            this.jobMetricsDelegate.updateGraph();
            this.log.logMinimal(BaseMessages.getString(PKG, (String)"JobLog.Log.JobHasEnded", (String[])new String[0]));
        }
        this.setControlStates();
    }

    public synchronized void stopJob() {
        if (this.job != null && this.job.isActive() && this.job.isInitialized()) {
            this.job.stopAll();
            this.job.waitUntilFinished(5000L);
            this.log.logMinimal(BaseMessages.getString(PKG, (String)"JobLog.Log.JobWasStopped", (String[])new String[0]));
        }
        this.setControlStates();
    }

    private boolean controlDisposed(XulToolbarbutton button) {
        if (button.getManagedObject() instanceof Widget) {
            Widget widget = (Widget)button.getManagedObject();
            return widget.isDisposed();
        }
        return false;
    }

    @Override
    public void setControlStates() {
        if (this.isDisposed() || this.getDisplay().isDisposed()) {
            return;
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                XulToolbarbutton versionsButton;
                XulToolbarbutton replayButton;
                XulToolbarbutton stopButton;
                boolean operationsNotAllowed = false;
                try {
                    operationsNotAllowed = RepositorySecurityUI.verifyOperations(JobGraph.this.shell, JobGraph.this.spoon.rep, false, RepositoryOperation.EXECUTE_JOB);
                }
                catch (KettleRepositoryLostException krle) {
                    JobGraph.this.log.logError(krle.getLocalizedMessage());
                }
                boolean running = JobGraph.this.job != null && JobGraph.this.job.isActive();
                XulToolbarbutton runButton = (XulToolbarbutton)JobGraph.this.toolbar.getElementById("job-run");
                if (runButton != null && !JobGraph.this.controlDisposed(runButton) && !operationsNotAllowed && runButton.isDisabled() ^ running) {
                    runButton.setDisabled(running);
                }
                if ((stopButton = (XulToolbarbutton)JobGraph.this.toolbar.getElementById("job-stop")) != null && !JobGraph.this.controlDisposed(stopButton) && stopButton.isDisabled() ^ !running) {
                    stopButton.setDisabled(!running);
                }
                if ((replayButton = (XulToolbarbutton)JobGraph.this.toolbar.getElementById("job-replay")) != null && !JobGraph.this.controlDisposed(replayButton) && !operationsNotAllowed && replayButton.isDisabled() ^ running) {
                    replayButton.setDisabled(running);
                }
                if ((versionsButton = (XulToolbarbutton)JobGraph.this.toolbar.getElementById("browse-versions")) != null && !JobGraph.this.controlDisposed(versionsButton)) {
                    boolean hasRepository = JobGraph.this.spoon.rep != null;
                    boolean enabled = hasRepository && JobGraph.this.spoon.rep.getRepositoryMeta().getRepositoryCapabilities().supportsRevisions();
                    if (versionsButton.isDisabled() ^ !enabled) {
                        versionsButton.setDisabled(!enabled);
                    }
                }
            }
        });
    }

    public List<RefreshListener> getRefreshListeners() {
        return this.refreshListeners;
    }

    public void setRefreshListeners(List<RefreshListener> refreshListeners) {
        this.refreshListeners = refreshListeners;
    }

    public void addRefreshListener(RefreshListener refreshListener) {
        this.refreshListeners.add(refreshListener);
    }

    public String getName() {
        return "jobgraph";
    }

    public XulDomContainer getXulDomContainer() {
        return this.xulDomContainer;
    }

    public void setName(String name) {
    }

    public void setXulDomContainer(XulDomContainer xulDomContainer) {
        this.xulDomContainer = xulDomContainer;
    }

    @Override
    public boolean canHandleSave() {
        return true;
    }

    public HasLogChannelInterface getLogChannelProvider() {
        return this.job;
    }

    public void addUndoPosition(Object[] obj, int[] pos, Point[] prev, Point[] curr) {
        this.addUndoPosition(obj, pos, prev, curr, false);
    }

    public void addUndoPosition(Object[] obj, int[] pos, Point[] prev, Point[] curr, boolean nextAlso) {
        this.jobMeta.addUndo(obj, null, pos, prev, curr, 4, nextAlso);
        this.spoon.setUndoMenu((UndoInterface)this.jobMeta);
    }

    @Override
    public int showChangedWarning() throws KettleException {
        return this.showChangedWarning(this.jobMeta.getName());
    }

    public void replayJob() {
        List selectedEntries = this.jobMeta.getSelectedEntries();
        if (selectedEntries.size() != 1) {
            MessageBox box = new MessageBox(this.shell, 66);
            box.setText(BaseMessages.getString(PKG, (String)"JobGraph.ReplayJob.SelectOneEntryToStartFrom.Title", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"JobGraph.ReplayJob.SelectOneEntryToStartFrom.Message", (String[])new String[0]));
            box.open();
            return;
        }
        JobEntryCopy copy = (JobEntryCopy)selectedEntries.get(0);
        this.spoon.executeJob(this.jobMeta, true, false, null, false, copy.getName(), copy.getNr());
    }

    public void handleJobMetaChanges(JobMeta jobMeta) throws KettleException {
        if (jobMeta.hasChanged()) {
            if (this.spoon.props.getAutoSave()) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"JobLog.Log.AutoSaveFileBeforeRunning", (String[])new String[0]));
                }
                this.spoon.saveToFile((EngineMetaInterface)jobMeta);
            } else {
                MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"JobLog.Dialog.SaveChangedFile.Title", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"JobLog.Dialog.SaveChangedFile.Message", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"JobLog.Dialog.SaveChangedFile.Message2", (String[])new String[0]) + Const.CR, 3, new String[]{BaseMessages.getString(PKG, (String)"System.Button.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0])}, 0, BaseMessages.getString(PKG, (String)"JobLog.Dialog.SaveChangedFile.Toggle", (String[])new String[0]), this.spoon.props.getAutoSave());
                int answer = md.open();
                if ((answer & 0xFF) == 0) {
                    this.spoon.saveToFile((EngineMetaInterface)jobMeta);
                }
                this.spoon.props.setAutoSave(md.getToggleState());
            }
        }
    }

    public void addJobEntryToChain(String typeDesc, boolean shift) {
        List sel;
        JobMeta jobMeta = this.spoon.getActiveJob();
        if (jobMeta == null) {
            return;
        }
        if (this.lastChained != null && jobMeta.findJobEntry(this.lastChained.getName(), this.lastChained.getNr(), false) == null) {
            this.lastChained = null;
        }
        if ((sel = jobMeta.getSelectedEntries()).size() == 1) {
            this.lastChained = (JobEntryCopy)sel.get(0);
        }
        Point p = null;
        if (this.lastChained == null) {
            p = jobMeta.getMaximum();
            p.x -= 100;
        } else {
            p = new Point(this.lastChained.getLocation().x, this.lastChained.getLocation().y);
        }
        p.x += 200;
        JobEntryCopy newEntry = this.spoon.newJobEntry(jobMeta, typeDesc, false);
        if (newEntry == null) {
            return;
        }
        newEntry.setLocation(p.x, p.y);
        newEntry.setDrawn();
        if (this.lastChained != null) {
            this.spoon.newJobHop(jobMeta, this.lastChained, newEntry);
        }
        this.lastChained = newEntry;
        this.spoon.refreshGraph();
        this.spoon.refreshTree();
        if (shift) {
            this.editEntry(newEntry);
        }
        jobMeta.unselectAll();
        newEntry.setSelected(true);
    }

    public Spoon getSpoon() {
        return this.spoon;
    }

    public void setSpoon(Spoon spoon) {
        this.spoon = spoon;
    }

    public JobMeta getJobMeta() {
        return this.jobMeta;
    }

    public Job getJob() {
        return this.job;
    }
}

