/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.trans;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.di.ui.spoon.trans.LogBrowser;
import org.pentaho.di.ui.spoon.trans.TransGraph;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulToolbarbutton;
import org.pentaho.ui.xul.containers.XulToolbar;
import org.pentaho.ui.xul.impl.XulEventHandler;

public class TransLogDelegate
extends SpoonDelegate
implements XulEventHandler {
    private static Class<?> PKG = Spoon.class;
    private static final String XUL_FILE_TRANS_LOG_TOOLBAR = "ui/trans-log-toolbar.xul";
    private TransGraph transGraph;
    private CTabItem transLogTab;
    private StyledText transLogText;
    private XulToolbar toolbar;
    private Composite transLogComposite;
    private LogBrowser logBrowser;

    public TransLogDelegate(Spoon spoon, TransGraph transGraph) {
        super(spoon);
        this.transGraph = transGraph;
    }

    public void addTransLog() {
        if (this.transGraph.extraViewComposite == null || this.transGraph.extraViewComposite.isDisposed()) {
            this.transGraph.addExtraView();
        } else if (this.transLogTab != null && !this.transLogTab.isDisposed()) {
            this.transGraph.extraViewTabFolder.setSelection(this.transLogTab);
            return;
        }
        this.transLogTab = new CTabItem(this.transGraph.extraViewTabFolder, 0);
        this.transLogTab.setImage(GUIResource.getInstance().getImageShowLog());
        this.transLogTab.setText(BaseMessages.getString(PKG, (String)"Spoon.TransGraph.LogTab.Name", (String[])new String[0]));
        this.transLogComposite = new Composite((Composite)this.transGraph.extraViewTabFolder, 786432);
        this.transLogComposite.setLayout((Layout)new FormLayout());
        this.addToolBar();
        Control toolbarControl = (Control)this.toolbar.getManagedObject();
        toolbarControl.setLayoutData((Object)new FormData());
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        toolbarControl.setLayoutData((Object)fd);
        toolbarControl.setParent(this.transLogComposite);
        this.transLogText = new StyledText(this.transLogComposite, 778);
        this.spoon.props.setLook((Control)this.transLogText);
        FormData fdText = new FormData();
        fdText.left = new FormAttachment(0, 0);
        fdText.right = new FormAttachment(100, 0);
        fdText.top = new FormAttachment((Control)this.toolbar.getManagedObject(), 0);
        fdText.bottom = new FormAttachment(100, 0);
        this.transLogText.setLayoutData((Object)fdText);
        this.logBrowser = new LogBrowser(this.transLogText, this.transGraph);
        this.logBrowser.installLogSniffer();
        this.transGraph.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (((TransLogDelegate)TransLogDelegate.this).transGraph.trans != null) {
                    KettleLogStore.discardLines((String)((TransLogDelegate)TransLogDelegate.this).transGraph.trans.getLogChannelId(), (boolean)true);
                }
            }
        });
        this.transLogTab.setControl((Control)this.transLogComposite);
        this.transGraph.extraViewTabFolder.setSelection(this.transLogTab);
    }

    private void addToolBar() {
        try {
            KettleXulLoader loader = new KettleXulLoader();
            loader.setSettingsManager(XulSpoonSettingsManager.getInstance());
            XulSpoonResourceBundle bundle = new XulSpoonResourceBundle(Spoon.class);
            XulDomContainer xulDomContainer = loader.loadXul(XUL_FILE_TRANS_LOG_TOOLBAR, bundle);
            xulDomContainer.addEventHandler((XulEventHandler)this);
            this.toolbar = (XulToolbar)xulDomContainer.getDocumentRoot().getElementById("nav-toolbar");
            ToolBar swtToolBar = (ToolBar)this.toolbar.getManagedObject();
            this.spoon.props.setLook((Control)swtToolBar, 6);
            swtToolBar.layout(true, true);
        }
        catch (Throwable t) {
            this.log.logError(Const.getStackTracker((Throwable)t));
            new ErrorDialog(this.transLogComposite.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Message", (String[])new String[]{XUL_FILE_TRANS_LOG_TOOLBAR}), new Exception(t));
        }
    }

    public void showLogView() {
        if (this.transLogTab == null || this.transLogTab.isDisposed()) {
            this.addTransLog();
        } else {
            this.transLogTab.dispose();
            this.transGraph.checkEmptyExtraView();
        }
    }

    public void showLogSettings() {
        this.spoon.setLog();
    }

    public void clearLog() {
        Map<StepMeta, String> stepLogMap;
        if (this.transLogText != null && !this.transLogText.isDisposed()) {
            this.transLogText.setText("");
        }
        if ((stepLogMap = this.transGraph.getStepLogMap()) != null) {
            stepLogMap.clear();
            this.transGraph.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TransLogDelegate.this.transGraph.redraw();
                }
            });
        }
    }

    public void showErrors() {
        String uLine;
        String line;
        int i;
        String all = this.transLogText.getText();
        ArrayList<String> err = new ArrayList<String>();
        int startpos = 0;
        int crlen = Const.CR.length();
        for (i = 0; i < all.length() - crlen; ++i) {
            if (!all.substring(i, i + crlen).equalsIgnoreCase(Const.CR)) continue;
            line = all.substring(startpos, i);
            uLine = line.toUpperCase();
            if (uLine.indexOf(BaseMessages.getString(PKG, (String)"TransLog.System.ERROR", (String[])new String[0])) >= 0 || uLine.indexOf(BaseMessages.getString(PKG, (String)"TransLog.System.EXCEPTION", (String[])new String[0])) >= 0 || uLine.indexOf("ERROR") >= 0 || uLine.indexOf("EXCEPTION") >= 0) {
                err.add(line);
            }
            startpos = i + crlen;
        }
        line = all.substring(startpos);
        uLine = line.toUpperCase();
        if (uLine.indexOf(BaseMessages.getString(PKG, (String)"TransLog.System.ERROR2", (String[])new String[0])) >= 0 || uLine.indexOf(BaseMessages.getString(PKG, (String)"TransLog.System.EXCEPTION2", (String[])new String[0])) >= 0 || uLine.indexOf("ERROR") >= 0 || uLine.indexOf("EXCEPTION") >= 0) {
            err.add(line);
        }
        if (err.size() > 0) {
            String[] err_lines = new String[err.size()];
            for (i = 0; i < err_lines.length; ++i) {
                err_lines[i] = (String)err.get(i);
            }
            EnterSelectionDialog esd = new EnterSelectionDialog(this.transGraph.getShell(), err_lines, BaseMessages.getString(PKG, (String)"TransLog.Dialog.ErrorLines.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLog.Dialog.ErrorLines.Message", (String[])new String[0]));
            line = esd.open();
            if (line != null) {
                TransMeta transMeta = this.transGraph.getManagedObject();
                for (i = 0; i < transMeta.nrSteps(); ++i) {
                    StepMeta stepMeta = transMeta.getStep(i);
                    if (line.indexOf(stepMeta.getName()) < 0) continue;
                    this.spoon.editStep(transMeta, stepMeta);
                }
            }
        }
    }

    public CTabItem getTransLogTab() {
        return this.transLogTab;
    }

    public String getLoggingText() {
        if (this.transLogText != null && !this.transLogText.isDisposed()) {
            return this.transLogText.getText();
        }
        return null;
    }

    public void pauseLog() {
        XulToolbarbutton pauseContinueButton = (XulToolbarbutton)this.toolbar.getElementById("log-pause");
        ToolItem swtToolItem = (ToolItem)pauseContinueButton.getManagedObject();
        if (this.logBrowser.isPaused()) {
            this.logBrowser.setPaused(false);
            if (pauseContinueButton != null) {
                swtToolItem.setImage(GUIResource.getInstance().getImagePauseLog());
            }
        } else {
            this.logBrowser.setPaused(true);
            if (pauseContinueButton != null) {
                swtToolItem.setImage(GUIResource.getInstance().getImageContinueLog());
            }
        }
    }

    public LogBrowser getLogBrowser() {
        return this.logBrowser;
    }

    public Object getData() {
        return null;
    }

    public String getName() {
        return "translog";
    }

    public XulDomContainer getXulDomContainer() {
        return null;
    }

    public void setData(Object data) {
    }

    public void setName(String name) {
    }

    public void setXulDomContainer(XulDomContainer xulDomContainer) {
    }
}

