/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.dialog;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.trans.dialog.TransDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class TransHopDialog
extends Dialog {
    private static Class<?> PKG = TransDialog.class;
    private Label wlFrom;
    private CCombo wFrom;
    private FormData fdlFrom;
    private FormData fdFrom;
    private Label wlTo;
    private Button wFlip;
    private CCombo wTo;
    private FormData fdlTo;
    private FormData fdFlip;
    private FormData fdTo;
    private Label wlEnabled;
    private Button wEnabled;
    private FormData fdlEnabled;
    private FormData fdEnabled;
    private Button wOK;
    private Button wCancel;
    private FormData fdOK;
    private FormData fdCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Listener lsFlip;
    private TransHopMeta input;
    private Shell shell;
    private TransMeta transMeta;
    private PropsUI props = PropsUI.getInstance();
    private ModifyListener lsMod;
    private boolean changed;

    public TransHopDialog(Shell parent, int style, TransHopMeta transHopMeta, TransMeta tr) {
        super(parent, style);
        this.input = transHopMeta;
        this.transMeta = tr;
    }

    public Object open() {
        StepMeta stepMeta;
        int i;
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 2160);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageHop());
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TransHopDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TransHopDialog.Shell.Label", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        int width = 0;
        this.wlFrom = new Label((Composite)this.shell, 131072);
        this.wlFrom.setText(BaseMessages.getString(PKG, (String)"TransHopDialog.FromStep.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFrom);
        this.fdlFrom = new FormData();
        this.fdlFrom.left = new FormAttachment(0, 0);
        this.fdlFrom.right = new FormAttachment(middle, -margin);
        this.fdlFrom.top = new FormAttachment(0, margin);
        this.wlFrom.setLayoutData((Object)this.fdlFrom);
        this.wFrom = new CCombo((Composite)this.shell, 18436);
        this.wFrom.setText(BaseMessages.getString(PKG, (String)"TransHopDialog.FromStepDropdownList.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wFrom);
        for (i = 0; i < this.transMeta.nrSteps(); ++i) {
            stepMeta = this.transMeta.getStep(i);
            this.wFrom.add(stepMeta.getName());
        }
        this.wFrom.addModifyListener(this.lsMod);
        this.fdFrom = new FormData();
        this.fdFrom.left = new FormAttachment(middle, 0);
        this.fdFrom.top = new FormAttachment(0, margin);
        this.fdFrom.right = new FormAttachment(100, 0);
        this.wFrom.setLayoutData((Object)this.fdFrom);
        this.wlTo = new Label((Composite)this.shell, 131072);
        this.wlTo.setText(BaseMessages.getString(PKG, (String)"TransHopDialog.TargetStep.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTo);
        this.fdlTo = new FormData();
        this.fdlTo.left = new FormAttachment(0, 0);
        this.fdlTo.right = new FormAttachment(middle, -margin);
        this.fdlTo.top = new FormAttachment((Control)this.wFrom, margin);
        this.wlTo.setLayoutData((Object)this.fdlTo);
        this.wTo = new CCombo((Composite)this.shell, 2056);
        this.wTo.setText(BaseMessages.getString(PKG, (String)"TransHopDialog.TargetStepDropdownList.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wTo);
        for (i = 0; i < this.transMeta.nrSteps(); ++i) {
            stepMeta = this.transMeta.getStep(i);
            this.wTo.add(stepMeta.getName());
        }
        this.wTo.addModifyListener(this.lsMod);
        this.fdTo = new FormData();
        this.fdTo.left = new FormAttachment(middle, 0);
        this.fdTo.top = new FormAttachment((Control)this.wFrom, margin);
        this.fdTo.right = new FormAttachment(100, 0);
        this.wTo.setLayoutData((Object)this.fdTo);
        this.wlEnabled = new Label((Composite)this.shell, 131072);
        this.wlEnabled.setText(BaseMessages.getString(PKG, (String)"TransHopDialog.EnableHop.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEnabled);
        this.fdlEnabled = new FormData();
        this.fdlEnabled.left = new FormAttachment(0, 0);
        this.fdlEnabled.right = new FormAttachment(middle, -margin);
        this.fdlEnabled.top = new FormAttachment((Control)this.wlTo, margin * 5);
        this.wlEnabled.setLayoutData((Object)this.fdlEnabled);
        this.wEnabled = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wEnabled);
        this.fdEnabled = new FormData();
        this.fdEnabled.left = new FormAttachment(middle, 0);
        this.fdEnabled.top = new FormAttachment((Control)this.wlTo, margin * 5);
        this.wEnabled.setLayoutData((Object)this.fdEnabled);
        this.wEnabled.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransHopDialog.this.input.setEnabled(!TransHopDialog.this.input.isEnabled());
                TransHopDialog.this.input.setChanged();
            }
        });
        this.wFlip = new Button((Composite)this.shell, 8);
        this.wFlip.setText(BaseMessages.getString(PKG, (String)"TransHopDialog.FromTo.Button", (String[])new String[0]));
        this.fdFlip = new FormData();
        this.fdFlip.right = new FormAttachment(100, 0);
        this.fdFlip.top = new FormAttachment((Control)this.wlTo, 20);
        this.wFlip.setLayoutData((Object)this.fdFlip);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOK.pack(true);
        Rectangle rOK = this.wOK.getBounds();
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.pack(true);
        Rectangle rCancel = this.wCancel.getBounds();
        width = rOK.width > rCancel.width ? rOK.width : rCancel.width;
        this.fdOK = new FormData();
        this.fdOK.top = new FormAttachment((Control)this.wFlip, margin * 5);
        this.fdOK.left = new FormAttachment(50, -(width += margin));
        this.fdOK.right = new FormAttachment(50, -(margin / 2));
        this.wOK.setLayoutData((Object)this.fdOK);
        this.fdCancel = new FormData();
        this.fdCancel.top = new FormAttachment((Control)this.wFlip, margin * 5);
        this.fdCancel.left = new FormAttachment(50, margin / 2);
        this.fdCancel.right = new FormAttachment(50, width);
        this.wCancel.setLayoutData((Object)this.fdCancel);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                TransHopDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                TransHopDialog.this.ok();
            }
        };
        this.lsFlip = new Listener(){

            public void handleEvent(Event e) {
                TransHopDialog.this.flip();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.wFlip.addListener(13, this.lsFlip);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                TransHopDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.input;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        if (this.input.getFromStep() != null) {
            this.wFrom.setText(this.input.getFromStep().getName());
        }
        if (this.input.getToStep() != null) {
            this.wTo.setText(this.input.getToStep().getName());
        }
        this.wEnabled.setSelection(this.input.isEnabled());
    }

    private void cancel() {
        this.input.setChanged(this.changed);
        this.input = null;
        this.dispose();
    }

    private void ok() {
        StepMeta fromBackup = this.input.getFromStep();
        StepMeta toBackup = this.input.getToStep();
        this.input.setFromStep(this.transMeta.findStep(this.wFrom.getText()));
        this.input.setToStep(this.transMeta.findStep(this.wTo.getText()));
        if (this.transMeta.hasLoop(this.input.getFromStep())) {
            this.input.setFromStep(fromBackup);
            this.input.setToStep(toBackup);
            MessageBox mb = new MessageBox(this.shell, 72);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TransHopDialog.LoopsNotAllowed.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"TransHopDialog.LoopsNotAllowed.DialogTitle", (String[])new String[0]));
            mb.open();
        } else if (this.input.getFromStep() == null) {
            MessageBox mb = new MessageBox(this.shell, 72);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TransHopDialog.StepDoesNotExist.DialogMessage", (String[])new String[]{this.wFrom.getText()}));
            mb.setText(BaseMessages.getString(PKG, (String)"TransHopDialog.StepDoesNotExist.DialogTitle", (String[])new String[0]));
            mb.open();
        } else if (this.input.getToStep() == null) {
            MessageBox mb = new MessageBox(this.shell, 72);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TransHopDialog.StepDoesNotExist.DialogMessage", (String[])new String[]{this.wTo.getText()}));
            mb.setText(BaseMessages.getString(PKG, (String)"TransHopDialog.StepDoesNotExist.DialogTitle", (String[])new String[0]));
            mb.open();
        } else if (this.input.getFromStep().equals((Object)this.input.getToStep())) {
            MessageBox mb = new MessageBox(this.shell, 72);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TransHopDialog.CannotGoToSameStep.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"TransHopDialog.CannotGoToSameStep.DialogTitle", (String[])new String[0]));
            mb.open();
        } else {
            this.dispose();
        }
    }

    private void flip() {
        String dummy = this.wFrom.getText();
        this.wFrom.setText(this.wTo.getText());
        this.wTo.setText(dummy);
        this.input.setChanged();
    }
}

