/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.formula;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.formula.FormulaMeta;
import org.pentaho.di.trans.steps.formula.FormulaMetaFunction;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.libformula.ui.editor.LibFormulaEditor;

public class FormulaDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = FormulaMeta.class;
    private Label wlStepname;
    private Text wStepname;
    private FormData fdlStepname;
    private FormData fdStepname;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private FormulaMeta currentMeta;
    private FormulaMeta originalMeta;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] colinf;
    private String[] fieldNames;

    public FormulaDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.currentMeta = (FormulaMeta)in;
        this.originalMeta = (FormulaMeta)this.currentMeta.clone();
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.currentMeta);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormulaDialog.this.currentMeta.setChanged();
            }
        };
        this.changed = this.currentMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FormulaDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"FormulaDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsRows = this.currentMeta.getFormula() != null ? this.currentMeta.getFormula().length : 1;
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"FormulaDialog.NewField.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FormulaDialog.Formula.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FormulaDialog.ValueType.Column", (String[])new String[0]), 2, ValueMeta.getTypes()), new ColumnInfo(BaseMessages.getString(PKG, (String)"FormulaDialog.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FormulaDialog.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FormulaDialog.Replace.Column", (String[])new String[0]), 2, new String[0])};
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, this.colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = FormulaDialog.this.transMeta.findStep(FormulaDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = FormulaDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            FormulaDialog.this.inputFields.put(row.getValueMeta(i).getName(), new Integer(i));
                        }
                        FormulaDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        FormulaDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"FormulaDialog.Log.UnableToFindInput", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.colinf[1].setSelectionAdapter((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FormulaDialog.this.fieldNames == null) {
                    return;
                }
                TableView tv = (TableView)e.widget;
                TableItem item = tv.table.getItem(e.y);
                String formula = item.getText(e.x);
                try {
                    LibFormulaEditor libFormulaEditor;
                    if (!FormulaDialog.this.shell.isDisposed() && (formula = (libFormulaEditor = new LibFormulaEditor(FormulaDialog.this.shell, 0x10010000, Const.NVL((String)formula, (String)""), FormulaDialog.this.fieldNames)).open()) != null && !tv.isDisposed()) {
                        tv.setText(formula, e.x, e.y);
                    }
                }
                catch (Exception ex) {
                    new ErrorDialog(FormulaDialog.this.shell, "Error", "There was an unexpected error in the formula editor", ex);
                }
            }
        });
        this.wFields.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                FormulaDialog.this.shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FormulaDialog.this.setComboBoxes();
                    }
                });
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                FormulaDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                FormulaDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                FormulaDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                FormulaDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.currentMeta.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        final HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Set keySet = fields.keySet();
                ArrayList entries = new ArrayList(keySet);
                String[] fieldNames = entries.toArray(new String[entries.size()]);
                Const.sortStrings((String[])fieldNames);
                FormulaDialog.this.colinf[5].setComboValues(fieldNames);
                FormulaDialog.access$602(FormulaDialog.this, fieldNames);
            }
        });
    }

    public void getData() {
        if (this.currentMeta.getFormula() != null) {
            for (int i = 0; i < this.currentMeta.getFormula().length; ++i) {
                FormulaMetaFunction fn = this.currentMeta.getFormula()[i];
                TableItem item = this.wFields.table.getItem(i);
                item.setText(1, Const.NVL((String)fn.getFieldName(), (String)""));
                item.setText(2, Const.NVL((String)fn.getFormula(), (String)""));
                item.setText(3, Const.NVL((String)ValueMeta.getTypeDesc((int)fn.getValueType()), (String)""));
                if (fn.getValueLength() >= 0) {
                    item.setText(4, "" + fn.getValueLength());
                }
                if (fn.getValuePrecision() >= 0) {
                    item.setText(5, "" + fn.getValuePrecision());
                }
                item.setText(6, Const.NVL((String)fn.getReplaceField(), (String)""));
            }
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.currentMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.currentMeta.allocate(this.wFields.nrNonEmpty());
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            String fieldName = item.getText(1);
            String formula = item.getText(2);
            int valueType = ValueMeta.getType((String)item.getText(3));
            int valueLength = Const.toInt((String)item.getText(4), (int)-1);
            int valuePrecision = Const.toInt((String)item.getText(5), (int)-1);
            String replaceField = item.getText(6);
            this.currentMeta.getFormula()[i] = new FormulaMetaFunction(fieldName, formula, valueType, valueLength, valuePrecision, replaceField);
        }
        if (!this.originalMeta.equals((Object)this.currentMeta)) {
            this.currentMeta.setChanged();
            this.changed = this.currentMeta.hasChanged();
        }
        this.dispose();
    }

    static /* synthetic */ String[] access$602(FormulaDialog x0, String[] x1) {
        x0.fieldNames = x1;
        return x1;
    }
}

