/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.monetdbbulkloader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoaderMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class MonetDBBulkLoaderDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = MonetDBBulkLoaderMeta.class;
    private CTabFolder wTabFolder;
    private CTabItem wGeneralSettingsTab;
    private CTabItem wMonetDBmclientSettingsTab;
    private CTabItem wOutputFieldsTab;
    private Composite wGeneralSettingsComp;
    private Composite wMonetDBmclientSettingsComp;
    private Composite wOutputFieldsComp;
    private Group wMonetDBmclientParamGroup;
    private FormData fdgMonetDBmclientParamGroup;
    private ComboVar wConnection;
    private Label wlSchema;
    private TextVar wSchema;
    private FormData fdlSchema;
    private FormData fdSchema;
    private Label wlTable;
    private Button wbTable;
    private TextVar wTable;
    private FormData fdlTable;
    private FormData fdbTable;
    private FormData fdTable;
    private Label wlBufferSize;
    private TextVar wBufferSize;
    private FormData fdlBufferSize;
    private FormData fdBufferSize;
    private Label wlLogFile;
    private Button wbLogFile;
    private TextVar wLogFile;
    private FormData fdlLogFile;
    private FormData fdbLogFile;
    private FormData fdLogFile;
    private Label wlTruncate;
    private Button wTruncate;
    private FormData fdlTruncate;
    private FormData fdTruncate;
    private Label wlFullyQuoteSQL;
    private Button wFullyQuoteSQL;
    private FormData fdlFullyQuoteSQL;
    private FormData fdFullyQuoteSQL;
    private Label wlFieldSeparator;
    private Combo wFieldSeparator;
    private FormData fdlFieldSeparator;
    private FormData fdFieldSeparator;
    private Label wlFieldEnclosure;
    private Combo wFieldEnclosure;
    private FormData fdlFieldEnclosure;
    private FormData fdFieldEnclosure;
    private Label wlNULLrepresentation;
    private Combo wNULLrepresentation;
    private FormData fdlNULLrepresentation;
    private FormData fdNULLrepresentation;
    private Label wlEncoding;
    private Combo wEncoding;
    private FormData fdlEncoding;
    private FormData fdEncoding;
    private Label wlReturn;
    private TableView wReturn;
    private FormData fdlReturn;
    private FormData fdReturn;
    private Button wGetLU;
    private FormData fdGetLU;
    private Listener lsGetLU;
    private Button wClearDBCache;
    private FormData fdClearDBCache;
    private Listener lsClearDBCache;
    private Button wDoMapping;
    private FormData fdDoMapping;
    private MonetDBBulkLoaderMeta input;
    private ColumnInfo[] ciReturn;
    private Map<String, Integer> inputFields;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();
    private static String[] fieldSeparators = new String[]{"", "|", ","};
    private static String[] fieldEnclosures = new String[]{"", "\""};
    private static String[] nullRepresentations = new String[]{"", "null"};
    private static String[] encodings = new String[]{"", "US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16BE", "UTF-16LE", "UTF-16"};
    private static final String[] ALL_FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Filetype.All", (String[])new String[0])};

    public MonetDBBulkLoaderDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (MonetDBBulkLoaderMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MonetDBBulkLoaderDialog.this.input.setChanged();
            }
        };
        FocusAdapter lsFocusLost = new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                MonetDBBulkLoaderDialog.this.setTableFieldCombo();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 16384);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wGeneralSettingsTab = new CTabItem(this.wTabFolder, 0);
        this.wGeneralSettingsTab.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.GeneralSettings.Label", (String[])new String[0]));
        this.wGeneralSettingsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wGeneralSettingsComp);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 3;
        tabLayout.marginHeight = 3;
        this.wGeneralSettingsComp.setLayout((Layout)tabLayout);
        this.wGeneralSettingsComp.layout();
        this.wGeneralSettingsTab.setControl((Control)this.wGeneralSettingsComp);
        this.wMonetDBmclientSettingsTab = new CTabItem(this.wTabFolder, 0);
        this.wMonetDBmclientSettingsTab.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.MonetDBmclientSettings.Label", (String[])new String[0]));
        this.wMonetDBmclientSettingsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wMonetDBmclientSettingsComp);
        this.wMonetDBmclientSettingsComp.setLayout((Layout)tabLayout);
        this.wMonetDBmclientSettingsComp.layout();
        this.wMonetDBmclientSettingsTab.setControl((Control)this.wMonetDBmclientSettingsComp);
        this.wMonetDBmclientParamGroup = new Group(this.wMonetDBmclientSettingsComp, 4);
        this.wMonetDBmclientParamGroup.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.MonetDBmclientSettings.ParameterGroup", (String[])new String[0]));
        this.props.setLook((Control)this.wMonetDBmclientParamGroup);
        this.wMonetDBmclientParamGroup.setLayout((Layout)tabLayout);
        this.wMonetDBmclientParamGroup.layout();
        this.wOutputFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wOutputFieldsTab.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.OutputFields", (String[])new String[0]));
        this.wOutputFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wOutputFieldsComp);
        this.wOutputFieldsComp.setLayout((Layout)tabLayout);
        this.wOutputFieldsComp.layout();
        this.wOutputFieldsTab.setControl((Control)this.wOutputFieldsComp);
        this.wTabFolder.setSelection(0);
        this.wTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MonetDBBulkLoaderDialog.this.wTabFolder.layout(true, true);
            }
        });
        this.wConnection = this.addConnectionLine(this.wGeneralSettingsComp, (Control)this.wTabFolder, middle, margin, null, this.transMeta);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wlSchema = new Label(this.wGeneralSettingsComp, 16384);
        this.wlSchema.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSchema);
        this.wSchema = new TextVar((VariableSpace)this.transMeta, this.wGeneralSettingsComp, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.wSchema.addFocusListener((FocusListener)lsFocusLost);
        this.wlTable = new Label(this.wGeneralSettingsComp, 16384);
        this.wlTable.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTable);
        this.wbTable = new Button(this.wGeneralSettingsComp, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Browse.Button", (String[])new String[0]));
        this.wTable = new TextVar((VariableSpace)this.transMeta, this.wGeneralSettingsComp, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsMod);
        this.wTable.addFocusListener((FocusListener)lsFocusLost);
        this.wlBufferSize = new Label(this.wGeneralSettingsComp, 131072);
        this.wlBufferSize.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.BufferSize.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlBufferSize);
        this.wBufferSize = new TextVar((VariableSpace)this.transMeta, this.wGeneralSettingsComp, 18436);
        this.props.setLook((Control)this.wBufferSize);
        this.wBufferSize.addModifyListener(lsMod);
        this.wlLogFile = new Label(this.wGeneralSettingsComp, 16384);
        this.wlLogFile.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.LogFile.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLogFile);
        this.wbLogFile = new Button(this.wGeneralSettingsComp, 0x1000008);
        this.props.setLook((Control)this.wbLogFile);
        this.wbLogFile.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Browse.Button", (String[])new String[0]));
        this.wLogFile = new TextVar((VariableSpace)this.transMeta, this.wGeneralSettingsComp, 18436);
        this.props.setLook((Control)this.wLogFile);
        this.wLogFile.addModifyListener(lsMod);
        this.wlTruncate = new Label(this.wGeneralSettingsComp, 16384);
        this.wlTruncate.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Truncate.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTruncate);
        this.wTruncate = new Button(this.wGeneralSettingsComp, 32);
        this.props.setLook((Control)this.wTruncate);
        SelectionAdapter lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MonetDBBulkLoaderDialog.this.input.setChanged();
                MonetDBBulkLoaderDialog.this.input.setTruncate(MonetDBBulkLoaderDialog.this.wTruncate.getSelection());
            }
        };
        this.wTruncate.addSelectionListener((SelectionListener)lsSelMod);
        this.wlFullyQuoteSQL = new Label(this.wGeneralSettingsComp, 16384);
        this.wlFullyQuoteSQL.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.FullyQuoteSQL.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFullyQuoteSQL);
        this.wFullyQuoteSQL = new Button(this.wGeneralSettingsComp, 32);
        this.props.setLook((Control)this.wFullyQuoteSQL);
        SelectionAdapter lsFullyQuoteSQL = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MonetDBBulkLoaderDialog.this.input.setChanged();
                MonetDBBulkLoaderDialog.this.input.getDatabaseMeta().setQuoteAllFields(MonetDBBulkLoaderDialog.this.wFullyQuoteSQL.getSelection());
            }
        };
        this.wFullyQuoteSQL.addSelectionListener((SelectionListener)lsFullyQuoteSQL);
        this.wlFieldSeparator = new Label((Composite)this.wMonetDBmclientParamGroup, 16384);
        this.wlFieldSeparator.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.MonetDBmclientSettings.ParameterGroup.FieldSeparator.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFieldSeparator);
        this.wFieldSeparator = new Combo((Composite)this.wMonetDBmclientParamGroup, 16779268);
        this.wFieldSeparator.setItems(fieldSeparators);
        this.props.setLook((Control)this.wFieldSeparator);
        this.wFieldSeparator.addModifyListener(lsMod);
        this.wlFieldEnclosure = new Label((Composite)this.wMonetDBmclientParamGroup, 16384);
        this.wlFieldEnclosure.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.MonetDBmclientSettings.ParameterGroup.FieldEnclosure.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFieldEnclosure);
        this.wFieldEnclosure = new Combo((Composite)this.wMonetDBmclientParamGroup, 16779268);
        this.wFieldEnclosure.setItems(fieldEnclosures);
        this.wFieldEnclosure.addModifyListener(lsMod);
        this.wlNULLrepresentation = new Label((Composite)this.wMonetDBmclientParamGroup, 16384);
        this.wlNULLrepresentation.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.MonetDBmclientSettings.ParameterGroup.NULLrepresentation.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlNULLrepresentation);
        this.wNULLrepresentation = new Combo((Composite)this.wMonetDBmclientParamGroup, 16779268);
        this.wNULLrepresentation.setItems(nullRepresentations);
        this.wNULLrepresentation.addModifyListener(lsMod);
        this.wlEncoding = new Label((Composite)this.wMonetDBmclientParamGroup, 131072);
        this.wlEncoding.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEncoding);
        this.wEncoding = new Combo((Composite)this.wMonetDBmclientParamGroup, 18436);
        this.wEncoding.setToolTipText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Encoding.Tooltip", (String[])new String[0]));
        this.wEncoding.setItems(encodings);
        this.props.setLook((Control)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wSQL = new Button((Composite)this.shell, 8);
        this.wSQL.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.SQL.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel, this.wSQL}, margin, null);
        this.wlReturn = new Label(this.wOutputFieldsComp, 0);
        this.wlReturn.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReturn);
        int UpInsCols = 3;
        int UpInsRows = this.input.getFieldTable() != null ? this.input.getFieldTable().length : 1;
        this.ciReturn = new ColumnInfo[UpInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.ColumnInfo.FormatOK", (String[])new String[0]), 2, new String[]{"Y", "N"}, true);
        this.tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView((VariableSpace)this.transMeta, this.wOutputFieldsComp, 68354, this.ciReturn, UpInsRows, lsMod, this.props);
        this.wReturn.optWidth(true);
        this.wGetLU = new Button(this.wOutputFieldsComp, 8);
        this.wGetLU.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.GetFields.Label", (String[])new String[0]));
        this.wDoMapping = new Button(this.wOutputFieldsComp, 8);
        this.wDoMapping.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.EditMapping.Label", (String[])new String[0]));
        this.wDoMapping.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MonetDBBulkLoaderDialog.this.generateMappings();
            }
        });
        this.wClearDBCache = new Button(this.wOutputFieldsComp, 8);
        this.wClearDBCache.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Tab.ClearDbCache", (String[])new String[0]));
        this.lsClearDBCache = new Listener(){

            public void handleEvent(Event e) {
                DBCache.getInstance().clear(MonetDBBulkLoaderDialog.this.input.getDbConnectionName());
                MessageBox mb = new MessageBox(MonetDBBulkLoaderDialog.this.shell, 34);
                mb.setMessage(BaseMessages.getString((Class)PKG, (String)"MonetDBBulkLoaderDialog.Tab.ClearedDbCacheMsg", (String[])new String[0]));
                mb.setText(BaseMessages.getString((Class)PKG, (String)"MonetDBBulkLoaderDialog.Tab.ClearedDbCacheTitle", (String[])new String[0]));
                mb.open();
            }
        };
        this.wClearDBCache.addListener(13, this.lsClearDBCache);
        this.fdlStepname = new FormData();
        this.fdlStepname.top = new FormAttachment(0, 15);
        this.fdlStepname.left = new FormAttachment(0, margin);
        this.fdlStepname.right = new FormAttachment(20, 0);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.fdStepname = new FormData();
        this.fdStepname.top = new FormAttachment(0, 15);
        this.fdStepname.left = new FormAttachment((Control)this.wlStepname, margin);
        this.fdStepname.right = new FormAttachment(100, -margin);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wStepname, margin + 20);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.fdlSchema = new FormData();
        this.fdlSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.fdlSchema.left = new FormAttachment((Control)this.wGeneralSettingsComp, margin);
        this.wlSchema.setLayoutData((Object)this.fdlSchema);
        this.fdSchema = new FormData();
        this.fdSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.fdSchema.left = new FormAttachment(middle, margin);
        this.fdSchema.right = new FormAttachment(100, -margin);
        this.wSchema.setLayoutData(this.fdSchema);
        this.fdlTable = new FormData();
        this.fdlTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.fdlTable.left = new FormAttachment(0, margin);
        this.wlTable.setLayoutData((Object)this.fdlTable);
        this.fdbTable = new FormData();
        this.fdbTable.top = new FormAttachment((Control)this.wSchema, 0);
        this.fdbTable.right = new FormAttachment(100, -margin);
        this.wbTable.setLayoutData((Object)this.fdbTable);
        this.fdTable = new FormData();
        this.fdTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.fdTable.left = new FormAttachment(middle, margin);
        this.fdTable.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTable.setLayoutData(this.fdTable);
        this.fdlBufferSize = new FormData();
        this.fdlBufferSize.top = new FormAttachment((Control)this.wTable, margin);
        this.fdlBufferSize.left = new FormAttachment(0, margin);
        this.wlBufferSize.setLayoutData((Object)this.fdlBufferSize);
        this.fdBufferSize = new FormData();
        this.fdBufferSize.top = new FormAttachment((Control)this.wTable, margin);
        this.fdBufferSize.left = new FormAttachment(middle, margin);
        this.fdBufferSize.right = new FormAttachment(100, -margin);
        this.wBufferSize.setLayoutData(this.fdBufferSize);
        this.fdlLogFile = new FormData();
        this.fdlLogFile.top = new FormAttachment((Control)this.wBufferSize, margin);
        this.fdlLogFile.left = new FormAttachment(0, margin);
        this.wlLogFile.setLayoutData((Object)this.fdlLogFile);
        this.fdbLogFile = new FormData();
        this.fdbLogFile.top = new FormAttachment((Control)this.wBufferSize, 0);
        this.fdbLogFile.right = new FormAttachment(100, -margin);
        this.wbLogFile.setLayoutData((Object)this.fdbLogFile);
        this.fdLogFile = new FormData();
        this.fdLogFile.left = new FormAttachment(middle, margin);
        this.fdLogFile.top = new FormAttachment((Control)this.wBufferSize, margin);
        this.fdLogFile.right = new FormAttachment((Control)this.wbLogFile, -margin);
        this.wLogFile.setLayoutData(this.fdLogFile);
        this.fdlTruncate = new FormData();
        this.fdlTruncate.top = new FormAttachment((Control)this.wLogFile, margin * 2);
        this.fdlTruncate.left = new FormAttachment(0, margin);
        this.wlTruncate.setLayoutData((Object)this.fdlTruncate);
        this.fdTruncate = new FormData();
        this.fdTruncate.top = new FormAttachment((Control)this.wLogFile, margin * 2);
        this.fdTruncate.left = new FormAttachment((Control)this.wlTruncate, margin);
        this.fdTruncate.right = new FormAttachment(100, -margin);
        this.wTruncate.setLayoutData((Object)this.fdTruncate);
        this.fdlFullyQuoteSQL = new FormData();
        this.fdlFullyQuoteSQL.top = new FormAttachment((Control)this.wlTruncate, margin * 2);
        this.fdlFullyQuoteSQL.left = new FormAttachment(0, margin);
        this.wlFullyQuoteSQL.setLayoutData((Object)this.fdlFullyQuoteSQL);
        this.fdFullyQuoteSQL = new FormData();
        this.fdFullyQuoteSQL.top = new FormAttachment((Control)this.wTruncate, margin * 2);
        this.fdFullyQuoteSQL.left = new FormAttachment((Control)this.wlFullyQuoteSQL, margin);
        this.fdFullyQuoteSQL.right = new FormAttachment(100, -margin);
        this.wFullyQuoteSQL.setLayoutData((Object)this.fdFullyQuoteSQL);
        this.fdgMonetDBmclientParamGroup = new FormData();
        this.fdgMonetDBmclientParamGroup.top = new FormAttachment((Control)this.wMonetDBmclientSettingsComp, margin * 3);
        this.fdgMonetDBmclientParamGroup.left = new FormAttachment(0, margin);
        this.fdgMonetDBmclientParamGroup.right = new FormAttachment(100, -margin);
        this.wMonetDBmclientParamGroup.setLayoutData((Object)this.fdgMonetDBmclientParamGroup);
        Text text = new Text((Composite)this.shell, 0);
        GC gc = new GC((Drawable)text);
        FontMetrics fm = gc.getFontMetrics();
        int charWidth = fm.getAverageCharWidth();
        int fieldWidth = text.computeSize((int)(charWidth * 20), (int)-1).x;
        gc.dispose();
        this.fdlFieldSeparator = new FormData();
        this.fdlFieldSeparator.top = new FormAttachment((Control)this.wMonetDBmclientSettingsComp, 3 * margin);
        this.fdlFieldSeparator.left = new FormAttachment(0, 3 * margin);
        this.wlFieldSeparator.setLayoutData((Object)this.fdlFieldSeparator);
        this.fdFieldSeparator = new FormData();
        this.fdFieldSeparator.top = new FormAttachment((Control)this.wMonetDBmclientSettingsComp, 3 * margin);
        this.fdFieldSeparator.left = new FormAttachment(middle, margin);
        this.fdFieldSeparator.width = fieldWidth;
        this.wFieldSeparator.setLayoutData((Object)this.fdFieldSeparator);
        this.fdlFieldEnclosure = new FormData();
        this.fdlFieldEnclosure.top = new FormAttachment((Control)this.wFieldSeparator, 2 * margin);
        this.fdlFieldEnclosure.left = new FormAttachment(0, 3 * margin);
        this.wlFieldEnclosure.setLayoutData((Object)this.fdlFieldEnclosure);
        this.fdFieldEnclosure = new FormData();
        this.fdFieldEnclosure.top = new FormAttachment((Control)this.wFieldSeparator, 2 * margin);
        this.fdFieldEnclosure.left = new FormAttachment(middle, margin);
        this.fdFieldEnclosure.width = fieldWidth;
        this.wFieldEnclosure.setLayoutData((Object)this.fdFieldEnclosure);
        this.fdlNULLrepresentation = new FormData();
        this.fdlNULLrepresentation.top = new FormAttachment((Control)this.wFieldEnclosure, 2 * margin);
        this.fdlNULLrepresentation.left = new FormAttachment(0, 3 * margin);
        this.wlNULLrepresentation.setLayoutData((Object)this.fdlNULLrepresentation);
        this.fdNULLrepresentation = new FormData();
        this.fdNULLrepresentation.top = new FormAttachment((Control)this.wFieldEnclosure, 2 * margin);
        this.fdNULLrepresentation.left = new FormAttachment(middle, margin);
        this.fdNULLrepresentation.width = fieldWidth;
        this.wNULLrepresentation.setLayoutData((Object)this.fdNULLrepresentation);
        this.fdlEncoding = new FormData();
        this.fdlEncoding.top = new FormAttachment((Control)this.wNULLrepresentation, 2 * margin);
        this.fdlEncoding.left = new FormAttachment(0, 3 * margin);
        this.wlEncoding.setLayoutData((Object)this.fdlEncoding);
        this.fdEncoding = new FormData();
        this.fdEncoding.top = new FormAttachment((Control)this.wNULLrepresentation, 2 * margin);
        this.fdEncoding.left = new FormAttachment(middle, margin);
        this.fdEncoding.width = fieldWidth;
        this.wEncoding.setLayoutData((Object)this.fdEncoding);
        this.fdlReturn = new FormData();
        this.fdlReturn.top = new FormAttachment((Control)this.wOutputFieldsComp, 2 * margin);
        this.fdlReturn.left = new FormAttachment(0, margin);
        this.wlReturn.setLayoutData((Object)this.fdlReturn);
        this.fdDoMapping = new FormData();
        this.fdDoMapping.top = new FormAttachment((Control)this.wOutputFieldsComp, 2 * margin);
        this.fdDoMapping.right = new FormAttachment(100, -margin);
        this.wDoMapping.setLayoutData((Object)this.fdDoMapping);
        this.fdGetLU = new FormData();
        this.fdGetLU.top = new FormAttachment((Control)this.wOutputFieldsComp, 2 * margin);
        this.fdGetLU.right = new FormAttachment((Control)this.wDoMapping, -margin);
        this.wGetLU.setLayoutData((Object)this.fdGetLU);
        this.fdClearDBCache = new FormData();
        this.fdClearDBCache.top = new FormAttachment((Control)this.wOutputFieldsComp, 2 * margin);
        this.fdClearDBCache.right = new FormAttachment((Control)this.wGetLU, -margin);
        this.wClearDBCache.setLayoutData((Object)this.fdClearDBCache);
        this.fdReturn = new FormData();
        this.fdReturn.top = new FormAttachment((Control)this.wGetLU, 3 * margin);
        this.fdReturn.left = new FormAttachment(0, margin);
        this.fdReturn.right = new FormAttachment(100, -margin);
        this.fdReturn.bottom = new FormAttachment(100, -2 * margin);
        this.wReturn.setLayoutData(this.fdReturn);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = MonetDBBulkLoaderDialog.this.transMeta.findStep(MonetDBBulkLoaderDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = MonetDBBulkLoaderDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            MonetDBBulkLoaderDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        MonetDBBulkLoaderDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        MonetDBBulkLoaderDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.wbLogFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(MonetDBBulkLoaderDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*"});
                if (MonetDBBulkLoaderDialog.this.wLogFile.getText() != null) {
                    dialog.setFileName(MonetDBBulkLoaderDialog.this.wLogFile.getText());
                }
                dialog.setFilterNames(ALL_FILETYPES);
                if (dialog.open() != null) {
                    MonetDBBulkLoaderDialog.this.wLogFile.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                MonetDBBulkLoaderDialog.this.ok();
            }
        };
        this.lsGetLU = new Listener(){

            public void handleEvent(Event e) {
                MonetDBBulkLoaderDialog.this.getUpdate();
            }
        };
        this.lsSQL = new Listener(){

            public void handleEvent(Event e) {
                MonetDBBulkLoaderDialog.this.create();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                MonetDBBulkLoaderDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGetLU.addListener(13, this.lsGetLU);
        this.wSQL.addListener(13, this.lsSQL);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MonetDBBulkLoaderDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wSchema.addSelectionListener(this.lsDef);
        this.wTable.addSelectionListener(this.lsDef);
        this.wBufferSize.addSelectionListener(this.lsDef);
        this.wLogFile.addSelectionListener(this.lsDef);
        this.wFieldSeparator.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                MonetDBBulkLoaderDialog.this.cancel();
            }
        });
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MonetDBBulkLoaderDialog.this.getTableName();
            }
        });
        this.setSize();
        this.getData();
        this.setTableFieldCombo();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setTableFieldCombo() {
        Runnable fieldLoader = new Runnable(){

            @Override
            public void run() {
                block7: {
                    if (!(MonetDBBulkLoaderDialog.this.wTable.isDisposed() || MonetDBBulkLoaderDialog.this.wConnection.isDisposed() || MonetDBBulkLoaderDialog.this.wSchema.isDisposed())) {
                        DatabaseMeta ci;
                        String tableName = MonetDBBulkLoaderDialog.this.wTable.getText();
                        String connectionName = MonetDBBulkLoaderDialog.this.wConnection.getText();
                        String schemaName = MonetDBBulkLoaderDialog.this.wSchema.getText();
                        for (ColumnInfo colInfo : MonetDBBulkLoaderDialog.this.tableFieldColumns) {
                            colInfo.setComboValues(new String[0]);
                        }
                        if (!Const.isEmpty((String)tableName) && (ci = MonetDBBulkLoaderDialog.this.transMeta.findDatabase(connectionName)) != null) {
                            Database db = new Database(BaseStepDialog.loggingObject, ci);
                            try {
                                String[] fieldNames;
                                db.connect();
                                String schemaTable = ci.getQuotedSchemaTableCombination(MonetDBBulkLoaderDialog.this.transMeta.environmentSubstitute(schemaName), MonetDBBulkLoaderDialog.this.transMeta.environmentSubstitute(tableName));
                                RowMetaInterface r = db.getTableFields(schemaTable);
                                if (null == r || null == (fieldNames = r.getFieldNames())) break block7;
                                for (ColumnInfo colInfo : MonetDBBulkLoaderDialog.this.tableFieldColumns) {
                                    colInfo.setComboValues(fieldNames);
                                }
                            }
                            catch (Exception e) {
                                for (ColumnInfo colInfo : MonetDBBulkLoaderDialog.this.tableFieldColumns) {
                                    colInfo.setComboValues(new String[0]);
                                }
                            }
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getFieldTable() != null) {
            for (int i = 0; i < this.input.getFieldTable().length; ++i) {
                TableItem item = this.wReturn.table.getItem(i);
                if (this.input.getFieldTable()[i] != null) {
                    item.setText(1, this.input.getFieldTable()[i]);
                }
                if (this.input.getFieldStream()[i] != null) {
                    item.setText(2, this.input.getFieldStream()[i]);
                }
                item.setText(3, this.input.getFieldFormatOk()[i] ? "Y" : "N");
            }
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        this.wBufferSize.setText("" + this.input.getBufferSize());
        if (this.input.getLogFile() != null) {
            this.wLogFile.setText(this.input.getLogFile());
        }
        this.wTruncate.setSelection(this.input.isTruncate());
        this.wFullyQuoteSQL.setSelection(this.input.isFullyQuoteSQL());
        if (this.input.getFieldSeparator() != null) {
            this.wFieldSeparator.setText(this.input.getFieldSeparator());
        }
        if (this.input.getFieldEnclosure() != null) {
            this.wFieldEnclosure.setText(this.input.getFieldEnclosure());
        }
        if (this.input.getNULLrepresentation() != null) {
            this.wNULLrepresentation.setText(this.input.getNULLrepresentation());
        }
        if (this.input.getEncoding() != null) {
            this.wEncoding.setText(this.input.getEncoding());
        }
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    protected void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        if (this.ciReturn != null) {
            this.ciReturn[1].setComboValues(fieldNames);
        }
    }

    protected void getInfo(MonetDBBulkLoaderMeta inf) {
        int nrfields = this.wReturn.nrNonEmpty();
        inf.allocate(nrfields);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Log.FoundFields", (String[])new String[]{"" + nrfields}));
        }
        for (int i = 0; i < nrfields; ++i) {
            TableItem item = this.wReturn.getNonEmpty(i);
            inf.getFieldTable()[i] = item.getText(1);
            inf.getFieldStream()[i] = item.getText(2);
            inf.getFieldFormatOk()[i] = "Y".equalsIgnoreCase(item.getText(3));
        }
        inf.setDbConnectionName(this.wConnection.getText());
        inf.setSchemaName(this.wSchema.getText());
        inf.setTableName(this.wTable.getText());
        inf.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        inf.setBufferSize(this.wBufferSize.getText());
        inf.setLogFile(this.wLogFile.getText());
        inf.setTruncate(this.wTruncate.getSelection());
        inf.setFullyQuoteSQL(this.wFullyQuoteSQL.getSelection());
        inf.setFieldSeparator(this.wFieldSeparator.getText());
        inf.setFieldEnclosure(this.wFieldEnclosure.getText());
        inf.setNULLrepresentation(this.wNULLrepresentation.getText());
        inf.setEncoding(this.wEncoding.getText());
        this.stepname = this.wStepname.getText();
    }

    protected void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    protected void getTableName() {
        DatabaseMeta inf = null;
        int connr = -1;
        if (this.wConnection != null && this.wConnection.getCComboWidget() != null) {
            connr = this.wConnection.getCComboWidget().getSelectionIndex();
        }
        if (connr >= 0) {
            inf = this.transMeta.getDatabase(connr);
        }
        if (inf != null) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Log.LookingAtConnection", (String[])new String[0]) + inf.toString());
            }
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void generateMappings() {
        EnterMappingDialog d;
        RowMetaInterface targetFields;
        RowMetaInterface sourceFields;
        try {
            sourceFields = this.transMeta.getPrevStepFields(this.stepMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        this.input.setTableName(this.transMeta.environmentSubstitute(this.wTable.getText()));
        StepMetaInterface stepMetaInterface = this.stepMeta.getStepMetaInterface();
        try {
            targetFields = stepMetaInterface.getRequiredFields((VariableSpace)this.transMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            ValueMetaInterface value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName() + "            (" + value.getOrigin() + ")";
        }
        List<SourceToTargetMapping> mappings = new ArrayList<SourceToTargetMapping>();
        StringBuilder missingSourceFields = new StringBuilder();
        StringBuilder missingTargetFields = new StringBuilder();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR).append("   ").append(source).append(" --> ").append(target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            String message = "";
            if (missingSourceFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = message + Const.CR;
            message = message + BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            boolean goOn = MessageDialog.openConfirm((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message);
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = mappings.get(i);
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }

    private void getUpdate() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    @Override
                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        if (v.getType() == 3) {
                            tableItem.setText(3, "Y");
                        } else {
                            tableItem.setText(3, "Y");
                        }
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious(r, this.wReturn, 1, new int[]{1, 2}, new int[0], -1, -1, listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            MonetDBBulkLoaderMeta info = new MonetDBBulkLoaderMeta();
            this.getInfo(info);
            String name = this.stepname;
            SQLStatement sql = info.getTableDdl(this.transMeta, name, false, null, false);
            if (!sql.hasError()) {
                if (sql.hasSQL()) {
                    SQLEditor sqledit = new SQLEditor((VariableSpace)this.transMeta, this.shell, 0, info.getDatabaseMeta(), this.transMeta.getDbCache(), sql.getSQL());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.CouldNotBuildSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.CouldNotBuildSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public ComboVar addConnectionLine(Composite parent, Control previous, int middle, int margin, final Class<? extends DatabaseInterface> databaseType, final TransMeta transMeta) {
        final ComboVar wConnection = new ComboVar((VariableSpace)transMeta, parent, 2048);
        this.props.setLook((Control)wConnection);
        this.addDatabases(wConnection, null);
        Label wlConnection = new Label(parent, 16384);
        wlConnection.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.Connection.Label", (String[])new String[0]));
        this.props.setLook((Control)wlConnection);
        Button wbnConnection = new Button(parent, 131072);
        wbnConnection.setText(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.NewConnectionButton.Label", (String[])new String[0]));
        wbnConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseMeta databaseMeta = new DatabaseMeta();
                databaseMeta.shareVariablesWith((VariableSpace)transMeta);
                DatabaseDialog cid = MonetDBBulkLoaderDialog.this.getDatabaseDialog(MonetDBBulkLoaderDialog.this.shell);
                cid.setDatabaseMeta(databaseMeta);
                cid.setModalDialog(true);
                if (cid.open() != null) {
                    transMeta.addDatabase(databaseMeta);
                    wConnection.removeAll();
                    MonetDBBulkLoaderDialog.this.addDatabases(wConnection, (Class<? extends DatabaseInterface>)databaseType);
                    MonetDBBulkLoaderDialog.this.selectDatabase(wConnection, databaseMeta.getName());
                }
            }
        });
        Button wbeConnection = new Button(parent, 131072);
        wbeConnection.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.EditConnectionButton.Label", (String[])new String[0]));
        wbeConnection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DatabaseMeta databaseMeta = transMeta.findDatabase(wConnection.getText());
                if (databaseMeta != null) {
                    databaseMeta.shareVariablesWith((VariableSpace)transMeta);
                    DatabaseDialog cid = MonetDBBulkLoaderDialog.this.getDatabaseDialog(MonetDBBulkLoaderDialog.this.shell);
                    cid.setDatabaseMeta(databaseMeta);
                    cid.setModalDialog(true);
                    if (cid.open() != null) {
                        wConnection.removeAll();
                        MonetDBBulkLoaderDialog.this.addDatabases(wConnection, null);
                        MonetDBBulkLoaderDialog.this.selectDatabase(wConnection, databaseMeta.getName());
                    }
                }
            }
        });
        FormData fdlConnection = new FormData();
        fdlConnection.left = new FormAttachment(0, margin);
        fdlConnection.top = previous != null ? new FormAttachment(previous, margin + 10) : new FormAttachment(0, 0);
        wlConnection.setLayoutData((Object)fdlConnection);
        FormData fdbConnection = new FormData();
        fdbConnection.right = new FormAttachment(100, -margin);
        fdbConnection.top = previous != null ? new FormAttachment(previous, margin) : new FormAttachment(0, 0);
        wbnConnection.setLayoutData((Object)fdbConnection);
        FormData fdeConnection = new FormData();
        fdeConnection.right = new FormAttachment((Control)wbnConnection, -margin);
        fdeConnection.top = previous != null ? new FormAttachment(previous, margin) : new FormAttachment(0, 0);
        wbeConnection.setLayoutData((Object)fdeConnection);
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(middle, margin);
        fdConnection.right = new FormAttachment((Control)wbeConnection, -margin);
        fdConnection.top = previous != null ? new FormAttachment(previous, margin + 10) : new FormAttachment((Control)wlConnection, margin);
        wConnection.setLayoutData(fdConnection);
        return wConnection;
    }

    public void addDatabases(ComboVar wConnection, Class<? extends DatabaseInterface> databaseType) {
        List<Object> databaseNameList;
        String[] arrayDatabaseList;
        for (int i = 0; i < this.transMeta.nrDatabases(); ++i) {
            DatabaseMeta ci = this.transMeta.getDatabase(i);
            if (databaseType != null && !ci.getDatabaseInterface().getClass().equals(databaseType)) continue;
            wConnection.add(ci.getName());
        }
        if (!Const.isEmpty((String)this.input.getDbConnectionName()) && (arrayDatabaseList = wConnection.getItems()) == null && !(databaseNameList = Arrays.asList(new Object[0])).contains(this.input.getDbConnectionName())) {
            wConnection.add(this.input.getDbConnectionName());
        }
    }

    public void selectDatabase(ComboVar wConnection, String name) {
        int idx = wConnection.getCComboWidget().indexOf(name);
        if (idx >= 0) {
            wConnection.select(idx);
        }
    }
}

