/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.util;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.ShowHelpDialog;
import org.pentaho.di.ui.core.gui.GUIResource;

public class HelpUtils {
    private static final Class<?> PKG = HelpUtils.class;

    public static Button createHelpButton(final Composite parent, String title, final PluginInterface plugin) {
        Button button = HelpUtils.newButton(parent);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                HelpUtils.openHelpDialog(parent.getShell(), plugin);
            }
        });
        return button;
    }

    public static Button createHelpButton(final Composite parent, final String title, final String url, final String header) {
        Button button = HelpUtils.newButton(parent);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                HelpUtils.openHelpDialog(parent.getShell(), title, url, header);
            }
        });
        return button;
    }

    private static Button newButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setImage(GUIResource.getInstance().getImageHelpWeb());
        button.setText(BaseMessages.getString(PKG, (String)"System.Button.Help", (String[])new String[0]));
        button.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.Help", (String[])new String[0]));
        FormData fdButton = new FormData();
        fdButton.left = new FormAttachment(0, 0);
        fdButton.bottom = new FormAttachment(100, 0);
        button.setLayoutData((Object)fdButton);
        return button;
    }

    public static String getHelpDialogTitle(PluginInterface plugin) {
        if (plugin == null) {
            return "";
        }
        String msgKey = "";
        msgKey = plugin.getPluginType().equals(StepPluginType.class) ? "System.ShowHelpDialog.StepPluginType.Title" : "System.ShowHelpDialog.JobEntryPluginType.Title";
        return BaseMessages.getString(PKG, (String)msgKey, (String[])new String[]{plugin.getName()});
    }

    public static boolean isPluginDocumented(PluginInterface plugin) {
        if (plugin == null) {
            return false;
        }
        return !StringUtil.isEmpty((String)plugin.getDocumentationUrl());
    }

    public static ShowHelpDialog openHelpDialog(Shell shell, PluginInterface plugin) {
        if (shell == null || plugin == null) {
            return null;
        }
        if (HelpUtils.isPluginDocumented(plugin)) {
            return HelpUtils.openHelpDialog(shell, HelpUtils.getHelpDialogTitle(plugin), plugin.getDocumentationUrl(), plugin.getName());
        }
        MessageBox mb = new MessageBox(shell, 33);
        String msgKey = "";
        msgKey = plugin.getPluginType().equals(StepPluginType.class) ? "System.ShowHelpDialog.Step.HelpIsNotAvailable" : "System.ShowHelpDialog.JobEntry.HelpIsNotAvailable";
        mb.setMessage(BaseMessages.getString(PKG, (String)msgKey, (String[])new String[]{plugin.getName()}));
        mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
        mb.open();
        return null;
    }

    private static ShowHelpDialog openHelpDialog(Shell shell, String dialogTitle, String url, String header) {
        ShowHelpDialog helpDlg = new ShowHelpDialog(shell, dialogTitle, url, header);
        helpDlg.open();
        return helpDlg;
    }
}

