/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.util;

import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.pentaho.di.core.vfs.KettleVFS;

public class ImageUtil {
    private static FileObject base;

    public static Image makeImageTransparent(Display display, Image tempImage, RGB transparentColor) {
        int pixelIndex;
        ImageData imageData = tempImage.getImageData();
        imageData.transparentPixel = pixelIndex = imageData.palette.getPixel(transparentColor);
        Image image = new Image((Device)display, imageData);
        tempImage.dispose();
        return image;
    }

    public static InputStream getImageInputStream(Display display, String location) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL res = cl.getResource(location);
        if (res != null) {
            try {
                InputStream s = res.openStream();
                return s;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            FileObject imageFileObject = KettleVFS.getInstance().getFileSystemManager().resolveFile(base, location);
            return KettleVFS.getInputStream((FileObject)imageFileObject);
        }
        catch (FileSystemException e) {
            throw new RuntimeException("Unable to load image with name [" + location + "]", e);
        }
    }

    public static Image getImageAsResource(Display display, String location) {
        return new Image((Device)display, ImageUtil.getImageInputStream(display, location));
    }

    public static Image getImage(Display display, Class<?> resourceClass, String filename) {
        try {
            return new Image((Device)display, resourceClass.getResourceAsStream(filename));
        }
        catch (Exception e) {
            try {
                return new Image((Device)display, resourceClass.getResourceAsStream("/" + filename));
            }
            catch (Exception e2) {
                return ImageUtil.getImage(display, filename);
            }
        }
    }

    public static Image getImage(Display display, ClassLoader classLoader, String filename) {
        try {
            return new Image((Device)display, classLoader.getResourceAsStream(filename));
        }
        catch (Exception e) {
            try {
                return new Image((Device)display, classLoader.getResourceAsStream("/" + filename));
            }
            catch (Exception e2) {
                return ImageUtil.getImage(display, filename);
            }
        }
    }

    public static Image getImage(Display display, String location) {
        try {
            InputStream is = KettleVFS.getInputStream((String)location);
            Image im = new Image((Device)display, is);
            is.close();
            return im;
        }
        catch (Exception e) {
            try {
                return new Image((Device)display, ImageUtil.class.getClassLoader().getResourceAsStream(location));
            }
            catch (Exception npe) {
                throw new RuntimeException("Unable to load image with name [" + location + "]", e);
            }
        }
    }

    public static ImageData convertToSWT(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[4];
            for (int y = 0; y < data.height; ++y) {
                for (int x = 0; x < data.width; ++x) {
                    raster.getPixel(x, y, pixelArray);
                    int pixel = palette.getPixel(new RGB(pixelArray[0], pixelArray[1], pixelArray[2]));
                    data.setPixel(x, y, pixel);
                    data.setAlpha(x, y, pixelArray[3]);
                }
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            for (int i = 0; i < rgbs.length; ++i) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            for (int y = 0; y < data.height; ++y) {
                for (int x = 0; x < data.width; ++x) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                }
            }
            return data;
        }
        return null;
    }

    static {
        try {
            base = KettleVFS.getInstance().getFileSystemManager().resolveFile(System.getProperty("user.dir"));
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            base = null;
        }
    }
}

