/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.pentaho.di.core.SwtUniversalImage;
import org.pentaho.di.core.SwtUniversalImageBitmap;
import org.pentaho.di.core.SwtUniversalImageSvg;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.svg.SvgSupport;
import org.pentaho.di.core.vfs.KettleVFS;

public class SwtSvgImageUtil {
    private static LogChannelInterface log = new LogChannel((Object)"SwtSvgImageUtil");
    private static final String NO_IMAGE = "ui/images/no_image.svg";
    private static FileObject base;

    public static SwtUniversalImage getMissingImage(Display display) {
        Image img = new Image((Device)display, 32, 32);
        GC gc = new GC((Drawable)img);
        gc.setForeground(new Color((Device)display, 0, 0, 0));
        gc.drawRectangle(4, 4, 24, 24);
        gc.setForeground(new Color((Device)display, 255, 0, 0));
        gc.drawLine(4, 4, 28, 28);
        gc.drawLine(28, 4, 4, 28);
        gc.dispose();
        return new SwtUniversalImageBitmap(img);
    }

    private static SwtUniversalImage getImageAsResourceInternal(Display display, String location) {
        SwtUniversalImage result = null;
        if (result == null) {
            result = SwtSvgImageUtil.loadFromCurrentClasspath(display, location);
        }
        if (result == null) {
            result = SwtSvgImageUtil.loadFromBasedVFS(display, location);
        }
        if (result == null) {
            result = SwtSvgImageUtil.loadFromSimpleVFS(display, location);
        }
        return result;
    }

    public static SwtUniversalImage getImageAsResource(Display display, String location) {
        SwtUniversalImage result = null;
        if (result == null && SvgSupport.isSvgEnabled()) {
            result = SwtSvgImageUtil.getImageAsResourceInternal(display, SvgSupport.toSvgName((String)location));
        }
        if (result == null) {
            result = SwtSvgImageUtil.getImageAsResourceInternal(display, SvgSupport.toPngName((String)location));
        }
        if (result == null && !location.equals(NO_IMAGE)) {
            log.logError("Unable to load image [" + location + "]");
            result = SwtSvgImageUtil.getImageAsResource(display, NO_IMAGE);
        }
        if (result == null) {
            log.logError("Unable to load image [" + location + "]");
            result = SwtSvgImageUtil.getMissingImage(display);
        }
        return result;
    }

    public static Image getImage(Display display, ClassLoader classLoader, String filename, int width, int height) {
        SwtUniversalImage u = SwtSvgImageUtil.getUniversalImage(display, classLoader, filename);
        return u.getAsBitmapForSize((Device)display, width, height);
    }

    private static SwtUniversalImage getUniversalImageInternal(Display display, ClassLoader classLoader, String filename) {
        SwtUniversalImage result = SwtSvgImageUtil.loadFromClassLoader(display, classLoader, filename);
        if (result == null && (result = SwtSvgImageUtil.loadFromClassLoader(display, classLoader, "/" + filename)) == null && (result = SwtSvgImageUtil.loadFromClassLoader(display, classLoader, "ui/images/" + filename)) == null) {
            result = SwtSvgImageUtil.getImageAsResourceInternal(display, filename);
        }
        return result;
    }

    public static SwtUniversalImage getUniversalImage(Display display, ClassLoader classLoader, String filename) {
        if (StringUtils.isBlank((String)filename)) {
            log.logError("Unable to load image [" + filename + "]");
            return SwtSvgImageUtil.getImageAsResource(display, NO_IMAGE);
        }
        SwtUniversalImage result = null;
        if (SvgSupport.isSvgEnabled()) {
            result = SwtSvgImageUtil.getUniversalImageInternal(display, classLoader, SvgSupport.toSvgName((String)filename));
        }
        if (result == null) {
            result = SwtSvgImageUtil.getUniversalImageInternal(display, classLoader, SvgSupport.toPngName((String)filename));
        }
        if (result == null) {
            log.logError("Unable to load image [" + filename + "]");
            result = SwtSvgImageUtil.getImageAsResource(display, NO_IMAGE);
        }
        return result;
    }

    public static SwtUniversalImage getImage(Display display, String location) {
        return SwtSvgImageUtil.getImageAsResource(display, location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SwtUniversalImage loadFromClassLoader(Display display, ClassLoader classLoader, String location) {
        InputStream s = classLoader.getResourceAsStream(location);
        if (s == null) {
            return null;
        }
        try {
            SwtUniversalImage swtUniversalImage = SwtSvgImageUtil.loadImage(display, s, location);
            return swtUniversalImage;
        }
        finally {
            IOUtils.closeQuietly((InputStream)s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SwtUniversalImage loadFromCurrentClasspath(Display display, String location) {
        InputStream s;
        URL res;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = SwtSvgImageUtil.class.getClassLoader();
        }
        if ((res = cl.getResource(location)) == null) {
            return null;
        }
        try {
            s = res.openStream();
        }
        catch (IOException ex) {
            return null;
        }
        if (s == null) {
            return null;
        }
        try {
            SwtUniversalImage swtUniversalImage = SwtSvgImageUtil.loadImage(display, s, location);
            return swtUniversalImage;
        }
        finally {
            IOUtils.closeQuietly((InputStream)s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SwtUniversalImage loadFromBasedVFS(Display display, String location) {
        SwtUniversalImage swtUniversalImage;
        FileObject imageFileObject = KettleVFS.getInstance().getFileSystemManager().resolveFile(base, location);
        InputStream s = KettleVFS.getInputStream((FileObject)imageFileObject);
        if (s == null) {
            return null;
        }
        try {
            swtUniversalImage = SwtSvgImageUtil.loadImage(display, s, location);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)s);
                throw throwable;
            }
            catch (FileSystemException ex) {
                return null;
            }
        }
        IOUtils.closeQuietly((InputStream)s);
        return swtUniversalImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SwtUniversalImage loadFromSimpleVFS(Display display, String location) {
        SwtUniversalImage swtUniversalImage;
        InputStream s = KettleVFS.getInputStream((String)location);
        if (s == null) {
            return null;
        }
        try {
            swtUniversalImage = SwtSvgImageUtil.loadImage(display, s, location);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)s);
                throw throwable;
            }
            catch (KettleFileException kettleFileException) {
                return null;
            }
        }
        IOUtils.closeQuietly((InputStream)s);
        return swtUniversalImage;
    }

    private static SwtUniversalImage loadImage(Display display, InputStream in, String filename) {
        if (!SvgSupport.isSvgName((String)filename)) {
            return new SwtUniversalImageBitmap(new Image((Device)display, in));
        }
        try {
            return new SwtUniversalImageSvg(SvgSupport.loadSvgImage((InputStream)in));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        try {
            base = KettleVFS.getInstance().getFileSystemManager().resolveFile(System.getProperty("user.dir"));
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            base = null;
        }
    }
}

