/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.libformula.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.libformula.editor.FormulaEvaluator;
import org.pentaho.libformula.editor.FormulaMessage;
import org.pentaho.libformula.editor.function.FunctionDescription;
import org.pentaho.libformula.editor.function.FunctionLib;
import org.pentaho.libformula.editor.util.CompletionProposal;
import org.pentaho.libformula.editor.util.PositionAndLength;
import org.pentaho.reporting.libraries.formula.lvalues.ParsePosition;

public class LibFormulaEditor
extends Dialog
implements KeyListener {
    public static final String FUNCTIONS_FILE = "functions.xml";
    private Shell shell;
    private Tree tree;
    private SashForm sashForm;
    private StyledText expressionEditor;
    private String formula;
    private Browser message;
    private Button ok;
    private Button cancel;
    private String[] inputFields;
    private Color blue;
    private Color red;
    private Color green;
    private Color white;
    private Color gray;
    private Color black;
    Menu helperMenu;
    private FunctionLib functionLib;
    private String[] functions;
    private String[] categories;
    private SashForm rightSash;
    private FormulaEvaluator evaluator;

    public LibFormulaEditor(Shell parent, int style, String formula, String[] inputFields) throws Exception {
        super(parent, style);
        this.formula = formula;
        this.inputFields = inputFields;
        this.shell = new Shell(parent, 3312);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        Composite buttonsComposite = new Composite((Composite)this.shell, 0);
        FillLayout bcLayout = new FillLayout();
        bcLayout.spacing = 5;
        buttonsComposite.setLayout((Layout)bcLayout);
        this.ok = new Button(buttonsComposite, 8);
        this.ok.setText("  OK  ");
        this.cancel = new Button(buttonsComposite, 8);
        this.cancel.setText(" Cancel ");
        this.ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibFormulaEditor.this.ok();
            }
        });
        this.cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibFormulaEditor.this.cancel();
            }
        });
        this.sashForm = new SashForm((Composite)this.shell, 256);
        this.sashForm.setLayout((Layout)new FillLayout());
        FormData fdSashForm = new FormData();
        fdSashForm.left = new FormAttachment(0, 0);
        fdSashForm.right = new FormAttachment(100, 0);
        fdSashForm.top = new FormAttachment(0, 10);
        fdSashForm.bottom = new FormAttachment((Control)buttonsComposite, -10);
        this.sashForm.setLayoutData((Object)fdSashForm);
        FormData fdBC = new FormData();
        fdBC.left = new FormAttachment((Control)this.sashForm, 0, 0x1000000);
        fdBC.bottom = new FormAttachment(100, 0);
        buttonsComposite.setLayoutData((Object)fdBC);
        this.readFunctions();
        this.evaluator = new FormulaEvaluator(this.functions, inputFields);
        this.tree = new Tree((Composite)this.sashForm, 4);
        for (int i = 0; i < this.categories.length; ++i) {
            String[] fnames;
            String category;
            String i18nCategory = category = this.categories[i];
            if (category.startsWith("%")) {
                i18nCategory = BaseMessages.getString(FunctionLib.class, (String)category.substring(1), (String[])new String[0]);
            }
            TreeItem item = new TreeItem(this.tree, 0);
            item.setText(i18nCategory);
            for (String fname : fnames = this.functionLib.getFunctionsForACategory(category)) {
                TreeItem fitem = new TreeItem(item, 0);
                fitem.setText(fname);
            }
        }
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeItem item;
                if (LibFormulaEditor.this.tree.getSelectionCount() == 1 && (item = LibFormulaEditor.this.tree.getSelection()[0]).getParentItem() != null) {
                    String functionName = item.getText();
                    FunctionDescription functionDescription = LibFormulaEditor.this.functionLib.getFunctionDescription(functionName);
                    if (functionDescription != null) {
                        String report = functionDescription.getHtmlReport();
                        LibFormulaEditor.this.message.setText(report);
                    }
                }
            }
        });
        this.rightSash = new SashForm((Composite)this.sashForm, 512);
        this.expressionEditor = new StyledText((Composite)this.rightSash, 0);
        this.expressionEditor.setText(this.formula);
        this.expressionEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                LibFormulaEditor.this.setStyles();
            }
        });
        this.expressionEditor.addKeyListener((KeyListener)this);
        this.message = new Browser((Composite)this.rightSash, 778);
        FormData fdMessage = new FormData();
        fdMessage.left = new FormAttachment(0, 0);
        fdMessage.right = new FormAttachment(100, 0);
        fdMessage.top = new FormAttachment(0, 0);
        fdMessage.bottom = new FormAttachment(0, 100);
        this.message.setLayoutData((Object)fdMessage);
        this.rightSash.setWeights(new int[]{10, 80});
        this.sashForm.setWeights(new int[]{15, 85});
        this.red = new Color((Device)this.shell.getDisplay(), 255, 0, 0);
        this.green = new Color((Device)this.shell.getDisplay(), 0, 220, 0);
        this.blue = new Color((Device)this.shell.getDisplay(), 0, 0, 255);
        this.white = new Color((Device)this.shell.getDisplay(), 255, 255, 255);
        this.gray = new Color((Device)this.shell.getDisplay(), 150, 150, 150);
        this.black = new Color((Device)this.shell.getDisplay(), 0, 0, 0);
        this.setStyles();
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                LibFormulaEditor.this.red.dispose();
                LibFormulaEditor.this.green.dispose();
                LibFormulaEditor.this.blue.dispose();
                LibFormulaEditor.this.white.dispose();
                LibFormulaEditor.this.gray.dispose();
                LibFormulaEditor.this.black.dispose();
            }
        });
    }

    public String open() {
        this.shell.layout();
        this.shell.open();
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                LibFormulaEditor.this.cancel();
            }
        });
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.formula;
    }

    public void ok() {
        this.formula = this.expressionEditor.getText();
        this.shell.dispose();
    }

    public void cancel() {
        this.formula = null;
        this.shell.dispose();
    }

    public void readFunctions() throws Exception {
        this.functionLib = new FunctionLib(FUNCTIONS_FILE);
        this.functions = this.functionLib.getFunctionNames();
        this.categories = this.functionLib.getFunctionCategories();
    }

    public void setStyles() {
        String expression = this.expressionEditor.getText();
        int expressionLength = expression.length();
        Map messages = this.evaluator.evaluateFormula(expression);
        Vector<StyleRange> styles = new Vector<StyleRange>();
        StringBuffer report = new StringBuffer();
        for (FormulaMessage message : messages.values()) {
            ParsePosition position = message.getPosition();
            PositionAndLength positionAndLength = PositionAndLength.calculatePositionAndLength((String)expression, (ParsePosition)position);
            int pos = positionAndLength.getPosition();
            int length = positionAndLength.getLength();
            if (pos >= expressionLength) continue;
            switch (message.getType()) {
                case 1: {
                    report.append(message.toString()).append(Const.CR);
                    StyleRange styleRangeRed = new StyleRange(pos, length, this.red, null, 1);
                    styleRangeRed.underline = true;
                    styles.add(styleRangeRed);
                    break;
                }
                case 4: {
                    styles.add(new StyleRange(pos, length, this.black, null, 1));
                    break;
                }
                case 5: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    styles.add(new StyleRange(pos, length, this.blue, this.gray, 3));
                    break;
                }
            }
        }
        this.message.setText(report.toString());
        Collections.sort(styles, new Comparator<StyleRange>(){

            @Override
            public int compare(StyleRange o1, StyleRange o2) {
                return o1.start - o2.start;
            }
        });
        Object[] styleRanges = new StyleRange[styles.size()];
        styles.copyInto(styleRanges);
        this.expressionEditor.setStyleRanges((StyleRange[])styleRanges);
    }

    public static void main(String[] args) throws Exception {
        Display display = new Display();
        String[] inputFields = new String[]{"firstname", "name"};
        LibFormulaEditor lbe = new LibFormulaEditor(new Shell(display, 0), 0, "MID(UPPER([name] & \" \" & [firstname]);5;10)", inputFields);
        lbe.open();
    }

    public void keyPressed(KeyEvent e) {
        boolean ctrl = (e.stateMask & 0x40000) != 0;
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        if (ctrl && e.character == ' ') {
            char c;
            StringBuffer beforeBuffer = new StringBuffer();
            String editor = this.expressionEditor.getText();
            for (int pos = this.expressionEditor.getCaretOffset() - 1; pos >= 0 && pos < editor.length() && !Character.isWhitespace(c = editor.charAt(pos)) && (Character.isLetterOrDigit(c) || c == '['); --pos) {
                beforeBuffer.insert(0, c);
            }
            String before = beforeBuffer.toString();
            System.out.println("BEFORE = " + before);
            if (before.equals("[")) {
                for (String string : this.inputFields) {
                    proposals.add(new CompletionProposal("[" + string + "] (input field)", string + "]", string.length() + 1));
                }
            } else if (Const.isEmpty((String)before)) {
                for (String string : this.inputFields) {
                    proposals.add(new CompletionProposal("[" + string + "] (input field)", "[" + string + "]", string.length() + 2));
                }
            } else {
                for (String string : this.inputFields) {
                    String key = "[" + string;
                    if (!key.startsWith(before) || key.equalsIgnoreCase(before)) continue;
                    proposals.add(new CompletionProposal("[" + string + "] (keyword)", string.substring(before.length()) + "]", string.length() - before.length() + 1));
                }
                for (String string : this.functions) {
                    if (!string.startsWith(before) || string.equalsIgnoreCase(before)) continue;
                    proposals.add(new CompletionProposal(string + "() (Function)", string.substring(before.length()) + "()", string.length() - before.length() + 1));
                }
            }
            if (this.helperMenu == null) {
                this.helperMenu = new Menu((Decorations)this.shell, 8);
            } else {
                for (String string : this.helperMenu.getItems()) {
                    string.dispose();
                }
            }
            final int offset = this.expressionEditor.getCaretOffset();
            Point p = this.expressionEditor.getLocationAtOffset(offset);
            int h = this.expressionEditor.getLineHeight(offset);
            Point point = GUIResource.calculateControlPosition((Control)this.expressionEditor);
            MenuItem first = null;
            if (proposals.size() == 1) {
                MenuItem item = new MenuItem(this.helperMenu, 0);
                if (first == null) {
                    first = item;
                }
                final CompletionProposal proposal = (CompletionProposal)proposals.get(0);
                item.setText(proposal.getMenuText());
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent se) {
                        LibFormulaEditor.this.expressionEditor.insert(proposal.getCompletionString());
                        LibFormulaEditor.this.expressionEditor.setSelection(offset + proposal.getOffset());
                    }
                });
                this.helperMenu.setLocation(point.x + p.x, point.y + p.y + h);
                this.helperMenu.setDefaultItem(first);
                this.helperMenu.setVisible(true);
            } else if (proposals.size() > 0) {
                int nr = 0;
                for (final CompletionProposal proposal : proposals) {
                    MenuItem item = new MenuItem(this.helperMenu, 0);
                    if (first == null) {
                        first = item;
                    }
                    item.setText(proposal.getMenuText());
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent se) {
                            LibFormulaEditor.this.expressionEditor.insert(proposal.getCompletionString());
                            LibFormulaEditor.this.expressionEditor.setSelection(offset + proposal.getOffset());
                        }
                    });
                    if (nr++ <= 5) continue;
                    break;
                }
                this.helperMenu.setLocation(point.x + p.x, point.y + p.y + h);
                this.helperMenu.setDefaultItem(first);
                this.helperMenu.setVisible(true);
            }
        }
    }

    public void keyReleased(KeyEvent arg0) {
    }
}

