/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.palo.cellinput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.palo.core.DimensionField;
import org.pentaho.di.palo.core.PaloHelper;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.palo.cellinput.PaloCellInput;
import org.pentaho.di.trans.steps.palo.cellinput.PaloCellInputData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="PaloCellInput", image="PaloCellInput.svg", i18nPackageName="org.pentaho.di.trans.steps.palo.cellinput", name="PaloCellInput.TransName", description="PaloCellInput.TransDescription", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Palo")
public class PaloCellInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private DatabaseMeta databaseMeta = null;
    private String cube = "";
    private DimensionField cubeMeasure = new DimensionField("", "", "");
    private List<DimensionField> fields = new ArrayList<DimensionField>();

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public Object clone() {
        PaloCellInputMeta retval = (PaloCellInputMeta)((Object)super.clone());
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)XMLHandler.getTagValue((Node)stepnode, (String)"connection"));
            this.cube = XMLHandler.getTagValue((Node)stepnode, (String)"cube");
            String cubeMeasureName = XMLHandler.getTagValue((Node)stepnode, (String)"cubemeasurename");
            String cubeMeasureType = XMLHandler.getTagValue((Node)stepnode, (String)"cubemeasuretype");
            this.cubeMeasure = new DimensionField("Measure", cubeMeasureName, cubeMeasureType);
            this.fields = new ArrayList<DimensionField>();
            Node levels = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrLevels = XMLHandler.countNodes((Node)levels, (String)"field");
            for (int i = 0; i < nrLevels; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)levels, (String)"field", (int)i);
                String dimensionName = XMLHandler.getTagValue((Node)fnode, (String)"dimensionname");
                String fieldName = XMLHandler.getTagValue((Node)fnode, (String)"fieldname");
                String fieldType = XMLHandler.getTagValue((Node)fnode, (String)"fieldtype");
                this.fields.add(new DimensionField(dimensionName, fieldName, fieldType));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void setDefault() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (this.databaseMeta == null) {
            throw new KettleStepException("There is no Palo database server connection defined");
        }
        PaloHelper helper = new PaloHelper(this.databaseMeta, DefaultLogLevel.getLogLevel());
        try {
            helper.connect();
            try {
                RowMetaInterface rowMeta = helper.getCellRowMeta(this.cube, this.fields, this.cubeMeasure);
                row.addRowMeta(rowMeta);
            }
            finally {
                helper.disconnect();
            }
        }
        catch (Exception e) {
            throw new KettleStepException((Throwable)e);
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"cube", (String)this.cube));
        retval.append("    ").append(XMLHandler.addTagValue((String)"cubemeasurename", (String)this.cubeMeasure.getFieldName()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"cubemeasuretype", (String)this.cubeMeasure.getFieldType()));
        retval.append("    <fields>").append(Const.CR);
        for (DimensionField field : this.fields) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"dimensionname", (String)field.getDimensionName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"fieldname", (String)field.getFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"fieldtype", (String)field.getFieldType()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId idStep, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(idStep, "connection", databases);
            this.cube = rep.getStepAttributeString(idStep, "cube");
            String cubeMeasureName = rep.getStepAttributeString(idStep, "cubemeasurename");
            String cubeMeasureType = rep.getStepAttributeString(idStep, "cubemeasuretype");
            this.cubeMeasure = new DimensionField("Measure", cubeMeasureName, cubeMeasureType);
            int nrFields = rep.countNrStepAttributes(idStep, "dimensionname");
            for (int i = 0; i < nrFields; ++i) {
                String dimensionName = rep.getStepAttributeString(idStep, i, "dimensionname");
                String fieldName = rep.getStepAttributeString(idStep, i, "fieldname");
                String fieldType = rep.getStepAttributeString(idStep, i, "fieldtype");
                this.fields.add(new DimensionField(dimensionName, fieldName, fieldType));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId idTransformation, ObjectId idStep) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(idTransformation, idStep, "connection", this.databaseMeta);
            rep.saveStepAttribute(idTransformation, idStep, "cube", this.cube);
            rep.saveStepAttribute(idTransformation, idStep, "cubemeasurename", this.cubeMeasure.getFieldName());
            rep.saveStepAttribute(idTransformation, idStep, "cubemeasuretype", this.cubeMeasure.getFieldType());
            for (int i = 0; i < this.fields.size(); ++i) {
                rep.saveStepAttribute(idTransformation, idStep, i, "dimensionname", this.fields.get(i).getDimensionName());
                rep.saveStepAttribute(idTransformation, idStep, i, "fieldname", this.fields.get(i).getFieldName());
                rep.saveStepAttribute(idTransformation, idStep, i, "fieldtype", this.fields.get(i).getFieldType());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for idStep=" + idStep, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        if (this.databaseMeta != null) {
            CheckResult cr = new CheckResult(1, "Connection exists", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            PaloHelper helper = new PaloHelper(this.databaseMeta, DefaultLogLevel.getLogLevel());
            try {
                helper.connect();
                cr = new CheckResult(1, "Connection to database OK", (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
                if (!Const.isEmpty((String)this.cube)) {
                    cr = new CheckResult(1, "The name of the cube is entered", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else {
                    cr = new CheckResult(4, "The name of the cube is missing.", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                if (this.cubeMeasure == null) {
                    cr = new CheckResult(4, "Measure field is empty.", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                } else {
                    if (Const.isEmpty((String)this.cubeMeasure.getFieldName())) {
                        cr = new CheckResult(4, "Measure field Name is empty.", (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                    if (Const.isEmpty((String)this.cubeMeasure.getFieldType())) {
                        cr = new CheckResult(4, "Measure field Type is empty.", (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                if (this.fields == null || this.fields.size() == 0) {
                    cr = new CheckResult(4, "Cell Input Fields are empty.", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                for (DimensionField field : this.fields) {
                    if (Const.isEmpty((String)field.getFieldName())) {
                        cr = new CheckResult(4, "Output field for dimension " + field.getDimensionName() + " is empty.", (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                    if (!Const.isEmpty((String)field.getFieldType())) continue;
                    cr = new CheckResult(4, "Output field type for dimension " + field.getDimensionName() + " is empty.", (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
            }
            catch (KettleException e) {
                cr = new CheckResult(4, "An error occurred: " + e.getMessage(), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                helper.disconnect();
            }
        } else {
            CheckResult cr = new CheckResult(4, "Please select or create a connection to use", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new PaloCellInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        try {
            return new PaloCellInputData(this.databaseMeta);
        }
        catch (Exception e) {
            return null;
        }
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public String getCube() {
        return this.cube;
    }

    public void setCube(String cube) {
        this.cube = cube;
    }

    public List<DimensionField> getFields() {
        return this.fields;
    }

    public void setLevels(List<DimensionField> fields) {
        this.fields = fields;
    }

    public DimensionField getCubeMeasure() {
        return this.cubeMeasure;
    }

    public void setCubeMeasureName(DimensionField cubeMeasure) {
        this.cubeMeasure = cubeMeasure;
    }
}

