/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hdfs.server.datanode.DataBlockScanner;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RollingLogs;

class RollingLogsImpl
implements RollingLogs {
    private static final String CURR_SUFFIX = ".curr";
    private static final String PREV_SUFFIX = ".prev";
    private final File curr;
    private final File prev;
    private PrintWriter out;
    private final RollingLogs.Appender appender = new RollingLogs.Appender(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Appendable append(CharSequence csq) {
            RollingLogsImpl rollingLogsImpl = RollingLogsImpl.this;
            synchronized (rollingLogsImpl) {
                if (RollingLogsImpl.this.out == null) {
                    throw new IllegalStateException(RollingLogsImpl.this + " is not yet opened.");
                }
                RollingLogsImpl.this.out.print(csq);
                RollingLogsImpl.this.out.flush();
            }
            return this;
        }

        @Override
        public Appendable append(char c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            RollingLogsImpl rollingLogsImpl = RollingLogsImpl.this;
            synchronized (rollingLogsImpl) {
                if (RollingLogsImpl.this.out != null) {
                    RollingLogsImpl.this.out.close();
                    RollingLogsImpl.this.out = null;
                }
            }
        }
    };
    private final AtomicInteger numReaders = new AtomicInteger();

    static boolean isFilePresent(String dir, String filePrefix) {
        return new File(dir, filePrefix + CURR_SUFFIX).exists() || new File(dir, filePrefix + PREV_SUFFIX).exists();
    }

    RollingLogsImpl(String dir, String filePrefix) throws FileNotFoundException {
        this.curr = new File(dir, filePrefix + CURR_SUFFIX);
        this.prev = new File(dir, filePrefix + PREV_SUFFIX);
        this.out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.curr, true), Charsets.UTF_8));
    }

    @Override
    public Reader iterator(boolean skipPrevFile) throws IOException {
        this.numReaders.incrementAndGet();
        return new Reader(skipPrevFile);
    }

    @Override
    public RollingLogs.Appender appender() {
        return this.appender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean roll() throws IOException {
        if (this.numReaders.get() > 0) {
            return false;
        }
        if (!this.prev.delete() && this.prev.exists()) {
            throw new IOException("Failed to delete " + this.prev);
        }
        RollingLogsImpl rollingLogsImpl = this;
        synchronized (rollingLogsImpl) {
            this.appender.close();
            boolean renamed = this.curr.renameTo(this.prev);
            this.out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.curr, true), Charsets.UTF_8));
            if (!renamed) {
                throw new IOException("Failed to rename " + this.curr + " to " + this.prev);
            }
        }
        return true;
    }

    public String toString() {
        return this.curr.toString();
    }

    private class Reader
    implements RollingLogs.LineIterator {
        private File file;
        private File lastReadFile;
        private BufferedReader reader = null;
        private String line;
        private boolean closed = false;

        private Reader(boolean skipPrevFile) throws IOException {
            this.file = skipPrevFile ? RollingLogsImpl.this.curr : RollingLogsImpl.this.prev;
            this.readNext();
        }

        @Override
        public boolean isPrevious() {
            return this.file == RollingLogsImpl.this.prev;
        }

        @Override
        public boolean isLastReadFromPrevious() {
            return this.lastReadFile == RollingLogsImpl.this.prev;
        }

        private boolean openFile() throws IOException {
            for (int i = 0; i < 2; ++i) {
                if (this.reader != null || i > 0) {
                    File file = this.file = this.isPrevious() ? RollingLogsImpl.this.curr : null;
                }
                if (this.file == null) {
                    return false;
                }
                if (this.file.exists()) break;
            }
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), Charsets.UTF_8));
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readNext() throws IOException {
            this.line = null;
            try {
                if (this.reader != null && (this.line = this.reader.readLine()) != null) {
                    return;
                }
                if (this.line == null && this.openFile()) {
                    this.readNext();
                }
            }
            finally {
                if (!this.hasNext()) {
                    this.close();
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.line != null;
        }

        @Override
        public String next() {
            String curLine = this.line;
            try {
                this.lastReadFile = this.file;
                this.readNext();
            }
            catch (IOException e) {
                DataBlockScanner.LOG.warn((Object)"Failed to read next line.", (Throwable)e);
            }
            return curLine;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (!this.closed) {
                try {
                    if (this.reader != null) {
                        this.reader.close();
                    }
                }
                finally {
                    this.file = null;
                    this.reader = null;
                    this.closed = true;
                    int n = RollingLogsImpl.this.numReaders.decrementAndGet();
                    assert (n >= 0);
                }
            }
        }
    }
}

