/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import javax.measure.converter.MultiplyConverter;
import javax.measure.converter.UnitConverter;

public final class RationalConverter
extends UnitConverter {
    private final long _dividend;
    private final long _divisor;
    private static final long serialVersionUID = 1L;

    public RationalConverter(long dividend, long divisor) {
        if (divisor < 0L) {
            throw new IllegalArgumentException("Negative divisor");
        }
        if (dividend == divisor) {
            throw new IllegalArgumentException("Identity converter not allowed");
        }
        this._dividend = dividend;
        this._divisor = divisor;
    }

    public long getDividend() {
        return this._dividend;
    }

    public long getDivisor() {
        return this._divisor;
    }

    @Override
    public UnitConverter inverse() {
        return this._dividend < 0L ? new RationalConverter(-this._divisor, -this._dividend) : new RationalConverter(this._divisor, this._dividend);
    }

    @Override
    public double convert(double amount) {
        return amount * (double)this._dividend / (double)this._divisor;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public UnitConverter concatenate(UnitConverter converter) {
        if (converter instanceof RationalConverter) {
            RationalConverter that = (RationalConverter)converter;
            long dividendLong = this._dividend * that._dividend;
            long divisorLong = this._divisor * that._divisor;
            double dividendDouble = (double)this._dividend * (double)that._dividend;
            double divisorDouble = (double)this._divisor * (double)that._divisor;
            if ((double)dividendLong != dividendDouble || (double)divisorLong != divisorDouble) {
                return new MultiplyConverter(dividendDouble / divisorDouble);
            }
            long gcd = RationalConverter.gcd(dividendLong, divisorLong);
            return RationalConverter.valueOf(dividendLong / gcd, divisorLong / gcd);
        }
        if (converter instanceof MultiplyConverter) {
            return converter.concatenate(this);
        }
        return super.concatenate(converter);
    }

    private static UnitConverter valueOf(long dividend, long divisor) {
        return dividend == 1L && divisor == 1L ? UnitConverter.IDENTITY : new RationalConverter(dividend, divisor);
    }

    private static long gcd(long m, long n) {
        if (n == 0L) {
            return m;
        }
        return RationalConverter.gcd(n, m % n);
    }
}

