/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.List;
import javolution.context.ObjectFactory;
import javolution.context.StackContext;
import javolution.util.FastTable;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.mathematics.structure.Field;
import org.jscience.mathematics.vector.DimensionException;
import org.jscience.mathematics.vector.Vector;

public final class DenseVector<F extends Field<F>>
extends Vector<F> {
    protected static final XMLFormat<DenseVector> XML = new XMLFormat<DenseVector>(DenseVector.class){

        @Override
        public DenseVector newInstance(Class<DenseVector> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return (DenseVector)FACTORY.object();
        }

        @Override
        public void read(XMLFormat.InputElement xml, DenseVector V) throws XMLStreamException {
            int dimension = xml.getAttribute("dimension", 0);
            for (int i = 0; i < dimension; ++i) {
                V._elements.add(xml.getNext());
            }
            if (xml.hasNext()) {
                throw new XMLStreamException("Too many elements");
            }
        }

        @Override
        public void write(DenseVector V, XMLFormat.OutputElement xml) throws XMLStreamException {
            int dimension = V._elements.size();
            xml.setAttribute("dimension", dimension);
            int i = 0;
            while (i < dimension) {
                xml.add(V._elements.get(i++));
            }
        }
    };
    final FastTable<F> _elements = new FastTable();
    private static final ObjectFactory<DenseVector> FACTORY = new ObjectFactory<DenseVector>(){

        @Override
        protected DenseVector create() {
            return new DenseVector();
        }

        @Override
        protected void cleanup(DenseVector vector) {
            vector._elements.reset();
        }
    };
    private static final long serialVersionUID = 1L;

    public static <F extends Field<F>> DenseVector<F> valueOf(F ... elements) {
        DenseVector<F> V = DenseVector.newInstance();
        int i = 0;
        int n = elements.length;
        while (i < n) {
            V._elements.add(elements[i++]);
        }
        return V;
    }

    public static <F extends Field<F>> DenseVector<F> valueOf(List<F> elements) {
        DenseVector<F> V = DenseVector.newInstance();
        V._elements.addAll(elements);
        return V;
    }

    public static <F extends Field<F>> DenseVector<F> valueOf(Vector<F> that) {
        if (that instanceof DenseVector) {
            return (DenseVector)that;
        }
        DenseVector<F> V = DenseVector.newInstance();
        int i = 0;
        int n = that.getDimension();
        while (i < n) {
            V._elements.add(that.get(i++));
        }
        return V;
    }

    @Override
    public int getDimension() {
        return this._elements.size();
    }

    @Override
    public F get(int i) {
        return (F)((Field)this._elements.get(i));
    }

    @Override
    public DenseVector<F> opposite() {
        DenseVector<F> V = DenseVector.newInstance();
        int i = 0;
        int n = this._elements.size();
        while (i < n) {
            V._elements.add(((Field)this._elements.get(i++)).opposite());
        }
        return V;
    }

    @Override
    public DenseVector<F> plus(Vector<F> that) {
        int n = this._elements.size();
        if (that.getDimension() != n) {
            throw new DimensionException();
        }
        DenseVector<F> V = DenseVector.newInstance();
        for (int i = 0; i < n; ++i) {
            V._elements.add(((Field)this._elements.get(i)).plus(that.get(i)));
        }
        return V;
    }

    @Override
    public DenseVector<F> minus(Vector<F> that) {
        return this.plus((Vector)that.opposite());
    }

    @Override
    public DenseVector<F> times(F k) {
        DenseVector<F> V = DenseVector.newInstance();
        int i = 0;
        int n = this._elements.size();
        while (i < n) {
            V._elements.add(((Field)this._elements.get(i++)).times(k));
        }
        return V;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public F times(Vector<F> that) {
        int n = this._elements.size();
        if (that.getDimension() != n) {
            throw new DimensionException();
        }
        StackContext.enter();
        try {
            Field sum = (Field)((Field)this._elements.get(0)).times(that.get(0));
            for (int i = 1; i < n; ++i) {
                sum = (Field)sum.plus(((Field)this._elements.get(i)).times(that.get(i)));
            }
            Field field = StackContext.outerCopy(sum);
            return (F)field;
        }
        finally {
            StackContext.exit();
        }
    }

    @Override
    public DenseVector<F> copy() {
        DenseVector<F> V = DenseVector.newInstance();
        for (Field e : this._elements) {
            V._elements.add((Field)e.copy());
        }
        return V;
    }

    static <F extends Field<F>> DenseVector<F> newInstance() {
        return FACTORY.object();
    }

    private DenseVector() {
    }
}

