/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.Expression;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.AbstractSwingContainer;
import org.pentaho.ui.xul.swing.tags.SwingMenuitem;
import org.pentaho.ui.xul.swing.tags.SwingMenupopup;

public class SwingMenuList<T>
extends AbstractSwingContainer
implements XulMenuList<T> {
    private JComboBox combobox;
    private XulDomContainer xulDomContainer;
    private static final Log logger = LogFactory.getLog(SwingMenuList.class);
    private boolean loaded = false;
    private String binding;
    private String previousSelectedItem = null;
    private boolean editable = false;
    private boolean suppressLayout = false;
    private boolean inLayoutProcess = false;
    private String oldValue = "";
    private JTextComponent textComp;

    public SwingMenuList(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("menulist");
        this.xulDomContainer = domContainer;
        this.combobox = new JComboBox(new DefaultComboBoxModel());
        this.setManagedObject(this.combobox);
        this.combobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && !SwingMenuList.this.inLayoutProcess && SwingMenuList.this.initialized) {
                    SwingMenuList.this.fireSelectedEvents();
                }
            }
        });
    }

    @Override
    public void layout() {
        this.inLayoutProcess = true;
        if (this.suppressLayout) {
            this.inLayoutProcess = false;
            return;
        }
        SwingMenupopup popup = this.getPopupElement();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.combobox.getModel();
        model.removeAllElements();
        SwingMenuitem selectedItem = null;
        boolean firstChild = true;
        for (XulComponent item : popup.getChildNodes()) {
            JMenuItem jmenuItem = (JMenuItem)((SwingMenuitem)item).getManagedObject();
            SwingMenuitem tempItem = (SwingMenuitem)item;
            model.addElement(tempItem);
            if (!tempItem.isSelected() && !firstChild) continue;
            selectedItem = tempItem;
            firstChild = false;
        }
        this.inLayoutProcess = false;
        if (selectedItem != null) {
            if (model.getSelectedItem() == selectedItem) {
                this.fireSelectedEvents();
            }
            model.setSelectedItem((Object)selectedItem);
        }
        this.initialized = true;
        this.loaded = true;
    }

    public void onDomReady() {
        if (this.combobox.getSelectedItem() != null) {
            this.fireSelectedEvents();
        }
    }

    private void fireSelectedEvents() {
        this.changeSupport.firePropertyChange("selectedItem", this.previousSelectedItem, this.getSelectedItem());
        this.changeSupport.firePropertyChange("selectedIndex", null, (Object)this.combobox.getSelectedIndex());
        this.previousSelectedItem = this.getSelectedItem();
    }

    public SwingMenupopup getPopupElement() {
        for (Element comp : this.getChildNodes()) {
            if (!SwingMenupopup.class.isAssignableFrom(comp.getClass())) continue;
            return (SwingMenupopup)comp;
        }
        throw new IllegalStateException("menulist is missing a menupopup child element");
    }

    @Deprecated
    public void replaceAllItems(Collection<T> tees) {
        this.setElements(tees);
    }

    public String getSelectedItem() {
        if (this.editable) {
            return this.textComp.getText();
        }
        return ((SwingMenuitem)((Object)this.combobox.getModel().getSelectedItem())).getLabel();
    }

    public void setSelectedItem(T t) {
        SwingMenupopup popup = this.getPopupElement();
        for (XulComponent item : popup.getChildNodes()) {
            SwingMenuitem tempItem = (SwingMenuitem)item;
            if (!tempItem.getLabel().equals(this.extractLabel(t))) continue;
            this.combobox.setSelectedItem((Object)tempItem);
        }
    }

    public void setOncommand(final String command) {
        this.combobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!SwingMenuList.this.loaded) {
                    return;
                }
                Document doc = SwingMenuList.this.getDocument();
                XulRoot window = (XulRoot)doc.getRootElement();
                final XulDomContainer con = window.getXulDomContainer();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            con.invoke(command, new Object[0]);
                        }
                        catch (XulException e) {
                            logger.error((Object)"Error calling oncommand event", (Throwable)e);
                        }
                    }
                });
            }
        });
    }

    public Collection<T> getElements() {
        return this.getPopupElement().getChildNodes();
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    private String extractLabel(T t) {
        String attribute = this.getBinding();
        if (StringUtils.isEmpty((String)attribute)) {
            return t.toString();
        }
        String getter = "get" + String.valueOf(attribute.charAt(0)).toUpperCase() + attribute.substring(1);
        try {
            return new Expression(t, getter, null).getValue().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setElements(Collection<T> tees) {
        this.suppressLayout = true;
        SwingMenupopup popup = this.getPopupElement();
        for (XulComponent menuItem : popup.getChildNodes()) {
            popup.removeChild((Element)menuItem);
        }
        for (Object t : tees) {
            SwingMenuitem item = new SwingMenuitem(null, (XulComponent)popup, this.xulDomContainer, null);
            String attribute = this.getBinding();
            item.setLabel(this.extractLabel(t));
            popup.addChild((Element)item);
        }
        this.suppressLayout = false;
        this.layout();
    }

    public int getSelectedIndex() {
        return this.combobox.getSelectedIndex();
    }

    public void setSelectedIndex(int idx) {
        this.combobox.setSelectedIndex(idx);
    }

    public void setWidth(int width) {
        super.setWidth(width);
        Dimension box = new Dimension();
        box.height = this.combobox.getPreferredSize().height;
        box.width = width;
        this.combobox.setMaximumSize(box);
        this.combobox.setPreferredSize(box);
        this.combobox.setMinimumSize(box);
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.combobox.setEditable(editable);
        if (editable) {
            this.textComp = (JTextComponent)this.combobox.getEditor().getEditorComponent();
            this.textComp.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    SwingMenuList.this.oldValue = SwingMenuList.this.textComp.getText();
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (SwingMenuList.this.oldValue != null && !SwingMenuList.this.oldValue.equals(SwingMenuList.this.textComp.getText())) {
                        SwingMenuList.this.changeSupport.firePropertyChange("value", SwingMenuList.this.oldValue, SwingMenuList.this.getValue());
                        SwingMenuList.this.oldValue = SwingMenuList.this.textComp.getText();
                    } else if (SwingMenuList.this.oldValue == null) {
                        SwingMenuList.this.oldValue = SwingMenuList.this.textComp.getText();
                    } else {
                        logger.debug((Object)"Special key pressed, ignoring");
                    }
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
        }
    }

    public boolean getEditable() {
        return this.editable;
    }

    public String getValue() {
        return this.textComp != null ? this.textComp.getText() : ((SwingMenuitem)((Object)this.combobox.getModel().getSelectedItem())).getLabel();
    }

    public void setValue(String value) {
        if (this.editable) {
            ((JTextComponent)this.combobox.getEditor().getEditorComponent()).setText(value);
        }
    }
}

