/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.Algebraic;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigWarning;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigLogger;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigProgressable;
import org.apache.pig.builtin.OutputSchema;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class EvalFunc<T> {
    protected PigProgressable reporter;
    protected Log log = LogFactory.getLog(this.getClass());
    protected PigLogger pigLogger;
    private static int nextSchemaId;
    protected Type returnType;
    private Schema inputSchemaInternal = null;

    protected String getSchemaName(String name, Schema input) {
        String alias = name + "_";
        if (input != null && input.getAliases().size() > 0) {
            alias = alias + input.getAliases().iterator().next() + "_";
        }
        alias = alias + ++nextSchemaId;
        return alias;
    }

    public EvalFunc() {
        HashMap typesByTypeVariable = new HashMap();
        Class<?> cls = this.getClass();
        Type type = cls.getGenericSuperclass();
        cls = cls.getSuperclass();
        while (EvalFunc.class.isAssignableFrom(cls)) {
            TypeVariable<Class<?>>[] typeParams = cls.getTypeParameters();
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Type[] typeArgs = pType.getActualTypeArguments();
                for (int i = 0; i < typeParams.length; ++i) {
                    typesByTypeVariable.put(typeParams[i], typeArgs[i]);
                }
            }
            type = cls.getGenericSuperclass();
            cls = cls.getSuperclass();
        }
        Type targetType = EvalFunc.class.getTypeParameters()[0];
        while (targetType != null && targetType instanceof TypeVariable) {
            targetType = (Type)typesByTypeVariable.get(targetType);
        }
        if (targetType == null || targetType instanceof GenericArrayType || targetType instanceof WildcardType) {
            throw new RuntimeException(String.format("Failed to determine concrete type for type parameter T of EvalFunc<T> for derived class '%s'", this.getClass().getName()));
        }
        this.returnType = targetType;
        if (this instanceof Algebraic) {
            Algebraic a = (Algebraic)((Object)this);
            String errMsg = "function of " + this.getClass().getName() + " is not of the expected type.";
            if (this.getReturnTypeFromSpec(new FuncSpec(a.getInitial())) != Tuple.class) {
                throw new RuntimeException("Initial " + errMsg);
            }
            if (this.getReturnTypeFromSpec(new FuncSpec(a.getIntermed())) != Tuple.class) {
                throw new RuntimeException("Intermediate " + errMsg);
            }
            if (!this.getReturnTypeFromSpec(new FuncSpec(a.getFinal())).equals(this.returnType)) {
                throw new RuntimeException("Final " + errMsg);
            }
        }
    }

    private Type getReturnTypeFromSpec(FuncSpec funcSpec) {
        try {
            return ((EvalFunc)PigContext.instantiateFuncFromSpec(funcSpec)).getReturnType();
        }
        catch (ClassCastException e) {
            throw new RuntimeException(funcSpec + " does not specify an eval func", e);
        }
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public final void progress() {
        if (this.reporter != null) {
            this.reporter.progress();
        } else {
            this.warn("No reporter object provided to UDF.", PigWarning.PROGRESS_REPORTER_NOT_PROVIDED);
        }
    }

    public final void warn(String msg, Enum warningEnum) {
        if (this.pigLogger != null) {
            this.pigLogger.warn(this, msg, warningEnum);
        } else {
            this.log.warn((Object)("No logger object provided to UDF: " + this.getClass().getName() + ". " + msg));
        }
    }

    public void finish() {
    }

    public abstract T exec(Tuple var1) throws IOException;

    public Schema outputSchema(Schema input) {
        OutputSchema schema = this.getClass().getAnnotation(OutputSchema.class);
        try {
            return schema == null ? null : Utils.getSchemaFromString(schema.value());
        }
        catch (ParserException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public boolean isAsynchronous() {
        return false;
    }

    public PigProgressable getReporter() {
        return this.reporter;
    }

    public final void setReporter(PigProgressable reporter) {
        this.reporter = reporter;
    }

    public List<FuncSpec> getArgToFuncMapping() throws FrontendException {
        return null;
    }

    public List<String> getCacheFiles() {
        return null;
    }

    public List<String> getShipFiles() {
        return null;
    }

    public PigLogger getPigLogger() {
        return this.pigLogger;
    }

    public final void setPigLogger(PigLogger pigLogger) {
        this.pigLogger = pigLogger;
    }

    public Log getLogger() {
        return this.log;
    }

    public void setUDFContextSignature(String signature) {
    }

    public void setInputSchema(Schema input) {
        this.inputSchemaInternal = input;
    }

    public Schema getInputSchema() {
        return this.inputSchemaInternal;
    }

    public SchemaType getSchemaType() {
        return SchemaType.NORMAL;
    }

    public boolean allowCompileTimeCalculation() {
        return false;
    }

    public static enum SchemaType {
        NORMAL,
        VARARG;

    }
}

