/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.util.ArrayList;
import java.util.List;
import org.apache.pig.data.DataType;

public class ColumnInfo
implements Cloneable {
    List<Integer> columns;
    byte resultType;
    int startCol = -1;
    boolean isRangeProject = false;

    public ColumnInfo(List<Integer> columns, byte type) {
        this.columns = columns;
        this.resultType = type;
    }

    public ColumnInfo(int startCol, byte type) {
        this.startCol = startCol;
        this.resultType = type;
        this.isRangeProject = true;
    }

    public byte getResultType() {
        return this.resultType;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public boolean isRangeProject() {
        return this.isRangeProject;
    }

    public List<Integer> getColumns() {
        return this.columns;
    }

    public String toString() {
        if (this.isStar()) {
            String string = "[*]:";
        }
        String result = this.columns.toString() + ":";
        result = result + DataType.findTypeName(this.resultType);
        return result;
    }

    private boolean isStar() {
        return this.isRangeProject && this.startCol == 0;
    }

    public boolean equals(Object o2) {
        if (o2 == null || !(o2 instanceof ColumnInfo)) {
            return false;
        }
        ColumnInfo c2 = (ColumnInfo)o2;
        return this.isRangeProject == c2.isRangeProject && this.startCol == c2.startCol && (this.columns == null && c2.columns == null || this.columns != null && ((Object)this.columns).equals(c2.columns));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        ColumnInfo newColInfo = (ColumnInfo)super.clone();
        ArrayList<Integer> cols = new ArrayList<Integer>();
        cols.addAll(this.columns);
        newColInfo.columns = cols;
        return newColInfo;
    }
}

