/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.partitioners;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.io.NullablePartitionWritable;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.util.Pair;

public class SkewedPartitioner
extends Partitioner<PigNullableWritable, Writable>
implements Configurable {
    protected static final TupleFactory tf = TupleFactory.getInstance();
    protected Map<Tuple, Pair<Integer, Integer>> reducerMap = Maps.newHashMap();
    protected Integer totalReducers = -1;
    protected boolean inited = false;
    private Map<Tuple, Integer> currentIndexMap = Maps.newHashMap();
    private Configuration conf;

    public int getPartition(PigNullableWritable wrappedKey, Writable value, int numPartitions) {
        if (!this.inited) {
            this.init();
        }
        if (wrappedKey instanceof NullablePartitionWritable && ((NullablePartitionWritable)wrappedKey).getPartition() != -1) {
            return ((NullablePartitionWritable)wrappedKey).getPartition();
        }
        Integer curIndex = -1;
        Tuple keyTuple = tf.newTuple(1);
        PigNullableWritable key = ((NullablePartitionWritable)wrappedKey).getKey();
        try {
            keyTuple.set(0, key.getValueAsPigType());
        }
        catch (ExecException e) {
            return -1;
        }
        if (key instanceof NullableTuple && key.getValueAsPigType() != null) {
            keyTuple = (Tuple)key.getValueAsPigType();
        }
        this.totalReducers = this.totalReducers > 0 ? this.totalReducers : numPartitions;
        Pair<Integer, Integer> indexes = this.reducerMap.get(keyTuple);
        if (indexes == null) {
            return Math.abs(keyTuple.hashCode() % this.totalReducers);
        }
        if (this.currentIndexMap.containsKey(keyTuple)) {
            curIndex = this.currentIndexMap.get(keyTuple);
        }
        if (curIndex >= (Integer)indexes.first + (Integer)indexes.second || curIndex == -1) {
            curIndex = (Integer)indexes.first;
        } else {
            Integer n = curIndex;
            Integer n2 = curIndex = Integer.valueOf(curIndex + 1);
        }
        this.currentIndexMap.put(keyTuple, curIndex);
        return curIndex % this.totalReducers;
    }

    public void setConf(Configuration job) {
        this.conf = job;
        PigMapReduce.sJobConfInternal.set(this.conf);
        PigMapReduce.sJobConf = this.conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    protected void init() {
        String keyDistFile = this.conf.get("pig.keyDistFile", "");
        if (keyDistFile.length() == 0) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getSimpleName() + " used but no key distribution found");
        }
        try {
            Integer[] redCnt = new Integer[1];
            this.reducerMap = MapRedUtil.loadPartitionFileFromLocalCache(keyDistFile, redCnt, (byte)110, this.conf);
            this.totalReducers = redCnt[0] == null ? -1 : redCnt[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.inited = true;
    }
}

