/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.filecache.ClientDistributedCacheManager;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.HDataType;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.JobCreationException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.JobControlCompiler;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PhyPlanSetter;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigBigDecimalRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigBigIntegerRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigBooleanRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigBytesRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigCombiner;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigDateTimeRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigDoubleRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigFloatRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigInputFormat;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigIntRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigLongRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigOutputFormat;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSecondaryKeyComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigTextRawComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigTupleSortComparator;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.partitioners.SecondaryKeyPartitioner;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.EndOfAllInputSetter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.backend.hadoop.executionengine.tez.TezJobCompiler;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPOPackageAnnotator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POIdentityInOutTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POLocalRearrangeTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POShuffleTezLoad;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POValueInputTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.udf.ReadScalarsTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.PartitionerDefinedVertexManager;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.PigOutputFormatTez;
import org.apache.pig.backend.hadoop.executionengine.tez.util.MRToTezHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.util.SecurityHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.util.TezCompilerUtil;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.io.NullablePartitionWritable;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.tools.pigstats.tez.TezScriptState;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeManagerPluginDescriptor;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.GroupInputEdge;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.VertexGroup;
import org.apache.tez.dag.api.VertexLocationHint;
import org.apache.tez.dag.api.VertexManagerPluginDescriptor;
import org.apache.tez.dag.library.vertexmanager.ShuffleVertexManager;
import org.apache.tez.mapreduce.combine.MRCombiner;
import org.apache.tez.mapreduce.committer.MROutputCommitter;
import org.apache.tez.mapreduce.common.MRInputSplitDistributor;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.mapreduce.input.MRInput;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.mapreduce.partition.MRPartitioner;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.library.input.ConcatenatedMergedKeyValueInput;
import org.apache.tez.runtime.library.input.OrderedGroupedKVInput;
import org.apache.tez.runtime.library.input.OrderedGroupedMergedKVInput;
import org.apache.tez.runtime.library.input.UnorderedKVInput;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class TezDagBuilder
extends TezOpPlanVisitor {
    private static final Log log = LogFactory.getLog(TezJobCompiler.class);
    private DAG dag;
    private Map<String, LocalResource> localResources;
    private PigContext pc;
    private Configuration globalConf;
    private long intermediateTaskInputSize;

    public TezDagBuilder(PigContext pc, TezOperPlan plan, DAG dag, Map<String, LocalResource> localResources) {
        super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(plan));
        this.pc = pc;
        this.globalConf = ConfigurationUtil.toConfiguration(pc.getProperties(), true);
        this.localResources = localResources;
        this.dag = dag;
        try {
            SecurityHelper.populateTokenCache(this.globalConf, dag.getCredentials());
        }
        catch (IOException e) {
            throw new RuntimeException("Error while fetching delegation tokens", e);
        }
        try {
            this.intermediateTaskInputSize = HadoopShims.getDefaultBlockSize(FileSystem.get((Configuration)this.globalConf), FileLocalizer.getTemporaryResourcePath(pc));
        }
        catch (Exception e) {
            log.warn((Object)"Unable to get the block size for temporary directory, defaulting to 128MB", (Throwable)e);
            this.intermediateTaskInputSize = 0x8000000L;
        }
        this.intermediateTaskInputSize = Math.max(this.intermediateTaskInputSize, 0x8000000L);
        this.intermediateTaskInputSize = Math.min(this.intermediateTaskInputSize, this.globalConf.getLong("pig.exec.reducers.bytes.per.reducer", 1000000000L));
    }

    @Override
    public void visitTezOp(TezOperator tezOp) throws VisitorException {
        TezOperPlan tezPlan = (TezOperPlan)this.getPlan();
        List<TezOperator> predecessors = tezPlan.getPredecessors(tezOp);
        Vertex to = null;
        try {
            if (!tezOp.isVertexGroup()) {
                to = this.newVertex(tezOp);
                this.dag.addVertex(to);
            }
        }
        catch (Exception e) {
            throw new VisitorException("Cannot create vertex for " + tezOp.name(), e);
        }
        if (predecessors != null) {
            Vertex[] groupMembers = new Vertex[predecessors.size()];
            for (int i = 0; i < predecessors.size(); ++i) {
                TezOperator pred = predecessors.get(i);
                try {
                    VertexGroup from;
                    if (pred.isVertexGroup()) {
                        from = pred.getVertexGroupInfo().getVertexGroup();
                        GroupInputEdge edge = this.newGroupInputEdge((TezOperator)((TezOperPlan)this.getPlan()).getOperator(pred.getVertexGroupMembers().get(0)), tezOp, from, to);
                        this.dag.addEdge(edge);
                        continue;
                    }
                    from = this.dag.getVertex(pred.getOperatorKey().toString());
                    if (tezOp.isVertexGroup()) {
                        groupMembers[i] = from;
                        continue;
                    }
                    EdgeProperty prop = this.newEdge(pred, tezOp);
                    Edge edge = Edge.create((Vertex)from, (Vertex)to, (EdgeProperty)prop);
                    this.dag.addEdge(edge);
                    continue;
                }
                catch (IOException e) {
                    throw new VisitorException("Cannot create edge from " + pred.name() + " to " + tezOp.name(), e);
                }
            }
            if (tezOp.isVertexGroup()) {
                String groupName = tezOp.getOperatorKey().toString();
                VertexGroup vertexGroup = this.dag.createVertexGroup(groupName, groupMembers);
                tezOp.getVertexGroupInfo().setVertexGroup(vertexGroup);
                POStore store = tezOp.getVertexGroupInfo().getStore();
                if (store != null) {
                    vertexGroup.addDataSink(store.getOperatorKey().toString(), new DataSinkDescriptor(tezOp.getVertexGroupInfo().getStoreOutputDescriptor(), OutputCommitterDescriptor.create((String)MROutputCommitter.class.getName()), this.dag.getCredentials()));
                }
            }
        }
    }

    private GroupInputEdge newGroupInputEdge(TezOperator fromOp, TezOperator toOp, VertexGroup from, Vertex to) throws IOException {
        EdgeProperty edgeProperty = this.newEdge(fromOp, toOp);
        String groupInputClass = ConcatenatedMergedKeyValueInput.class.getName();
        if (edgeProperty.getDataMovementType().equals((Object)EdgeProperty.DataMovementType.SCATTER_GATHER) && edgeProperty.getEdgeDestination().getClassName().equals(OrderedGroupedKVInput.class.getName())) {
            groupInputClass = OrderedGroupedMergedKVInput.class.getName();
        }
        return GroupInputEdge.create((VertexGroup)from, (Vertex)to, (EdgeProperty)edgeProperty, (InputDescriptor)((InputDescriptor)((InputDescriptor)InputDescriptor.create((String)groupInputClass).setUserPayload(edgeProperty.getEdgeDestination().getUserPayload())).setHistoryText(edgeProperty.getEdgeDestination().getHistoryText())));
    }

    private EdgeProperty newEdge(TezOperator from, TezOperator to) throws IOException {
        TezEdgeDescriptor edge = to.inEdges.get(from.getOperatorKey());
        PhysicalPlan combinePlan = edge.combinePlan;
        InputDescriptor in = InputDescriptor.create((String)edge.inputClassName);
        OutputDescriptor out = OutputDescriptor.create((String)edge.outputClassName);
        Configuration conf = ConfigurationUtil.toConfiguration(this.pc.getProperties(), false);
        if (!combinePlan.isEmpty()) {
            this.addCombiner(combinePlan, to, conf);
        }
        LinkedList<POLocalRearrangeTez> lrs = PlanHelper.getPhysicalOperators(from.plan, POLocalRearrangeTez.class);
        for (POLocalRearrangeTez lr : lrs) {
            if (!lr.getOutputKey().equals(to.getOperatorKey().toString())) continue;
            byte keyType = lr.getKeyType();
            this.setIntermediateOutputKeyValue(keyType, conf, to, lr.isConnectedToPackage());
            conf.set("pig.reduce.key.type", Byte.toString(lr.getMainKeyType()));
            break;
        }
        conf.setIfUnset("tez.runtime.partitioner.class", MRPartitioner.class.getName());
        if (edge.getIntermediateOutputKeyClass() != null) {
            conf.set("tez.runtime.key.class", edge.getIntermediateOutputKeyClass());
        }
        if (edge.getIntermediateOutputValueClass() != null) {
            conf.set("tez.runtime.value.class", edge.getIntermediateOutputValueClass());
        }
        if (edge.getIntermediateOutputKeyComparatorClass() != null) {
            conf.set("tez.runtime.key.comparator.class", edge.getIntermediateOutputKeyComparatorClass());
        }
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.set("pig.pigContext", ObjectSerializer.serialize(this.pc));
        conf.set("udf.import.list", ObjectSerializer.serialize(PigContext.getPackageImportList()));
        if (to.isGlobalSort() || to.isLimitAfterSort()) {
            conf.set("pig.sortOrder", ObjectSerializer.serialize((Serializable)to.getSortOrder()));
        }
        if (edge.isUseSecondaryKey()) {
            conf.set("pig.secondarySortOrder", ObjectSerializer.serialize((Serializable)edge.getSecondarySortOrder()));
            conf.set("mapreduce.job.partitioner.class", SecondaryKeyPartitioner.class.getName());
            conf.set("tez.runtime.key.comparator.class", PigSecondaryKeyComparator.class.getName());
            conf.set("tez.runtime.key.class", NullableTuple.class.getName());
            this.setGroupingComparator(conf, JobControlCompiler.PigSecondaryKeyGroupComparator.class.getName());
        }
        if (edge.partitionerClass != null) {
            conf.set("mapreduce.job.partitioner.class", edge.partitionerClass.getName());
        }
        conf.set("udf.import.list", ObjectSerializer.serialize(PigContext.getPackageImportList()));
        MRToTezHelper.processMRSettings(conf, this.globalConf);
        String historyString = TezDagBuilder.convertToHistoryText("", conf);
        ((InputDescriptor)in.setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)conf))).setHistoryText(historyString);
        ((OutputDescriptor)out.setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)conf))).setHistoryText(historyString);
        if (edge.dataMovementType != EdgeProperty.DataMovementType.BROADCAST && to.getEstimatedParallelism() != -1 && (to.isGlobalSort() || to.isSkewedJoin())) {
            return EdgeProperty.create((EdgeManagerPluginDescriptor)null, (EdgeProperty.DataSourceType)edge.dataSourceType, (EdgeProperty.SchedulingType)edge.schedulingType, (OutputDescriptor)out, (InputDescriptor)in);
        }
        return EdgeProperty.create((EdgeProperty.DataMovementType)edge.dataMovementType, (EdgeProperty.DataSourceType)edge.dataSourceType, (EdgeProperty.SchedulingType)edge.schedulingType, (OutputDescriptor)out, (InputDescriptor)in);
    }

    private void addCombiner(PhysicalPlan combinePlan, TezOperator pkgTezOp, Configuration conf) throws IOException {
        POPackage combPack = (POPackage)combinePlan.getRoots().get(0);
        POLocalRearrange combRearrange = (POLocalRearrange)combinePlan.getLeaves().get(0);
        this.setIntermediateOutputKeyValue(combRearrange.getKeyType(), conf, pkgTezOp);
        TezPOPackageAnnotator.LoRearrangeDiscoverer lrDiscoverer = new TezPOPackageAnnotator.LoRearrangeDiscoverer(combinePlan, pkgTezOp, combPack);
        lrDiscoverer.visit();
        combinePlan.remove(combPack);
        conf.set("tez.runtime.combiner.class", MRCombiner.class.getName());
        conf.set("mapreduce.job.combine.class", PigCombiner.Combine.class.getName());
        conf.setBoolean("mapred.mapper.new-api", true);
        conf.set("pig.pigContext", ObjectSerializer.serialize(this.pc));
        conf.set("udf.import.list", ObjectSerializer.serialize(PigContext.getPackageImportList()));
        conf.set("pig.combinePlan", ObjectSerializer.serialize(combinePlan));
        conf.set("pig.combine.package", ObjectSerializer.serialize(combPack));
        conf.set("pig.map.keytype", ObjectSerializer.serialize((Serializable)new byte[]{combRearrange.getKeyType()}));
    }

    /*
     * WARNING - void declaration
     */
    private Vertex newVertex(TezOperator tezOp) throws IOException, ClassNotFoundException, InterruptedException {
        List roots;
        ProcessorDescriptor procDesc = ProcessorDescriptor.create((String)tezOp.getProcessorName());
        JobConf payloadConf = new JobConf(ConfigurationUtil.toConfiguration(this.pc.getProperties(), false));
        payloadConf.setCredentials(this.dag.getCredentials());
        Job job = new Job((Configuration)payloadConf);
        payloadConf = (JobConf)job.getConfiguration();
        if (tezOp.getSampleOperator() != null) {
            payloadConf.set("pig.sampleVertex", tezOp.getSampleOperator().getOperatorKey().toString());
        }
        if (tezOp.getSortOperator() != null) {
            payloadConf.set("pig.sortVertex", tezOp.getSortOperator().getOperatorKey().toString());
            if (tezOp.getSortOperator().getEstimatedParallelism() != -1 && TezCompilerUtil.isIntermediateReducer(tezOp.getSortOperator())) {
                payloadConf.setLong("pig.exec.reducers.bytes.per.reducer", this.intermediateTaskInputSize);
            }
        }
        payloadConf.set("pig.inputs", ObjectSerializer.serialize(tezOp.getLoaderInfo().getInp()));
        payloadConf.set("pig.inpSignatures", ObjectSerializer.serialize(tezOp.getLoaderInfo().getInpSignatureLists()));
        payloadConf.set("pig.inpLimits", ObjectSerializer.serialize(tezOp.getLoaderInfo().getInpLimits()));
        LinkedList<POStore> stores = this.processStores(tezOp, (Configuration)payloadConf, job);
        payloadConf.set("pig.pigContext", ObjectSerializer.serialize(this.pc));
        payloadConf.set("udf.import.list", ObjectSerializer.serialize(PigContext.getPackageImportList()));
        payloadConf.set("exectype", "TEZ");
        payloadConf.setBoolean("mapred.mapper.new-api", true);
        payloadConf.setClass("mapreduce.inputformat.class", PigInputFormat.class, InputFormat.class);
        new PhyPlanSetter(tezOp.plan).visit();
        EndOfAllInputSetter.EndOfAllInputChecker checker = new EndOfAllInputSetter.EndOfAllInputChecker(tezOp.plan);
        checker.visit();
        if (checker.isEndOfAllInputPresent()) {
            payloadConf.set("pig.invoke.close.in.map", "true");
        }
        if ((roots = tezOp.plan.getRoots()).size() == 1 && roots.get(0) instanceof POPackage) {
            POPackage pack = (POPackage)roots.get(0);
            List<POPackage> succsList = tezOp.plan.getSuccessors(pack);
            if (succsList != null) {
                succsList = new ArrayList<POPackage>(succsList);
            }
            byte keyType = pack.getPkgr().getKeyType();
            tezOp.plan.remove(pack);
            payloadConf.set("pig.reduce.package", ObjectSerializer.serialize(pack));
            this.setIntermediateOutputKeyValue(keyType, (Configuration)payloadConf, tezOp);
            POShuffleTezLoad newPack = new POShuffleTezLoad(pack);
            if (tezOp.isSkewedJoin()) {
                newPack.setSkewedJoins(true);
            }
            tezOp.plan.add(newPack);
            TreeMap<Integer, String> localRearrangeMap = new TreeMap<Integer, String>();
            for (TezOperator tezOperator : ((TezOperPlan)this.mPlan).getPredecessors(tezOp)) {
                void var14_17;
                if (tezOp.getSampleOperator() != null && tezOp.getSampleOperator() == tezOperator) continue;
                String inputKey = tezOperator.getOperatorKey().toString();
                if (tezOperator.isVertexGroup()) {
                    TezOperator tezOperator2 = (TezOperator)((TezOperPlan)this.mPlan).getOperator(tezOperator.getVertexGroupMembers().get(0));
                }
                LinkedList<POLocalRearrangeTez> lrs = PlanHelper.getPhysicalOperators(var14_17.plan, POLocalRearrangeTez.class);
                for (POLocalRearrangeTez lr : lrs) {
                    if (!lr.isConnectedToPackage() || !lr.getOutputKey().equals(tezOp.getOperatorKey().toString())) continue;
                    localRearrangeMap.put(Integer.valueOf(lr.getIndex()), inputKey);
                }
            }
            for (Map.Entry entry : localRearrangeMap.entrySet()) {
                newPack.addInputKey((String)entry.getValue());
            }
            if (succsList != null) {
                for (PhysicalOperator physicalOperator : succsList) {
                    tezOp.plan.connect(newPack, physicalOperator);
                }
            }
            this.setIntermediateOutputKeyValue(pack.getPkgr().getKeyType(), (Configuration)payloadConf, tezOp);
        } else if (roots.size() == 1 && roots.get(0) instanceof POIdentityInOutTez) {
            POIdentityInOutTez identityInOut = (POIdentityInOutTez)roots.get(0);
            Operator identityInOutPred = null;
            for (TezOperator pred : ((TezOperPlan)this.mPlan).getPredecessors(tezOp)) {
                if (pred.isSampleAggregation()) continue;
                identityInOutPred = pred;
                break;
            }
            identityInOut.setInputKey(identityInOutPred.getOperatorKey().toString());
        } else if (roots.size() == 1 && roots.get(0) instanceof POValueInputTez) {
            POValueInputTez valueInput = (POValueInputTez)roots.get(0);
            LinkedList<String> scalarInputs = new LinkedList<String>();
            for (POUserFunc userFunc : PlanHelper.getPhysicalOperators(tezOp.plan, POUserFunc.class)) {
                if (!(userFunc.getFunc() instanceof ReadScalarsTez)) continue;
                scalarInputs.add(((ReadScalarsTez)userFunc.getFunc()).getTezInputs()[0]);
            }
            for (TezOperator pred : ((TezOperPlan)this.mPlan).getPredecessors(tezOp)) {
                if (scalarInputs.contains(pred.getOperatorKey().toString())) continue;
                valueInput.setInputKey(pred.getOperatorKey().toString());
                break;
            }
        }
        this.setOutputFormat(job);
        new PhyPlanSetter(tezOp.plan).visit();
        payloadConf.set("pig.exec.tez.plan", ObjectSerializer.serialize(tezOp.plan));
        UDFContext.getUDFContext().serialize((Configuration)payloadConf);
        MRToTezHelper.processMRSettings((Configuration)payloadConf, this.globalConf);
        if (!this.pc.inIllustrator) {
            for (POStore store : stores) {
                store.setInputs(null);
                store.setParentPlan(null);
            }
            payloadConf.set("pig.map.stores", ObjectSerializer.serialize(new ArrayList()));
            payloadConf.set("pig.reduce.stores", ObjectSerializer.serialize(stores));
        }
        if (tezOp.isNeedEstimateParallelism()) {
            payloadConf.setBoolean("pig.exec.estimate.parallelism", true);
            log.info((Object)("Estimate quantile for sample aggregation vertex " + tezOp.getOperatorKey().toString()));
        }
        payloadConf.setInt("pig.info.reducers.default.parallel", this.pc.defaultParallel);
        payloadConf.setInt("pig.info.reducers.requested.parallel", tezOp.getRequestedParallelism());
        payloadConf.setInt("pig.info.reducers.estimated.parallel", tezOp.getEstimatedParallelism());
        TezScriptState ss = TezScriptState.get();
        ss.addVertexSettingsToConf(this.dag.getName(), tezOp, (Configuration)payloadConf);
        UserPayload userPayload = TezUtils.createUserPayloadFromConf((Configuration)payloadConf);
        ((ProcessorDescriptor)procDesc.setUserPayload(userPayload)).setHistoryText(TezDagBuilder.convertToHistoryText(tezOp.getOperatorKey().toString(), (Configuration)payloadConf));
        Vertex vertex = Vertex.create((String)tezOp.getOperatorKey().toString(), (ProcessorDescriptor)procDesc, (int)tezOp.getVertexParallelism(), (Resource)(tezOp.isUseMRMapSettings() ? MRHelpers.getResourceForMRMapper((Configuration)this.globalConf) : MRHelpers.getResourceForMRReducer((Configuration)this.globalConf)));
        HashMap taskEnv = new HashMap();
        MRHelpers.updateEnvBasedOnMRTaskEnv((Configuration)this.globalConf, taskEnv, (boolean)tezOp.isUseMRMapSettings());
        vertex.setTaskEnvironment(taskEnv);
        ClientDistributedCacheManager.determineTimestampsAndCacheVisibilities((Configuration)this.globalConf);
        ClientDistributedCacheManager.getDelegationTokens((Configuration)this.globalConf, (Credentials)job.getCredentials());
        MRApps.setupDistributedCache((Configuration)this.globalConf, this.localResources);
        vertex.addTaskLocalFiles(this.localResources);
        vertex.setTaskLaunchCmdOpts(tezOp.isUseMRMapSettings() ? MRHelpers.getJavaOptsForMRMapper((Configuration)this.globalConf) : MRHelpers.getJavaOptsForMRReducer((Configuration)this.globalConf));
        log.info((Object)("For vertex - " + tezOp.getOperatorKey().toString() + ": parallelism=" + tezOp.getVertexParallelism() + ", memory=" + vertex.getTaskResource().getMemory() + ", java opts=" + vertex.getTaskLaunchCmdOpts()));
        for (POLoad ld : tezOp.getLoaderInfo().getLoads()) {
            vertex.setLocationHint(VertexLocationHint.create((List)tezOp.getLoaderInfo().getInputSplitInfo().getTaskLocationHints()));
            vertex.addDataSource(ld.getOperatorKey().toString(), DataSourceDescriptor.create((InputDescriptor)((InputDescriptor)((InputDescriptor)InputDescriptor.create((String)MRInput.class.getName()).setUserPayload(UserPayload.create((ByteBuffer)MRRuntimeProtos.MRInputUserPayloadProto.newBuilder().setConfigurationBytes(TezUtils.createByteStringFromConf((Configuration)payloadConf)).setSplits(tezOp.getLoaderInfo().getInputSplitInfo().getSplitsProto()).build().toByteString().asReadOnlyByteBuffer()))).setHistoryText(TezDagBuilder.convertToHistoryText("", (Configuration)payloadConf))), (InputInitializerDescriptor)InputInitializerDescriptor.create((String)MRInputSplitDistributor.class.getName()), (Credentials)this.dag.getCredentials()));
        }
        for (POStore store : stores) {
            OperatorKey vertexGroupKey;
            ArrayList arrayList = new ArrayList();
            ArrayList<POStore> singleStore = new ArrayList<POStore>();
            singleStore.add(store);
            Configuration outputPayLoad = new Configuration((Configuration)payloadConf);
            outputPayLoad.set("pig.map.stores", ObjectSerializer.serialize(arrayList));
            outputPayLoad.set("pig.reduce.stores", ObjectSerializer.serialize(singleStore));
            OutputDescriptor storeOutDescriptor = (OutputDescriptor)((OutputDescriptor)OutputDescriptor.create((String)MROutput.class.getName()).setUserPayload(TezUtils.createUserPayloadFromConf((Configuration)outputPayLoad))).setHistoryText(TezDagBuilder.convertToHistoryText("", outputPayLoad));
            if (tezOp.getVertexGroupStores() != null && (vertexGroupKey = tezOp.getVertexGroupStores().get(store.getOperatorKey())) != null) {
                ((TezOperator)((TezOperPlan)this.getPlan()).getOperator(vertexGroupKey)).getVertexGroupInfo().setStoreOutputDescriptor(storeOutDescriptor);
                continue;
            }
            vertex.addDataSink(store.getOperatorKey().toString(), new DataSinkDescriptor(storeOutDescriptor, OutputCommitterDescriptor.create((String)MROutputCommitter.class.getName()), this.dag.getCredentials()));
        }
        if (stores.size() > 0) {
            new PigOutputFormat().checkOutputSpecs((JobContext)job);
        }
        String vmPluginName = null;
        Configuration vmPluginConf = null;
        if (tezOp.getEstimatedParallelism() != -1) {
            if (tezOp.isGlobalSort() || tezOp.isSkewedJoin()) {
                vmPluginName = PartitionerDefinedVertexManager.class.getName();
                log.info((Object)("Set VertexManagerPlugin to PartitionerDefinedParallelismVertexManager for vertex " + tezOp.getOperatorKey().toString()));
            } else {
                boolean bl;
                boolean bl2 = false;
                boolean containCustomPartitioner = false;
                for (TezEdgeDescriptor edge : tezOp.inEdges.values()) {
                    if (edge.dataMovementType == EdgeProperty.DataMovementType.SCATTER_GATHER) {
                        bl = true;
                    }
                    if (edge.partitionerClass == null) continue;
                    containCustomPartitioner = true;
                }
                if (bl && !containCustomPartitioner) {
                    vmPluginName = ShuffleVertexManager.class.getName();
                    vmPluginConf = vmPluginConf == null ? ConfigurationUtil.toConfiguration(this.pc.getProperties(), false) : vmPluginConf;
                    vmPluginConf.setBoolean("tez.shuffle-vertex-manager.enable.auto-parallel", true);
                    if (stores.size() <= 0) {
                        vmPluginConf.setLong("tez.shuffle-vertex-manager.desired-task-input-size", this.intermediateTaskInputSize);
                    } else if (vmPluginConf.getLong("pig.exec.reducers.bytes.per.reducer", 1000000000L) != 1000000000L) {
                        vmPluginConf.setLong("tez.shuffle-vertex-manager.desired-task-input-size", vmPluginConf.getLong("pig.exec.reducers.bytes.per.reducer", 1000000000L));
                    }
                    log.info((Object)("Set auto parallelism for vertex " + tezOp.getOperatorKey().toString()));
                }
            }
        }
        if (tezOp.isLimit() && (vmPluginName == null || vmPluginName.equals(ShuffleVertexManager.class.getName())) && tezOp.inEdges.values().iterator().next().inputClassName.equals(UnorderedKVInput.class.getName())) {
            vmPluginName = ShuffleVertexManager.class.getName();
            vmPluginConf = vmPluginConf == null ? ConfigurationUtil.toConfiguration(this.pc.getProperties(), false) : vmPluginConf;
            vmPluginConf.set("tez.shuffle-vertex-manager.min-src-fraction", "0.00001");
            vmPluginConf.set("tez.shuffle-vertex-manager.max-src-fraction", "0.00001");
            log.info((Object)("Set tez.shuffle-vertex-manager.min-src-fraction to 0.00001 for limit vertex " + tezOp.getOperatorKey().toString()));
        }
        if (vmPluginName != null) {
            VertexManagerPluginDescriptor vertexManagerPluginDescriptor = VertexManagerPluginDescriptor.create((String)vmPluginName);
            if (vmPluginConf != null) {
                ((VertexManagerPluginDescriptor)vertexManagerPluginDescriptor.setUserPayload(TezUtils.createUserPayloadFromConf(vmPluginConf))).setHistoryText(TezDagBuilder.convertToHistoryText(vmPluginName, vmPluginConf));
            }
            vertex.setVertexManagerPlugin(vertexManagerPluginDescriptor);
        }
        UDFContext.getUDFContext().addJobConf(null);
        return vertex;
    }

    private LinkedList<POStore> processStores(TezOperator tezOp, Configuration payloadConf, Job job) throws VisitorException, IOException {
        LinkedList<POStore> stores = PlanHelper.getPhysicalOperators(tezOp.plan, POStore.class);
        if (stores.size() > 0) {
            ArrayList<POStore> storeLocations = new ArrayList<POStore>();
            for (POStore st : stores) {
                storeLocations.add(st);
                StoreFuncInterface sFunc = st.getStoreFunc();
                sFunc.setStoreLocation(st.getSFile().getFileName(), job);
            }
            Path tmpLocation = null;
            if (stores.size() == 1) {
                POStore st;
                st = stores.get(0);
                String outputPathString = st.getSFile().getFileName();
                if (!outputPathString.contains("://") || outputPathString.startsWith("hdfs://")) {
                    payloadConf.set("pig.streaming.log.dir", new Path(outputPathString, "_logs").toString());
                } else {
                    String tmpLocationStr = FileLocalizer.getTemporaryPath(this.pc).toString();
                    tmpLocation = new Path(tmpLocationStr);
                    payloadConf.set("pig.streaming.log.dir", new Path(tmpLocation, "_logs").toString());
                }
                payloadConf.set("pig.streaming.task.output.dir", outputPathString);
                if (tezOp.plan.getLeaves().get(0) instanceof POSplit) {
                    st.setMultiStore(true);
                }
            } else {
                log.info((Object)"Setting up multi store job");
                String tmpLocationStr = FileLocalizer.getTemporaryPath(this.pc).toString();
                tmpLocation = new Path(tmpLocationStr);
                boolean disableCounter = payloadConf.getBoolean("pig.disable.counter", false);
                if (disableCounter) {
                    log.info((Object)"Disable Pig custom output counters");
                }
                int idx = 0;
                for (POStore sto : storeLocations) {
                    sto.setDisableCounter(disableCounter);
                    sto.setMultiStore(true);
                    sto.setIndex(idx++);
                }
                payloadConf.set("pig.streaming.log.dir", new Path(tmpLocation, "_logs").toString());
                payloadConf.set("pig.streaming.task.output.dir", tmpLocation.toString());
            }
        }
        return stores;
    }

    private void setIntermediateOutputKeyValue(byte keyType, Configuration conf, TezOperator tezOp) throws JobCreationException, ExecException {
        this.setIntermediateOutputKeyValue(keyType, conf, tezOp, true);
    }

    private void setIntermediateOutputKeyValue(byte keyType, Configuration conf, TezOperator tezOp, boolean isConnectedToPackage) throws JobCreationException, ExecException {
        if (tezOp != null && tezOp.isUseSecondaryKey() && isConnectedToPackage) {
            conf.set("tez.runtime.key.class", NullableTuple.class.getName());
        } else if (tezOp != null && tezOp.isSkewedJoin() && isConnectedToPackage) {
            conf.set("tez.runtime.key.class", NullablePartitionWritable.class.getName());
        } else {
            Class<?> keyClass = HDataType.getWritableComparableTypes(keyType).getClass();
            conf.set("tez.runtime.key.class", keyClass.getName());
        }
        conf.set("tez.runtime.value.class", NullableTuple.class.getName());
        conf.set("tez.runtime.partitioner.class", MRPartitioner.class.getName());
        this.selectOutputComparator(keyType, conf, tezOp);
    }

    private static Class<? extends WritableComparator> comparatorForKeyType(byte keyType, boolean hasOrderBy) throws JobCreationException {
        switch (keyType) {
            case 5: {
                return PigBooleanRawComparator.class;
            }
            case 10: {
                return PigIntRawComparator.class;
            }
            case 65: {
                return PigBigIntegerRawComparator.class;
            }
            case 70: {
                return PigBigDecimalRawComparator.class;
            }
            case 15: {
                return PigLongRawComparator.class;
            }
            case 20: {
                return PigFloatRawComparator.class;
            }
            case 25: {
                return PigDoubleRawComparator.class;
            }
            case 30: {
                return PigDateTimeRawComparator.class;
            }
            case 55: {
                return PigTextRawComparator.class;
            }
            case 50: {
                return PigBytesRawComparator.class;
            }
            case 100: {
                int errCode = 1068;
                String msg = "Using Map as key not supported.";
                throw new JobCreationException(msg, errCode, 2);
            }
            case 110: {
                return PigTupleSortComparator.class;
            }
            case 120: {
                int errCode = 1068;
                String msg = "Using Bag as key not supported.";
                throw new JobCreationException(msg, errCode, 2);
            }
        }
        int errCode = 2036;
        String msg = "Unhandled key type " + DataType.findTypeName(keyType);
        throw new JobCreationException(msg, errCode, 4);
    }

    private static Class<? extends WritableComparator> getGroupingComparatorForKeyType(byte keyType) throws JobCreationException {
        switch (keyType) {
            case 5: {
                return JobControlCompiler.PigGroupingBooleanWritableComparator.class;
            }
            case 10: {
                return JobControlCompiler.PigGroupingIntWritableComparator.class;
            }
            case 65: {
                return JobControlCompiler.PigGroupingBigIntegerWritableComparator.class;
            }
            case 70: {
                return JobControlCompiler.PigGroupingBigDecimalWritableComparator.class;
            }
            case 15: {
                return JobControlCompiler.PigGroupingLongWritableComparator.class;
            }
            case 20: {
                return JobControlCompiler.PigGroupingFloatWritableComparator.class;
            }
            case 25: {
                return JobControlCompiler.PigGroupingDoubleWritableComparator.class;
            }
            case 30: {
                return JobControlCompiler.PigGroupingDateTimeWritableComparator.class;
            }
            case 55: {
                return JobControlCompiler.PigGroupingCharArrayWritableComparator.class;
            }
            case 50: {
                return JobControlCompiler.PigGroupingDBAWritableComparator.class;
            }
            case 100: {
                int errCode = 1068;
                String msg = "Using Map as key not supported.";
                throw new JobCreationException(msg, errCode, 2);
            }
            case 110: {
                return JobControlCompiler.PigGroupingTupleWritableComparator.class;
            }
            case 120: {
                int errCode = 1068;
                String msg = "Using Bag as key not supported.";
                throw new JobCreationException(msg, errCode, 2);
            }
        }
        int errCode = 2036;
        String msg = "Unhandled key type " + DataType.findTypeName(keyType);
        throw new JobCreationException(msg, errCode, 4);
    }

    void selectOutputComparator(byte keyType, Configuration conf, TezOperator tezOp) throws JobCreationException {
        if (tezOp != null && tezOp.isUseSecondaryKey()) {
            conf.set("tez.runtime.key.comparator.class", PigSecondaryKeyComparator.class.getName());
            this.setGroupingComparator(conf, JobControlCompiler.PigSecondaryKeyGroupComparator.class.getName());
        } else if (tezOp != null && tezOp.isSkewedJoin()) {
            conf.set("tez.runtime.key.comparator.class", JobControlCompiler.PigGroupingPartitionWritableComparator.class.getName());
            this.setGroupingComparator(conf, JobControlCompiler.PigGroupingPartitionWritableComparator.class.getName());
        } else {
            boolean hasOrderby = this.hasOrderby(tezOp);
            conf.setClass("tez.runtime.key.comparator.class", TezDagBuilder.comparatorForKeyType(keyType, hasOrderby), RawComparator.class);
            if (!hasOrderby) {
                this.setGroupingComparator(conf, TezDagBuilder.getGroupingComparatorForKeyType(keyType).getName());
            }
        }
    }

    private boolean hasOrderby(TezOperator tezOp) {
        List<TezOperator> succs;
        boolean hasOrderBy;
        boolean bl = hasOrderBy = tezOp.isGlobalSort() || tezOp.isLimitAfterSort();
        if (!hasOrderBy && (succs = ((TezOperPlan)this.getPlan()).getSuccessors(tezOp)) != null && succs.size() == 1 && succs.get(0).isGlobalSort()) {
            hasOrderBy = true;
        }
        return hasOrderBy;
    }

    private void setGroupingComparator(Configuration conf, String comparatorClass) {
        conf.set("tez.runtime.group.comparator.class", comparatorClass);
        conf.set("tez.runtime.key.secondary.comparator.class", comparatorClass);
    }

    private void setOutputFormat(Job job) {
        if ("true".equalsIgnoreCase(job.getConfiguration().get("pig.output.lazy"))) {
            try {
                Class clazz = PigContext.resolveClassName("org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat");
                Method method = clazz.getMethod("setOutputFormatClass", Job.class, Class.class);
                method.invoke(null, job, PigOutputFormatTez.class);
            }
            catch (Exception e) {
                job.setOutputFormatClass(PigOutputFormatTez.class);
                log.warn((Object)"pig.output.lazy is set but LazyOutputFormat couldn't be loaded. Default PigOutputFormat will be used");
            }
        } else {
            job.setOutputFormatClass(PigOutputFormatTez.class);
        }
    }

    public static String convertToHistoryText(String description, Configuration conf) throws IOException {
        JSONObject jsonObject = new JSONObject();
        try {
            if (description != null && !description.isEmpty()) {
                jsonObject.put("desc", (Object)description);
            }
            if (conf != null) {
                JSONObject confJson = new JSONObject();
                for (Map.Entry entry : conf) {
                    confJson.put((String)entry.getKey(), entry.getValue());
                }
                jsonObject.put("config", (Object)confJson);
            }
        }
        catch (JSONException e) {
            throw new IOException("Error when trying to convert description/conf to JSON", e);
        }
        return jsonObject.toString();
    }
}

