/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.pig.backend.hadoop.executionengine.JobCreationException;
import org.apache.pig.backend.hadoop.executionengine.tez.TezDagBuilder;
import org.apache.pig.backend.hadoop.executionengine.tez.TezJob;
import org.apache.pig.backend.hadoop.executionengine.tez.TezResourceManager;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainer;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerNode;
import org.apache.pig.impl.PigContext;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezConfiguration;

public class TezJobCompiler {
    private static final Log log = LogFactory.getLog(TezJobCompiler.class);
    private PigContext pigContext;
    private TezConfiguration tezConf;

    public TezJobCompiler(PigContext pigContext, Configuration conf) throws IOException {
        this.pigContext = pigContext;
        this.tezConf = new TezConfiguration(conf);
    }

    public DAG buildDAG(TezPlanContainerNode tezPlanNode, Map<String, LocalResource> localResources) throws IOException, YarnException {
        DAG tezDag = DAG.create((String)tezPlanNode.getOperatorKey().toString());
        tezDag.setCredentials(new Credentials());
        TezDagBuilder dagBuilder = new TezDagBuilder(this.pigContext, tezPlanNode.getTezOperPlan(), tezDag, localResources);
        dagBuilder.visit();
        return tezDag;
    }

    public TezJob compile(TezPlanContainerNode tezPlanNode, TezPlanContainer planContainer) throws JobCreationException {
        TezJob job = null;
        try {
            job = this.getJob(tezPlanNode, planContainer);
        }
        catch (JobCreationException jce) {
            throw jce;
        }
        catch (Exception e) {
            int errCode = 2017;
            String msg = "Internal error creating job configuration.";
            throw new JobCreationException(msg, errCode, 4, (Throwable)e);
        }
        return job;
    }

    private TezJob getJob(TezPlanContainerNode tezPlanNode, TezPlanContainer planContainer) throws JobCreationException {
        try {
            String cacheFiles;
            HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
            localResources.putAll(planContainer.getLocalResources());
            TezOperPlan tezPlan = tezPlanNode.getTezOperPlan();
            localResources.putAll(tezPlan.getExtraResources());
            String shipFiles = this.pigContext.getProperties().getProperty("pig.streaming.ship.files");
            if (shipFiles != null) {
                for (String file : shipFiles.split(",")) {
                    TezResourceManager.getInstance().addTezResource(new File(file).toURI());
                }
            }
            if ((cacheFiles = this.pigContext.getProperties().getProperty("pig.streaming.cache.files")) != null) {
                for (String file : cacheFiles.split(",")) {
                    TezResourceManager.getInstance().addTezResource(new Path(new URI(file.trim())).toUri());
                }
            }
            for (Map.Entry entry : localResources.entrySet()) {
                log.info((Object)("Local resource: " + (String)entry.getKey()));
            }
            DAG tezDag = this.buildDAG(tezPlanNode, localResources);
            return new TezJob(this.tezConf, tezDag, localResources, tezPlan.getEstimatedTotalParallelism());
        }
        catch (Exception e) {
            int errCode = 2017;
            String msg = "Internal error creating job configuration.";
            throw new JobCreationException(msg, errCode, 4, (Throwable)e);
        }
    }
}

