/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.PigException;
import org.apache.pig.PigWarning;
import org.apache.pig.backend.BackendException;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.Launcher;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.tez.TezJob;
import org.apache.pig.backend.hadoop.executionengine.tez.TezJobCompiler;
import org.apache.pig.backend.hadoop.executionengine.tez.TezResourceManager;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezCompiler;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPOPackageAnnotator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainer;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerNode;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerPrinter;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.NativeTezOper;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer.AccumulatorOptimizer;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer.CombinerOptimizer;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer.LoaderProcessor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer.MultiQueryOptimizerTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer.NoopFilterRemover;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer.ParallelismSetter;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer.SecondaryKeyOptimizerTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer.UnionOptimizer;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.LogUtils;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.tez.TezPigScriptStats;
import org.apache.pig.tools.pigstats.tez.TezScriptState;
import org.apache.pig.tools.pigstats.tez.TezVertexStats;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.DAGStatus;

public class TezLauncher
extends Launcher {
    private static final Log log = LogFactory.getLog(TezLauncher.class);
    private static ThreadFactory namedThreadFactory;
    private ExecutorService executor;
    private boolean aggregateWarning = false;
    private TezScriptState tezScriptState;
    private TezPigScriptStats tezStats;
    private TezJob runningJob;

    public TezLauncher() {
        if (namedThreadFactory == null) {
            namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("PigTezLauncher-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new Launcher.JobControlThreadExceptionHandler()).build();
        }
        this.executor = Executors.newSingleThreadExecutor(namedThreadFactory);
    }

    @Override
    public PigStats launchPig(PhysicalPlan php, String grpName, PigContext pc) throws Exception {
        TezPlanContainerNode tezPlanContainerNode;
        if (pc.getExecType().isLocal()) {
            pc.getProperties().setProperty("tez.local.mode", "true");
            pc.getProperties().setProperty("tez.runtime.optimize.local.fetch", "true");
            pc.getProperties().setProperty("tez.ignore.lib.uris", "true");
        }
        Configuration conf = ConfigurationUtil.toConfiguration(pc.getProperties(), true);
        if (pc.defaultParallel == -1 && !conf.getBoolean("pig.tez.auto.parallelism", true)) {
            pc.defaultParallel = 1;
        }
        this.aggregateWarning = conf.getBoolean("aggregate.warning", false);
        TezResourceManager tezResourceManager = TezResourceManager.getInstance();
        tezResourceManager.init(pc, conf);
        Path stagingDir = tezResourceManager.getStagingDir();
        log.info((Object)("Tez staging directory is " + stagingDir.toString()));
        conf.set("tez.staging-dir", stagingDir.toString());
        ArrayList<TezOperPlan> processedPlans = new ArrayList<TezOperPlan>();
        this.tezScriptState = TezScriptState.get();
        this.tezStats = new TezPigScriptStats(pc);
        PigStats.start(this.tezStats);
        conf.set("tez.use.cluster.hadoop-libs", "true");
        TezJobCompiler jc = new TezJobCompiler(pc, conf);
        TezPlanContainer tezPlanContainer = this.compile(php, pc);
        this.tezStats.initialize(tezPlanContainer);
        this.tezScriptState.emitInitialPlanNotification(tezPlanContainer);
        this.tezScriptState.emitLaunchStartedNotification(tezPlanContainer.size());
        int processedDAGs = 0;
        while ((tezPlanContainerNode = tezPlanContainer.getNextPlan(processedPlans)) != null) {
            TezOperPlan tezPlan = tezPlanContainerNode.getTezOperPlan();
            TezLauncher.processLoadAndParallelism(tezPlan, pc);
            processedPlans.add(tezPlan);
            ProgressReporter reporter = new ProgressReporter(tezPlanContainer.size(), processedDAGs);
            if (tezPlan.size() == 1 && tezPlan.getRoots().get(0) instanceof NativeTezOper) {
                NativeTezOper nativeOper = (NativeTezOper)tezPlan.getRoots().get(0);
                this.tezScriptState.emitJobsSubmittedNotification(1);
                nativeOper.runJob(tezPlanContainerNode.getOperatorKey().toString());
            } else {
                TezPOPackageAnnotator pkgAnnotator = new TezPOPackageAnnotator(tezPlan);
                pkgAnnotator.visit();
                this.runningJob = jc.compile(tezPlanContainerNode, tezPlanContainer);
                this.tezScriptState.dagLaunchNotification(this.runningJob.getName(), tezPlan, tezPlan.size());
                this.runningJob.setPigStats(this.tezStats);
                final UDFContext udfContext = UDFContext.getUDFContext();
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setContextClassLoader(PigContext.getClassLoader());
                        UDFContext.setUdfContext(udfContext.clone());
                        TezLauncher.this.runningJob.run();
                    }
                };
                long scriptSubmittedTimestamp = System.currentTimeMillis();
                Configuration jobConf = this.runningJob.getConfiguration();
                jobConf.set("pig.script.submitted.timestamp", Long.toString(scriptSubmittedTimestamp));
                jobConf.set("pig.job.submitted.timestamp", Long.toString(System.currentTimeMillis()));
                Future<?> future = this.executor.submit(task);
                this.tezScriptState.emitJobsSubmittedNotification(1);
                boolean jobStarted = false;
                while (!future.isDone()) {
                    if (!jobStarted && this.runningJob.getApplicationId() != null) {
                        jobStarted = true;
                        String appId = this.runningJob.getApplicationId().toString();
                        log.info((Object)("HadoopJobId: " + appId.replace("application", "job")));
                        this.tezScriptState.emitJobStartedNotification(appId);
                        this.tezScriptState.dagStartedNotification(this.runningJob.getName(), appId);
                    }
                    reporter.notifyUpdate();
                    Thread.sleep(1000L);
                }
                UDFContext.setUdfContext(udfContext);
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    this.setJobException(e.getCause());
                }
            }
            if (tezPlanContainer.size() == ++processedDAGs) {
                this.tezScriptState.emitProgressUpdatedNotification(100);
            } else {
                this.tezScriptState.emitProgressUpdatedNotification((tezPlanContainer.size() - processedDAGs) / tezPlanContainer.size() * 100);
            }
            this.handleUnCaughtException(pc);
            tezPlanContainer.updatePlan(tezPlan, reporter.notifyFinishedOrFailed());
        }
        this.tezStats.finish();
        this.tezScriptState.emitLaunchCompletedNotification(this.tezStats.getNumberSuccessfulJobs());
        for (OutputStats output : this.tezStats.getOutputStats()) {
            POStore store = output.getPOStore();
            try {
                if (!output.isSuccessful()) {
                    store.getStoreFunc().cleanupOnFailure(store.getSFile().getFileName(), Job.getInstance((Configuration)output.getConf()));
                    continue;
                }
                store.getStoreFunc().cleanupOnSuccess(store.getSFile().getFileName(), Job.getInstance((Configuration)output.getConf()));
            }
            catch (IOException e) {
                throw new ExecException(e);
            }
            catch (AbstractMethodError nsme) {
            }
        }
        return this.tezStats;
    }

    private void handleUnCaughtException(PigContext pc) throws Exception {
        if (this.jobControlException != null) {
            if (this.jobControlException instanceof PigException) {
                if (this.jobControlExceptionStackTrace != null) {
                    LogUtils.writeLog("Error message from Tez Job", this.jobControlExceptionStackTrace, pc.getProperties().getProperty("pig.logfile"), log);
                }
                throw this.jobControlException;
            }
            int errCode = 2117;
            String msg = "Unexpected error when launching Tez job.";
            throw new ExecException(msg, errCode, 4, this.jobControlException);
        }
    }

    private void computeWarningAggregate(Map<String, Map<String, Long>> counterGroups, Map<Enum, Long> aggMap) {
        for (Map<String, Long> counters : counterGroups.values()) {
            for (PigWarning e : PigWarning.values()) {
                if (!counters.containsKey(e.toString())) continue;
                if (aggMap.containsKey(e.toString())) {
                    Long currentCount = aggMap.get(e.toString());
                    currentCount = currentCount == null ? 0L : currentCount;
                    if (counters != null) {
                        currentCount = currentCount + counters.get(e.toString());
                    }
                    aggMap.put(e, currentCount);
                    continue;
                }
                aggMap.put(e, counters.get(e.toString()));
            }
        }
    }

    @Override
    public void explain(PhysicalPlan php, PigContext pc, PrintStream ps, String format, boolean verbose) throws PlanException, VisitorException, IOException {
        log.debug((Object)"Entering TezLauncher.explain");
        TezPlanContainer tezPlanContainer = this.compile(php, pc);
        if (!format.equals("text")) {
            throw new IOException("Non-text output of explain is not supported.");
        }
        TezPlanContainerPrinter printer = new TezPlanContainerPrinter(ps, tezPlanContainer);
        printer.setVerbose(verbose);
        printer.visit();
    }

    public TezPlanContainer compile(PhysicalPlan php, PigContext pc) throws PlanException, IOException, VisitorException {
        TezCompiler comp = new TezCompiler(php, pc);
        comp.compile();
        TezPlanContainer planContainer = comp.getPlanContainer();
        for (Map.Entry entry : planContainer.getKeys().entrySet()) {
            TezOperPlan tezPlan = ((TezPlanContainerNode)entry.getValue()).getTezOperPlan();
            this.optimize(tezPlan, pc);
        }
        return planContainer;
    }

    private void optimize(TezOperPlan tezPlan, PigContext pc) throws VisitorException {
        boolean isUnionOpt;
        boolean isAccum;
        boolean isMultiQuery;
        Configuration conf = ConfigurationUtil.toConfiguration(pc.getProperties());
        boolean aggregateWarning = conf.getBoolean("aggregate.warning", false);
        NoopFilterRemover filter = new NoopFilterRemover(tezPlan);
        filter.visit();
        boolean nocombiner = conf.getBoolean("pig.exec.nocombiner", false);
        if (!pc.inIllustrator && !nocombiner) {
            boolean doMapAgg = Boolean.parseBoolean(pc.getProperties().getProperty("pig.exec.mapPartAgg", "false"));
            CombinerOptimizer co = new CombinerOptimizer(tezPlan, doMapAgg);
            co.visit();
            co.getMessageCollector().logMessages(CompilationMessageCollector.MessageType.Warning, aggregateWarning, log);
        }
        boolean noSecKeySort = conf.getBoolean("pig.exec.nosecondarykey", false);
        if (!pc.inIllustrator && !noSecKeySort) {
            SecondaryKeyOptimizerTez skOptimizer = new SecondaryKeyOptimizerTez(tezPlan);
            skOptimizer.visit();
        }
        if (isMultiQuery = conf.getBoolean("opt.multiquery", true)) {
            MultiQueryOptimizerTez mqOptimizer = new MultiQueryOptimizerTez(tezPlan);
            mqOptimizer.visit();
        }
        if (isAccum = conf.getBoolean("opt.accumulator", true)) {
            AccumulatorOptimizer accum = new AccumulatorOptimizer(tezPlan);
            accum.visit();
        }
        if (isUnionOpt = conf.getBoolean("pig.tez.opt.union", true)) {
            UnionOptimizer uo = new UnionOptimizer(tezPlan);
            uo.visit();
        }
    }

    public static void processLoadAndParallelism(TezOperPlan tezPlan, PigContext pc) throws VisitorException {
        if (!pc.inExplain && !pc.inDumpSchema) {
            LoaderProcessor loaderStorer = new LoaderProcessor(tezPlan, pc);
            loaderStorer.visit();
            ParallelismSetter parallelismSetter = new ParallelismSetter(tezPlan, pc);
            parallelismSetter.visit();
            tezPlan.setEstimatedParallelism(parallelismSetter.getEstimatedTotalParallelism());
        }
    }

    @Override
    public void kill() throws BackendException {
        if (this.runningJob != null) {
            try {
                this.runningJob.killJob();
            }
            catch (Exception e) {
                throw new BackendException(e);
            }
        }
        this.destroy();
    }

    @Override
    public void killJob(String jobID, Configuration conf) throws BackendException {
        if (this.runningJob != null && this.runningJob.getApplicationId().toString() == jobID) {
            try {
                this.runningJob.killJob();
            }
            catch (Exception e) {
                throw new BackendException(e);
            }
        } else {
            log.info((Object)("Cannot find job: " + jobID));
        }
    }

    @Override
    public void destroy() {
        try {
            if (this.executor != null && !this.executor.isShutdown()) {
                log.info((Object)"Shutting down thread pool");
                this.executor.shutdownNow();
            }
        }
        catch (Exception e) {
            log.warn((Object)"Error shutting down threadpool");
        }
    }

    private class ProgressReporter {
        private int totalDAGs;
        private int processedDAGS;
        private int count = 0;
        private int prevProgress = 0;

        public ProgressReporter(int totalDAGs, int processedDAGs) {
            this.totalDAGs = totalDAGs;
            this.processedDAGS = processedDAGs;
        }

        public void notifyUpdate() {
            DAGStatus dagStatus = TezLauncher.this.runningJob.getDAGStatus();
            if (dagStatus != null && dagStatus.getState() == DAGStatus.State.RUNNING) {
                int currProgress = Math.round(TezLauncher.this.runningJob.getDAGProgress() * 100.0f);
                if (currProgress - this.prevProgress >= 1 || this.count % 100 == 0) {
                    TezLauncher.this.tezScriptState.dagProgressNotification(TezLauncher.this.runningJob.getName(), -1, currProgress);
                    TezLauncher.this.tezScriptState.emitProgressUpdatedNotification((currProgress + 100 * this.processedDAGS) / this.totalDAGs);
                    this.prevProgress = currProgress;
                }
                ++this.count;
            }
        }

        public boolean notifyFinishedOrFailed() {
            DAGStatus dagStatus = TezLauncher.this.runningJob.getDAGStatus();
            if (dagStatus == null) {
                return false;
            }
            if (dagStatus.getState() == DAGStatus.State.SUCCEEDED) {
                HashMap<Enum, Long> warningAggMap = new HashMap<Enum, Long>();
                DAG dag = TezLauncher.this.runningJob.getDAG();
                for (Vertex v : dag.getVertices()) {
                    TezVertexStats tts = TezLauncher.this.tezStats.getVertexStats(dag.getName(), v.getName());
                    if (tts == null) continue;
                    Map<String, Map<String, Long>> counterGroups = tts.getCounters();
                    if (counterGroups == null) {
                        log.warn((Object)("Counters are not available for vertex " + v.getName() + ". Not computing warning aggregates."));
                        continue;
                    }
                    TezLauncher.this.computeWarningAggregate(counterGroups, warningAggMap);
                }
                if (TezLauncher.this.aggregateWarning) {
                    CompilationMessageCollector.logAggregate(warningAggMap, CompilationMessageCollector.MessageType.Warning, log);
                }
                return true;
            }
            return false;
        }
    }
}

