/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.lib.partition.HashPartitioner;
import org.apache.pig.CollectableLoadFunc;
import org.apache.pig.FuncSpec;
import org.apache.pig.IndexableLoadFunc;
import org.apache.pig.LoadFunc;
import org.apache.pig.OrderedLoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.JobControlCompiler;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MergeJoinIndexer;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.ScalarPhyFinder;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.UDFFinder;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.LitePackager;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCollectedGroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCounter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCross;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POGlobalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeCogroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PONative;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPoissonSample;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PORank;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POReservoirSample;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSkewedJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStream;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.Packager;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezCompilerException;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainer;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.NativeTezOper;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POCounterStatsTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POCounterTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POFRJoinTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POIdentityInOutTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POLocalRearrangeTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POLocalRearrangeTezFactory;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POPartitionRearrangeTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.PORankTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POShuffledValueInputTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POStoreTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POValueInputTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POValueOutputTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.udf.FindQuantilesTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.udf.PartitionSkewedKeysTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.udf.ReadScalarsTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.SkewedPartitionerTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.WeightedRangePartitionerTez;
import org.apache.pig.backend.hadoop.executionengine.tez.util.TezCompilerUtil;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.builtin.DefaultIndexableLoader;
import org.apache.pig.impl.builtin.GetMemNumRows;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.CompilerUtils;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.runtime.library.input.OrderedGroupedKVInput;
import org.apache.tez.runtime.library.input.UnorderedKVInput;
import org.apache.tez.runtime.library.output.UnorderedKVOutput;

public class TezCompiler
extends PhyPlanVisitor {
    private static final Log LOG = LogFactory.getLog(TezCompiler.class);
    private PigContext pigContext;
    private Properties pigProperties;
    private PhysicalPlan plan;
    private TezOperPlan tezPlan;
    private TezOperator curTezOp;
    private TezOperator[] compiledInputs = null;
    private Map<OperatorKey, TezOperator> splitsSeen;
    private NodeIdGenerator nig;
    private String scope;
    private UDFFinder udfFinder;
    private Map<PhysicalOperator, TezOperator> phyToTezOpMap;
    public static final String USER_COMPARATOR_MARKER = "user.comparator.func:";
    public static final String FILE_CONCATENATION_THRESHOLD = "pig.files.concatenation.threshold";
    public static final String OPTIMISTIC_FILE_CONCATENATION = "pig.optimistic.files.concatenation";
    private int fileConcatenationThreshold = 100;
    private boolean optimisticFileConcatenation = false;
    private POLocalRearrangeTezFactory localRearrangeFactory;

    public TezCompiler(PhysicalPlan plan, PigContext pigContext) throws TezCompilerException {
        super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
        this.plan = plan;
        this.pigContext = pigContext;
        this.pigProperties = pigContext.getProperties();
        this.splitsSeen = Maps.newHashMap();
        this.tezPlan = new TezOperPlan();
        this.nig = NodeIdGenerator.getGenerator();
        this.udfFinder = new UDFFinder();
        List roots = plan.getRoots();
        if (roots == null || roots.size() <= 0) {
            int errCode = 2053;
            String msg = "Internal error. Did not find roots in the physical plan.";
            throw new TezCompilerException(msg, errCode, 4);
        }
        this.scope = ((PhysicalOperator)roots.get(0)).getOperatorKey().getScope();
        this.localRearrangeFactory = new POLocalRearrangeTezFactory(this.scope, this.nig);
        this.phyToTezOpMap = Maps.newHashMap();
        this.fileConcatenationThreshold = Integer.parseInt(this.pigProperties.getProperty(FILE_CONCATENATION_THRESHOLD, "100"));
        this.optimisticFileConcatenation = this.pigProperties.getProperty(OPTIMISTIC_FILE_CONCATENATION, "false").equals("true");
        LOG.info((Object)("File concatenation threshold: " + this.fileConcatenationThreshold + " optimistic? " + this.optimisticFileConcatenation));
    }

    public TezOperPlan getTezPlan() {
        return this.tezPlan;
    }

    public TezPlanContainer getPlanContainer() throws PlanException {
        TezPlanContainer tezPlanContainer = new TezPlanContainer(this.pigContext);
        tezPlanContainer.addPlan(this.tezPlan);
        return tezPlanContainer;
    }

    public TezOperPlan compile() throws IOException, PlanException, VisitorException {
        ArrayList<PhysicalOperator> ops;
        List leaves = this.plan.getLeaves();
        if (!this.pigContext.inIllustrator) {
            for (PhysicalOperator op : leaves) {
                if (op instanceof POStore) continue;
                int errCode = 2025;
                String msg = "Expected leaf of reduce plan to always be POStore. Found " + op.getClass().getSimpleName();
                throw new TezCompilerException(msg, errCode, 4);
            }
        }
        LinkedList<POStore> stores = PlanHelper.getPhysicalOperators(this.plan, POStore.class);
        LinkedList<PONative> nativeTezs = PlanHelper.getPhysicalOperators(this.plan, PONative.class);
        if (!this.pigContext.inIllustrator) {
            ops = new ArrayList<PhysicalOperator>(stores.size() + nativeTezs.size());
            ops.addAll(stores);
        } else {
            ops = new ArrayList(leaves.size() + nativeTezs.size());
            ops.addAll(leaves);
        }
        ops.addAll(nativeTezs);
        Collections.sort(ops);
        for (PhysicalOperator op : ops) {
            this.compile(op);
        }
        for (TezOperator tezOper : this.splitsSeen.values()) {
            int idx = 0;
            LinkedList<POStore> strs = PlanHelper.getPhysicalOperators(tezOper.plan, POStore.class);
            for (POStore op : strs) {
                op.setIndex(idx++);
            }
            tezOper.setClosed(true);
        }
        this.fixScalar();
        return this.tezPlan;
    }

    private void fixScalar() throws VisitorException, PlanException {
        HashMap<POStore, POValueOutputTez> storeSeen = new HashMap<POStore, POValueOutputTez>();
        for (TezOperator tezOp : this.tezPlan) {
            LinkedList<POUserFunc> userFuncs = PlanHelper.getPhysicalOperators(tezOp.plan, POUserFunc.class);
            for (POUserFunc userFunc : userFuncs) {
                if (userFunc.getReferencedOperator() == null) continue;
                POStore store = (POStore)userFunc.getReferencedOperator();
                TezOperator from = this.phyToTezOpMap.get(store);
                FuncSpec newSpec = new FuncSpec(ReadScalarsTez.class.getName(), from.getOperatorKey().toString());
                userFunc.setFuncSpec(newSpec);
                if (storeSeen.containsKey(store)) {
                    ((POValueOutputTez)storeSeen.get(store)).addOutputKey(tezOp.getOperatorKey().toString());
                } else {
                    POValueOutputTez output = new POValueOutputTez(OperatorKey.genOpKey(this.scope));
                    output.addOutputKey(tezOp.getOperatorKey().toString());
                    from.plan.remove((PhysicalOperator)from.plan.getOperator(store.getOperatorKey()));
                    from.plan.addAsLeaf(output);
                    storeSeen.put(store, output);
                    userFunc.getInputs().remove(1);
                }
                TezEdgeDescriptor edge = TezCompilerUtil.connect(this.tezPlan, from, tezOp);
                TezCompilerUtil.configureValueOnlyTupleOutput(edge, EdgeProperty.DataMovementType.BROADCAST);
            }
        }
    }

    private void compile(PhysicalOperator op) throws IOException, PlanException, VisitorException {
        TezOperator[] prevCompInp = this.compiledInputs;
        List<PhysicalOperator> predecessors = this.plan.getPredecessors(op);
        if (!(op instanceof PONative)) {
            if (predecessors != null && predecessors.size() > 0) {
                if (op instanceof POLoad) {
                    if (predecessors.size() != 1) {
                        int errCode = 2125;
                        String msg = "Expected at most one predecessor of load. Got " + predecessors.size();
                        throw new PlanException(msg, errCode, 4);
                    }
                    PhysicalOperator p = predecessors.get(0);
                    TezOperator oper = null;
                    if (!(p instanceof POStore) && !(p instanceof PONative)) {
                        int errCode = 2126;
                        String msg = "Predecessor of load should be a store or native oper. Got " + p.getClass();
                        throw new PlanException(msg, errCode, 4);
                    }
                    oper = this.phyToTezOpMap.get(p);
                    if (p instanceof POStore) {
                        PhysicalOperator store = (PhysicalOperator)oper.plan.getOperator(p.getOperatorKey());
                        oper.plan.disconnect((Operator)oper.plan.getPredecessors(store).get(0), store);
                        oper.plan.remove(store);
                        POValueOutputTez valueOutput = new POValueOutputTez(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
                        oper.plan.addAsLeaf(valueOutput);
                        oper.setSplitter(true);
                        TezOperator storeOnlyTezOperator = this.getTezOp();
                        PhysicalPlan storeOnlyPhyPlan = new PhysicalPlan();
                        POValueInputTez valueInput = new POValueInputTez(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
                        valueInput.setInputKey(oper.getOperatorKey().toString());
                        storeOnlyPhyPlan.addAsLeaf(valueInput);
                        storeOnlyPhyPlan.addAsLeaf(store);
                        storeOnlyTezOperator.plan = storeOnlyPhyPlan;
                        this.tezPlan.add(storeOnlyTezOperator);
                        this.phyToTezOpMap.put(store, storeOnlyTezOperator);
                        this.curTezOp = this.getTezOp();
                        POValueInputTez valueInput2 = new POValueInputTez(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
                        valueInput2.setInputKey(oper.getOperatorKey().toString());
                        this.curTezOp.plan.add(valueInput2);
                        this.tezPlan.add(this.curTezOp);
                        TezEdgeDescriptor edge = TezCompilerUtil.connect(this.tezPlan, oper, storeOnlyTezOperator);
                        TezCompilerUtil.configureValueOnlyTupleOutput(edge, EdgeProperty.DataMovementType.ONE_TO_ONE);
                        storeOnlyTezOperator.setRequestedParallelismByReference(oper);
                        edge = TezCompilerUtil.connect(this.tezPlan, oper, this.curTezOp);
                        TezCompilerUtil.configureValueOnlyTupleOutput(edge, EdgeProperty.DataMovementType.ONE_TO_ONE);
                        this.curTezOp.setRequestedParallelismByReference(oper);
                    } else if (p instanceof PONative) {
                        this.curTezOp = this.getTezOp();
                        this.curTezOp.plan.add(op);
                        this.tezPlan.add(this.curTezOp);
                        this.plan.disconnect(op, p);
                        TezCompilerUtil.connect(this.tezPlan, oper, this.curTezOp);
                        this.phyToTezOpMap.put(op, this.curTezOp);
                        return;
                    }
                    return;
                }
                Collections.sort(predecessors);
                if (!(op instanceof POSplit) || !this.splitsSeen.containsKey(op.getOperatorKey())) {
                    this.compiledInputs = new TezOperator[predecessors.size()];
                    int i = -1;
                    for (PhysicalOperator pred : predecessors) {
                        this.compile(pred);
                        this.compiledInputs[++i] = this.curTezOp;
                    }
                }
            } else {
                this.curTezOp = this.getTezOp();
                this.curTezOp.plan.add(op);
                this.curTezOp.setUseMRMapSettings(true);
                if (op != null && op instanceof POLoad && ((POLoad)op).getLFile() != null && ((POLoad)op).getLFile().getFuncSpec() != null) {
                    this.curTezOp.UDFs.add(((POLoad)op).getLFile().getFuncSpec().toString());
                }
                this.tezPlan.add(this.curTezOp);
                this.phyToTezOpMap.put(op, this.curTezOp);
                return;
            }
        }
        op.visit(this);
        this.compiledInputs = prevCompInp;
    }

    private void nonBlocking(PhysicalOperator op) throws PlanException, IOException {
        TezOperator tezOp;
        if (this.compiledInputs.length == 1) {
            tezOp = this.compiledInputs[0];
            if (tezOp.isClosed()) {
                int errCode = 2027;
                String msg = "Tez operator has been closed. This is unexpected for a merge.";
                throw new PlanException(msg, errCode, 4);
            }
        } else {
            tezOp = this.merge(this.compiledInputs);
        }
        tezOp.plan.addAsLeaf(op);
        this.curTezOp = tezOp;
    }

    private void blocking() throws IOException, PlanException {
        TezOperator newTezOp = this.getTezOp();
        this.tezPlan.add(newTezOp);
        for (TezOperator tezOp : this.compiledInputs) {
            tezOp.setClosed(true);
            TezCompilerUtil.connect(this.tezPlan, tezOp, newTezOp);
        }
        this.curTezOp = newTezOp;
    }

    private POSplit findPOSplit(TezOperator tezOp, OperatorKey splitKey) throws PlanException {
        POSplit split = (POSplit)tezOp.plan.getOperator(splitKey);
        if (split != null) {
            return split;
        }
        Stack<POSplit> stack = new Stack<POSplit>();
        split = (POSplit)tezOp.plan.getLeaves().get(0);
        stack.push(split);
        while (!stack.isEmpty()) {
            split = (POSplit)stack.pop();
            for (PhysicalPlan plan : split.getPlans()) {
                PhysicalOperator op = (PhysicalOperator)plan.getLeaves().get(0);
                if (!(op instanceof POSplit)) continue;
                split = (POSplit)op;
                if (split.getOperatorKey().equals(splitKey)) {
                    return split;
                }
                stack.push(split);
            }
        }
        throw new PlanException("Could not find the split operator " + splitKey, 2059, 4);
    }

    private TezOperator merge(TezOperator[] compiledInputs) throws PlanException {
        TezOperator ret = this.getTezOp();
        this.tezPlan.add(ret);
        HashSet toBeConnected = Sets.newHashSet();
        ArrayList toBeRemoved = Lists.newArrayList();
        ArrayList toBeMerged = Lists.newArrayList();
        for (TezOperator tezOp : compiledInputs) {
            if (!tezOp.isClosed()) {
                toBeRemoved.add(tezOp);
                toBeMerged.add(tezOp.plan);
                List<TezOperator> predecessors = this.tezPlan.getPredecessors(tezOp);
                if (predecessors == null) continue;
                for (TezOperator predecessorTezOp : predecessors) {
                    toBeConnected.add(predecessorTezOp);
                }
                continue;
            }
            int errCode = 2027;
            String msg = "Tez operator has been closed. This is unexpected for a merge.";
            throw new PlanException(msg, errCode, 4);
        }
        this.merge(ret.plan, toBeMerged);
        Iterator it = toBeConnected.iterator();
        while (it.hasNext()) {
            this.tezPlan.connect((Operator)it.next(), ret);
        }
        for (TezOperator tezOp : toBeRemoved) {
            if (tezOp.getRequestedParallelism() > ret.getRequestedParallelism()) {
                ret.setRequestedParallelism(tezOp.getRequestedParallelism());
            }
            for (String udf : tezOp.UDFs) {
                if (ret.UDFs.contains(udf)) continue;
                ret.UDFs.add(udf);
            }
            for (PhysicalOperator physOp : tezOp.scalars) {
                if (ret.scalars.contains(physOp)) continue;
                ret.scalars.add(physOp);
            }
            HashSet opsToChange = Sets.newHashSet();
            for (Map.Entry<PhysicalOperator, TezOperator> entry : this.phyToTezOpMap.entrySet()) {
                if (entry.getValue() != tezOp) continue;
                opsToChange.add(entry.getKey());
            }
            for (PhysicalOperator op : opsToChange) {
                this.phyToTezOpMap.put(op, ret);
            }
            this.tezPlan.remove(tezOp);
        }
        return ret;
    }

    private <O extends Operator<?>, E extends OperatorPlan<O>> void merge(E finPlan, List<E> plans) throws PlanException {
        for (OperatorPlan e : plans) {
            finPlan.merge(e);
        }
    }

    private void processUDFs(PhysicalPlan plan) throws VisitorException {
        if (plan != null) {
            ScalarPhyFinder scalarPhyFinder = new ScalarPhyFinder(plan);
            scalarPhyFinder.visit();
            this.curTezOp.scalars.addAll(scalarPhyFinder.getScalars());
            this.udfFinder.setPlan(plan);
            this.udfFinder.visit();
            this.curTezOp.UDFs.addAll(this.udfFinder.getUDFs());
        }
    }

    @Override
    public void visitCollectedGroup(POCollectedGroup op) throws VisitorException {
        List roots = this.curTezOp.plan.getRoots();
        if (roots.size() != 1) {
            int errCode = 2171;
            String errMsg = "Expected one but found more then one root physical operator in physical plan.";
            throw new TezCompilerException(errMsg, errCode, 4);
        }
        PhysicalOperator phyOp = (PhysicalOperator)roots.get(0);
        if (!(phyOp instanceof POLoad)) {
            int errCode = 2172;
            String errMsg = "Expected physical operator at root to be POLoad. Found : " + phyOp.getClass().getCanonicalName();
            throw new TezCompilerException(errMsg, errCode, 4);
        }
        LoadFunc loadFunc = ((POLoad)phyOp).getLoadFunc();
        try {
            if (!CollectableLoadFunc.class.isAssignableFrom(loadFunc.getClass())) {
                int errCode = 2249;
                throw new TezCompilerException("While using 'collected' on group; data must be loaded via loader implementing CollectableLoadFunc.", errCode);
            }
            ((CollectableLoadFunc)((Object)loadFunc)).ensureAllKeyInstancesInSameSplit();
        }
        catch (TezCompilerException e) {
            throw e;
        }
        catch (IOException e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
        try {
            this.nonBlocking(op);
            this.phyToTezOpMap.put(op, this.curTezOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitCounter(POCounter op) throws VisitorException {
        try {
            POCounterTez counterTez = new POCounterTez(op);
            this.nonBlocking(counterTez);
            this.phyToTezOpMap.put(op, this.curTezOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitCross(POCross op) throws VisitorException {
        try {
            this.nonBlocking(op);
            this.phyToTezOpMap.put(op, this.curTezOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitDistinct(PODistinct op) throws VisitorException {
        try {
            POLocalRearrangeTez lr = this.localRearrangeFactory.create();
            lr.setDistinct(true);
            lr.copyAliasFrom(op);
            this.curTezOp.plan.addAsLeaf(lr);
            TezOperator lastOp = this.curTezOp;
            this.blocking();
            TezCompilerUtil.setCustomPartitioner(op.getCustomPartitioner(), this.curTezOp);
            PhysicalPlan combinePlan = this.curTezOp.inEdges.get((Object)lastOp.getOperatorKey()).combinePlan;
            this.addDistinctPlan(combinePlan, 1);
            POLocalRearrangeTez clr = this.localRearrangeFactory.create();
            clr.setOutputKey(this.curTezOp.getOperatorKey().toString());
            clr.setDistinct(true);
            combinePlan.addAsLeaf(clr);
            this.addDistinctPlan(this.curTezOp.plan, op.getRequestedParallelism());
            this.curTezOp.setRequestedParallelism(op.getRequestedParallelism());
            this.phyToTezOpMap.put(op, this.curTezOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Cannot compile " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4);
        }
    }

    private void addDistinctPlan(PhysicalPlan plan, int rp) throws PlanException {
        POPackage pkg = this.getPackage(1, (byte)110);
        pkg.getPkgr().setDistinct(true);
        plan.addAsLeaf(pkg);
        POProject project = new POProject(OperatorKey.genOpKey(this.scope));
        project.setResultType((byte)110);
        project.setStar(false);
        project.setColumn(0);
        project.setOverloaded(false);
        POForEach forEach = TezCompilerUtil.getForEach(project, rp, this.scope, this.nig);
        plan.addAsLeaf(forEach);
    }

    @Override
    public void visitFilter(POFilter op) throws VisitorException {
        try {
            this.nonBlocking(op);
            this.processUDFs(op.getPlan());
            this.phyToTezOpMap.put(op, this.curTezOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitFRJoin(POFRJoin op) throws VisitorException {
        try {
            ArrayList inputKeys = Lists.newArrayList();
            this.curTezOp = this.phyToTezOpMap.get(op.getInputs().get(op.getFragment()));
            for (int i = 0; i < this.compiledInputs.length; ++i) {
                TezOperator tezOp = this.compiledInputs[i];
                if (this.curTezOp.equals(tezOp)) continue;
                if (!tezOp.isClosed()) {
                    POLocalRearrangeTez lr = new POLocalRearrangeTez(op.getLRs()[i]);
                    lr.setOutputKey(this.curTezOp.getOperatorKey().toString());
                    lr.setConnectedToPackage(false);
                    tezOp.plan.addAsLeaf(lr);
                    TezEdgeDescriptor edge = TezCompilerUtil.connect(this.tezPlan, tezOp, this.curTezOp);
                    inputKeys.add(tezOp.getOperatorKey().toString());
                    edge.dataMovementType = EdgeProperty.DataMovementType.BROADCAST;
                    edge.outputClassName = UnorderedKVOutput.class.getName();
                    edge.inputClassName = UnorderedKVInput.class.getName();
                    continue;
                }
                int errCode = 2022;
                String msg = "The current operator is closed. This is unexpected while compiling.";
                throw new TezCompilerException(msg, errCode, 4);
            }
            if (this.curTezOp.isClosed()) {
                int errCode = 2022;
                String msg = "The current operator is closed. This is unexpected while compiling.";
                throw new TezCompilerException(msg, errCode, 4);
            }
            this.curTezOp.plan.addAsLeaf(new POFRJoinTez(op, inputKeys));
            List<List<PhysicalPlan>> joinPlans = op.getJoinPlans();
            if (joinPlans != null) {
                for (List<PhysicalPlan> joinPlan : joinPlans) {
                    if (joinPlan == null) continue;
                    for (PhysicalPlan plan : joinPlan) {
                        this.processUDFs(plan);
                    }
                }
            }
            this.phyToTezOpMap.put(op, this.curTezOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitLimit(POLimit op) throws VisitorException {
        try {
            if (op.getLimitPlan() != null) {
                this.processUDFs(op.getLimitPlan());
            }
            if (!this.pigContext.inIllustrator) {
                this.nonBlocking(op);
                this.phyToTezOpMap.put(op, this.curTezOp);
            }
            boolean limitAfterSort = this.curTezOp.isGlobalSort();
            if (this.curTezOp.getRequestedParallelism() == 1 || this.curTezOp.isUnion()) {
                boolean canStop = true;
                for (PhysicalOperator planOp : this.curTezOp.plan.getRoots()) {
                    if (!(planOp instanceof POLoad)) continue;
                    canStop = false;
                    break;
                }
                if (canStop) {
                    if (this.curTezOp.isUnion()) {
                        this.curTezOp.setRequestedParallelism(1);
                    }
                    this.curTezOp.setDontEstimateParallelism(true);
                    if (limitAfterSort) {
                        this.curTezOp.markLimitAfterSort();
                    } else {
                        this.curTezOp.markLimit();
                    }
                    return;
                }
            }
            POValueOutputTez output = new POValueOutputTez(OperatorKey.genOpKey(this.scope));
            output.copyAliasFrom(op);
            this.curTezOp.plan.addAsLeaf(output);
            TezOperator prevOp = this.curTezOp;
            this.blocking();
            this.curTezOp.setRequestedParallelism(1);
            this.curTezOp.setDontEstimateParallelism(true);
            output.addOutputKey(this.curTezOp.getOperatorKey().toString());
            TezEdgeDescriptor edge = this.curTezOp.inEdges.get(prevOp.getOperatorKey());
            TezCompilerUtil.configureValueOnlyTupleOutput(edge, EdgeProperty.DataMovementType.SCATTER_GATHER);
            if (limitAfterSort) {
                this.curTezOp.markLimitAfterSort();
                output.setTaskIndexWithRecordIndexAsKey(true);
                edge.outputClassName = UnorderedKVOutput.class.getName();
                edge.inputClassName = OrderedGroupedKVInput.class.getName();
                edge.setIntermediateOutputKeyClass(TezCompilerUtil.TUPLE_CLASS);
                edge.setIntermediateOutputKeyComparatorClass(JobControlCompiler.PigTupleWritableComparator.class.getName());
            } else {
                this.curTezOp.markLimit();
            }
            POValueInputTez input = new POValueInputTez(OperatorKey.genOpKey(this.scope));
            input.copyAliasFrom(op);
            input.setInputKey(prevOp.getOperatorKey().toString());
            this.curTezOp.plan.addAsLeaf(input);
            if (!this.pigContext.inIllustrator) {
                POLimit limitCopy = new POLimit(OperatorKey.genOpKey(this.scope));
                limitCopy.copyAliasFrom(op);
                limitCopy.setLimit(op.getLimit());
                limitCopy.setLimitPlan(op.getLimitPlan());
                this.curTezOp.plan.addAsLeaf(limitCopy);
            } else {
                this.curTezOp.plan.addAsLeaf(op);
            }
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitLoad(POLoad op) throws VisitorException {
        try {
            this.nonBlocking(op);
            this.curTezOp.setUseMRMapSettings(true);
            this.phyToTezOpMap.put(op, this.curTezOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitLocalRearrange(POLocalRearrange op) throws VisitorException {
        try {
            POLocalRearrangeTez opTez = new POLocalRearrangeTez(op);
            this.nonBlocking(opTez);
            List<PhysicalPlan> plans = opTez.getPlans();
            if (plans != null) {
                for (PhysicalPlan ep : plans) {
                    this.processUDFs(ep);
                }
            }
            this.phyToTezOpMap.put(opTez, this.curTezOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitGlobalRearrange(POGlobalRearrange op) throws VisitorException {
        try {
            this.blocking();
            TezCompilerUtil.setCustomPartitioner(op.getCustomPartitioner(), this.curTezOp);
            this.curTezOp.setRequestedParallelism(op.getRequestedParallelism());
            if (op.isCross()) {
                this.curTezOp.addCrossKey(op.getOperatorKey().toString());
            }
            this.phyToTezOpMap.put(op, this.curTezOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitMergeCoGroup(POMergeCogroup poCoGrp) throws VisitorException {
        if (this.compiledInputs.length < 2) {
            int errCode = 2251;
            String errMsg = "Merge Cogroup work on two or more relations.To use map-side group-by on single relation, use 'collected' qualifier.";
            throw new TezCompilerException(errMsg, errCode);
        }
        ArrayList<FuncSpec> funcSpecs = new ArrayList<FuncSpec>(this.compiledInputs.length - 1);
        ArrayList<String> fileSpecs = new ArrayList<String>(this.compiledInputs.length - 1);
        ArrayList<String> loaderSigns = new ArrayList<String>(this.compiledInputs.length - 1);
        try {
            poCoGrp.setEndOfRecordMark((byte)1);
            for (int i = 0; i < this.compiledInputs.length; ++i) {
                TezOperator tezOper = this.compiledInputs[i];
                PhysicalPlan plan = tezOper.plan;
                if (plan.getRoots().size() != 1) {
                    int errCode = 2171;
                    String errMsg = "Expected one but found more then one root physical operator in physical plan.";
                    throw new TezCompilerException(errMsg, errCode, 4);
                }
                PhysicalOperator rootPOOp = (PhysicalOperator)plan.getRoots().get(0);
                if (!(rootPOOp instanceof POLoad)) {
                    int errCode = 2172;
                    String errMsg = "Expected physical operator at root to be POLoad. Found : " + rootPOOp.getClass().getCanonicalName();
                    throw new TezCompilerException(errMsg, errCode);
                }
                POLoad sideLoader = (POLoad)rootPOOp;
                FileSpec loadFileSpec = sideLoader.getLFile();
                FuncSpec funcSpec = loadFileSpec.getFuncSpec();
                LoadFunc loadfunc = sideLoader.getLoadFunc();
                if (i == 0) {
                    if (!CollectableLoadFunc.class.isAssignableFrom(loadfunc.getClass())) {
                        int errCode = 2252;
                        throw new TezCompilerException("Base loader in Cogroup must implement CollectableLoadFunc.", errCode);
                    }
                    ((CollectableLoadFunc)((Object)loadfunc)).ensureAllKeyInstancesInSameSplit();
                    continue;
                }
                if (!IndexableLoadFunc.class.isAssignableFrom(loadfunc.getClass())) {
                    int errCode = 2253;
                    throw new TezCompilerException("Side loaders in cogroup must implement IndexableLoadFunc.", errCode);
                }
                funcSpecs.add(funcSpec);
                fileSpecs.add(loadFileSpec.getFileName());
                loaderSigns.add(sideLoader.getSignature());
                this.tezPlan.remove(tezOper);
            }
            poCoGrp.setSideLoadFuncs(funcSpecs);
            poCoGrp.setSideFileSpecs(fileSpecs);
            poCoGrp.setLoaderSignatures(loaderSigns);
            TezOperator baseMROp = this.phyToTezOpMap.get(poCoGrp.getInputs().get(0));
            if (baseMROp.isClosed()) {
                int errCode = 2254;
                throw new TezCompilerException("Currently merged cogroup is not supported after blocking operators.", errCode);
            }
            TezOperator indexerTezOp = this.getTezOp();
            FileSpec idxFileSpec = this.getIndexingJob(indexerTezOp, baseMROp, poCoGrp.getLRInnerPlansOf(0));
            poCoGrp.setIdxFuncSpec(idxFileSpec.getFuncSpec());
            poCoGrp.setIndexFileName(idxFileSpec.getFileName());
            baseMROp.plan.addAsLeaf(poCoGrp);
            for (FuncSpec funcSpec : funcSpecs) {
                baseMROp.UDFs.add(funcSpec.toString());
            }
            this.phyToTezOpMap.put(poCoGrp, baseMROp);
            this.curTezOp = baseMROp;
        }
        catch (ExecException e) {
            throw new TezCompilerException(e.getDetailedMessage(), e.getErrorCode(), e.getErrorSource(), (Throwable)e);
        }
        catch (TezCompilerException mrce) {
            throw mrce;
        }
        catch (CloneNotSupportedException e) {
            throw new TezCompilerException(e);
        }
        catch (PlanException e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + poCoGrp.getClass().getCanonicalName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
        catch (IOException e) {
            int errCode = 3000;
            String errMsg = "IOException caught while compiling POMergeCoGroup";
            throw new TezCompilerException(errMsg, errCode, e);
        }
    }

    private FileSpec getIndexingJob(TezOperator indexerTezOp, TezOperator baseTezOp, List<PhysicalPlan> mapperLRInnerPlans) throws TezCompilerException, PlanException, ExecException, IOException, CloneNotSupportedException {
        PhysicalPlan phyPlan;
        PhysicalPlan basePlan = baseTezOp.plan;
        POLoad baseLoader = (POLoad)basePlan.getRoots().get(0);
        FileSpec origLoaderFileSpec = baseLoader.getLFile();
        FuncSpec funcSpec = origLoaderFileSpec.getFuncSpec();
        LoadFunc loadFunc = baseLoader.getLoadFunc();
        if (!OrderedLoadFunc.class.isAssignableFrom(loadFunc.getClass())) {
            int errCode = 1104;
            String errMsg = "Base relation of merge-coGroup must implement OrderedLoadFunc interface. The specified loader " + funcSpec + " doesn't implement it";
            throw new TezCompilerException(errMsg, errCode);
        }
        String[] indexerArgs = new String[6];
        indexerArgs[0] = funcSpec.toString();
        indexerArgs[1] = ObjectSerializer.serialize((Serializable)((Object)mapperLRInnerPlans));
        indexerArgs[3] = baseLoader.getSignature();
        indexerArgs[4] = baseLoader.getOperatorKey().scope;
        indexerArgs[5] = Boolean.toString(false);
        if (basePlan.getSuccessors(baseLoader) == null || basePlan.getSuccessors(baseLoader).isEmpty()) {
            phyPlan = null;
        } else {
            phyPlan = basePlan.clone();
            PhysicalOperator root = (PhysicalOperator)phyPlan.getRoots().get(0);
            phyPlan.disconnect(root, (Operator)phyPlan.getSuccessors(root).get(0));
            phyPlan.remove(root);
        }
        indexerArgs[2] = ObjectSerializer.serialize(phyPlan);
        POLoad idxJobLoader = new POLoad(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        idxJobLoader.setPc(this.pigContext);
        idxJobLoader.setIsTmpLoad(true);
        idxJobLoader.setLFile(new FileSpec(origLoaderFileSpec.getFileName(), new FuncSpec(MergeJoinIndexer.class.getName(), indexerArgs)));
        indexerTezOp.plan.add(idxJobLoader);
        indexerTezOp.UDFs.add(baseLoader.getLFile().getFuncSpec().toString());
        TezOperator indexAggrOper = this.getTezOp();
        this.tezPlan.add(indexAggrOper);
        this.tezPlan.add(indexerTezOp);
        TezCompilerUtil.simpleConnectTwoVertex(this.tezPlan, indexerTezOp, indexAggrOper, this.scope, this.nig);
        TezCompilerUtil.connect(this.tezPlan, indexAggrOper, baseTezOp);
        indexAggrOper.segmentBelow = true;
        indexerTezOp.setRequestedParallelism(1);
        indexerTezOp.setDontEstimateParallelism(true);
        POStore st = TezCompilerUtil.getStore(this.scope, this.nig);
        FileSpec strFile = this.getTempFileSpec();
        st.setSFile(strFile);
        indexAggrOper.plan.addAsLeaf(st);
        indexAggrOper.setClosed(true);
        return strFile;
    }

    @Override
    public void visitMergeJoin(POMergeJoin joinOp) throws VisitorException {
        try {
            PhysicalPlan rightPipelinePlan;
            joinOp.setEndOfRecordMark((byte)1);
            if (this.compiledInputs.length != 2 || joinOp.getInputs().size() != 2) {
                int errCode = 1101;
                throw new TezCompilerException("Merge Join must have exactly two inputs. Found : " + this.compiledInputs.length, errCode);
            }
            this.curTezOp = this.phyToTezOpMap.get(joinOp.getInputs().get(0));
            TezOperator rightTezOpr = null;
            TezOperator rightTezOprAggr = null;
            rightTezOpr = this.curTezOp.equals(this.compiledInputs[0]) ? this.compiledInputs[1] : this.compiledInputs[0];
            if (!rightTezOpr.closed) {
                PhysicalPlan rightPlan = rightTezOpr.plan;
                if (rightPlan.getRoots().size() != 1) {
                    int errCode = 2171;
                    String errMsg = "Expected one but found more then one root physical operator in physical plan.";
                    throw new TezCompilerException(errMsg, errCode, 4);
                }
                PhysicalOperator rightLoader = (PhysicalOperator)rightPlan.getRoots().get(0);
                if (!(rightLoader instanceof POLoad)) {
                    int errCode = 2172;
                    String errMsg = "Expected physical operator at root to be POLoad. Found : " + rightLoader.getClass().getCanonicalName();
                    throw new TezCompilerException(errMsg, errCode);
                }
                if (rightPlan.getSuccessors(rightLoader) == null || rightPlan.getSuccessors(rightLoader).isEmpty()) {
                    rightPipelinePlan = null;
                } else {
                    rightPipelinePlan = rightPlan.clone();
                    PhysicalOperator root = (PhysicalOperator)rightPipelinePlan.getRoots().get(0);
                    rightPipelinePlan.disconnect(root, (Operator)rightPipelinePlan.getSuccessors(root).get(0));
                    rightPipelinePlan.remove(root);
                    rightPlan.trimBelow(rightLoader);
                }
            } else {
                int errCode = 2022;
                String msg = "Right input plan have been closed. This is unexpected while compiling.";
                throw new PlanException(msg, errCode, 4);
            }
            joinOp.setupRightPipeline(rightPipelinePlan);
            POLoad rightLoader = (POLoad)rightTezOpr.plan.getRoots().get(0);
            joinOp.setSignature(rightLoader.getSignature());
            LoadFunc rightLoadFunc = rightLoader.getLoadFunc();
            ArrayList<String> udfs = new ArrayList<String>();
            if (IndexableLoadFunc.class.isAssignableFrom(rightLoadFunc.getClass())) {
                joinOp.setRightLoaderFuncSpec(rightLoader.getLFile().getFuncSpec());
                joinOp.setRightInputFileName(rightLoader.getLFile().getFileName());
                udfs.add(rightLoader.getLFile().getFuncSpec().toString());
                this.tezPlan.remove(rightTezOpr);
                if (rightTezOpr == this.compiledInputs[0]) {
                    this.compiledInputs[0] = null;
                } else if (rightTezOpr == this.compiledInputs[1]) {
                    this.compiledInputs[1] = null;
                }
                rightTezOpr = null;
                int numInputs = ((PhysicalPlan)this.mPlan).getPredecessors(joinOp).size();
                for (int i = 0; i < numInputs; ++i) {
                    List<PhysicalPlan> keyPlans = joinOp.getInnerPlansOf(i);
                    for (PhysicalPlan keyPlan : keyPlans) {
                        for (PhysicalOperator op : keyPlan) {
                            if (op instanceof POProject) continue;
                            int errCode = 1106;
                            String errMsg = "Merge join is possible only for simple column or '*' join keys when using " + rightLoader.getLFile().getFuncSpec() + " as the loader";
                            throw new TezCompilerException(errMsg, errCode, 2);
                        }
                    }
                }
            } else {
                LoadFunc loadFunc = rightLoader.getLoadFunc();
                if (joinOp.getJoinType() == LOJoin.JOINTYPE.MERGESPARSE) {
                    int errCode = 1104;
                    String errMsg = "Right input of merge-join must implement IndexableLoadFunc. The specified loader " + loadFunc + " doesn't implement it";
                    throw new TezCompilerException(errMsg, errCode);
                }
                if (!OrderedLoadFunc.class.isAssignableFrom(loadFunc.getClass())) {
                    int errCode = 1104;
                    String errMsg = "Right input of merge-join must implement OrderedLoadFunc interface. The specified loader " + loadFunc + " doesn't implement it";
                    throw new TezCompilerException(errMsg, errCode);
                }
                String[] indexerArgs = new String[6];
                List<PhysicalPlan> rightInpPlans = joinOp.getInnerPlansOf(1);
                FileSpec origRightLoaderFileSpec = rightLoader.getLFile();
                indexerArgs[0] = origRightLoaderFileSpec.getFuncSpec().toString();
                indexerArgs[1] = ObjectSerializer.serialize((Serializable)((Object)rightInpPlans));
                indexerArgs[2] = ObjectSerializer.serialize(rightPipelinePlan);
                indexerArgs[3] = rightLoader.getSignature();
                indexerArgs[4] = rightLoader.getOperatorKey().scope;
                indexerArgs[5] = Boolean.toString(true);
                FileSpec lFile = new FileSpec(rightLoader.getLFile().getFileName(), new FuncSpec(MergeJoinIndexer.class.getName(), indexerArgs));
                rightLoader.setLFile(lFile);
                rightTezOprAggr = this.getTezOp();
                this.tezPlan.add(rightTezOprAggr);
                TezCompilerUtil.simpleConnectTwoVertex(this.tezPlan, rightTezOpr, rightTezOprAggr, this.scope, this.nig);
                rightTezOprAggr.setRequestedParallelism(1);
                rightTezOprAggr.setDontEstimateParallelism(true);
                POStore st = TezCompilerUtil.getStore(this.scope, this.nig);
                FileSpec strFile = this.getTempFileSpec();
                st.setSFile(strFile);
                rightTezOprAggr.plan.addAsLeaf(st);
                rightTezOprAggr.setClosed(true);
                rightTezOprAggr.segmentBelow = true;
                String[] defaultIndexableLoaderArgs = new String[]{origRightLoaderFileSpec.getFuncSpec().toString(), strFile.getFileName(), strFile.getFuncSpec().toString(), joinOp.getOperatorKey().scope, origRightLoaderFileSpec.getFileName()};
                joinOp.setRightLoaderFuncSpec(new FuncSpec(DefaultIndexableLoader.class.getName(), defaultIndexableLoaderArgs));
                joinOp.setRightInputFileName(origRightLoaderFileSpec.getFileName());
                joinOp.setIndexFile(strFile.getFileName());
                udfs.add(origRightLoaderFileSpec.getFuncSpec().toString());
            }
            if (this.curTezOp.isClosed()) {
                int errCode = 2022;
                String msg = "Input plan has been closed. This is unexpected while compiling.";
                throw new PlanException(msg, errCode, 4);
            }
            this.curTezOp.plan.addAsLeaf(joinOp);
            if (rightTezOprAggr != null) {
                rightTezOprAggr.markIndexer();
                TezCompilerUtil.connect(this.tezPlan, rightTezOprAggr, this.curTezOp);
            }
            this.phyToTezOpMap.put(joinOp, this.curTezOp);
            this.curTezOp.noCombineSmallSplits();
            this.curTezOp.UDFs.addAll(udfs);
        }
        catch (PlanException e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + joinOp.getClass().getCanonicalName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
        catch (IOException e) {
            int errCode = 3000;
            String errMsg = "IOException caught while compiling POMergeJoin";
            throw new TezCompilerException(errMsg, errCode, e);
        }
        catch (CloneNotSupportedException e) {
            int errCode = 2127;
            String errMsg = "Cloning exception caught while compiling POMergeJoin";
            throw new TezCompilerException(errMsg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitNative(PONative op) throws VisitorException {
        try {
            this.curTezOp.segmentBelow = true;
            NativeTezOper nativeTezOper = new NativeTezOper(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), op.getNativeMRjar(), op.getParams());
            this.tezPlan.add(nativeTezOper);
            this.curTezOp.setClosed(true);
            this.tezPlan.connect(this.curTezOp, nativeTezOper);
            this.phyToTezOpMap.put(op, nativeTezOper);
            nativeTezOper.setClosed(true);
            nativeTezOper.segmentBelow = true;
            nativeTezOper.markNative();
            this.curTezOp = nativeTezOper;
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitPackage(POPackage op) throws VisitorException {
        try {
            this.nonBlocking(op);
            this.phyToTezOpMap.put(op, this.curTezOp);
            if (op.getPkgr().getPackageType() == Packager.PackageType.JOIN) {
                this.curTezOp.markRegularJoin();
            } else if (op.getPkgr().getPackageType() == Packager.PackageType.GROUP) {
                if (op.getNumInps() == 1) {
                    this.curTezOp.markGroupBy();
                } else if (op.getNumInps() > 1) {
                    this.curTezOp.markCogroup();
                }
            }
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitPOForEach(POForEach op) throws VisitorException {
        try {
            this.nonBlocking(op);
            List<PhysicalPlan> plans = op.getInputPlans();
            if (plans != null) {
                for (PhysicalPlan ep : plans) {
                    this.processUDFs(ep);
                }
            }
            this.phyToTezOpMap.put(op, this.curTezOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitRank(PORank op) throws VisitorException {
        try {
            TezOperator counterOper = this.curTezOp;
            POCounterTez counterTez = (POCounterTez)counterOper.plan.getLeaves().get(0);
            TezOperator statsOper = this.getTezOp();
            this.tezPlan.add(statsOper);
            POCounterStatsTez counterStatsTez = new POCounterStatsTez(OperatorKey.genOpKey(this.scope));
            statsOper.plan.addAsLeaf(counterStatsTez);
            statsOper.setRequestedParallelism(1);
            statsOper.setDontEstimateParallelism(true);
            TezOperator rankOper = this.getTezOp();
            this.tezPlan.add(rankOper);
            PORankTez rankTez = new PORankTez(op);
            rankOper.plan.addAsLeaf(rankTez);
            this.curTezOp = rankOper;
            rankOper.setRequestedParallelismByReference(counterOper);
            TezEdgeDescriptor edge = TezCompilerUtil.connect(this.tezPlan, counterOper, rankOper);
            rankOper.setUseMRMapSettings(counterOper.isUseMRMapSettings());
            TezCompilerUtil.configureValueOnlyTupleOutput(edge, EdgeProperty.DataMovementType.ONE_TO_ONE);
            counterTez.setTuplesOutputKey(rankOper.getOperatorKey().toString());
            rankTez.setTuplesInputKey(counterOper.getOperatorKey().toString());
            edge = TezCompilerUtil.connect(this.tezPlan, counterOper, statsOper);
            edge.setIntermediateOutputKeyClass(IntWritable.class.getName());
            edge.partitionerClass = HashPartitioner.class;
            edge.setIntermediateOutputValueClass(LongWritable.class.getName());
            counterTez.setStatsOutputKey(statsOper.getOperatorKey().toString());
            counterStatsTez.setInputKey(counterOper.getOperatorKey().toString());
            edge = TezCompilerUtil.connect(this.tezPlan, statsOper, rankOper);
            TezCompilerUtil.configureValueOnlyTupleOutput(edge, EdgeProperty.DataMovementType.BROADCAST);
            counterStatsTez.setOutputKey(rankOper.getOperatorKey().toString());
            rankTez.setStatsInputKey(statsOper.getOperatorKey().toString());
            this.phyToTezOpMap.put(op, rankOper);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitSkewedJoin(POSkewedJoin op) throws VisitorException {
        try {
            POLocalRearrangeTez lrTez = new POLocalRearrangeTez(OperatorKey.genOpKey(this.scope));
            POLocalRearrangeTez lrTezSample = this.localRearrangeFactory.create(POLocalRearrangeTezFactory.LocalRearrangeType.NULL);
            int sampleRate = 17;
            if (this.pigProperties.containsKey("pig.sksampler.samplerate")) {
                sampleRate = Integer.valueOf(this.pigProperties.getProperty("pig.sksampler.samplerate"));
            }
            float heapPerc = 0.3f;
            if (this.pigProperties.containsKey("pig.skewedjoin.reduce.memusage")) {
                heapPerc = Float.valueOf(this.pigProperties.getProperty("pig.skewedjoin.reduce.memusage")).floatValue();
            }
            POPoissonSample poSample = new POPoissonSample(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, sampleRate, heapPerc);
            TezOperator prevOp = this.compiledInputs[0];
            prevOp.plan.addAsLeaf(lrTez);
            prevOp.plan.addAsLeaf(poSample);
            prevOp.markSampler();
            MultiMap<PhysicalOperator, PhysicalPlan> joinPlans = op.getJoinPlans();
            List<POSkewedJoin> l = this.plan.getPredecessors(op);
            List<PhysicalPlan> groups = joinPlans.get(l.get(0));
            ArrayList<Boolean> ascCol = new ArrayList<Boolean>();
            for (int i = 0; i < groups.size(); ++i) {
                ascCol.add(false);
            }
            ArrayList<PhysicalPlan> transformPlans = new ArrayList<PhysicalPlan>();
            transformPlans.addAll(groups);
            POProject prjStar = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            prjStar.setResultType((byte)110);
            prjStar.setStar(true);
            ArrayList<PhysicalOperator> ufInps = new ArrayList<PhysicalOperator>();
            ufInps.add(prjStar);
            PhysicalPlan ep = new PhysicalPlan();
            POUserFunc uf = new POUserFunc(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, ufInps, new FuncSpec(GetMemNumRows.class.getName(), (String[])null));
            uf.setResultType((byte)110);
            ep.add(uf);
            ep.add(prjStar);
            ep.connect(prjStar, uf);
            transformPlans.add(ep);
            ArrayList<Boolean> flat1 = new ArrayList<Boolean>();
            ArrayList<PhysicalPlan> eps1 = new ArrayList<PhysicalPlan>();
            for (int i = 0; i < transformPlans.size(); ++i) {
                eps1.add((PhysicalPlan)transformPlans.get(i));
                flat1.add(true);
            }
            POForEach nfe1 = new POForEach(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, eps1, flat1);
            prevOp.plan.addAsLeaf(nfe1);
            prevOp.plan.addAsLeaf(lrTezSample);
            prevOp.setClosed(true);
            int rp = op.getRequestedParallelism();
            if (rp == -1) {
                rp = this.pigContext.defaultParallel;
            }
            POSort sort = new POSort(op.getOperatorKey(), rp, null, groups, ascCol, null);
            String per = this.pigProperties.getProperty("pig.skewedjoin.reduce.memusage", String.valueOf(0.3f));
            String mc = this.pigProperties.getProperty("pig.skewedjoin.reduce.maxtuple", "0");
            Pair<TezOperator, Integer> sampleJobPair = this.getSamplingAggregationJob(sort, rp, null, PartitionSkewedKeysTez.class.getName(), new String[]{per, mc});
            rp = (Integer)sampleJobPair.second;
            TezOperator[] joinJobs = new TezOperator[]{null, this.compiledInputs[1], null};
            TezOperator[] joinInputs = new TezOperator[]{this.compiledInputs[0], this.compiledInputs[1]};
            TezOperator[] rearrangeOutputs = new TezOperator[2];
            this.compiledInputs = new TezOperator[]{joinInputs[0]};
            this.blocking();
            joinJobs[0] = this.curTezOp;
            try {
                lrTez.setIndex(0);
            }
            catch (ExecException e) {
                int errCode = 2058;
                String msg = "Unable to set index on newly created POLocalRearrange.";
                throw new PlanException(msg, errCode, 4, (Throwable)e);
            }
            byte type = 110;
            if (groups.size() == 1) {
                type = ((PhysicalOperator)groups.get(0).getLeaves().get(0)).getResultType();
            }
            lrTez.setKeyType(type);
            lrTez.setPlans(groups);
            lrTez.setSkewedJoin(true);
            lrTez.setResultType((byte)110);
            POIdentityInOutTez identityInOutTez = new POIdentityInOutTez(OperatorKey.genOpKey(this.scope), lrTez);
            identityInOutTez.setInputKey(prevOp.getOperatorKey().toString());
            joinJobs[0].plan.addAsLeaf(identityInOutTez);
            joinJobs[0].setClosed(true);
            joinJobs[0].markSampleBasedPartitioner();
            rearrangeOutputs[0] = joinJobs[0];
            this.compiledInputs = new TezOperator[]{joinInputs[1]};
            POPartitionRearrangeTez pr = new POPartitionRearrangeTez(OperatorKey.genOpKey(this.scope));
            try {
                pr.setIndex(1);
            }
            catch (ExecException e) {
                int errCode = 2058;
                String msg = "Unable to set index on newly created POPartitionRearrange.";
                throw new PlanException(msg, errCode, 4, (Throwable)e);
            }
            groups = joinPlans.get(l.get(1));
            pr.setPlans(groups);
            pr.setKeyType(type);
            pr.setSkewedJoin(true);
            pr.setResultType((byte)110);
            joinJobs[1].plan.addAsLeaf(pr);
            joinJobs[1].setClosed(true);
            rearrangeOutputs[1] = joinJobs[1];
            this.compiledInputs = rearrangeOutputs;
            POGlobalRearrange gr = new POGlobalRearrange(OperatorKey.genOpKey(this.scope), rp);
            gr.setResultType((byte)110);
            gr.visit(this);
            joinJobs[2] = this.curTezOp;
            joinJobs[2].setRequestedParallelism(rp);
            this.compiledInputs = new TezOperator[]{joinJobs[2]};
            POPackage pkg = this.getPackage(2, type);
            pkg.setResultType((byte)110);
            boolean[] inner = op.getInnerFlags();
            pkg.getPkgr().setInner(inner);
            pkg.visit(this);
            this.compiledInputs = new TezOperator[]{this.curTezOp};
            ArrayList<PhysicalPlan> eps = new ArrayList<PhysicalPlan>();
            ArrayList<Boolean> flat = new ArrayList<Boolean>();
            for (int i = 0; i < 2; ++i) {
                ep = new PhysicalPlan();
                POProject prj = new POProject(OperatorKey.genOpKey(this.scope));
                prj.setColumn(i + 1);
                prj.setOverloaded(false);
                prj.setResultType((byte)120);
                ep.add(prj);
                eps.add(ep);
                if (!inner[i]) {
                    CompilerUtils.addEmptyBagOuterJoin(ep, op.getSchema(i));
                }
                flat.add(true);
            }
            POForEach fe = new POForEach(OperatorKey.genOpKey(this.scope), -1, eps, flat);
            fe.setResultType((byte)110);
            fe.visit(this);
            lrTez.setOutputKey(joinJobs[0].getOperatorKey().toString());
            lrTezSample.setOutputKey(((TezOperator)sampleJobPair.first).getOperatorKey().toString());
            identityInOutTez.setOutputKey(joinJobs[2].getOperatorKey().toString());
            pr.setOutputKey(joinJobs[2].getOperatorKey().toString());
            TezEdgeDescriptor edge = joinJobs[0].inEdges.get(prevOp.getOperatorKey());
            joinJobs[0].setUseMRMapSettings(prevOp.isUseMRMapSettings());
            edge.dataMovementType = EdgeProperty.DataMovementType.ONE_TO_ONE;
            edge.outputClassName = UnorderedKVOutput.class.getName();
            edge.inputClassName = UnorderedKVInput.class.getName();
            joinJobs[0].setRequestedParallelismByReference(prevOp);
            TezCompilerUtil.connect(this.tezPlan, prevOp, (TezOperator)sampleJobPair.first);
            POValueOutputTez sampleOut = (POValueOutputTez)((TezOperator)sampleJobPair.first).plan.getLeaves().get(0);
            for (int i = 0; i < 2; ++i) {
                joinJobs[i].setSampleOperator((TezOperator)sampleJobPair.first);
                edge = TezCompilerUtil.connect(this.tezPlan, (TezOperator)sampleJobPair.first, joinJobs[i]);
                TezCompilerUtil.configureValueOnlyTupleOutput(edge, EdgeProperty.DataMovementType.BROADCAST);
                sampleOut.addOutputKey(joinJobs[i].getOperatorKey().toString());
                edge = joinJobs[2].inEdges.get(joinJobs[i].getOperatorKey());
                edge.partitionerClass = SkewedPartitionerTez.class;
            }
            joinJobs[2].markSkewedJoin();
            ((TezOperator)sampleJobPair.first).setSortOperator(joinJobs[2]);
            if (rp == -1) {
                ((TezOperator)sampleJobPair.first).setNeedEstimatedQuantile(true);
            }
            this.phyToTezOpMap.put(op, this.curTezOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    private FileSpec getTempFileSpec() throws IOException {
        return new FileSpec(FileLocalizer.getTemporaryPath(this.pigContext).toString(), new FuncSpec(Utils.getTmpFileCompressorName(this.pigContext)));
    }

    private TezOperator endSingleInputWithStoreAndSample(POSort sort, POLocalRearrangeTez lr, POLocalRearrangeTez lrSample, byte keyType, Pair<POProject, Byte>[] fields) throws PlanException {
        ArrayList<PhysicalPlan> eps1;
        ArrayList<Boolean> flat1;
        if (this.compiledInputs.length > 1) {
            int errCode = 2023;
            String msg = "Received a multi input plan when expecting only a single input one.";
            throw new PlanException(msg, errCode, 4);
        }
        TezOperator oper = this.compiledInputs[0];
        if (!oper.isClosed()) {
            ArrayList<PhysicalPlan> eps = new ArrayList<PhysicalPlan>();
            if (fields == null) {
                PhysicalPlan ep = new PhysicalPlan();
                POProject prj = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
                prj.setStar(true);
                prj.setOverloaded(false);
                prj.setResultType((byte)110);
                ep.add(prj);
                eps.add(ep);
            } else {
                eps.addAll(sort.getSortPlans());
            }
            try {
                lr.setIndex(0);
            }
            catch (ExecException e) {
                int errCode = 2058;
                String msg = "Unable to set index on newly created POLocalRearrange.";
                throw new PlanException(msg, errCode, 4, (Throwable)e);
            }
            lr.setKeyType(fields == null || fields.length > 1 ? (byte)110 : keyType);
            lr.setPlans(eps);
            lr.setResultType((byte)110);
            lr.addOriginalLocation(sort.getAlias(), sort.getOriginalLocations());
            lr.setOutputKey(this.curTezOp.getOperatorKey().toString());
            oper.plan.addAsLeaf(lr);
            flat1 = new ArrayList<Boolean>();
            eps1 = new ArrayList<PhysicalPlan>();
            Pair<POProject, Byte>[] sortProjs = null;
            try {
                sortProjs = TezCompiler.getSortCols(sort.getSortPlans());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (sortProjs == null) {
                PhysicalPlan ep = new PhysicalPlan();
                POProject prj = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
                prj.setStar(true);
                prj.setOverloaded(false);
                prj.setResultType((byte)110);
                ep.add(prj);
                eps1.add(ep);
                flat1.add(false);
            } else {
                for (Pair<POProject, Byte> sortProj : sortProjs) {
                    POProject prj;
                    if (sortProj == null) {
                        int errCode = 2174;
                        String msg = "Internal exception. Could not create a sampler job";
                        throw new PlanException(msg, errCode, 4);
                    }
                    PhysicalPlan ep = new PhysicalPlan();
                    try {
                        prj = ((POProject)sortProj.first).clone();
                    }
                    catch (CloneNotSupportedException e) {
                        throw new AssertionError((Object)("Error cloning project caught exception" + e));
                    }
                    ep.add(prj);
                    eps1.add(ep);
                    flat1.add(false);
                }
            }
            String numSamples = this.pigContext.getProperties().getProperty("pig.random.sampler.sample.size", "100");
            POReservoirSample poSample = new POReservoirSample(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, null, Integer.parseInt(numSamples));
            oper.plan.addAsLeaf(poSample);
            List<PhysicalPlan> sortPlans = sort.getSortPlans();
            ArrayList<PhysicalPlan> transformPlans = new ArrayList<PhysicalPlan>();
            transformPlans.addAll(sortPlans);
            POProject prjStar = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            prjStar.setResultType((byte)110);
            prjStar.setStar(true);
            ArrayList<PhysicalOperator> ufInps = new ArrayList<PhysicalOperator>();
            ufInps.add(prjStar);
            PhysicalPlan ep = new PhysicalPlan();
            POUserFunc uf = new POUserFunc(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, ufInps, new FuncSpec(GetMemNumRows.class.getName(), (String[])null));
            uf.setResultType((byte)110);
            ep.add(uf);
            ep.add(prjStar);
            ep.connect(prjStar, uf);
            transformPlans.add(ep);
            flat1 = new ArrayList();
            eps1 = new ArrayList();
            for (int i = 0; i < transformPlans.size(); ++i) {
                eps1.add((PhysicalPlan)transformPlans.get(i));
                if (i < sortPlans.size()) {
                    flat1.add(false);
                    continue;
                }
                flat1.add(true);
            }
        } else {
            int errCode = 2022;
            String msg = "The current operator is closed. This is unexpected while compiling.";
            throw new PlanException(msg, errCode, 4);
        }
        POForEach nfe1 = new POForEach(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, eps1, flat1);
        oper.plan.addAsLeaf(nfe1);
        lrSample.setOutputKey(this.curTezOp.getOperatorKey().toString());
        oper.plan.addAsLeaf(lrSample);
        return oper;
    }

    private Pair<TezOperator, Integer> getOrderbySamplingAggregationJob(POSort inpSort, int rp) throws PlanException, VisitorException, ExecException {
        POSort sort = new POSort(inpSort.getOperatorKey(), inpSort.getRequestedParallelism(), null, inpSort.getSortPlans(), inpSort.getMAscCols(), inpSort.getMSortFunc());
        sort.addOriginalLocation(inpSort.getAlias(), inpSort.getOriginalLocations());
        List<Boolean> ascCols = inpSort.getMAscCols();
        String[] ascs = new String[ascCols.size()];
        for (int i = 0; i < ascCols.size(); ++i) {
            ascs[i] = ascCols.get(i).toString();
        }
        String[] ctorArgs = ascs;
        if (sort.isUDFComparatorUsed) {
            String userComparatorFuncSpec = sort.getMSortFunc().getFuncSpec().toString();
            ctorArgs = new String[ascs.length + 1];
            ctorArgs[0] = USER_COMPARATOR_MARKER + userComparatorFuncSpec;
            for (int j = 0; j < ascs.length; ++j) {
                ctorArgs[j + 1] = ascs[j];
            }
        }
        return this.getSamplingAggregationJob(sort, rp, null, FindQuantilesTez.class.getName(), ctorArgs);
    }

    private Pair<TezOperator, Integer> getSamplingAggregationJob(POSort sort, int rp, List<PhysicalPlan> sortKeyPlans, String udfClassName, String[] udfArgs) throws PlanException, VisitorException, ExecException {
        TezOperator oper = this.getTezOp();
        this.tezPlan.add(oper);
        POPackage pkg = this.getPackage(1, (byte)50);
        oper.plan.add(pkg);
        PhysicalPlan fe2Plan = new PhysicalPlan();
        POProject topPrj = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        topPrj.setColumn(1);
        topPrj.setResultType((byte)120);
        topPrj.setOverloaded(true);
        fe2Plan.add(topPrj);
        ArrayList<PhysicalPlan> nesSortPlanLst = new ArrayList<PhysicalPlan>();
        if (sortKeyPlans != null) {
            for (int i = 0; i < sortKeyPlans.size(); ++i) {
                nesSortPlanLst.add(sortKeyPlans.get(i));
            }
        } else {
            POProject prj;
            Pair<POProject, Byte>[] sortProjs = null;
            try {
                sortProjs = TezCompiler.getSortCols(sort.getSortPlans());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (sortProjs == null) {
                PhysicalPlan ep = new PhysicalPlan();
                prj = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
                prj.setStar(true);
                prj.setOverloaded(false);
                prj.setResultType((byte)110);
                ep.add(prj);
                nesSortPlanLst.add(ep);
            } else {
                for (int i = 0; i < sortProjs.length; ++i) {
                    prj = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
                    prj.setResultType((Byte)sortProjs[i].second);
                    if (sortProjs[i].first != null && ((POProject)sortProjs[i].first).isProjectToEnd()) {
                        if (i != sortProjs.length - 1) {
                            throw new AssertionError((Object)"Project-range to end (x..) is supported in order-by only as last sort column");
                        }
                        prj.setProjectToEnd(i);
                        break;
                    }
                    prj.setColumn(i);
                    prj.setOverloaded(false);
                    PhysicalPlan ep = new PhysicalPlan();
                    ep.add(prj);
                    nesSortPlanLst.add(ep);
                }
            }
        }
        sort.setSortPlans(nesSortPlanLst);
        sort.setResultType((byte)120);
        fe2Plan.add(sort);
        fe2Plan.connect(topPrj, sort);
        PhysicalPlan rpep = new PhysicalPlan();
        ConstantExpression rpce = new ConstantExpression(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        rpce.setRequestedParallelism(rp);
        rpce.setValue(rp);
        rpce.setResultType((byte)10);
        rpep.add(rpce);
        ArrayList<PhysicalPlan> genEps = new ArrayList<PhysicalPlan>();
        genEps.add(rpep);
        genEps.add(fe2Plan);
        ArrayList<Boolean> flattened2 = new ArrayList<Boolean>();
        flattened2.add(false);
        flattened2.add(false);
        POForEach nfe2 = new POForEach(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, genEps, flattened2);
        oper.plan.add(nfe2);
        oper.plan.connect(pkg, nfe2);
        PhysicalPlan ep4 = new PhysicalPlan();
        POProject prjStar4 = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        prjStar4.setResultType((byte)110);
        prjStar4.setStar(true);
        ep4.add(prjStar4);
        ArrayList<PhysicalOperator> ufInps = new ArrayList<PhysicalOperator>();
        ufInps.add(prjStar4);
        POUserFunc uf = new POUserFunc(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, ufInps, new FuncSpec(udfClassName, udfArgs));
        ep4.add(uf);
        ep4.connect(prjStar4, uf);
        ArrayList<PhysicalPlan> ep4s = new ArrayList<PhysicalPlan>();
        ep4s.add(ep4);
        ArrayList<Boolean> flattened3 = new ArrayList<Boolean>();
        flattened3.add(false);
        POForEach nfe3 = new POForEach(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, ep4s, flattened3);
        oper.plan.add(nfe3);
        oper.plan.connect(nfe2, nfe3);
        POValueOutputTez sampleOut = new POValueOutputTez(OperatorKey.genOpKey(this.scope));
        oper.plan.add(sampleOut);
        oper.plan.connect(nfe3, sampleOut);
        oper.setClosed(true);
        oper.setRequestedParallelism(1);
        oper.setDontEstimateParallelism(true);
        oper.markSampleAggregation();
        return new Pair<TezOperator, Integer>(oper, rp);
    }

    public static Pair<POProject, Byte>[] getSortCols(List<PhysicalPlan> plans) throws PlanException {
        if (plans != null) {
            Pair[] ret = new Pair[plans.size()];
            int i = -1;
            for (PhysicalPlan plan : plans) {
                POProject proj;
                PhysicalOperator op = (PhysicalOperator)plan.getLeaves().get(0);
                if (op instanceof POProject) {
                    if (((POProject)op).isStar()) {
                        return null;
                    }
                    proj = (POProject)op;
                } else {
                    proj = null;
                }
                byte type = op.getResultType();
                ret[++i] = new Pair<POProject, Byte>(proj, type);
            }
            return ret;
        }
        int errCode = 2026;
        String msg = "No expression plan found in POSort.";
        throw new PlanException(msg, errCode, 4);
    }

    private TezOperator[] getSortJobs(TezOperator inputOper, POLocalRearrangeTez inputOperRearrange, POSort sort, byte keyType, Pair<POProject, Byte>[] fields) throws PlanException {
        TezOperator[] opers = new TezOperator[2];
        TezOperator oper1 = this.getTezOp();
        this.tezPlan.add(oper1);
        opers[0] = oper1;
        POIdentityInOutTez identityInOutTez = new POIdentityInOutTez(OperatorKey.genOpKey(this.scope), inputOperRearrange);
        identityInOutTez.setInputKey(inputOper.getOperatorKey().toString());
        oper1.plan.addAsLeaf(identityInOutTez);
        oper1.setClosed(true);
        oper1.markSampleBasedPartitioner();
        TezOperator oper2 = this.getTezOp();
        oper2.markGlobalSort();
        opers[1] = oper2;
        this.tezPlan.add(oper2);
        long limit = sort.getLimit();
        List<Boolean> sortOrderList = sort.getMAscCols();
        if (sortOrderList != null) {
            boolean[] sortOrder = new boolean[sortOrderList.size()];
            for (int i = 0; i < sortOrderList.size(); ++i) {
                sortOrder[i] = sortOrderList.get(i);
            }
            oper2.setSortOrder(sortOrder);
        }
        identityInOutTez.setOutputKey(oper2.getOperatorKey().toString());
        if (limit != -1L) {
            POPackage pkg_c = new POPackage(OperatorKey.genOpKey(this.scope));
            pkg_c.setPkgr(new LitePackager());
            pkg_c.getPkgr().setKeyType(fields == null || fields.length > 1 ? (byte)110 : keyType);
            pkg_c.setNumInps(1);
            oper2.inEdges.put(oper1.getOperatorKey(), new TezEdgeDescriptor());
            PhysicalPlan combinePlan = oper2.inEdges.get((Object)oper1.getOperatorKey()).combinePlan;
            combinePlan.add(pkg_c);
            ArrayList<PhysicalPlan> eps_c1 = new ArrayList<PhysicalPlan>();
            ArrayList<Boolean> flat_c1 = new ArrayList<Boolean>();
            PhysicalPlan ep_c1 = new PhysicalPlan();
            POProject prj_c1 = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            prj_c1.setColumn(1);
            prj_c1.setOverloaded(false);
            prj_c1.setResultType((byte)120);
            ep_c1.add(prj_c1);
            eps_c1.add(ep_c1);
            flat_c1.add(true);
            POForEach fe_c1 = new POForEach(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, eps_c1, flat_c1);
            fe_c1.setResultType((byte)110);
            combinePlan.addAsLeaf(fe_c1);
            POLimit pLimit = new POLimit(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            pLimit.setLimit(limit);
            combinePlan.addAsLeaf(pLimit);
            ArrayList<PhysicalPlan> eps_c2 = new ArrayList<PhysicalPlan>();
            eps_c2.addAll(sort.getSortPlans());
            POLocalRearrangeTez lr_c2 = new POLocalRearrangeTez(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            lr_c2.setOutputKey(oper2.getOperatorKey().toString());
            try {
                lr_c2.setIndex(0);
            }
            catch (ExecException e) {
                int errCode = 2058;
                String msg = "Unable to set index on newly created POLocalRearrange.";
                throw new PlanException(msg, errCode, 4, (Throwable)e);
            }
            lr_c2.setKeyType(fields.length > 1 ? (byte)110 : (byte)keyType);
            lr_c2.setPlans(eps_c2);
            lr_c2.setResultType((byte)110);
            combinePlan.addAsLeaf(lr_c2);
        }
        POPackage pkg = new POPackage(OperatorKey.genOpKey(this.scope));
        pkg.setPkgr(new LitePackager());
        pkg.getPkgr().setKeyType(fields == null || fields.length > 1 ? (byte)110 : keyType);
        pkg.setNumInps(1);
        oper2.plan.add(pkg);
        PhysicalPlan ep = new PhysicalPlan();
        POProject prj = new POProject(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
        prj.setColumn(1);
        prj.setOverloaded(false);
        prj.setResultType((byte)120);
        ep.add(prj);
        ArrayList<PhysicalPlan> eps2 = new ArrayList<PhysicalPlan>();
        eps2.add(ep);
        ArrayList<Boolean> flattened = new ArrayList<Boolean>();
        flattened.add(true);
        POForEach nfe1 = new POForEach(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)), -1, eps2, flattened);
        oper2.plan.add(nfe1);
        oper2.plan.connect(pkg, nfe1);
        if (limit != -1L) {
            POLimit pLimit2 = new POLimit(new OperatorKey(this.scope, this.nig.getNextNodeId(this.scope)));
            pLimit2.setLimit(limit);
            oper2.plan.addAsLeaf(pLimit2);
        }
        return opers;
    }

    @Override
    public void visitSort(POSort op) throws VisitorException {
        try {
            Pair<POProject, Byte>[] fields = TezCompiler.getSortCols(op.getSortPlans());
            byte keyType = 0;
            try {
                FindKeyTypeVisitor fktv = new FindKeyTypeVisitor(op.getSortPlans().get(0));
                fktv.visit();
                keyType = fktv.keyType;
            }
            catch (VisitorException ve) {
                int errCode = 2035;
                String msg = "Internal error. Could not compute key type of sort operator.";
                throw new PlanException(msg, errCode, 4, (Throwable)ve);
            }
            POLocalRearrangeTez lr = new POLocalRearrangeTez(OperatorKey.genOpKey(this.scope));
            POLocalRearrangeTez lrSample = this.localRearrangeFactory.create(POLocalRearrangeTezFactory.LocalRearrangeType.NULL);
            TezOperator prevOper = this.endSingleInputWithStoreAndSample(op, lr, lrSample, keyType, fields);
            prevOper.markSampler();
            int rp = op.getRequestedParallelism();
            if (rp == -1) {
                rp = this.pigContext.defaultParallel;
            }
            Pair<TezOperator, Integer> quantJobParallelismPair = this.getOrderbySamplingAggregationJob(op, rp);
            TezOperator[] sortOpers = this.getSortJobs(prevOper, lr, op, keyType, fields);
            TezEdgeDescriptor edge = TezCompilerUtil.connect(this.tezPlan, prevOper, sortOpers[0]);
            sortOpers[0].setUseMRMapSettings(prevOper.isUseMRMapSettings());
            edge.dataMovementType = EdgeProperty.DataMovementType.ONE_TO_ONE;
            edge.outputClassName = UnorderedKVOutput.class.getName();
            edge.inputClassName = UnorderedKVInput.class.getName();
            sortOpers[0].setRequestedParallelismByReference(prevOper);
            if (rp == -1) {
                ((TezOperator)quantJobParallelismPair.first).setNeedEstimatedQuantile(true);
            }
            sortOpers[1].setRequestedParallelism((Integer)quantJobParallelismPair.second);
            TezCompilerUtil.connect(this.tezPlan, prevOper, (TezOperator)quantJobParallelismPair.first);
            lr.setOutputKey(sortOpers[0].getOperatorKey().toString());
            lrSample.setOutputKey(((TezOperator)quantJobParallelismPair.first).getOperatorKey().toString());
            edge = TezCompilerUtil.connect(this.tezPlan, (TezOperator)quantJobParallelismPair.first, sortOpers[0]);
            TezCompilerUtil.configureValueOnlyTupleOutput(edge, EdgeProperty.DataMovementType.BROADCAST);
            POValueOutputTez sampleOut = (POValueOutputTez)((TezOperator)quantJobParallelismPair.first).plan.getLeaves().get(0);
            sampleOut.addOutputKey(sortOpers[0].getOperatorKey().toString());
            sortOpers[0].setSampleOperator((TezOperator)quantJobParallelismPair.first);
            edge = TezCompilerUtil.connect(this.tezPlan, sortOpers[0], sortOpers[1]);
            edge.partitionerClass = WeightedRangePartitionerTez.class;
            this.curTezOp = sortOpers[1];
            ((TezOperator)quantJobParallelismPair.first).setSortOperator(sortOpers[1]);
            if (op.isLimited() && rp != 1) {
                POValueOutputTez output = new POValueOutputTez(OperatorKey.genOpKey(this.scope));
                output.copyAliasFrom(op);
                sortOpers[1].plan.addAsLeaf(output);
                TezOperator limitOper = this.getTezOp();
                this.tezPlan.add(limitOper);
                this.curTezOp = limitOper;
                limitOper.setRequestedParallelism(1);
                limitOper.setDontEstimateParallelism(true);
                limitOper.markLimitAfterSort();
                edge = TezCompilerUtil.connect(this.tezPlan, sortOpers[1], limitOper);
                output.addOutputKey(limitOper.getOperatorKey().toString());
                output.setTaskIndexWithRecordIndexAsKey(true);
                edge = this.curTezOp.inEdges.get(sortOpers[1].getOperatorKey());
                TezCompilerUtil.configureValueOnlyTupleOutput(edge, EdgeProperty.DataMovementType.SCATTER_GATHER);
                edge.outputClassName = UnorderedKVOutput.class.getName();
                edge.inputClassName = OrderedGroupedKVInput.class.getName();
                edge.setIntermediateOutputKeyClass(TezCompilerUtil.TUPLE_CLASS);
                edge.setIntermediateOutputKeyComparatorClass(JobControlCompiler.PigTupleWritableComparator.class.getName());
                POValueInputTez input = new POValueInputTez(OperatorKey.genOpKey(this.scope));
                input.copyAliasFrom(op);
                input.setInputKey(sortOpers[1].getOperatorKey().toString());
                this.curTezOp.plan.addAsLeaf(input);
                POLimit limit = new POLimit(OperatorKey.genOpKey(this.scope));
                limit.setLimit(op.getLimit());
                this.curTezOp.plan.addAsLeaf(limit);
            }
            this.phyToTezOpMap.put(op, this.curTezOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitSplit(POSplit op) throws VisitorException {
        try {
            TezOperator splitOp = this.curTezOp;
            POValueOutputTez output = null;
            if (this.splitsSeen.containsKey(op.getOperatorKey())) {
                splitOp = this.splitsSeen.get(op.getOperatorKey());
                output = (POValueOutputTez)splitOp.plan.getLeaves().get(0);
            } else {
                this.splitsSeen.put(op.getOperatorKey(), splitOp);
                splitOp.setSplitter(true);
                this.phyToTezOpMap.put(op, splitOp);
                output = new POValueOutputTez(OperatorKey.genOpKey(this.scope));
                output.copyAliasFrom(op);
                splitOp.plan.addAsLeaf(output);
            }
            this.curTezOp = this.getTezOp();
            this.curTezOp.setSplitParent(splitOp.getOperatorKey());
            this.tezPlan.add(this.curTezOp);
            output.addOutputKey(this.curTezOp.getOperatorKey().toString());
            TezEdgeDescriptor edge = TezCompilerUtil.connect(this.tezPlan, splitOp, this.curTezOp);
            TezCompilerUtil.configureValueOnlyTupleOutput(edge, EdgeProperty.DataMovementType.ONE_TO_ONE);
            this.curTezOp.setRequestedParallelismByReference(splitOp);
            POValueInputTez input = new POValueInputTez(OperatorKey.genOpKey(this.scope));
            input.copyAliasFrom(op);
            input.setInputKey(splitOp.getOperatorKey().toString());
            this.curTezOp.plan.addAsLeaf(input);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitStore(POStore op) throws VisitorException {
        try {
            POStoreTez store = new POStoreTez(op);
            this.nonBlocking(store);
            this.phyToTezOpMap.put(op, this.curTezOp);
            if (store.getSFile() != null && store.getSFile().getFuncSpec() != null) {
                this.curTezOp.UDFs.add(store.getSFile().getFuncSpec().toString());
            }
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitStream(POStream op) throws VisitorException {
        try {
            this.nonBlocking(op);
            this.phyToTezOpMap.put(op, this.curTezOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    @Override
    public void visitUnion(POUnion op) throws VisitorException {
        try {
            TezOperator unionTezOp = this.getTezOp();
            this.tezPlan.add(unionTezOp);
            unionTezOp.markUnion();
            unionTezOp.setRequestedParallelism(op.getRequestedParallelism());
            POShuffledValueInputTez unionInput = new POShuffledValueInputTez(OperatorKey.genOpKey(this.scope));
            unionTezOp.plan.addAsLeaf(unionInput);
            POValueOutputTez[] outputs = new POValueOutputTez[this.compiledInputs.length];
            for (int i = 0; i < this.compiledInputs.length; ++i) {
                TezOperator prevTezOp = this.compiledInputs[i];
                unionTezOp.addUnionPredecessor(prevTezOp.getOperatorKey());
                TezEdgeDescriptor edge = TezCompilerUtil.connect(this.tezPlan, prevTezOp, unionTezOp);
                TezCompilerUtil.configureValueOnlyTupleOutput(edge, EdgeProperty.DataMovementType.SCATTER_GATHER);
                outputs[i] = new POValueOutputTez(OperatorKey.genOpKey(this.scope));
                outputs[i].addOutputKey(unionTezOp.getOperatorKey().toString());
                unionInput.addInputKey(prevTezOp.getOperatorKey().toString());
                prevTezOp.plan.addAsLeaf(outputs[i]);
                prevTezOp.setClosed(true);
                if (!prevTezOp.isUseMRMapSettings()) continue;
                unionTezOp.setUseMRMapSettings(true);
            }
            this.curTezOp = unionTezOp;
            this.phyToTezOpMap.put(op, this.curTezOp);
        }
        catch (Exception e) {
            int errCode = 2034;
            String msg = "Error compiling operator " + op.getClass().getSimpleName();
            throw new TezCompilerException(msg, errCode, 4, (Throwable)e);
        }
    }

    private POPackage getPackage(int numOfInputs, byte keyType) {
        boolean[] inner = new boolean[numOfInputs];
        POPackage pkg = new POPackage(OperatorKey.genOpKey(this.scope));
        pkg.getPkgr().setInner(inner);
        pkg.getPkgr().setKeyType(keyType);
        pkg.setNumInps(numOfInputs);
        return pkg;
    }

    private TezOperator getTezOp() {
        return new TezOperator(OperatorKey.genOpKey(this.scope));
    }

    private static class FindKeyTypeVisitor
    extends PhyPlanVisitor {
        byte keyType = 0;

        FindKeyTypeVisitor(PhysicalPlan plan) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
        }

        @Override
        public void visitProject(POProject p) throws VisitorException {
            this.keyType = p.getResultType();
        }
    }
}

