/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.LitePackager;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POLocalRearrangeTez;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.OptimizerException;
import org.apache.pig.impl.util.Pair;

public class TezPOPackageAnnotator
extends TezOpPlanVisitor {
    public TezPOPackageAnnotator(TezOperPlan plan) {
        super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DepthFirstWalker<TezOperator, TezOperPlan>(plan));
    }

    @Override
    public void visitTezOp(TezOperator tezOp) throws VisitorException {
        if (!tezOp.plan.isEmpty()) {
            PackageDiscoverer pkgDiscoverer = new PackageDiscoverer(tezOp.plan);
            pkgDiscoverer.visit();
            POPackage pkg = pkgDiscoverer.getPkg();
            if (pkg != null) {
                this.handlePackage(tezOp, pkg);
            }
        }
    }

    private void handlePackage(TezOperator pkgTezOp, POPackage pkg) throws VisitorException {
        int lrFound = 0;
        List<TezOperator> preds = ((TezOperPlan)this.mPlan).getPredecessors(pkgTezOp);
        for (TezOperator predTezOp : preds) {
            if (predTezOp.isVertexGroup()) {
                predTezOp = (TezOperator)((TezOperPlan)this.getPlan()).getOperator(predTezOp.getVertexGroupMembers().get(0));
            }
            if ((lrFound += this.patchPackage(predTezOp, pkgTezOp, pkg)) != pkg.getNumInps()) continue;
            break;
        }
        if (lrFound != pkg.getNumInps()) {
            int errCode = 2086;
            String msg = "Unexpected problem during optimization. Could not find all LocalRearrange operators.";
            throw new OptimizerException(msg, errCode, 4);
        }
    }

    private int patchPackage(TezOperator predTezOp, TezOperator pkgTezOp, POPackage pkg) throws VisitorException {
        LoRearrangeDiscoverer lrDiscoverer = new LoRearrangeDiscoverer(predTezOp.plan, pkgTezOp, pkg);
        lrDiscoverer.visit();
        return lrDiscoverer.getLoRearrangeFound();
    }

    public static class LoRearrangeDiscoverer
    extends PhyPlanVisitor {
        private int loRearrangeFound = 0;
        private TezOperator pkgTezOp;
        private POPackage pkg;

        public LoRearrangeDiscoverer(PhysicalPlan plan, TezOperator pkgTezOp, POPackage pkg) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
            this.pkgTezOp = pkgTezOp;
            this.pkg = pkg;
        }

        @Override
        public void visitLocalRearrange(POLocalRearrange lrearrange) throws VisitorException {
            POLocalRearrangeTez lr = (POLocalRearrangeTez)lrearrange;
            if (!lr.isConnectedToPackage() || !lr.getOutputKey().equals(this.pkgTezOp.getOperatorKey().toString())) {
                return;
            }
            ++this.loRearrangeFound;
            if (this.pkg.getPkgr() instanceof LitePackager && lrearrange.getIndex() != 0) {
                throw new RuntimeException("POLocalRearrange for POPackageLite cannot have index other than 0, but has index - " + lrearrange.getIndex());
            }
            Map<Integer, Pair<Boolean, Map<Integer, Integer>>> keyInfo = this.pkg.getPkgr().getKeyInfo();
            if (keyInfo == null) {
                keyInfo = new HashMap<Integer, Pair<Boolean, Map<Integer, Integer>>>();
            }
            if (keyInfo.get(lrearrange.getIndex()) != null) {
                int errCode = 2087;
                String msg = "Unexpected problem during optimization. Found index:" + lrearrange.getIndex() + " in multiple LocalRearrange operators.";
                throw new OptimizerException(msg, errCode, 4);
            }
            keyInfo.put(Integer.valueOf(lrearrange.getIndex()), new Pair<Boolean, Map<Integer, Integer>>(lrearrange.isProjectStar(), lrearrange.getProjectedColsMap()));
            this.pkg.getPkgr().setKeyInfo(keyInfo);
            this.pkg.getPkgr().setKeyTuple(lrearrange.isKeyTuple());
            this.pkg.getPkgr().setKeyCompound(lrearrange.isKeyCompound());
        }

        public int getLoRearrangeFound() {
            return this.loRearrangeFound;
        }
    }

    static class PackageDiscoverer
    extends PhyPlanVisitor {
        private POPackage pkg;

        public PackageDiscoverer(PhysicalPlan plan) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
        }

        @Override
        public void visitPackage(POPackage pkg) throws VisitorException {
            this.pkg = pkg;
        }

        public POPackage getPkg() {
            return this.pkg;
        }
    }
}

