/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan;

import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PlanPrinter;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class TezPrinter
extends TezOpPlanVisitor {
    private PrintStream mStream = null;
    private boolean isVerbose = true;

    public TezPrinter(PrintStream ps, TezOperPlan plan) {
        super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(plan));
        this.mStream = ps;
    }

    public void setVerbose(boolean verbose) {
        this.isVerbose = verbose;
    }

    @Override
    public void visitTezOp(TezOperator tezOper) throws VisitorException {
        if (tezOper.isVertexGroup()) {
            TezOperator.VertexGroupInfo info = tezOper.getVertexGroupInfo();
            this.mStream.println("Tez vertex group " + tezOper.getOperatorKey().toString() + "\t<-\t " + info.getInputs() + "\t->\t " + info.getOutput());
            this.mStream.println("# No plan on vertex group");
        } else {
            this.mStream.println("Tez vertex " + tezOper.getOperatorKey().toString());
        }
        if (tezOper.inEdges.size() > 0) {
            for (Map.Entry<OperatorKey, TezEdgeDescriptor> inEdge : tezOper.inEdges.entrySet()) {
                if (inEdge.getValue().combinePlan.isEmpty()) continue;
                this.mStream.println("# Combine plan on edge <" + inEdge.getKey() + ">");
                PlanPrinter printer = new PlanPrinter(inEdge.getValue().combinePlan, this.mStream);
                printer.setVerbose(this.isVerbose);
                printer.visit();
                this.mStream.println();
            }
        }
        if (tezOper.plan != null && tezOper.plan.size() > 0) {
            this.mStream.println("# Plan on vertex");
            PlanPrinter printer = new PlanPrinter(tezOper.plan, this.mStream);
            printer.setVerbose(this.isVerbose);
            printer.visit();
            this.mStream.println();
        }
    }

    public static class TezGraphPrinter
    extends TezOpPlanVisitor {
        StringBuffer buf = new StringBuffer();

        public TezGraphPrinter(TezOperPlan plan) {
            super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(plan));
        }

        @Override
        public void visitTezOp(TezOperator tezOper) throws VisitorException {
            if (tezOper.isVertexGroup()) {
                this.buf.append("Tez vertex group " + tezOper.getOperatorKey().toString());
            } else {
                this.buf.append("Tez vertex " + tezOper.getOperatorKey().toString());
            }
            List<TezOperator> succs = ((TezOperPlan)this.mPlan).getSuccessors(tezOper);
            if (succs != null) {
                this.buf.append("\t->\t");
                for (TezOperator op : succs) {
                    if (op.isVertexGroup()) {
                        this.buf.append("Tez vertex group " + op.getOperatorKey().toString()).append(",");
                        continue;
                    }
                    this.buf.append("Tez vertex " + op.getOperatorKey().toString()).append(",");
                }
            }
            this.buf.append("\n");
        }

        public String toString() {
            this.buf.append("\n");
            return this.buf.toString();
        }
    }
}

