/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparator;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.AccumulativeTupleBuffer;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.backend.hadoop.executionengine.util.AccumulatorOptimizerUtil;
import org.apache.pig.data.AccumulativeBag;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.InternalCachedBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.NullableTuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.library.api.KeyValuesReader;
import org.apache.tez.runtime.library.common.ConfigUtils;

public class POShuffleTezLoad
extends POPackage
implements TezInput {
    private static final long serialVersionUID = 1L;
    protected List<String> inputKeys = new ArrayList<String>();
    protected List<LogicalInput> inputs = new ArrayList<LogicalInput>();
    protected List<KeyValuesReader> readers = new ArrayList<KeyValuesReader>();
    private boolean[] finished;
    private boolean[] readOnce;
    private WritableComparator comparator = null;
    private boolean isSkewedJoin = false;
    private transient Configuration conf;
    private transient int accumulativeBatchSize;

    public POShuffleTezLoad(POPackage pack) {
        super(pack);
    }

    @Override
    public String[] getTezInputs() {
        return this.inputKeys.toArray(new String[this.inputKeys.size()]);
    }

    @Override
    public void replaceInput(String oldInputKey, String newInputKey) {
        if (this.inputKeys.remove(oldInputKey)) {
            this.inputKeys.add(newInputKey);
        }
    }

    @Override
    public void addInputsToSkip(Set<String> inputsToSkip) {
    }

    @Override
    public void attachInputs(Map<String, LogicalInput> inputs, Configuration conf) throws ExecException {
        this.conf = conf;
        this.comparator = (WritableComparator)ConfigUtils.getInputKeySecondaryGroupingComparator((Configuration)conf);
        try {
            int i;
            for (String key : this.inputKeys) {
                LogicalInput input = inputs.get(key);
                this.inputs.add(input);
                this.readers.add((KeyValuesReader)input.getReader());
            }
            this.numInputs = this.inputs.size();
            this.readOnce = new boolean[this.numInputs];
            for (i = 0; i < this.numInputs; ++i) {
                this.readOnce[i] = false;
            }
            this.finished = new boolean[this.numInputs];
            for (i = 0; i < this.numInputs; ++i) {
                this.finished[i] = !this.readers.get(i).next();
            }
        }
        catch (Exception e) {
            throw new ExecException(e);
        }
        this.accumulativeBatchSize = AccumulatorOptimizerUtil.getAccumulativeBatchSize();
    }

    @Override
    public Result getNextTuple() throws ExecException {
        Result res = this.pkgr.getNext();
        TezAccumulativeTupleBuffer buffer = null;
        if (this.isAccumulative()) {
            buffer = new TezAccumulativeTupleBuffer(this.accumulativeBatchSize);
        }
        while (res.returnStatus == 3) {
            boolean hasData = false;
            Object cur = null;
            PigNullableWritable min = null;
            int minIndex = -1;
            try {
                for (int i = 0; i < this.numInputs; ++i) {
                    if (this.finished[i]) continue;
                    hasData = true;
                    cur = this.readers.get(i).getCurrentKey();
                    if (min != null && this.comparator.compare((Object)min, cur) <= 0) continue;
                    min = ((PigNullableWritable)cur).clone();
                    minIndex = i;
                }
            }
            catch (Exception e) {
                throw new ExecException(e);
            }
            if (!hasData) {
                if (Boolean.valueOf(this.conf.get("pig.invoke.close.in.map", "false")).booleanValue()) {
                    this.parentPlan.endOfAllInput = true;
                }
                return new Result(3, null);
            }
            this.key = this.pkgr.getKey(min);
            this.keyWritable = min;
            try {
                int i;
                DataBag[] bags = new DataBag[this.numInputs];
                if (this.isAccumulative()) {
                    buffer.setCurrentKey(min);
                    buffer.setCurrentKeyIndex(minIndex);
                    for (i = 0; i < this.numInputs; ++i) {
                        bags[i] = new AccumulativeBag(buffer, i);
                    }
                } else {
                    for (i = 0; i < this.numInputs; ++i) {
                        DataBag bag = null;
                        if (!this.finished[i]) {
                            cur = this.readers.get(i).getCurrentKey();
                            while (this.comparator.compare((Object)min, cur) == 0 && (!min.isNull() || min.isNull() && i == minIndex)) {
                                Iterable vals = this.readers.get(i).getCurrentValues();
                                bag = bags[i] == null ? new InternalCachedBag(this.numInputs) : bags[i];
                                for (Object val : vals) {
                                    NullableTuple nTup = (NullableTuple)val;
                                    byte index = nTup.getIndex();
                                    Tuple tup = this.pkgr.getValueTuple(this.keyWritable, nTup, index);
                                    bag.add(tup);
                                }
                                bags[i] = bag;
                                boolean bl = this.finished[i] = !this.readers.get(i).next();
                                if (this.finished[i]) break;
                                cur = this.readers.get(i).getCurrentKey();
                            }
                        }
                        if (bag != null) continue;
                        bags[i] = new InternalCachedBag(this.numInputs);
                    }
                }
                this.pkgr.attachInput(this.key, bags, this.readOnce);
                res = this.pkgr.getNext();
            }
            catch (IOException e) {
                throw new ExecException(e);
            }
        }
        return res;
    }

    public void setInputKeys(List<String> inputKeys) {
        this.inputKeys = inputKeys;
    }

    public void addInputKey(String inputKey) {
        this.inputKeys.add(inputKey);
    }

    public void setSkewedJoins(boolean isSkewedJoin) {
        this.isSkewedJoin = isSkewedJoin;
    }

    public boolean isSkewedJoin() {
        return this.isSkewedJoin;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return true;
    }

    private class TezAccumulativeTupleBuffer
    implements AccumulativeTupleBuffer {
        private int batchSize;
        private List<Tuple>[] bags;
        private PigNullableWritable min;
        private int minIndex;
        private boolean clearedCurrent = true;

        public TezAccumulativeTupleBuffer(int batchSize) {
            this.batchSize = batchSize;
            this.bags = new List[POShuffleTezLoad.this.numInputs];
            for (int i = 0; i < POShuffleTezLoad.this.numInputs; ++i) {
                this.bags[i] = new ArrayList<Tuple>(batchSize);
            }
        }

        public void setCurrentKey(PigNullableWritable curKey) {
            if (!this.clearedCurrent) {
                this.clear();
            }
            this.min = curKey;
            this.clearedCurrent = false;
        }

        public void setCurrentKeyIndex(int curKeyIndex) {
            this.minIndex = curKeyIndex;
        }

        @Override
        public boolean hasNextBatch() {
            Object cur = null;
            try {
                for (int i = 0; i < POShuffleTezLoad.this.numInputs; ++i) {
                    if (POShuffleTezLoad.this.finished[i]) continue;
                    cur = POShuffleTezLoad.this.readers.get(i).getCurrentKey();
                    if (POShuffleTezLoad.this.comparator.compare((Object)this.min, cur) != 0 || this.min.isNull() && (!this.min.isNull() || i != this.minIndex)) continue;
                    return true;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error while checking for next Accumulator batch", e);
            }
            return false;
        }

        @Override
        public void nextBatch() throws IOException {
            int i;
            Object cur = null;
            for (i = 0; i < this.bags.length; ++i) {
                this.bags[i].clear();
            }
            try {
                block3: for (i = 0; i < POShuffleTezLoad.this.numInputs; ++i) {
                    if (POShuffleTezLoad.this.finished[i]) continue;
                    cur = POShuffleTezLoad.this.readers.get(i).getCurrentKey();
                    int batchCount = 0;
                    while (POShuffleTezLoad.this.comparator.compare((Object)this.min, cur) == 0 && (!this.min.isNull() || this.min.isNull() && i == this.minIndex)) {
                        Iterator iter = POShuffleTezLoad.this.readers.get(i).getCurrentValues().iterator();
                        while (iter.hasNext() && batchCount < this.batchSize) {
                            this.bags[i].add(POShuffleTezLoad.this.pkgr.getValueTuple(POShuffleTezLoad.this.keyWritable, (NullableTuple)iter.next(), i));
                            ++batchCount;
                        }
                        if (batchCount == this.batchSize) {
                            if (iter.hasNext()) continue block3;
                            ((POShuffleTezLoad)POShuffleTezLoad.this).finished[i] = !POShuffleTezLoad.this.readers.get(i).next();
                            continue block3;
                        }
                        boolean bl = ((POShuffleTezLoad)POShuffleTezLoad.this).finished[i] = !POShuffleTezLoad.this.readers.get(i).next();
                        if (POShuffleTezLoad.this.finished[i]) continue block3;
                        cur = POShuffleTezLoad.this.readers.get(i).getCurrentKey();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error while reading next Accumulator batch", e);
            }
        }

        @Override
        public void clear() {
            for (int i = 0; i < this.bags.length; ++i) {
                this.bags[i].clear();
            }
            Object cur = null;
            try {
                block3: for (int i = 0; i < POShuffleTezLoad.this.numInputs; ++i) {
                    if (POShuffleTezLoad.this.finished[i]) continue;
                    cur = POShuffleTezLoad.this.readers.get(i).getCurrentKey();
                    while (POShuffleTezLoad.this.comparator.compare((Object)this.min, cur) == 0 && (!this.min.isNull() || this.min.isNull() && i == this.minIndex)) {
                        boolean bl = ((POShuffleTezLoad)POShuffleTezLoad.this).finished[i] = !POShuffleTezLoad.this.readers.get(i).next();
                        if (POShuffleTezLoad.this.finished[i]) continue block3;
                        cur = POShuffleTezLoad.this.readers.get(i).getCurrentKey();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error while cleaning up for next Accumulator batch", e);
            }
            this.clearedCurrent = true;
        }

        @Override
        public Iterator<Tuple> getTuples(int index) {
            return this.bags[index].iterator();
        }
    }
}

