/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.operator;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezOutput;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezTaskConfigurable;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.tools.pigstats.mapreduce.MRPigStatsUtil;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.mapreduce.output.MROutput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValueWriter;

public class POStoreTez
extends POStore
implements TezOutput,
TezTaskConfigurable {
    private static final long serialVersionUID = 1L;
    private transient MROutput output;
    private transient KeyValueWriter writer;
    private String outputKey;
    private TezCounter outputRecordCounter;

    public POStoreTez(OperatorKey k) {
        super(k);
        this.outputKey = k.toString();
    }

    public POStoreTez(POStore copy) {
        super(copy);
        this.outputKey = copy.getOperatorKey().toString();
        this.setCacheFiles(copy.getCacheFiles());
        this.setShipFiles(copy.getShipFiles());
    }

    public String getOutputKey() {
        return this.outputKey;
    }

    public void setOutputKey(String outputKey) {
        this.outputKey = outputKey;
    }

    @Override
    public String[] getTezOutputs() {
        return new String[]{this.outputKey};
    }

    @Override
    public void initialize(ProcessorContext processorContext) throws ExecException {
        if (this.isMultiStore()) {
            String name;
            CounterGroup multiStoreGroup = (CounterGroup)processorContext.getCounters().getGroup("MultiStoreCounters");
            if (multiStoreGroup == null) {
                processorContext.getCounters().addGroup("MultiStoreCounters", "MultiStoreCounters");
            }
            if ((name = MRPigStatsUtil.getMultiStoreCounterName(this)) != null) {
                this.outputRecordCounter = multiStoreGroup.addCounter(name, name, 0L);
            }
        }
    }

    @Override
    public void replaceOutput(String oldOutputKey, String newOutputKey) {
    }

    @Override
    public void attachOutputs(Map<String, LogicalOutput> outputs, Configuration conf) throws ExecException {
        LogicalOutput logicalOut = outputs.get(this.outputKey);
        if (logicalOut == null || !(logicalOut instanceof MROutput)) {
            throw new ExecException("POStoreTez only accepts MROutput. key =  " + this.getOperatorKey() + ", outputs = " + outputs);
        }
        this.output = (MROutput)logicalOut;
        try {
            this.writer = this.output.getWriter();
        }
        catch (IOException e) {
            throw new ExecException(e);
        }
    }

    @Override
    public Result getNextTuple() throws ExecException {
        Result res = this.processInput();
        try {
            switch (res.returnStatus) {
                case 0: {
                    if (this.illustrator == null) {
                        this.writer.write(null, res.result);
                    } else {
                        this.illustratorMarkup(res.result, res.result, 0);
                    }
                    res = empty;
                    if (this.outputRecordCounter == null) break;
                    this.outputRecordCounter.increment(1L);
                    break;
                }
            }
        }
        catch (IOException ioe) {
            int errCode = 2135;
            String msg = "Received error from store function." + ioe.getMessage();
            throw new ExecException(msg, errCode, ioe);
        }
        return res;
    }
}

