/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POValueOutputTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.udf.ReadScalarsTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.backend.hadoop.executionengine.tez.util.TezCompilerUtil;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.ReverseDependencyOrderWalker;
import org.apache.pig.impl.plan.VisitorException;

public class MultiQueryOptimizerTez
extends TezOpPlanVisitor {
    public MultiQueryOptimizerTez(TezOperPlan plan) {
        super(plan, (PlanWalker<TezOperator, TezOperPlan>)new ReverseDependencyOrderWalker<TezOperator, TezOperPlan>(plan));
    }

    @Override
    public void visitTezOp(TezOperator tezOp) throws VisitorException {
        try {
            if (!tezOp.isSplitter()) {
                return;
            }
            ArrayList<TezOperator> splittees = new ArrayList<TezOperator>();
            List<TezOperator> successors = ((TezOperPlan)this.getPlan()).getSuccessors(tezOp);
            ArrayList<TezOperator> succ_successors = new ArrayList<TezOperator>();
            for (TezOperator successor : successors) {
                if (((TezOperPlan)this.getPlan()).getPredecessors(successor).size() != 1) continue;
                boolean sharedSucc = false;
                if (((TezOperPlan)this.getPlan()).getSuccessors(successor) != null) {
                    for (TezOperator succ_successor : ((TezOperPlan)this.getPlan()).getSuccessors(successor)) {
                        if (!succ_successors.contains(succ_successor)) continue;
                        sharedSucc = true;
                        break;
                    }
                    succ_successors.addAll(((TezOperPlan)this.getPlan()).getSuccessors(successor));
                }
                if (sharedSucc) continue;
                splittees.add(successor);
            }
            if (splittees.size() == 0) {
                return;
            }
            if (splittees.size() == 1 && successors.size() == 1) {
                PhysicalOperator firstNodeLeaf = (PhysicalOperator)tezOp.plan.getLeaves().get(0);
                PhysicalOperator firstNodeLeafPred = tezOp.plan.getPredecessors(firstNodeLeaf).get(0);
                TezOperator singleSplitee = (TezOperator)splittees.get(0);
                PhysicalOperator secondNodeRoot = (PhysicalOperator)singleSplitee.plan.getRoots().get(0);
                PhysicalOperator secondNodeSucc = singleSplitee.plan.getSuccessors(secondNodeRoot).get(0);
                tezOp.plan.remove(firstNodeLeaf);
                singleSplitee.plan.remove(secondNodeRoot);
                tezOp.plan.merge(singleSplitee.plan);
                tezOp.plan.connect(firstNodeLeafPred, secondNodeSucc);
                MultiQueryOptimizerTez.addSubPlanPropertiesToParent(tezOp, singleSplitee);
                MultiQueryOptimizerTez.removeSplittee((TezOperPlan)this.getPlan(), tezOp, singleSplitee);
            } else {
                POValueOutputTez valueOutput = (POValueOutputTez)tezOp.plan.getLeaves().get(0);
                POSplit split = new POSplit(OperatorKey.genOpKey(valueOutput.getOperatorKey().getScope()));
                split.copyAliasFrom(valueOutput);
                for (TezOperator splitee : splittees) {
                    PhysicalOperator spliteeRoot = (PhysicalOperator)splitee.plan.getRoots().get(0);
                    splitee.plan.remove(spliteeRoot);
                    split.addPlan(splitee.plan);
                    MultiQueryOptimizerTez.addSubPlanPropertiesToParent(tezOp, splitee);
                    MultiQueryOptimizerTez.removeSplittee((TezOperPlan)this.getPlan(), tezOp, splitee);
                    valueOutput.removeOutputKey(splitee.getOperatorKey().toString());
                }
                if (valueOutput.getTezOutputs().length > 0) {
                    PhysicalPlan phyPlan = new PhysicalPlan();
                    phyPlan.addAsLeaf(valueOutput);
                    split.addPlan(phyPlan);
                }
                PhysicalOperator pred = tezOp.plan.getPredecessors(valueOutput).get(0);
                tezOp.plan.disconnect(pred, valueOutput);
                tezOp.plan.remove(valueOutput);
                tezOp.plan.add(split);
                tezOp.plan.connect(pred, split);
            }
        }
        catch (PlanException e) {
            throw new VisitorException(e);
        }
    }

    public static void removeSplittee(TezOperPlan plan, TezOperator splitter, TezOperator splittee) throws PlanException {
        if (plan.getSuccessors(splittee) != null) {
            ArrayList<TezOperator> succs = new ArrayList<TezOperator>();
            succs.addAll(plan.getSuccessors(splittee));
            plan.disconnect(splitter, splittee);
            for (TezOperator succTezOperator : succs) {
                int index;
                TezEdgeDescriptor edge = succTezOperator.inEdges.get(splittee.getOperatorKey());
                splitter.outEdges.remove(splittee.getOperatorKey());
                succTezOperator.inEdges.remove(splittee.getOperatorKey());
                plan.disconnect(splittee, succTezOperator);
                TezCompilerUtil.connect(plan, splitter, succTezOperator, edge);
                try {
                    LinkedList<TezInput> inputs = PlanHelper.getPhysicalOperators(succTezOperator.plan, TezInput.class);
                    for (TezInput input : inputs) {
                        input.replaceInput(splittee.getOperatorKey().toString(), splitter.getOperatorKey().toString());
                    }
                    LinkedList<POUserFunc> userFuncs = PlanHelper.getPhysicalOperators(succTezOperator.plan, POUserFunc.class);
                    for (POUserFunc userFunc : userFuncs) {
                        if (!(userFunc.getFunc() instanceof ReadScalarsTez)) continue;
                        TezInput tezInput = (TezInput)((Object)userFunc.getFunc());
                        tezInput.replaceInput(splittee.getOperatorKey().toString(), splitter.getOperatorKey().toString());
                        userFunc.getFuncSpec().setCtorArgs(tezInput.getTezInputs());
                    }
                }
                catch (VisitorException e) {
                    throw new PlanException(e);
                }
                if (!succTezOperator.isUnion() || (index = succTezOperator.getUnionPredecessors().indexOf(splittee.getOperatorKey())) <= -1) continue;
                succTezOperator.getUnionPredecessors().set(index, splitter.getOperatorKey());
            }
        }
        plan.remove(splittee);
    }

    public static void addSubPlanPropertiesToParent(TezOperator parentOper, TezOperator subPlanOper) {
        if (subPlanOper.getCrossKeys() != null) {
            for (String string : subPlanOper.getCrossKeys()) {
                parentOper.addCrossKey(string);
            }
        }
        parentOper.copyFeatures(subPlanOper, null);
        if (subPlanOper.getRequestedParallelism() > parentOper.getRequestedParallelism()) {
            parentOper.setRequestedParallelism(subPlanOper.getRequestedParallelism());
        }
        subPlanOper.setRequestedParallelismByReference(parentOper);
        parentOper.UDFs.addAll(subPlanOper.UDFs);
        parentOper.scalars.addAll(subPlanOper.scalars);
        if (subPlanOper.outEdges != null) {
            for (Map.Entry entry : subPlanOper.outEdges.entrySet()) {
                parentOper.outEdges.put((OperatorKey)entry.getKey(), (TezEdgeDescriptor)entry.getValue());
            }
        }
    }
}

