/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer;

import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.NativeTezOper;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer.TezOperDependencyParallelismEstimator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer.TezParallelismEstimator;
import org.apache.pig.backend.hadoop.executionengine.tez.util.TezCompilerUtil;
import org.apache.pig.backend.hadoop.executionengine.util.ParallelConstantVisitor;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.tez.dag.api.EdgeProperty;

public class ParallelismSetter
extends TezOpPlanVisitor {
    private static final Log LOG = LogFactory.getLog(ParallelismSetter.class);
    private Configuration conf;
    private PigContext pc;
    private TezParallelismEstimator estimator;
    private boolean autoParallelismEnabled;
    private int estimatedTotalParallelism = 0;

    public ParallelismSetter(TezOperPlan plan, PigContext pigContext) {
        super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(plan));
        this.pc = pigContext;
        this.conf = ConfigurationUtil.toConfiguration(this.pc.getProperties());
        this.autoParallelismEnabled = this.conf.getBoolean("pig.tez.auto.parallelism", true);
        try {
            this.estimator = this.conf.get("pig.exec.reducer.estimator") == null ? new TezOperDependencyParallelismEstimator() : PigContext.instantiateObjectFromParams(this.conf, "pig.exec.reducer.estimator", "pig.exec.reducer.estimator.arg", TezParallelismEstimator.class);
            this.estimator.setPigContext(this.pc);
        }
        catch (ExecException e) {
            throw new RuntimeException("Error instantiating TezParallelismEstimator", e);
        }
    }

    public int getEstimatedTotalParallelism() {
        return this.estimatedTotalParallelism;
    }

    @Override
    public void visitTezOp(TezOperator tezOp) throws VisitorException {
        if (tezOp instanceof NativeTezOper) {
            return;
        }
        try {
            int parallelism = -1;
            boolean intermediateReducer = false;
            LinkedList<POStore> stores = PlanHelper.getPhysicalOperators(tezOp.plan, POStore.class);
            if (stores.size() <= 0) {
                intermediateReducer = true;
            }
            if (tezOp.getLoaderInfo().getLoads() != null && tezOp.getLoaderInfo().getLoads().size() > 0) {
                parallelism = tezOp.getLoaderInfo().getInputSplitInfo().getNumTasks();
                tezOp.setRequestedParallelism(parallelism);
            } else {
                int prevParallelism = -1;
                boolean isOneToOneParallelism = false;
                intermediateReducer = TezCompilerUtil.isIntermediateReducer(tezOp);
                for (Map.Entry<OperatorKey, TezEdgeDescriptor> entry : tezOp.inEdges.entrySet()) {
                    if (entry.getValue().dataMovementType != EdgeProperty.DataMovementType.ONE_TO_ONE) continue;
                    TezOperator pred = (TezOperator)((TezOperPlan)this.mPlan).getOperator(entry.getKey());
                    parallelism = pred.getEffectiveParallelism();
                    if (prevParallelism == -1) {
                        prevParallelism = parallelism;
                    } else if (prevParallelism != parallelism) {
                        throw new VisitorException("one to one sources parallelism for vertex " + tezOp.getOperatorKey().toString() + " are not equal");
                    }
                    tezOp.setRequestedParallelism(pred.getRequestedParallelism());
                    tezOp.setEstimatedParallelism(pred.getEstimatedParallelism());
                    isOneToOneParallelism = true;
                    this.incrementTotalParallelism(tezOp, parallelism);
                    parallelism = -1;
                }
                if (!isOneToOneParallelism) {
                    if (tezOp.getRequestedParallelism() != -1) {
                        parallelism = tezOp.getRequestedParallelism();
                    } else if (this.pc.defaultParallel != -1) {
                        parallelism = this.pc.defaultParallel;
                    }
                    boolean overrideRequestedParallelism = false;
                    if (parallelism != -1 && this.autoParallelismEnabled && intermediateReducer && !tezOp.isDontEstimateParallelism() && tezOp.isOverrideIntermediateParallelism()) {
                        overrideRequestedParallelism = true;
                    }
                    if (parallelism == -1 || overrideRequestedParallelism) {
                        if (tezOp.getEstimatedParallelism() == -1) {
                            parallelism = this.estimator.estimateParallelism((TezOperPlan)this.mPlan, tezOp, this.conf);
                            if (overrideRequestedParallelism) {
                                tezOp.setRequestedParallelism(parallelism);
                            } else {
                                tezOp.setEstimatedParallelism(parallelism);
                            }
                        } else {
                            parallelism = tezOp.getEstimatedParallelism();
                        }
                        if (tezOp.isGlobalSort() || tezOp.isSkewedJoin()) {
                            if (!overrideRequestedParallelism) {
                                this.incrementTotalParallelism(tezOp, parallelism);
                                parallelism = -1;
                            } else {
                                block3: for (TezOperator pred : ((TezOperPlan)this.mPlan).getPredecessors(tezOp)) {
                                    if (!pred.isSampleBasedPartitioner()) continue;
                                    for (TezOperator partitionerPred : ((TezOperPlan)this.mPlan).getPredecessors(pred)) {
                                        if (!partitionerPred.isSampleAggregation()) continue;
                                        LOG.debug((Object)("Updating constant value to " + parallelism + " in " + partitionerPred.plan));
                                        LOG.info((Object)("Increased requested parallelism of " + partitionerPred.getOperatorKey() + " to " + parallelism));
                                        ParallelConstantVisitor visitor = new ParallelConstantVisitor(partitionerPred.plan, parallelism);
                                        visitor.visit();
                                        break block3;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            this.incrementTotalParallelism(tezOp, parallelism);
            tezOp.setVertexParallelism(parallelism);
            if (tezOp.getCrossKeys() != null) {
                for (String key : tezOp.getCrossKeys()) {
                    this.pc.getProperties().put("pig.cross.parallelism." + key, Integer.toString(tezOp.getVertexParallelism()));
                }
            }
        }
        catch (Exception e) {
            throw new VisitorException(e);
        }
    }

    private void incrementTotalParallelism(TezOperator tezOp, int tezOpParallelism) {
        if (tezOp.isVertexGroup()) {
            return;
        }
        if (tezOpParallelism != -1) {
            this.estimatedTotalParallelism += tezOpParallelism;
        }
    }
}

