/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POStoreTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POValueOutputTez;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.RoundRobinPartitioner;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezInput;
import org.apache.pig.backend.hadoop.executionengine.tez.runtime.TezOutput;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.ReverseDependencyOrderWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.runtime.library.input.UnorderedKVInput;
import org.apache.tez.runtime.library.output.UnorderedPartitionedKVOutput;

public class UnionOptimizer
extends TezOpPlanVisitor {
    public UnionOptimizer(TezOperPlan plan) {
        super(plan, (PlanWalker<TezOperator, TezOperPlan>)new ReverseDependencyOrderWalker<TezOperator, TezOperPlan>(plan));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitTezOp(TezOperator tezOp) throws VisitorException {
        ArrayList<TezOperator> successors;
        if (!tezOp.isUnion()) {
            return;
        }
        if ((tezOp.isLimit() || tezOp.isLimitAfterSort()) && tezOp.getRequestedParallelism() == 1) {
            return;
        }
        TezOperator unionOp = tezOp;
        String unionOpKey = unionOp.getOperatorKey().toString();
        String scope = unionOp.getOperatorKey().scope;
        TezOperPlan tezPlan = (TezOperPlan)this.getPlan();
        ArrayList<TezOperator> predecessors = new ArrayList<TezOperator>(tezPlan.getPredecessors(unionOp));
        if (predecessors.size() > unionOp.getVertexGroupMembers().size()) {
            return;
        }
        PhysicalPlan unionOpPlan = unionOp.plan;
        LinkedList<POStoreTez> unionStoreOutputs = PlanHelper.getPhysicalOperators(unionOpPlan, POStoreTez.class);
        TezOperator[] storeVertexGroupOps = new TezOperator[unionStoreOutputs.size()];
        for (int i = 0; i < storeVertexGroupOps.length; ++i) {
            storeVertexGroupOps[i] = new TezOperator(OperatorKey.genOpKey(scope));
            storeVertexGroupOps[i].setVertexGroupInfo(new TezOperator.VertexGroupInfo((POStore)unionStoreOutputs.get(i)));
            storeVertexGroupOps[i].setVertexGroupMembers(unionOp.getVertexGroupMembers());
            tezPlan.add(storeVertexGroupOps[i]);
        }
        LinkedList<TezOutput> unionOutputs = PlanHelper.getPhysicalOperators(unionOpPlan, TezOutput.class);
        ArrayList<String> unionOutputKeys = new ArrayList<String>();
        for (TezOutput output : unionOutputs) {
            if (output instanceof POStoreTez) continue;
            for (String string : output.getTezOutputs()) {
                unionOutputKeys.add(string);
            }
        }
        TezOperator[] outputVertexGroupOps = new TezOperator[unionOutputKeys.size()];
        String[] newOutputKeys = new String[unionOutputKeys.size()];
        for (int i = 0; i < outputVertexGroupOps.length; ++i) {
            outputVertexGroupOps[i] = new TezOperator(OperatorKey.genOpKey(scope));
            outputVertexGroupOps[i].setVertexGroupInfo(new TezOperator.VertexGroupInfo());
            outputVertexGroupOps[i].getVertexGroupInfo().setOutput((String)unionOutputKeys.get(i));
            outputVertexGroupOps[i].setVertexGroupMembers(unionOp.getVertexGroupMembers());
            newOutputKeys[i] = outputVertexGroupOps[i].getOperatorKey().toString();
            tezPlan.add(outputVertexGroupOps[i]);
        }
        try {
            unionOpPlan.remove((PhysicalOperator)unionOpPlan.getRoots().get(0));
            for (OperatorKey predKey : unionOp.getVertexGroupMembers()) {
                void var17_30;
                TezOperator pred = (TezOperator)tezPlan.getOperator(predKey);
                PhysicalPlan physicalPlan = pred.plan;
                PhysicalOperator predLeaf = (PhysicalOperator)physicalPlan.getLeaves().get(0);
                if (predLeaf instanceof POSplit) {
                    PhysicalPlan physicalPlan2 = UnionOptimizer.getUnionPredPlanFromSplit(physicalPlan, unionOpKey);
                    predLeaf = (PhysicalOperator)physicalPlan2.getLeaves().get(0);
                }
                PhysicalPlan clonePlan = unionOpPlan.clone();
                LinkedList<POStoreTez> clonedUnionStoreOutputs = PlanHelper.getPhysicalOperators(clonePlan, POStoreTez.class);
                var17_30.remove(predLeaf);
                boolean isEmptyPlan = var17_30.isEmpty();
                if (!isEmptyPlan) {
                    predLeaf = (PhysicalOperator)var17_30.getLeaves().get(0);
                }
                var17_30.merge(clonePlan);
                if (!isEmptyPlan) {
                    var17_30.connect(predLeaf, (PhysicalOperator)clonePlan.getRoots().get(0));
                }
                int i = 0;
                for (TezOperator storeVertexGroup : storeVertexGroupOps) {
                    storeVertexGroup.getVertexGroupInfo().addInput(pred.getOperatorKey());
                    ((POStoreTez)clonedUnionStoreOutputs.get(i)).setOutputKey(storeVertexGroup.getVertexGroupInfo().getStore().getOperatorKey().toString());
                    pred.addVertexGroupStore(((POStoreTez)clonedUnionStoreOutputs.get(i++)).getOperatorKey(), storeVertexGroup.getOperatorKey());
                    tezPlan.connect(pred, storeVertexGroup);
                }
                for (TezOperator outputVertexGroup : outputVertexGroupOps) {
                    outputVertexGroup.getVertexGroupInfo().addInput(pred.getOperatorKey());
                    tezPlan.connect(pred, outputVertexGroup);
                }
                this.copyOperatorProperties(pred, unionOp);
                tezPlan.disconnect(pred, unionOp);
            }
            List<TezOperator> successors2 = tezPlan.getSuccessors(unionOp);
            ArrayList<TezOutput> valueOnlyOutputs = new ArrayList<TezOutput>();
            for (TezOutput tezOutput : unionOutputs) {
                if (!(tezOutput instanceof POValueOutputTez)) continue;
                valueOnlyOutputs.add(tezOutput);
            }
            for (Map.Entry entry : unionOp.outEdges.entrySet()) {
                TezOperator succOp = (TezOperator)tezPlan.getOperator((OperatorKey)entry.getKey());
                TezOperator succOpVertexGroup = null;
                for (TezOperator succ : successors2) {
                    if (!succ.isVertexGroup() || !succ.getVertexGroupInfo().getOutput().equals(succOp.getOperatorKey().toString())) continue;
                    succOpVertexGroup = succ;
                    break;
                }
                TezEdgeDescriptor edge = (TezEdgeDescriptor)entry.getValue();
                if (edge.dataMovementType == EdgeProperty.DataMovementType.ONE_TO_ONE) {
                    edge.dataMovementType = EdgeProperty.DataMovementType.SCATTER_GATHER;
                    edge.partitionerClass = RoundRobinPartitioner.class;
                    edge.outputClassName = UnorderedPartitionedKVOutput.class.getName();
                    edge.inputClassName = UnorderedKVInput.class.getName();
                }
                TezOperator vertexGroupOp = outputVertexGroupOps[unionOutputKeys.indexOf(((OperatorKey)entry.getKey()).toString())];
                for (OperatorKey predKey : vertexGroupOp.getVertexGroupMembers()) {
                    TezOperator pred = (TezOperator)tezPlan.getOperator(predKey);
                    pred.outEdges.put((OperatorKey)entry.getKey(), edge);
                    succOp.inEdges.put(predKey, edge);
                    if (succOpVertexGroup == null) continue;
                    succOpVertexGroup.getVertexGroupMembers().add(predKey);
                    succOpVertexGroup.getVertexGroupInfo().addInput(predKey);
                    tezPlan.disconnect(pred, vertexGroupOp);
                    tezPlan.connect(pred, succOpVertexGroup);
                }
                if (succOpVertexGroup != null) {
                    succOpVertexGroup.getVertexGroupMembers().remove(unionOp.getOperatorKey());
                    succOpVertexGroup.getVertexGroupInfo().removeInput(unionOp.getOperatorKey());
                    tezPlan.remove(vertexGroupOp);
                    continue;
                }
                tezPlan.connect(vertexGroupOp, succOp);
            }
        }
        catch (Exception e) {
            throw new VisitorException(e);
        }
        List<TezOperator> succs = tezPlan.getSuccessors(unionOp);
        ArrayList<TezOperator> arrayList = successors = succs == null ? null : new ArrayList<TezOperator>(succs);
        if (successors != null) {
            for (TezOperator tezOperator : successors) {
                LinkedList<TezInput> inputs = PlanHelper.getPhysicalOperators(tezOperator.plan, TezInput.class);
                for (TezInput input : inputs) {
                    for (String key : input.getTezInputs()) {
                        if (!key.equals(unionOpKey)) continue;
                        input.replaceInput(key, newOutputKeys[unionOutputKeys.indexOf(tezOperator.getOperatorKey().toString())]);
                    }
                }
                tezPlan.disconnect(unionOp, tezOperator);
            }
        }
        tezPlan.remove(unionOp);
    }

    private void copyOperatorProperties(TezOperator pred, TezOperator unionOp) {
        pred.UDFs.addAll(unionOp.UDFs);
        pred.scalars.addAll(unionOp.scalars);
        if (unionOp.getCrossKeys() != null) {
            for (String key : unionOp.getCrossKeys()) {
                pred.addCrossKey(key);
            }
        }
        pred.copyFeatures(unionOp, Arrays.asList(TezOperator.OPER_FEATURE.UNION));
    }

    public static PhysicalPlan getUnionPredPlanFromSplit(PhysicalPlan plan, String unionOpKey) throws VisitorException {
        LinkedList<POSplit> splits = PlanHelper.getPhysicalOperators(plan, POSplit.class);
        for (POSplit split : splits) {
            for (PhysicalPlan subPlan : split.getPlans()) {
                POValueOutputTez out;
                if (!(subPlan.getLeaves().get(0) instanceof POValueOutputTez) || !(out = (POValueOutputTez)subPlan.getLeaves().get(0)).containsOutputKey(unionOpKey)) continue;
                return subPlan;
            }
        }
        throw new VisitorException("Did not find the union predecessor in the split plan");
    }
}

