/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.runtime;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.common.objectregistry.ObjectRegistryImpl;

@InterfaceAudience.Private
public class ObjectCache {
    private static final Log LOG = LogFactory.getLog(ObjectCache.class);
    private final ObjectRegistry registry = new ObjectRegistryImpl();
    private static ObjectCache cache = new ObjectCache();

    private ObjectCache() {
    }

    public static ObjectCache getInstance() {
        return cache;
    }

    public void cache(String key, Object value) {
        LOG.info((Object)("Adding " + key + " to cache"));
        this.registry.cacheForVertex(key, value);
    }

    public Object retrieve(String key) {
        Object o = this.registry.get(key);
        if (o != null) {
            LOG.info((Object)("Found " + key + " in cache"));
        }
        return o;
    }
}

