/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.builtin;

import java.io.IOException;
import java.util.Formatter;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class SPRINTF
extends EvalFunc<String> {
    @Override
    public String exec(Tuple input) throws IOException {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        try {
            if (input == null || input.size() == 0) {
                String string = null;
                return string;
            }
            if (input.get(0) == null) {
                String string = null;
                return string;
            }
            String fmt = String.valueOf(input.get(0));
            Object[] args = new Object[input.size() - 1];
            for (int i = 1; i < input.size(); ++i) {
                args[i - 1] = input.get(i);
                if (args[i - 1] != null) continue;
                String string = null;
                return string;
            }
            formatter.format(fmt, args);
            String i = sb.toString();
            return i;
        }
        catch (ExecException exp) {
            throw exp;
        }
        catch (Exception err) {
            int errCode = 2106;
            String msg = "Error while computing string format in " + this.getClass().getSimpleName() + " -- " + err.toString();
            throw new ExecException(msg, errCode, 4, err);
        }
        finally {
            formatter.close();
        }
    }

    @Override
    public Schema outputSchema(Schema input) {
        return new Schema(new Schema.FieldSchema(null, 55));
    }

    @Override
    public EvalFunc.SchemaType getSchemaType() {
        return EvalFunc.SchemaType.VARARG;
    }

    @Override
    public boolean allowCompileTimeCalculation() {
        return true;
    }
}

