/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.ReadToEndLoader;
import org.apache.pig.tools.pigstats.ScriptState;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class OutputStats {
    private String name;
    private String location;
    private long bytes;
    private long records;
    private boolean success;
    private POStore store = null;
    private Configuration conf;
    private static final Log LOG = LogFactory.getLog(OutputStats.class);

    public OutputStats(String location, long bytes, long records, boolean success) {
        this.location = location;
        this.bytes = bytes;
        this.records = records;
        this.success = success;
        try {
            this.name = new Path(location).getName();
        }
        catch (Exception e) {
            this.name = location;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public long getBytes() {
        return this.bytes;
    }

    public long getNumberRecords() {
        return this.records;
    }

    public String getFunctionName() {
        return this.store == null ? null : this.store.getSFile().getFuncSpec().getClassName();
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public String getAlias() {
        return this.store == null ? null : this.store.getAlias();
    }

    public POStore getPOStore() {
        return this.store;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public String getDisplayString() {
        StringBuilder sb = new StringBuilder();
        if (this.success) {
            sb.append("Successfully stored ");
            if (this.records >= 0L) {
                sb.append(this.records).append(" records ");
            } else {
                sb.append("records ");
            }
            if (this.bytes > 0L) {
                sb.append("(").append(this.bytes).append(" bytes) ");
            }
            sb.append("in: \"").append(this.location).append("\"\n");
        } else {
            sb.append("Failed to produce result in \"").append(this.location).append("\"\n");
        }
        return sb.toString();
    }

    public void setPOStore(POStore store) {
        this.store = store;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Iterator<Tuple> iterator() throws IOException {
        ReadToEndLoader p;
        PigContext pigContext = ScriptState.get().getPigContext();
        if (pigContext == null || this.store == null) {
            throw new IllegalArgumentException();
        }
        try {
            LoadFunc originalLoadFunc = (LoadFunc)PigContext.instantiateFuncFromSpec(this.store.getSFile().getFuncSpec());
            p = new ReadToEndLoader(originalLoadFunc, ConfigurationUtil.toConfiguration(pigContext.getProperties()), this.store.getSFile().getFileName(), 0);
        }
        catch (Exception e) {
            int errCode = 2088;
            String msg = "Unable to get results for: " + this.store.getSFile();
            throw new ExecException(msg, errCode, 4, e);
        }
        return new Iterator<Tuple>(){
            Tuple t;
            boolean atEnd;

            @Override
            public boolean hasNext() {
                if (this.atEnd) {
                    return false;
                }
                try {
                    if (this.t == null) {
                        this.t = p.getNext();
                    }
                    if (this.t == null) {
                        this.atEnd = true;
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                    this.t = null;
                    this.atEnd = true;
                    throw new Error(e);
                }
                return !this.atEnd;
            }

            @Override
            public Tuple next() {
                Tuple next = this.t;
                if (next != null) {
                    this.t = null;
                    return next;
                }
                try {
                    next = p.getNext();
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                }
                if (next == null) {
                    this.atEnd = true;
                }
                return next;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Removal not supported");
            }
        };
    }
}

