/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.tez;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.Counters;
import org.apache.pig.PigCounters;
import org.apache.pig.backend.hadoop.executionengine.tez.TezJob;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.tez.TezScriptState;
import org.apache.pig.tools.pigstats.tez.TezVertexStats;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.DAGCounter;
import org.apache.tez.common.counters.FileSystemCounter;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.dag.api.client.VertexStatus;

public class TezDAGStats
extends JobStats {
    private static final Log LOG = LogFactory.getLog(TezDAGStats.class);
    public static final String DAG_COUNTER_GROUP = DAGCounter.class.getName();
    public static final String FS_COUNTER_GROUP = FileSystemCounter.class.getName();
    public static final String TASK_COUNTER_GROUP = TaskCounter.class.getName();
    public static final String PIG_COUNTER_GROUP = PigCounters.class.getName();
    private Map<String, TezVertexStats> tezVertexStatsMap;
    private String appId;
    private int totalTasks = -1;
    private long fileBytesRead = -1L;
    private long fileBytesWritten = -1L;
    private Counters counters = null;
    private int numberMaps = 0;
    private int numberReduces = 0;
    private long mapInputRecords = 0L;
    private long mapOutputRecords = 0L;
    private long reduceInputRecords = 0L;
    private long reduceOutputRecords = 0L;
    private long spillCount = 0L;
    private long activeSpillCountObj = 0L;
    private long activeSpillCountRecs = 0L;
    private HashMap<String, Long> multiStoreCounters = new HashMap();

    protected TezDAGStats(String name, PigStats.JobGraph plan, Map<String, TezVertexStats> tezVertexStatsMap) {
        super(name, plan);
        this.tezVertexStatsMap = tezVertexStatsMap;
    }

    public TezVertexStats getVertexStats(String vertexName) {
        return this.tezVertexStatsMap.get(vertexName);
    }

    void setAlias(TezScriptState.TezDAGScriptInfo dagScriptInfo) {
        this.annotate("JobStatistics:alias", dagScriptInfo.getAlias());
        this.annotate("JobStatistics:alias_location", dagScriptInfo.getAliasLocation());
        this.annotate("JobStatistics:feature", dagScriptInfo.getPigFeatures());
    }

    public void accumulateStats(TezJob tezJob) throws IOException {
        this.appId = tezJob.getApplicationId().toString().replace("application", "job");
        this.setConf(tezJob.getConfiguration());
        DAG dag = tezJob.getDAG();
        this.hdfsBytesRead = -1L;
        this.hdfsBytesWritten = -1L;
        TezCounters tezCounters = tezJob.getDAGCounters();
        if (tezCounters != null) {
            this.counters = this.covertToHadoopCounters(tezCounters);
        }
        CounterGroup dagGrp = (CounterGroup)tezCounters.getGroup(DAG_COUNTER_GROUP);
        this.totalTasks = (int)dagGrp.findCounter("TOTAL_LAUNCHED_TASKS").getValue();
        CounterGroup fsGrp = (CounterGroup)tezCounters.getGroup(FS_COUNTER_GROUP);
        this.fileBytesRead = fsGrp.findCounter("FILE_BYTES_READ").getValue();
        this.fileBytesWritten = fsGrp.findCounter("FILE_BYTES_WRITTEN").getValue();
        this.hdfsBytesRead = fsGrp.findCounter("HDFS_BYTES_READ").getValue();
        this.hdfsBytesWritten = fsGrp.findCounter("HDFS_BYTES_WRITTEN").getValue();
        for (Map.Entry<String, TezVertexStats> entry : this.tezVertexStatsMap.entrySet()) {
            Vertex v = dag.getVertex(entry.getKey());
            if (v == null || !this.tezVertexStatsMap.containsKey(v.getName())) continue;
            TezVertexStats vertexStats = entry.getValue();
            UserPayload payload = v.getProcessorDescriptor().getUserPayload();
            Configuration conf = TezUtils.createConfFromUserPayload((UserPayload)payload);
            vertexStats.setConf(conf);
            VertexStatus status = tezJob.getVertexStatus(v.getName());
            vertexStats.accumulateStats(status, v.getParallelism());
            if (vertexStats.getInputs() != null && !vertexStats.getInputs().isEmpty()) {
                this.inputs.addAll(vertexStats.getInputs());
            }
            if (vertexStats.getOutputs() != null && !vertexStats.getOutputs().isEmpty()) {
                this.outputs.addAll(vertexStats.getOutputs());
            }
            if (!vertexStats.getMultiStoreCounters().isEmpty()) {
                this.multiStoreCounters.putAll(vertexStats.getMultiStoreCounters());
            }
            this.numberMaps += vertexStats.getNumberMaps();
            this.numberReduces += vertexStats.getNumberReduces();
            this.mapInputRecords += vertexStats.getMapInputRecords();
            this.mapOutputRecords += vertexStats.getMapOutputRecords();
            this.reduceInputRecords += vertexStats.getReduceInputRecords();
            this.reduceOutputRecords += vertexStats.getReduceOutputRecords();
            this.spillCount += vertexStats.getSMMSpillCount();
            this.activeSpillCountObj += vertexStats.getProactiveSpillCountObjects();
            this.activeSpillCountRecs += vertexStats.getProactiveSpillCountRecs();
        }
    }

    private Counters covertToHadoopCounters(TezCounters tezCounters) {
        Counters counters = new Counters();
        for (CounterGroup tezGrp : tezCounters) {
            Counters.Group grp = (Counters.Group)counters.addGroup(tezGrp.getName(), tezGrp.getDisplayName());
            for (TezCounter counter : tezGrp) {
                grp.addCounter(counter.getName(), counter.getDisplayName(), counter.getValue());
            }
        }
        return counters;
    }

    @Override
    public String getJobId() {
        return this.appId;
    }

    public void setJobId(String appId) {
        this.appId = appId;
    }

    @Override
    public void accept(PlanVisitor v) throws FrontendException {
        if (v instanceof PigStats.JobGraphPrinter) {
            PigStats.JobGraphPrinter jpp = (PigStats.JobGraphPrinter)v;
            jpp.visit(this);
        }
    }

    @Override
    public String getDisplayString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DAG " + this.name + ":\n");
        sb.append(String.format("%1$20s: %2$-100s%n", "ApplicationId", this.appId));
        sb.append(String.format("%1$20s: %2$-100s%n", "TotalLaunchedTasks", this.totalTasks));
        sb.append(String.format("%1$20s: %2$-100s%n", "FileBytesRead", this.fileBytesRead));
        sb.append(String.format("%1$20s: %2$-100s%n", "FileBytesWritten", this.fileBytesWritten));
        sb.append(String.format("%1$20s: %2$-100s%n", "HdfsBytesRead", this.hdfsBytesRead));
        sb.append(String.format("%1$20s: %2$-100s%n", "HdfsBytesWritten", this.hdfsBytesWritten));
        return sb.toString();
    }

    @Override
    @Deprecated
    public int getNumberMaps() {
        return this.numberMaps;
    }

    @Override
    @Deprecated
    public int getNumberReduces() {
        return this.numberReduces;
    }

    @Override
    @Deprecated
    public long getMaxMapTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getMinMapTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getAvgMapTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getMaxReduceTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getMinReduceTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getAvgREduceTime() {
        return -1L;
    }

    @Override
    @Deprecated
    public long getMapInputRecords() {
        return this.mapInputRecords;
    }

    @Override
    @Deprecated
    public long getMapOutputRecords() {
        return this.mapOutputRecords;
    }

    @Override
    @Deprecated
    public long getReduceInputRecords() {
        return this.reduceInputRecords;
    }

    @Override
    @Deprecated
    public long getReduceOutputRecords() {
        return this.reduceOutputRecords;
    }

    @Override
    public long getSMMSpillCount() {
        return this.spillCount;
    }

    @Override
    public long getProactiveSpillCountObjects() {
        return this.activeSpillCountObj;
    }

    @Override
    public long getProactiveSpillCountRecs() {
        return this.activeSpillCountRecs;
    }

    @Override
    @Deprecated
    public Counters getHadoopCounters() {
        return this.counters;
    }

    @Override
    @Deprecated
    public Map<String, Long> getMultiStoreCounters() {
        return this.multiStoreCounters;
    }

    @Override
    @Deprecated
    public Map<String, Long> getMultiInputCounters() {
        throw new UnsupportedOperationException();
    }

    static class JobGraphBuilder
    extends TezOpPlanVisitor {
        private PigStats.JobGraph jobPlan;
        private Map<String, TezVertexStats> tezVertexStatsMap = new HashMap<String, TezVertexStats>();
        private List<TezVertexStats> vertexStatsToBeRemoved = new ArrayList<TezVertexStats>();
        private TezScriptState.TezDAGScriptInfo dagScriptInfo;

        public JobGraphBuilder(TezOperPlan plan, TezScriptState.TezDAGScriptInfo dagScriptInfo) {
            super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(plan));
            this.jobPlan = new PigStats.JobGraph();
            this.dagScriptInfo = dagScriptInfo;
        }

        public Map<String, TezVertexStats> getTezVertexStatsMap() {
            return this.tezVertexStatsMap;
        }

        public PigStats.JobGraph getJobPlan() {
            return this.jobPlan;
        }

        @Override
        public void visitTezOp(TezOperator tezOp) throws VisitorException {
            TezVertexStats currStats = new TezVertexStats(tezOp.getOperatorKey().toString(), this.jobPlan, tezOp.isUseMRMapSettings());
            this.jobPlan.add(currStats);
            List<TezOperator> preds = ((TezOperPlan)this.getPlan()).getPredecessors(tezOp);
            if (preds != null) {
                for (TezOperator pred : preds) {
                    TezVertexStats predStats = this.tezVertexStatsMap.get(pred);
                    if (this.jobPlan.isConnected(predStats, currStats)) continue;
                    this.jobPlan.connect(predStats, currStats);
                }
            }
            if (tezOp.isVertexGroup()) {
                this.vertexStatsToBeRemoved.add(currStats);
            } else {
                currStats.annotate("JobStatistics:alias", this.dagScriptInfo.getAlias(tezOp));
                currStats.annotate("JobStatistics:alias_location", this.dagScriptInfo.getAliasLocation(tezOp));
                currStats.annotate("JobStatistics:feature", this.dagScriptInfo.getPigFeatures(tezOp));
            }
            this.tezVertexStatsMap.put(tezOp.getOperatorKey().toString(), currStats);
        }

        @Override
        public void visit() throws VisitorException {
            super.visit();
            try {
                for (TezVertexStats vertexStats : this.vertexStatsToBeRemoved) {
                    this.jobPlan.removeAndReconnect(vertexStats);
                }
            }
            catch (FrontendException e) {
                LOG.warn((Object)"Unable to build Tez DAG", (Throwable)e);
            }
        }
    }
}

