/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.tez;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobClient;
import org.apache.pig.backend.hadoop.executionengine.tez.TezExecType;
import org.apache.pig.backend.hadoop.executionengine.tez.TezJob;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainer;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerNode;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.NativeTezOper;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.tools.pigstats.InputStats;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.ScriptState;
import org.apache.pig.tools.pigstats.tez.TezDAGStats;
import org.apache.pig.tools.pigstats.tez.TezScriptState;
import org.apache.pig.tools.pigstats.tez.TezVertexStats;
import org.apache.tez.dag.api.client.DAGStatus;

public class TezPigScriptStats
extends PigStats {
    private static final Log LOG = LogFactory.getLog(TezPigScriptStats.class);
    private TezScriptState tezScriptState;
    private Map<String, TezDAGStats> tezDAGStatsMap;

    public TezPigScriptStats(PigContext pigContext) {
        this.pigContext = pigContext;
        this.jobPlan = new PigStats.JobGraph();
        this.tezDAGStatsMap = Maps.newHashMap();
        this.tezScriptState = (TezScriptState)ScriptState.get();
    }

    public void initialize(TezPlanContainer tezPlanContainer) {
        super.start();
        try {
            new DAGGraphBuilder(tezPlanContainer).visit();
        }
        catch (FrontendException e) {
            LOG.warn((Object)"Unable to build Tez DAG", (Throwable)e);
        }
    }

    public void finish() {
        super.stop();
        this.display();
    }

    private void display() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append(String.format("%1$20s: %2$-100s%n", "HadoopVersion", this.getHadoopVersion()));
        sb.append(String.format("%1$20s: %2$-100s%n", "PigVersion", this.getPigVersion()));
        sb.append(String.format("%1$20s: %2$-100s%n", "TezVersion", TezExecType.getTezVersion()));
        sb.append(String.format("%1$20s: %2$-100s%n", "UserId", this.userId));
        sb.append(String.format("%1$20s: %2$-100s%n", "FileName", this.getFileName()));
        sb.append(String.format("%1$20s: %2$-100s%n", "StartedAt", sdf.format(new Date(this.startTime))));
        sb.append(String.format("%1$20s: %2$-100s%n", "FinishedAt", sdf.format(new Date(this.endTime))));
        sb.append(String.format("%1$20s: %2$-100s%n", "Features", this.getFeatures()));
        sb.append("\n");
        if (this.returnCode == 0) {
            sb.append("Success!\n");
        } else if (this.returnCode == 3) {
            sb.append("Some tasks have failed! Stop running all dependent tasks\n");
        } else {
            sb.append("Failed!\n");
        }
        sb.append("\n");
        if ((this.returnCode == 2 || this.returnCode == 3) && this.errorMessage != null) {
            String[] lines = this.errorMessage.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String s = lines[i].trim();
                if (i != 0 && StringUtils.isEmpty((String)s)) continue;
                sb.append(String.format("%1$20s: %2$-100s%n", i == 0 ? "ErrorMessage" : "", s));
            }
            sb.append("\n");
        }
        for (TezDAGStats dagStats : this.tezDAGStatsMap.values()) {
            sb.append(dagStats.getDisplayString());
            sb.append("\n");
        }
        sb.append("Input(s):\n");
        for (InputStats is : this.getInputStats()) {
            sb.append(is.getDisplayString().trim()).append("\n");
        }
        sb.append("\n");
        sb.append("Output(s):\n");
        for (OutputStats os : this.getOutputStats()) {
            sb.append(os.getDisplayString().trim()).append("\n");
        }
        LOG.info((Object)("Script Statistics:\n" + sb.toString()));
    }

    public void accumulateStats(TezJob tezJob) throws IOException {
        DAGStatus dagStatus = tezJob.getDAGStatus();
        TezDAGStats tezDAGStats = this.tezDAGStatsMap.get(tezJob.getName());
        if (dagStatus == null) {
            tezDAGStats.setSuccessful(false);
            this.tezScriptState.emitJobFailedNotification(tezDAGStats);
            return;
        }
        tezDAGStats.accumulateStats(tezJob);
        for (OutputStats output : tezDAGStats.getOutputs()) {
            this.tezScriptState.emitOutputCompletedNotification(output);
        }
        if (dagStatus.getState() == DAGStatus.State.SUCCEEDED) {
            tezDAGStats.setSuccessful(true);
            this.tezScriptState.emitjobFinishedNotification(tezDAGStats);
        } else if (dagStatus.getState() == DAGStatus.State.FAILED) {
            tezDAGStats.setSuccessful(false);
            tezDAGStats.setErrorMsg(tezJob.getDiagnostics());
            this.tezScriptState.emitJobFailedNotification(tezDAGStats);
        }
        this.tezScriptState.dagCompletedNotification(tezJob.getName(), tezDAGStats);
    }

    public TezDAGStats addTezJobStatsForNative(String dagName, NativeTezOper tezOper, boolean success) {
        TezDAGStats js = this.tezDAGStatsMap.get(dagName);
        js.setJobId(tezOper.getJobId());
        js.setSuccessful(success);
        return js;
    }

    public TezVertexStats getVertexStats(String dagName, String vertexName) {
        TezDAGStats tezDAGStats = this.tezDAGStatsMap.get(dagName);
        return tezDAGStats == null ? null : tezDAGStats.getVertexStats(vertexName);
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }

    @Override
    public JobClient getJobClient() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, List<PigStats>> getAllStats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getAllErrorMessages() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getSMMSpillCount() {
        long ret = 0L;
        for (TezDAGStats dagStats : this.tezDAGStatsMap.values()) {
            ret += dagStats.getSMMSpillCount();
        }
        return ret;
    }

    @Override
    public long getProactiveSpillCountObjects() {
        long ret = 0L;
        for (TezDAGStats dagStats : this.tezDAGStatsMap.values()) {
            ret += dagStats.getProactiveSpillCountObjects();
        }
        return ret;
    }

    @Override
    public long getProactiveSpillCountRecords() {
        long ret = 0L;
        for (TezDAGStats dagStats : this.tezDAGStatsMap.values()) {
            ret += dagStats.getProactiveSpillCountRecs();
        }
        return ret;
    }

    private class DAGGraphBuilder
    extends TezPlanContainerVisitor {
        public DAGGraphBuilder(TezPlanContainer planContainer) {
            super(planContainer, (PlanWalker<TezPlanContainerNode, TezPlanContainer>)new DependencyOrderWalker<TezPlanContainerNode, TezPlanContainer>(planContainer));
        }

        @Override
        public void visitTezPlanContainerNode(TezPlanContainerNode tezPlanNode) throws VisitorException {
            TezScriptState ss = TezScriptState.get();
            TezScriptState.TezDAGScriptInfo dagScriptInfo = ss.setDAGScriptInfo(tezPlanNode);
            TezDAGStats.JobGraphBuilder jobGraphBuilder = new TezDAGStats.JobGraphBuilder(tezPlanNode.getTezOperPlan(), dagScriptInfo);
            jobGraphBuilder.visit();
            TezDAGStats currStats = new TezDAGStats(tezPlanNode.getOperatorKey().toString(), jobGraphBuilder.getJobPlan(), jobGraphBuilder.getTezVertexStatsMap());
            currStats.setAlias(dagScriptInfo);
            TezPigScriptStats.this.jobPlan.add(currStats);
            List<TezPlanContainerNode> preds = ((TezPlanContainer)this.getPlan()).getPredecessors(tezPlanNode);
            if (preds != null) {
                for (TezPlanContainerNode pred : preds) {
                    TezDAGStats predStats = (TezDAGStats)TezPigScriptStats.this.tezDAGStatsMap.get(pred.getOperatorKey().toString());
                    if (TezPigScriptStats.this.jobPlan.isConnected(predStats, currStats)) continue;
                    TezPigScriptStats.this.jobPlan.connect(predStats, currStats);
                }
            }
            TezPigScriptStats.this.tezDAGStatsMap.put(tezPlanNode.getOperatorKey().toString(), currStats);
        }
    }
}

